PROGRAM UpConv;
{$B-}     {shortcut Boolean}
{$D-}     {no debug}
{$L-}     {no local symbols}
{$S-}     {no stack checking}
{$V-}     {no VAR-string checking}

Uses Dos;                {v1.3 for all the wildcard stuff}

{$DEFINE NO_OVERWRITE}   {this enables .FMT file existence checking.
                          I suggest you leave it .. that keeps the
                          system from trying to reformat earlier
                          .FMT files during a wildcard run where
                          the user specified *.* or something!
                         }
{ DEFINE NOWORKLINE}     {for timing tests: building an output string
                          in WorkLine vs. outputting chars or words.
                         }

{ DEFINE TURTLE}         {Enable if you want Turtle-related reserved words}

{
 Original based on a bulletin board program by Jeff Firestone
 This version based on a program by Douglas S. Stivison in his book:
     'Turbo Pascal Library' published by Sybex.

  v1.3, Toad Hall, 14 Apr 89
    - Tweaking for Turbo Pascal v5.0
    - Adding a bunch of TP 4.0 and 5.0 Borland words.
    - Tightening up a little.
    - Added commandline multiple filename/wildcard capability.
    - Added '/L' switch for Pascal (non-Borland) reserved word
      lowercase conversion.
    - Building formatted output string (WorkLine).  Saved only a little
      processing time, but did cut out about 60-70 bytes of code.
                  time        size
      $DEFINE:    1:16.35     12160 bytes
      No DEFINE:  1:15.79     12096 bytes
    - Tried a Move instruction to concatenate strings to WorkLine
      (vs. WorkLine := WorkLine + String); gained no time, only saved
      16 bytes .. not worth the obtuseness.
    - Adding chars to WorkLine the hard way (see code) vs. normal way
      (WorkLine := WorkLine + char)  saved code, time:
                   1:17.34     12208 bytes

  v1.2, Toad Hall, 12 Oct 88
    - Bug in Scan_Till procedure.  Fixed.
    - Isn't leaving quoted strings alone.  Fixed.

  v1.1 Toad Hall Tweak, Sep 88
    - Added command line filename input.
    - Moved Identifier char set to a global typed constant.
    - Changed simple Reserved Word uppercasing to include Turbo Pascal
      formatted reserved words.
    - Added more reserved words for Turbo Pascal.  (Complete thru v3.0,
      I think .. don't have 4.0, so that should be added.)
    - Command line switch ('-U') to force all reserved words to uppercase
      (e.g., ignore Turbo Pascal format).
    - Considering how to change other text (non-quoted, non-comments)
      to all-upper, all-lower, As-Is, like PFORMAT.PAS does.
    - Still suspect a fancy hash procedure to confirm a RamWord as a
      reserved word would be better than this "if word is in line"
      business.  Later.
  One peculiarity about the comment-handling:  Anything within the usual
  '}{' comments is skipped over; anything within the "parenthesis asterisk"
  type comment IS processed!  So .. put real comments within '}{' comments,
  and commented-out code within the '(* *)' type comments.

  v1.0
    - Found in SIMTEL20's PD1:<MSDOS.TURBOPAS>UPCONV.ARC.
      Original author unknown.

  David Kirschbaum
  Toad Hall
  kirsch@braggvax.ARPA
}


CONST
{$IFNDEF TURTLE}
  NRLINES = 57;     {v1.3}
{$ELSE}
  NRLINES = 60;     {v1.3 3 more lines of Turtle-related reserved words}
{$ENDIF}

TYPE
  ReservedArray =   ARRAY[1..NRLINES] OF STRING[80];  {v1.3}

CONST
{ These words are NOT in any special order .. I alphabetized them just
  to make them neat.
}

  ReservedWords : ReservedArray = (
' $DEFINE $ELSE $ENDIF $IFDEF $IFNDEF $IFOPT $UNDEF ABS Absolute Addr AND ',
' AnyFile Append Arc ArcCoordsType Archive ARCTAN ARRAY Assign AssignCrt ATT400 ',
' ATT400C1 ATT400C2 ATT400C3 ATT400Hi ATT400Med Aux AuxIn AuxInPtr AuxOutPtr ',
' Bar3D BEGIN BkSlashFill BLACK BlockRead BlockWrite BLUE BOOLEAN BottomText ',
' BufLen BW40 BW80 Byte C40 C80 CASE CBreak CenterLn CenterText CGA CGAC0 CGAC1 ',
' CGAC3 CGAHi Chain CHAR ChDir CheckBreak CheckEOF CheckSnow ChkEOF CHR Circle ',
' ClearViewPort ClipOff ClipOn CLOSE CloseDotFill CloseGraph ClrEol ClrScr ',
' Con CONCAT ConIn ConInPtr ConOut ConOutPtr CONST ConstPtr COPY CopyPut COS ',
' CrtExit CrtInit CSeg CurrentDriver CYAN DARKGRAY DashedLn DateTime Dec ',
' Delay DELETE DelLine Detect DetectGraph Directory DirectVideo DirStr DiskFree ',
' Dispose DIV DO DosError DosExitCode DosVersion DottedLn DOWNTO Draw DrawPoly ',
' EGA EGA64 EGABlack EGABlue EGABrown EGACyan EGADarkGray EGAGreen EGAHi ',
' EGALightcyan EGALightgray EGALightgreen EGALightmagenta EGALightred EGALo ',
' EGAMono EGAMonoHi EGARed EGAWhite EGAYellow Ellipse ELSE EmptyFill END ',
' EnvStr EOF EOLN Erase ErrorAddr Execute Exit ExitCode ExitProc EXP EXTERNAL ',
' FALSE FAuxiliar FCarry FExpand FILE FileMode FilePos FileRec FileSize ',
' FillEllipse FillPattern FillPatternType FillPoly FillScreen FillSettingsType ',
' FindFirst FindNext FloodFill Flush fmClosed fmInOut fmInput fmOutput Font8x8 ',
' FORWARD FOverflow FParity Frac FreeMem FreeMin FreePtr FSearch FSign FSplit ',
' FZero GetArcCoords GetAspectRatio GetBkColor GetCBreak GetColor GetDate ',
' GetDir GetDotColor GetDriverName GetEnv GetFAttr GetFillPattern ',
' GetFTime GetGraphMode GetImage GetIntVec GetLineSettings GetMaxColor ',
' GetMaxX GetMaxY GetMem GetModeName GetModeRange GetPaletteSize GetPallette ',
' GetPixel GetTextSettings GetTime GetVerify GetViewSettings GetX GetY ',
' GOTO GotoXY Graph Graph3 GraphBackGround GraphColorMode GraphDefaults ',
' GraphFreeMemPtr GraphGetMemPtr GraphMode GraphResult GraphWindow GREEN ',
' grFileNotFound grFontNotFound grInvalidDriver grInvalidFont grInvalidFontNum ',
' grIOerror grNoFloodMem grNoFontMem grNoInitGraph grNoLoadMem grNoScanMem ',
' grOk HALT HatchFill HeapError HeapOrg HeapPtr HeapStr HercMono HercMonoHi Hi ',
' HighVideo HiRes HiResColor HorizDir IBM8514 IBM8514HI IBM8514LO IF ImageSize ',
' IN Inc InitGraph InLine InOutRes INPUT INSERT InsLine InstallUserDriver ',
' INT INTEGER InterleaveFill Intr IOResult Kbd Keep KeyPressed LABEL LastMode ',
' LENGTH LIGHTBLUE LIGHTCYAN LIGHTGRAY LIGHTGREEN LIGHTMAGENTA LIGHTRED Line ',
' LineRel LineSettingsType LineTo LN Lo LongFilePos LongFileSize LongSeek ',
' Lst LstOut LstOutPtr LtBkSlashFill LtSlashFill MAGENTA MARK MaxAvail ',
' MAXINT MCGA MCGAC0 MCGAC1 MCGAC2 MCGAC3 MCGAHi MCGAMed Mem MemAvail MemL MemW ',
' MOD Move MoveRel Moveto MsDos NameStr NEW NIL NormVideo NormWidth NoSound NOT ',
' ODD OF Ofs OR ORD OrPut OUTPUT OutText OutTextXY OverClearBuf OverCodeList ',
' OverInitEMS Overlay OverSetBuf OvrDebugPtr OvrDosHandle OvrEmsHandle ovrError ',
' OvrHeapEnd OvrHeapOrg OvrHeapPtr OvrHeapSize ovrIOError OvrLoadList ',
' ovrNoEMSMemory ovrNoMemory ovrNotFound ovrOk OvrPath OvrResult PACKED ',
' Palette PaletteType Pattern PC3270 PC3270Hi Pi PieSlice Plot PointType Port ',
' POS PRED PrefixSeg Printer PROCEDURE PROGRAM Ptr PutImage PutPic PutPixel ',
' Randomize RandSeed READ ReadKey READLN ReadOnly REAL RECORD RecTangle RED ',
' RegisterBGIfont Registers RELEASE Rename REPEAT RESET RestoreCrtMode REWRITE ',
' RmDir ROUND SanSeriFont SearchRec Sector Seek Seg SET SetActivePage ',
' SetAspectRatio SetBkColor SetCBreak SetColor SetDate SetFAttr SetFillPattern ',
' SetFTime SetGraphBufSize SetGraphMode SetIntVec SetLineStyle SetPalette ',
' SetTextJustify SetTextStyle SetTime SetUserCharSize SetVerify SetViewPort ',
' SetWriteMode ShL ShR SIN SIZEOF SlashFill SmallFont SolidFill SolidLn Sound ',
' Sqrt SSeg StackLimit STR STRING SUCC Swap SwapVectors SysFile Test8087 TEXT ',
' TextBackGround TextBuf TextColor TextHeight TextMode TextRec TextSettingsType ',
' THEN ThickWidth TO ToadHall TopOff TopOn TopText TriplexFont Trm TRUE TRUNC ',
' Turbo3 TYPE Unit UnpackTime UNTIL UpCase UserCharSize UserFill Uses Usr ',
' UsrIn UsrInPtr UsrOut UsrOutPtr VAL VAR VertDir VGA VGAHi VGALo VGAMed ',
' VolumeID WhereX WhereY WHILE WHITE WideDotFill WindMax WindMin Window WITH ',
' WRITE WRITELN XHatchFill XOr XORPut YELLOW '
{$IFDEF TURTLE}
,         {need a comma}
' Back ClearScreen Forwd Heading HideTurtle Home NoWrap PenUp PenDown '
' SetHeading SetPenColor SetPosition ShowTurtle TurnLeft TurnRight',
' TurtleDelay TurtleThere TurtleWindow Wrap Xcor Ycor'
{$ENDIF}
);

{ There's also a bunch of CP/M stuff, like BDOS .. you CP/M'ers do that. }


  APOS          = #39;            {This is the ' symbol.}
  OPENCOMMENT   = '{';
  CLOSECOMMENT  = '}';

TYPE
  Str80  = STRING[80];

CONST
   {Note: These are the only valid characters that can be used in Turbo
    identifiers.}
  Identifier : SET OF CHAR = ['A'..'Z', '0'..'9', '_'];

VAR
  charpsn,
  linenum    : word;          {v1.3 INTEGER;}
  Lower,                      {v1.3 If TRUE, all Pascal reserved words
                               lowercased (but not the Borland ones!)}
  AllUpper   : BOOLEAN;       {if TRUE, ALL reserved words uppercased
                               (Borland ones also)}

  UcWord,                               {possible keyword, uppercased}
  Padded     : STRING[20];              {UcWord, padded with spaces}

  WorkLine,                             {v1.3 Build formatted output line}
  ProgLine   : String;                  {v1.3 STRING[128]}
  worklen    : BYTE absolute WorkLine;  {v1.3}

  RamWord    : STRING [100];

  InFile,
  OutFile : TEXT;
  UCReserved : ReservedArray;           {uppercased reserved word lines}


{ Multiple cmdline parm/wildcard stuff }
CONST
  MAXARGS = 10;                         {change as you like}

VAR
  Ok : BOOLEAN;
  argv, argc : Byte;
  Args : ARRAY[1..MAXARGS]              {array of cmdline parms}
           OF PathStr;                  {STRING[79]}

  Dir : DirStr;                         {STRING[79]}
  Name: NameStr;                        {STRING[8]}
  Ext : ExtStr;                         {STRING[4]}

  OutName : PathStr;                    {STRING[79]}

{SearchRec is declared in the Dos unit:}
(*
 TYPE SearchRec = RECORD
                    fill : ARRAY[1..21] OF Byte;
                    attr : Byte;
                    time : longint;
                    size : longint;
                    Name : STRING[12];
                  END;
*)
    SrchRec : SearchRec;


PROCEDURE Usage;
  {Give user help, terminate.
   Happens on cmd line of '?', '-?', '/?', '-h', '/h', or empty.
  }
  BEGIN
    WRITELN(
'UPCONV v1.3 - Convert Pascal reserved words to uppercase,');
    WRITELN(
'       If Turbo Pascal reserved words, convert to Borland style');
    WRITELN(
'Usage:  UPCONV [[-][/]U][L] file1[.typ]');
    WRITELN( 'Switches:');
    Writeln(
' -u, -U, /u, or /U : uppercase ALL reserved words');
    Writeln(
'                     (overriding the Borland Style)');
    Writeln(
' -l, -L, /l, or /L : lowercase Pascal (non-Borland) reserved words');
    WRITELN(
'Source filename file1 will be forced to .PAS if no type is given.');
    WRITELN(
'Formatted output filename forced to FILE1.FMT');
    WRITELN('Wildcards may be used for file1.typ');
    Halt;
  END;  {of Usage}


FUNCTION Uc (S : String) : String;
  {v1.3 Returns S uppercased}
  BEGIN
Inline(
  $31/$C0/       {  xor   ax,ax}
  $8A/$86/>S/    {  mov   al,>S[bp]  ;snarf the length}
  $09/$C0/       {  or    ax,ax      ;0 length?}
  $74/$18/       {  jz    Exit       ;yep, exit}

  $89/$C1/       {  mov   cx,ax      ;loop counter}
  $BA/$61/$20/   {  mov   dx,$2061   ;DL='a',DH=$20}
  $31/$F6/       {  xor   si,si}
                 {L1:}
  $46/           {  inc   si       ;next char}
  $36/           {  SS:}
  $8A/$82/>S/    {  mov   al,>S[bp][si]  ;snarf the char}
  $38/$D0/       {  cmp   al,dl}
  $72/$05/       {  jb    S1       ;already uppercase}
  $36/           {  SS:}
  $28/$B2/>S/    {  sub  >S[bp][si],dh   ;uppercase it}
                 {S1:}
  $E2/$EF);      {  loop  L1}
                 {Exit:}

    Uc := S;    {return the function}
  END;  {of Uc}


PROCEDURE Uc_Str(VAR S : String);
  {v1.3  Same as Uc, but changes the string "in place".}
  BEGIN
Inline(
  $8C/$DB/       {  mov   bx,DS      ;preserve DS}
  $C5/$B6/>S/    {  lds   si,>S[bp]  ;get the VAR addr}
  $31/$C0/       {  xor   ax,ax}
  $8A/$04/       {  mov   al,[si]    ;snarf the length}
  $89/$C1/       {  mov   cx,ax      ;loop counter}
  $E3/$0E/       {  jcxz  Exit       ;zero length, forget it}
                 {;}
  $BA/$61/$20/   {  mov   dx,$2061   ;DL='a',DH=$20}
                 {L1:}
  $46/           {  inc   si         ;next char}
  $8A/$04/       {  mov   al,[si]    ;snarf the char}
  $38/$D0/       {  cmp   al,dl}
  $72/$02/       {  jb    S1         ;already uppercase}
  $28/$34/       {  sub   [si],dh    ;uppercase it}
                 {S1:}
  $E2/$F5/       {  loop  L1}
                 {Exit:}
  $8E/$DB);      {  mov   DS,bx      ;restore DS}
  END;  {of Uc_Str}

PROCEDURE Lo_Str (VAR S : String);
  {v1.3 Lowercase a string}
  BEGIN
Inline(
  $1E/           {  push  DS}
  $C5/$B6/>S/    {  lds   si,>S[bp]}
  $31/$C0/       {  xor   ax,ax}
  $8A/$04/       {  mov   al,[si];snarf the length}
  $09/$C0/       {  or    ax,ax  ;0 length?}
  $74/$16/       {  je    Exit   ;yep, exit}

  $89/$C1/       {  mov   cx,ax}
  $BA/$41/$5A/   {  mov   dx,$5A41  ;DL='A',DH='Z'}
  $B4/$20/       {  mov   ah,$20 ;handy constant}
                 {L1:}
  $46/           {  inc   si     ;next char}
  $8A/$04/       {  mov   al,[si];snarf the char}
  $38/$D0/       {  cmp   al,dl  ;<'A'?}
  $72/$06/       {  jb    S1     ;yep}
  $38/$F0/       {  cmp   al,dh  ;>'Z'?}
  $77/$02/       {  ja    S1     ;yep}
  $00/$24/       {  add   [si],ah  ;lowercase}
                 {S1:}
  $E2/$F1/       {  loop  L1}
                 {Exit:}
  $1F);          {  pop   DS    ;restore}

  END;  {of Lo_Str}


PROCEDURE Get_Args;
  {v1.3 process command line for all target filenames.
        Move them into a dynamic array of PathStrs.
  }
  VAR Ch : CHAR;
  BEGIN
    argc := ParamCount;
    IF (argc = 0)                       {no parms at all}
    OR (argc > MAXARGS)                 {or more than we can handle}
    THEN Usage;                         {display help, die}

    FOR argv := 1 TO argc DO
      Args[argv] := Uc(ParamStr(argv)); {snarf parm, (uppercased)}
    Args[SUCC(argc)] := '';             {double-insure no overruns}

{ The first arg could've been a '-u' or '/u',
  or a '-l' or '/l'.
  Check that out now.  If so, we set a global and skip that arg
  when it comes time to open files.
}
    argv := 0;                          {assume we start at 1}
    Lower := FALSE;
    AllUpper := FALSE;                  {assume no switches}

    IF (LENGTH(Args[1]) = 2)            {2 chars to a switch}
    AND (Args[1][1] IN ['-','/'])       {first is a switch char}
    THEN BEGIN                          {we got a switch}
      Ch := Args[1][2];                 {grab 2d char}
      IF Ch IN ['?','H'] THEN Usage;    {help, die}

      IF Ch = 'U' THEN AllUpper := TRUE     {maybe upper switch}
      ELSE IF Ch = 'L' THEN Lower := TRUE;  {or maybe lower}
      IF NOT (AllUpper OR Lower)            {bogus switch}
      THEN Writeln('Unknown switch: [', Args[1], '], ignored!');

      Inc(argv);                        {skip 1st arg in any case}
    END;  {if Arg(1) was a switch}

  END;  {of Get_Args}


{$IFDEF NO_OVERWRITE}      {v1.3 only if we want no overwriting}

FUNCTION Exists(Name : PathStr) : BOOLEAN;
  {Returns TRUE if Name exists on current drive:\dir}
  VAR  F : TEXT;
  BEGIN
    Assign(F, Name);
    {$I-}  RESET (F);  {$I+}
    IF IOResult = 0 THEN BEGIN
      Exists := TRUE;
      Close(F);
    END
    ELSE Exists := FALSE;
  END;  {of Exists}

{$ENDIF}


PROCEDURE Open_Files;
  {Works FindNext if appropriate, else uses a new Arg string.
   Returns Global Ok boolean per success/failure.
  }
  VAR  FName : PathStr;
  BEGIN
    IF SrchRec.Name = '' THEN BEGIN         {time for a new name}

      Inc(argv);                            {bump for first/next name}
      Ok := (argv <= argc);
      IF NOT Ok THEN Exit;                  {all done, Ok FALSE}

      FSplit(Args[argv], Dir, Name, Ext);   {split up the new name}
      IF Ext = '' THEN Ext := '.PAS';       {force to .PAS type}
      FName := Dir + Name + Ext;            {build new name}
      FindFirst(FName,READONLY OR ARCHIVE,SrchRec)  {first time thru}
    END
    ELSE FindNext(SrchRec);                 {working a wildcard}

    Ok := (DosError = 0);               {from FindFirst or FindNext}
    IF NOT Ok THEN BEGIN                {not found}
      SrchRec.Name := '';               {Flag we need a new arg
                                         and FindFirst}
      Exit;                             {Ok is FALSE}
    END;

    FName := Dir + SrchRec.Name;        {new name from FindFirst/FindNext}
    Args[argv] := FName;                {Update Args for outside display}

{v1.3 We'll always force the '.FMT' file type for output.}

    FSplit(FName, Dir, Name, Ext);

    OutName := Name + '.FMT';           {build a new output path
                                         (current drive:\directory) }

{$IFDEF NO_OVERWRITE}

    IF Exists(OutName) THEN BEGIN       {If .FMT file already exists...}
      Writeln(Outname + ' already exists .. skipping!');
      Ok := FALSE;                      {no processing}
      Exit;
    END;
{$ENDIF}

    Assign(InFile, FName);
    Reset(InFile);                      {open input file}

    Assign(OutFile, OutName);
    {$I-}  REWRITE (OutFile);  {$I+}
    Ok := (IOResult = 0);
    IF NOT Ok THEN BEGIN
      Close(InFile);                    {be neat}
      Writeln('Unable to open file [' + OutName + ']');
    END;                                {Exit, Ok FALSE}
  END;  {of Open_Files}


PROCEDURE Uc_The_Array;
  {Create a new array of uppercased lines of reserved words.
   We just do this once.
  }
  VAR i : word;                         {v1.3 INTEGER;}
  BEGIN
    UcReserved := ReservedWords;        {v1.3 copy the entire array}
    FOR i := 1 TO NRLINES DO
      Uc_Str(UCReserved[i]);            {v1.3 and uppercase them all}

    END;  {of Uc_The_Array}


PROCEDURE Test_For_Reserved_Words;
  {Test if the current word (RamWord) is a reserved word.
   If so, write its equivalent (uppercased or Turbo Pascal format)
   out to our output file.
   Else just write it as it is.
  }
  VAR
    i,p,len : word;                     {v1.3 INTEGER;}
  BEGIN
    Padded := ' ' + Uc(RamWord) + ' ';  {bracket with spaces}
    len := LENGTH(RamWord);             {v1.3}

    FOR i := 1 TO NRLINES DO BEGIN      {check all the reserved words}
      p := POS(Padded, UcReserved[i]);  {is this word (padded and uppercased)
                                         in the uppercase reserved word
                                         line?}
      IF p > 0 THEN BEGIN               {yep}

        Inc(p);                            {bump past the space}
        IF AllUpper                        {uppercasing everything}
        THEN Padded := Copy(UcReserved[i], {so get word from uppercase table}
                            p, len)
        ELSE BEGIN                         {might be per Reserved table
                                            or lowercasing}
          Padded := Copy(ReservedWords[i], {word per our Reserved table}
                         p, len);          {uppercase or Borlandized}
          IF Lower
          THEN IF Padded = Uc(Padded)      {If the mixed-case Table word
                                            matches the uppercased word..
                                            it's non-Borland...}
            THEN Lo_Str(Padded);           {..so lowercase it}
        END;
{$IFDEF NOWORKLINE}

        Write(OutFile, Padded);
{$ELSE}
        WorkLine := WorkLine + Padded;     {v1.3 build in WorkLine}
{$ENDIF}
        Exit;                              {don't look at any more lines}
      END;  {if Padded in line}
    END;    {line-checking loop}

{We checked all the lines, didn't find our RamWord as a Reserved word}

{$IFDEF NOWORKLINE}
    WRITE (OutFile, RamWord);           {.. so write the original word}
{$ELSE}
    WorkLine := WorkLine + RamWord;     {v1.3 build WorkLine with orig word}
{$ENDIF}

  END;  {of Test_For_Reserved_Words}


PROCEDURE Process_A_Word;
  VAR
    len : byte;   {v1.3}
    strt : word;  {v1.3}
  BEGIN
    strt := charpsn;                    {v1.3 remember where we started}
    WHILE (UpCase (ProgLine [charpsn]) IN Identifier)  {it's a legal char}
    AND (charpsn <= LENGTH (ProgLine) )                {and line isn't done}
    DO  Inc(charpsn);                   {v1.3 bump ProgLine ptr}

    len := (charpsn - strt);            {v1.3 nr chars in word}
    RamWord[0] := CHAR(len);            {v1.3 force string length}
    Move(ProgLine[strt], RamWord[1], len);  {v1.3 copy portion of ProgLine}

    Test_For_Reserved_Words;            {check RamWord for reserved
                                         words, write out}
  END;  {of Process_A_Word}


PROCEDURE Scan_Till (SearchChar: CHAR);
  VAR
    Ch : CHAR;  {v1.2}
  BEGIN
    REPEAT
      IF charpsn > LENGTH (ProgLine) THEN BEGIN

{$IFDEF NOWORKLINE}
        WRITELN (OutFile);              {Simply terminates current line
                                         on output.}
{$ELSE}
        Writeln(OutFile,WorkLine);      {Write the WorkLine we have
                                         (Ok if it's empty)}
{$ENDIF}

        READLN (InFile, ProgLine);      {Gets the next input line.}
        charpsn := 1;
        WorkLine := '';                 {v1.3 Reinit WorkLine}
      END;

      IF ProgLine <> '' THEN BEGIN      {do non-blank lines}
        Ch := ProgLine[charpsn];        {v1.2 remember what this char was}

{$IFDEF NOWORKLINE}
        WRITE (OutFile, Ch);            {v1.2 write it out}
{$ELSE}

        Inc(worklen);                   {v1.3 bump workline length}
        WorkLine[worklen] := Ch;        {v1.3 stuff char in line}
(* same as
        WorkLine := WorkLine + Ch;
   but faster, tighter
*)
{$ENDIF}

        Inc(charpsn);                   {v1.3 bump char ptr}
      END
      ELSE Ch := #0;                    {v1.2 blank line, clear Ch}
    UNTIL (Ch = SearchChar)             {v1.2 the LAST char was end of
                                         quoted string or comment}
    OR EOF(InFile);
  END;  {of Scan_Till}


PROCEDURE Convert;
  VAR Ch : CHAR;
  BEGIN
    WRITE('Converting ', Args[argv], ' => ', OutName,
          ', Processing line: ');

    linenum := 0;

    WHILE NOT EOF(InFile) DO BEGIN
      charpsn := 1;
      WorkLine := '';                   {v1.3 clear WorkLine string}
      READLN (InFile, ProgLine);
      IF LENGTH(ProgLine) <> 0 THEN BEGIN     {v1.3 nonblank line}
        REPEAT
          Ch := Upcase(ProgLine[charpsn]);
          IF Ch IN Identifier           {could be a reserved word}
          THEN Process_A_Word           {so process it}
          ELSE BEGIN

{$IFDEF NOWORKLINE}
            WRITE (OutFile, ProgLine [charpsn]);  {v1.2 write out char}
{$ELSE}
            Inc(worklen);               {v1.3 bump WorkLine length}
            WorkLine[worklen] := Ch;    {v1.3 stuff char in WorkLine}
(* Same as
            WorkLine := WorkLine + Ch;
   but tighter, faster
*)
{$ENDIF}

            Inc(charpsn);               {v1.3 bump ptr}
            IF Ch = OPENCOMMENT
            THEN Scan_Till(CLOSECOMMENT)  {v1.2 write until
                                           closing comment}
            ELSE IF Ch = APOS
            THEN Scan_Till(APOS);       {v1.2 write until 2d '}
          END;
        UNTIL (charpsn > LENGTH (ProgLine));
      END; {If nonblank}

{$IFDEF NOWORKLINE}
      Writeln(OutFile);                 {v1.3 new line}
{$ELSE}
      Writeln(OutFile, WorkLine);       {v1.3 Output Workline
                                         (Ok if blank)}
{$ENDIF}
      Write(linenum:6,^H^H^H^H^H^H);    {display, back up}
      Inc(linenum);                     {v1.3 bump linenr}
    END;  {While}

    Writeln;                            {v1.3 clean up screen}

    CLOSE (InFile);
    CLOSE (OutFile);
  END;  {of Convert}


BEGIN  {main}

  Get_Args;                             {process cmdline args
                                         (may die)}
  Uc_The_Array;                         {v1.1 build an array of uppercased
                                         reserved word lines}

{Now we go into our file loop.
 We continue until FindNext returns no more files.
 Get_Args set argv appropriately.
}

  SrchRec.Name := '';                   {clear for first file}

  WHILE (SrchRec.Name <> '')            {we're working a wildcard}
  OR (argv < argc)                      {no wildcard, but still got args}
  DO BEGIN

    Open_Files;                         {open InFile,OutFile}

    IF Ok THEN Convert;                 {files open, do the conversion}

  END;  {until all done}

END.
