Program Sort_Tok;
{ Sorts the typed array of Pascal tokens,
  builds them into 80-char strings (suitable for incorporation
  as typed constant arrays into a Pascal program),
  outputs to TOKENS.STR.
}

Uses Crt;


{$I TOKENS.INC}

FUNCTION Up_Strg (S : String) : String;
  BEGIN
Inline(
  $31/$C0/       {  xor   ax,ax}
  $8A/$86/>S/    {  mov   al,>S[bp]  ;snarf the length}
  $09/$C0/       {  or    ax,ax      ;0 length?}
  $74/$18/       {  jz    Exit       ;yep, exit}

  $89/$C1/       {  mov   cx,ax      ;loop counter}
  $BA/$61/$20/   {  mov   dx,$2061   ;DL='a',DH=$20}
  $31/$F6/       {  xor   si,si}
                 {L1:}
  $46/           {  inc   si       ;next char}
  $36/           {  SS:}
  $8A/$82/>S/    {  mov   al,>S[bp][si]  ;snarf the char}
  $38/$D0/       {  cmp   al,dl}
  $72/$05/       {  jb    S1       ;already uppercase}
  $36/           {  SS:}
  $28/$B2/>S/    {  sub  >S[bp][si],dh   ;uppercase it}
                 {S1:}
  $E2/$EF);      {  loop  L1}
                 {Exit:}

    Up_Strg := S;    {return the function}
  END;  {of Up_Strg}


PROCEDURE Quick_Sort;

  PROCEDURE Alpha_Sort(l,r : INTEGER);
    VAR
      i,j : INTEGER;
      X,W : STRING[20];
    BEGIN
      i := l;
      j := r;

      X := Up_Strg(CToken[ (l+r) ShR 1 ]);

      REPEAT
        WHILE Up_Strg(CToken[i]) < X DO Inc(i);
        WHILE X < Up_Strg(CToken[j]) DO Dec(j);

        IF i <= j THEN BEGIN
          W := CToken[i];
          CToken[i] := CToken[j];
          CToken[j] := W;
          Inc(i);
          Dec(j);
        END
      UNTIL i > j;

      IF l < j THEN Alpha_Sort(l,j);
      IF i < r THEN Alpha_Sort(i,r)
    END;  {of Alpha_Sort}


  PROCEDURE Len_Sort(l,r : INTEGER);
    VAR
      i,j : INTEGER;
      X,W : STRING[20];
    BEGIN
      i := l;
      j := r;

      X := CToken[ (l+r) ShR 1 ];  {v1.3}

      REPEAT
        WHILE LENGTH(CToken[i]) > LENGTH(X) DO Inc(i);
        WHILE LENGTH(X) > LENGTH(CToken[j]) DO Dec(j);

        IF i <= j THEN BEGIN
          W := CToken[i];
          CToken[i] := CToken[j];
          CToken[j] := W;
          Inc(i);
          Dec(j);
        END
      UNTIL i > j;

      IF l < j THEN Len_Sort(l,j);
      IF i < r THEN Len_Sort(i,r)
    END;  {of Len_Sort}

  BEGIN  {Quick_Sort}
    Len_Sort(0,NRTOKENS);
    Alpha_Sort(0,NRTOKENS);
  END;  {of Quick_Sort}

CONST
  QUOTE = '''';

VAR
  Text_File : TEXT;
  indx      : word;
  Tok       : String;

BEGIN  {main}

  Quick_sort;

  Assign(Text_File,'TOKEN.STR');
  Rewrite(Text_File);

  FOR indx := 0 TO NRTOKENS DO BEGIN
    IF LENGTH(Tok) + LENGTH(CToken[indx]) < 78
    THEN Tok := Tok + ' ' + CToken[indx]
    ELSE BEGIN
      Writeln(QUOTE + Tok + ' ' + QUOTE);
      Writeln(Text_File,QUOTE + Tok + ' ' + QUOTE + ',');
      Tok := '';
    END;
  END;
  IF Tok <> '' THEN BEGIN
    Writeln(QUOTE + Tok + ' ' + QUOTE);
    Writeln(Text_File,QUOTE + Tok + ' ' + QUOTE);
  END;
  Close(Text_File);

END.
