{$A-,B-,E+,F+,I+,N-,O+,R+,S+,V-}
{$M 32000,64000,655360}

{ Test Program for testing ULDial }

Program TESTDIAL;

Uses DOS, OpCrt, OpString, OpFrame, OpWindow, OpKey,
     ULRoot, ULDial;

label
  Again;

var
  Msg : string;
  Choices : string;
  Prompt : string;
  Len : byte absolute Prompt;
  EditSt : string;
  ExitCode : word;
  TimeOut : word;
  N : longint;
  Dial : DialogBox;
  Error : word;

begin
  N := MemAvail;
  InitCrt;
  with ULRootColorSet do
  TextAttr := ColorMono(HotSpotColor, HotSpotMono);
  { Initialize the DialogBox for upto 3 lines of text upto 78 chars wide and
    upto 4 choices upto 10 chars wide each.}
  if not Dial.Init(3,234,4,40) then
  begin
    WriteLn('Insufficient memory.');
    Halt(1);
  end;
Again:
  ClrScr;
  WriteLn('Test of DialogBox.');
  WriteLn('Enter 2 or 3 lines of text that you want used for message.');
  WriteLn('Use blank line to end.');
  EditSt := '';
  with Dial do
  begin
    AddHeader(' DialogBox ',heTC);
    repeat
      Write('');
      ReadLn(Msg);
      if Msg <> '' then AddMessageString(Msg);
    until Msg = '';
    WriteLn('Enter up to 4 choices you want displayed for exiting.');
    WriteLn('Separate each word used for choice with a space.');
    Write('');
    ReadLn(Choices);
    AddChoiceString(Choices);
    WriteLn('If you want a string entry field, enter a 2 or 3 word prompt.');
    WriteLn('If you do not want an entry field, enter a blank line.');
    Write('');
    ReadLn(Prompt);
    if Prompt <> '' then
      AddStringEntryField(Prompt,1,1,CharStr('X',78),1,Len+2,60-Len,0,EditSt);
    WriteLn('If you want an automatic timeout, enter number of millisecond delay.');
    WriteLn('Enter 0 to disable this function.');
    ReadLn(TimeOut);
    SetTimeOut(TimeOut);
    Error := GetLastError;
    if Error <> 0 then
    begin
      WriteLn('Error: ', Error);
      Halt(1);
    end;
    Process;
    ExitCode := GetLastChoice;
    EditSt := GetEditedString;
    Done;
  end;
  WriteLn('You exited with code: ',ExitCode);
  if Prompt <> '' then
    WriteLn('The edited string was: ', EditSt);
  WriteLn('Press {Enter} to go again; any other key to quit...');
  ExitCode := ReadKeyWord;
  if ExitCode = Enter then
  begin
    Dial.Clear;
    Goto Again;
  end;
  wStack.Done;  { If you don't use this, you eat up 40 bytes of the heap.}
  RestoreCrt;
  WriteLn('Memory Available: Start:', N);
  WriteLn('                 Finish:',MemAvail);
end.
