{$A-,B-,D+,E+,F+,I+,L-,N-,O+,R+,S+,V-}
{$M 32000,0,655360}
{ Test Program for testing ULDbase }

Program TESTDBASE;

Uses DOS, StrnTTT5, OpCrt, OpDate, ULDbase;

type
  ascii_image = (ascii, image);
  KeyString = string[74];

  LibItem = record
    del : longint;
    sel : char;               {key}
    tag : char;               {key}
    IDNumStr : string[7];     {key}
    fname : string[12];       {key}
    source : string[6];       {key}
    fdate : date;             {key}
    fsize : longint;          {key}
    dnload : integer;         {key}
    ftype : ascii_image;
    keywords : KeyString;
  end;

type
  FileDbasePtr = ^FileDbase;
  FileDbase = object(Dbase)
    Stru : LibItem;           {must be first field added}
    Indices : dbIndexArray;
    constructor Init(fspec: PathStr; ftitle: string);
    destructor Done; virtual;
    procedure CreateIndex(var nfields, nkeys : byte);
  end;

var
   FdbPtr : FileDbasePtr;

(* FileDbase object methods *)

constructor FileDbase.Init(fspec:PathStr; ftitle: string);
var
  FD : DirStr;
  FN : NameStr;
  FE : ExtStr;
  NrFields, NrKeys : byte;
begin
  Fsplit(fspec,FD,FN,FE);
  FillChar(Stru, Sizeof(Stru), 0);
  CreateIndex(NrFields, NrKeys);
  Dbase.Init(FD+FN, ftitle, Sizeof(Stru), NrFields, NrKeys, @Indices);
  CurrentDbasePtr := @Self;    {essential to provide interface with B-Tree}
end;

procedure FileDbase.CreateIndex(var nfields, nkeys : byte);
{This must be custom made for each data base. Posit calculations
 are critical.}
var
  Posit : word;
begin
  Posit := 4;     {skip over the delete field of the data base record}
                  {consider it field 0}
                  {the following is first key}
  Indices[1].Init(Posit, CharTyp, 1, True, 'Selected', False, False);
  Inc(Posit);
  Indices[2].Init(Posit, CharTyp, 1, True, 'Tagged', True, False);
  Inc(Posit);
  Indices[3].Init(Posit, StrTyp, 7, False, 'IDNumber', True, False);
  Inc(Posit,8);
  Indices[4].Init(Posit, StrTyp, 12, True, 'FileName', True, True);
  Inc(Posit,13);
  Indices[5].Init(Posit, StrTyp, 6, True, 'Source', True, True);
  Inc(Posit,7);
  Indices[6].Init(Posit, DateTyp, 4, True, 'FileDate', True, True);
  Inc(Posit,4);
  Indices[7].Init(Posit, LongTyp, 4, True, 'FileSize', True, True);
  Inc(Posit,4);   {the following is last key}
  Indices[8].Init(Posit, IntTyp, 2, True, 'DownLoad', True, True);
  Inc(Posit,2);
  Indices[9].Init(Posit, EnumTyp, 1, True, 'FileType', True, True);
  Inc(Posit);
  Indices[10].Init(Posit, StrTyp, Sizeof(KeyString)-1, True, 'KeyWords', True, True);
  nfields := 10;  {these two parameters are defined here}
  nkeys := 8;     {to keep them close to index data}
end;

destructor FileDbase.Done;
begin
  Dbase.Done;
  Dispose(FdbPtr);
end;

begin
  ClrScr;
  WriteLn('Memory Available: ', MemAvail);
  WriteLn('Testing B-Tree Filer Data Base...');
  New(FdbPtr,Init('TESTLIB.DAT', 'Sig File Library'));
  if FdbPtr <> nil then
  with FdbPtr^ do
  begin
    ReOrganize;
    GetRecord(1);
    ShowRecord;
    Done;
  end;
  WriteLn('Memory Available: ', MemAvail);
end.
