
{$I-,V-,S-,R-,F-,B-}

     {*******************************************************************}
     {*                          TWOBRDOS.PAS                           *}
     {*                    Version 1.00 January 1993                    *}
     {*              Copyright (c) 1993 TurboPower Software             *}
     {*                                                                 *}
     {*                         By Lee Inman,                           *}
     {*                      TurboPower Software                        *}
     {*******************************************************************}

{$I BTDEFINE.INC}
{$I OPDEFINE.INC}

{$IFNDEF UseOPCRT}
  *ERROR* This program requires UseOPCRT to be defined in BTDEFINE.INC.
{$ENDIF}

unit BrDosCus;
  {-implementes a browse window for the custmer database}

interface

uses
  {.......................... Turbo Pascal units}
  Dos,                       {standard DOS unit}
  {.......................... Object Professional units}
  OpKey,                     {Key constants}
  OpConst,                   {error codes, etc.}
  OpRoot,                    {low-level objects, error codes, etc.}
  OpInline,                  {useful inline macros}
  OpString,                  {string handling}
  OpCrt,                     {basic screen handling}
  {$IFDEF UseMouse}
  OpMouse,                   {mouse processing}
  {$ENDIF}
  OpCmd,                     {command processing}
  OpFrame,                   {window frames}
  OpWindow,                  {windows}
  OpField,                   {data entry fields}
  OpSelect,                  {abstract selector}
  OpEntry,                   {data entry screens}
  OpMemo,                    {memo editor}
  {.......................... Optional NetWare support}
  {$IFDEF Novell}
  NetSema,                   {BONUS NetWare Semaphore unit}
  OopSema,                   {OOP Semaphore unit}
  {$ENDIF}
  {.......................... B-Tree Filer units}
  Filer,                     {database management}
  VRec,                      {variable length records}
  VRebuild,                  {database repair--variable length records}
  FBrowse,                   {object-oriented database browser}
  {.......................... Order Browser units}
  BrDosUtl,                  {Common utility functions}
  BrDosDat,                  {Global types, constants and variables}
  BrDosOrd;                  {Unit for order browser}


  procedure InitCustomers;
  {-Initialize entry screen, open database and create browser}
  procedure ProcessCustomers;
  {-Enter the browser process loop}
  procedure CloseCustomers;
  {-Close the file block}


implementation


var
  Customer       : CustomerDef;        {Currently selected record}
  CustomerFilter : CustomerDef;        {used for filtering}

  {data entry stuff}
const
  PhoneMask      : String[12] = '999-999-9999';
  ValidPhone     : String[12] = 'ppp-uuu-uuuu';
  ZipMask        : String[10] = '99999-9999';
  ValidZip       : String[10] = 'uuuuu-pppp';
  ValidationOff  : Boolean = False;

  {field IDs}
  idCustNum      = 0;
  idName         = 1;
  idCompany      = 2;
  idAddress      = 3;
  idCity         = 4;
  idState        = 5;
  idZipCode      = 6;
  idPhone        = 7;
  idNotes        = 8;

  {coordinates for entry screen and memo field windows}
  EntryXL        = 29;
  EntryYL        = 04;
  EntryXH        = 78;
  EntryYH        = 12;
  MemoXL         = 29;
  MemoYL         = 15;
  MemoXH         = 78;
  MemoYH         = 22;

var
  ES             : EntryScreen; {for entry screens}
  M              : Memo;        {for memo fields}
  ScrapCustomer    : CustomerDef;   {used for editing}
  VRecLen        : Word;
  {$IFDEF Novell}
  Sync           : FilerSemaphore;
  {$ENDIF}

{$IFDEF Novell}
  {$F+}
  function SemaphoreRefresh(FBP : FBrowserPtr) : Boolean;
  var
    Ticks : LongInt absolute $40:$6C;
    T : LongInt;
  begin
    {assume false}
    SemaphoreRefresh := False;

    with FBP^ do
      {do nothing if this is a single-user fileblock}
      if LongFlagIsSet(fbOptions, fbIsNet) then begin
        {save tick count}
        T := Ticks;

        {loop while key not pressed}
        while not cwCmdPtr^.cpKeyPressed do
          {is it time to check again?}
          if (Ticks-T) >= RefreshPeriod then
            {check to see if page stack has been invalidated}
            if Sync.IsDirty(GetKeyNumber) then begin
              {we need to refresh the display}
              SemaphoreRefresh := True;
              Exit;
            end
            else
              {save the current tick count}
              T := Ticks;
      end;
  end;
  {$F-}
{$ENDIF}

{$IFDEF UseAdjustableWindows}
const
  Step = 1;

  procedure MoveBrowseWindow;
    {-Move the browse window interactively}
  var
    Finished : Boolean;
  begin
    if VBC.IsZoomed then
      Exit;
    WriteFooter('',' Use cursor keys to move, <Enter> to accept');
    Finished := False;
    with VBC do
      repeat
        case ReadKeyWord of
          $4700 : MoveWindow(-Step, -Step); {Home}
          $4800 : MoveWindow(0, -Step);     {Up arrow}
          $4900 : MoveWindow(Step, -Step);  {PgUp}
          $4B00 : MoveWindow(-Step, 0);     {Left Arrow}
          $4D00 : MoveWindow(Step, 0);      {Right Arrow}
          $4F00 : MoveWindow(-Step, Step);  {End}
          $5000 : MoveWindow(0, Step);      {Down arrow}
          $5100 : MoveWindow(Step, Step);   {PgDn}
          $1C0D : Finished := True;         {Enter}
        end;

        if ClassifyError(GetLastError) = etFatal then
          Abort;
      until Finished;

    WriteFooter('','');
  end;

  procedure ResizeBrowseWindow;
    {-Resize the browse window interactively}
  var
    Finished : Boolean;
  begin
    if VBC.IsZoomed then
      Exit;
    WriteFooter('',' Use cursor keys to resize, <Enter> to accept');
    Finished := False;
    with VBC do
      repeat
        case ReadKeyWord of
          $4700 : ResizeWindow(-Step, -Step); {Home}
          $4800 : ResizeWindow(0, -Step);     {Up}
          $4900 : ResizeWindow(Step, -Step);  {PgUp}
          $4B00 : ResizeWindow(-Step, 0);     {Left}
          $4D00 : ResizeWindow(Step, 0);      {Right}
          $4F00 : ResizeWindow(-Step, Step);  {End}
          $5000 : ResizeWindow(0, Step);      {Down}
          $5100 : ResizeWindow(Step, Step);   {PgDn}
          $1C0D : Finished := True;           {Enter}
        end;

        if ClassifyError(GetLastError) = etFatal then
          Abort;
      until Finished;

    WriteFooter('','');
  end;

  procedure ToggleZoom;
    {-Toggle zoom status of the browse window}
  begin
    with VBC do begin
      if IsZoomed then
        Unzoom
      else
        Zoom;

      if ClassifyError(GetLastError) = etFatal then
        Abort;
    end;
  end;
{$ENDIF}

{$F+}
  function ValidateState(EFP : EntryFieldPtr; var Err : Word;
                         var ErrSt : StringPtr) : Boolean;
    {-Validate a state entry}
  const
    StateStrings   : array[1..51] of array[1..2] of Char = (
      'AK', 'AL', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DC', 'DE', 'FL', 'GA', 'HI',
      'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN',
      'MO', 'MS', 'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH',
      'OK', 'OR', 'PA', 'RI', 'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA',
      'WI', 'WV', 'WY');
    BadState : String[36] = 'Not a valid abbreviation for a state';
  var
    I  : Word;
    S  : String[2];
  begin
    ValidateState := True;

    S := Trim(EFP^.efEditSt^);
    if not ValidationOff then
      case Length(S) of
        1 :                  {no 1-character abbreviations}
          begin
            Err := ecPartialEntry;    {standard error code}
            ErrSt := @emPartialEntry; {standard error message}
            ValidateState := False;
          end;
        2 :                  {check list of valid abbreviations}
          begin
            for I := 1 to 51 do
              if S = StateStrings[I] then
                Exit;
            Err := 1; {arbitrary}
            ErrSt := @BadState;
            ValidateState := False;
          end;
      end;
  end;

  function ValidatePhone(EFP : EntryFieldPtr; var Err : Word;
                         var ErrSt : StringPtr) : Boolean;
    {-Validate a phone number}
  begin
    if ValidationOff then
      ValidatePhone := True
    else
      ValidatePhone := ValidateSubfields(ValidPhone, EFP, Err, ErrSt);
  end;

  function ValidateZip(EFP : EntryFieldPtr; var Err : Word;
                       var ErrSt : StringPtr) : Boolean;
    {-Validate a zip code}
  begin
    if ValidationOff then
      ValidateZip := True
    else
      ValidateZip := ValidateSubfields(ValidZip, EFP, Err, ErrSt);
  end;

  procedure PhoneZipConversion(EFP : EntryFieldPtr; PostEdit : Boolean);
    {-Conversion routine for phone numbers and zip codes.}
    {-Special note: This special conversion routine is needed to meet the
      demands of the Search routine, which allows searches based on partial
      zip codes and phone numbers. The ValidationOff flag used in the three
      validation routines shown above is needed for the same reason.}
  var
    S : String[20];
    SLen : Byte absolute S;
    AllDone : Boolean;
  begin
    with EFP^ do
      if PostEdit then begin
        S := efEditSt^;
        AllDone := False;
        repeat
          {trim trailing blanks and hyphens}
          case S[SLen] of
            ' ', '-' :
              Dec(SLen);
            else
              AllDone := True;
          end;
        until AllDone;
        String(efVarPtr^) := S;
      end
      else begin
        {is string too long? if so, truncate it}
        if Byte(efVarPtr^) > efMaxLen then
          Byte(efVarPtr^) := efMaxLen;

        {initialize the edit string}
        efEditSt^ := String(efVarPtr^);

        {merge picture mask characters if necessary}
        if Length(efEditSt^) < efMaxLen then
          MergePicture(efEditSt^, efEditSt^);
      end;
  end;
{$F-}

  procedure ClearCustomer(var Customer : CustomerDef);
    {-Set up for a new Customer record}
  begin
    FillChar(Customer, SizeOf(CustomerDef), 0);
    Customer.NotesLen := 1;
    Customer.Notes[1] := ^Z;
  end;

  function CompCustomer(var P1, P2 : CustomerDef) : Boolean;
    {-Compare two Customer records}
  begin
    CompCustomer := False;
    if P1.Dele <> P2.Dele then
      Exit;
    if P1.CustNum <> P2.CustNum then
      Exit;
    if P1.Name <> P2.Name then
      Exit;
    if P1.Company <> P2.Company then
      Exit;
    if P1.Address <> P2.Address then
      Exit;
    if P1.City <> P2.City then
      Exit;
    if P1.State <> P2.State then
      Exit;
    if P1.Zip <> P2.Zip then
      Exit;
    if P1.Telephone <> P2.Telephone then
      Exit;
    if P1.NotesLen <> P2.NotesLen then
      Exit;

    {compare memo fields quickly using routine in OPSTRING}
    if CompStruct(P1.Notes, P2.Notes, P1.NotesLen) <> Equal then
      Exit;

    CompCustomer := True;
  end;

  procedure FixHeader(Header : String; RecNum : LongInt);
    {-Fix the entry screen's header}
  var
    Redraw : Boolean;
  begin
    {fix the header}
    if RecNum <> 0 then
      Header := Header+' Record # '+Long2Str(RecNum);
    with ES, wFrame do
      ChangeHeaderString(0, ' '+Header+' ', Redraw);
  end;

  procedure DisplayMemoField;
    {-Display the memo field}
  begin
    {reinitialize}
    M.ReinitBuffer;
    ScrapCustomer.NotesLen := M.meTotalBytes;

    {display the contents of the memo}
    M.Draw;
  end;

  procedure EraseWindows;
    {-Erase the two windows}
  begin
    if ES.IsCurrent then
      ES.Erase;
    if M.IsCurrent then
      M.Erase;
    if ES.IsCurrent then
      ES.Erase;
  end;

  procedure DisplayMemoPrompt;
    {-Display prompt at bottom of screen while editing}
  begin
    WriteFooter('',
      Center('Press <^Enter> when done editing notes to return to entry screen',
             ScreenWidth));
  end;

  procedure DisplayCustomer(var Customer : CustomerDef; Header : String;
                          RecNum : LongInt);
    {-Show data about Customer}
  begin
    {copy into our scrap record}
    ScrapCustomer := Customer;

    {change the entry screen's header}
    FixHeader(Header, RecNum);

    {display entry screen}
    ES.Draw;

    {display memo field if appropriate}
    if RecNum <> 0 then
      DisplayMemoField;
  end;

  procedure EditMemoField;
    {-Edit the memo field}
  begin
    {display prompt}
    DisplayMemoPrompt;

    {do the editing}
    M.Select;
    M.Process;

    {save the number of bytes in the buffer}
    ScrapCustomer.NotesLen := M.meTotalBytes;
  end;

  function GetCustomer(var Customer : CustomerDef; Required : Boolean;
                     Header : String; RecNum : LongInt) : Boolean;
    {-Edit a Customer record}
  var
    Done : Boolean;
  begin
    {copy into our scrap record}
    ScrapCustomer := Customer;

    {need special validation?}
    ValidationOff := not Required;

    {set required status for customer number}
    ES.ChangeRequired(idCustNum, Required);

    {hide Notes field if searching}
    ES.ChangeHidden(idNotes, not Required);

    {change the entry screen's header}
    FixHeader(Header, RecNum);

    {draw the memo window if not searching}
    if Required then
      DisplayMemoField;

    {start editing on first field}
    ES.SetNextField(idCustNum);

    Done := False;
    repeat
      {start editing}
      ES.Process;

      {see if we need to edit another record}
      case ES.GetLastCommand of
        ccDone :             {^Enter, ^KD, or ^KQ}
          begin
            Done := True;
            GetCustomer := True;
          end;
        ccError,             {fatal error}
        ccQuit :             {Esc}
          begin
            Done := True;
            GetCustomer := False;
          end;
        ccNested :
          {edit the notes field}
          if Required then begin
            EditMemoField;
            ES.Select;
          end;
      end;
    until Done;

    {erase the two windows}
    EraseWindows;

    {return modified record, even if <Esc> was pressed--caller will ignore
     changes if appropriate}
    Customer := ScrapCustomer;

    {clear the prompt line}
    WriteFooter('','');
  end;

  function CreateCustomerFile : Boolean;
    {-Create the database fileblock}
  var
    IID : IsamIndDescr;
  begin
    IID[1].KeyL := CKey1Len;
    IID[1].AllowDupK := False;
    IID[2].KeyL := CKey2Len;
    IID[2].AllowDupK := True;
    BTCreateFileBlock(CustomerFile, CSectionLength, 2, IID);
    CreateCustomerFile := IsamOK;
  end;

  function CustomerLine(var Customer : CustomerDef; Row: Byte) : String;
    {-Return a string representing Customer}
  const
    HaveNotes : array[Boolean] of Char = (' ', #251);
  begin
    if CRowsPerItem > 1 then begin
      if Row = 1 then begin
        with Customer do
          CustomerLine :=
            Extend(CustNum, 5)+' '+
            Extend(Name, 25)+' '+
            Extend(Address, 25)+' '+
            HaveNotes[NotesLen > 1];
      end else if Row = 2 then begin
        with Customer do
          CustomerLine :=
            Extend(' ', 5)+' '+
            Extend(Company, 25)+' '+
            Extend(Trim(City)+', '+Trim(State)+' '+Trim(Zip), 25)+' '+
            Extend(Telephone, 12);
      end else
        CustomerLine := '----- row '+Long2Str(row)+' of record';
    end else if Row = 1 then begin
      with Customer do
        CustomerLine :=
          Extend(CustNum, 5)+' '+
          Extend(Name, 25)+' '+
          Extend(Company, 19)+' '+
          Extend(Address, 19)+' '+
          Extend(City, 13)+' '+
          Extend(State, 2)+' '+
          Extend(Zip, 5)+' '+
          Extend(Telephone, 12)+' '+
          HaveNotes[NotesLen > 1];
    end else
      CustomerLine := '----- row '+Long2Str(row)+' of record';
  end;

{$F+} {the next four routines are called indirectly}
  function BuildCustomerKey(var P; KeyNr : Integer) : IsamKeyStr;
    {-Return the key string for either of the two indexes}
  begin
    with CustomerDef(P) do
      case KeyNr of
        1 : BuildCustomerKey := Extend(StUpCase(CustNum),5);
        2 : BuildCustomerKey := Extend(Zip,10);
      end;
  end;

  {!!.01}
  procedure PreMoveCustomer(RecNum : LongInt; Key : IsamKeyStr;
                            FBP : FBrowserPtr);
  {RecNum is the reference number for the currently selected item. Key
   is the corresponding index key. FBP is the address of the FBrowser
   making the call.}
  var
    Ref: LongInt;
  begin
    if KeyPressed then Exit;

    if (CActKeyNr <> 1) then begin
      {Get the primary key for the current record}
      VBC.GetCurrentRecord(Customer, CDatLen);
      OrderLinkKey := BuildCustomerKey(Customer,1);
    end else
      OrderLinkKey := Key;

    {Update the order window}
    FBO.SetKeyRange(OrderLinkKey, OrderLinkKey);

    {Next two statemnets are used to force the order window to display}
    {starting at the first matching item rather than the last}
    FBO.fbSearchKey(Ref, OrderLinkKey);
    FBO.SetCurrentRecord(OrderLinkKey, Ref);
    FBO.UpdateContents;
  end;

  procedure BuildRow(Row : Byte; var DatS; DatLen : Word; Ref : LongInt;
                     Key : IsamKeyStr; var S : string; FBP : FBrowserPtr);
    {-Return one row of an item to the browser}
  var
    P : CustomerDef absolute DatS;
    SLen : Byte absolute S;
  begin
    if Ref <> -1 then
      S := CustomerLine(P,Row)
    else begin
      {Record is locked, indicate it on screen}
      S := '';
      while SLen < CMaxCols do
        S := S+'**   ';
      SLen := CMaxCols;
    end;
  end;

  procedure UpdateScreen(FBP : FBrowserPtr);
    {-Called by FBROWSE on each screen update}
  const
    Header : string =
    'Cust# Name                      Company             Address             City          St Zip   Phone        Notes';

  begin
    if CRowsPerItem > 1 then
      Header :=
    'Cust# Name/Company              Address/City St Zip       Notes/Phone';
    with fbColors, FBP^ do
      {Write the header line now}
      fFastWrite(
        Extend(Copy(Header, GetCurrentCol, Width), Width), 1, 1,
        ColorMono(HighlightColor, HighlightMono));
  end;
{$F-}

  function AddStructure(var P : CustomerDef; var Rec : LongInt) : Boolean;
    {-Add a new record}
  begin
    AddStructure := False;
    repeat
      BTAddVariableRec(PfC, Rec, P, P.NotesLen+SizeOf(CustomerDef)-SizeOf(CMemoField));
      if LockAbort then
        Exit;
    until not Locked;
    if not IsamOK then
      IsamErrorNum(IsamError)
    else begin
      VBC.fbOptionsOn(fbForceUpdate);
      AddStructure := True;
    end;
  end;

  function ModStructure(var P : CustomerDef; Rec : LongInt) : Boolean;
    {-Write record over previous version}
  begin
    ModStructure := False;
    repeat
      BTPutVariableRec( {was BTAddVariableRec}
        PfC, Rec, P, P.NotesLen+SizeOf(CustomerDef)-SizeOf(CMemoField));
      if LockAbort then
        Exit;
    until not Locked;
    if not IsamOK then
      IsamErrorNum(IsamError)
    else begin
      VBC.fbOptionsOn(fbForceUpdate);
      ModStructure := True;
    end;
  end;

  function DelStructure(var Rec : LongInt) : Boolean;
    {-Delete record}
  begin
    DelStructure := False;
    repeat
      BTDeleteVariableRec(PfC, Rec);
      if LockAbort then
        Exit;
    until not Locked;
    if not IsamOK then
      IsamErrorNum(IsamError)
    else begin
      VBC.fbOptionsOn(fbForceUpdate);
      DelStructure := True;
    end;
  end;

  function AddKey(K : IsamKeyStr; Rec : LongInt; KeyNr : Integer) : Boolean;
    {-Add new key}
  begin
    AddKey := False;
    repeat
      BTAddKey(PfC, KeyNr, Rec, K);
      if LockAbort then
        Exit;
    until not Locked;
    if not IsamOK then
      IsamErrorNum(IsamError)
    else
      AddKey := True;
  end;

  function EraseKey(K : IsamKeyStr; Rec : LongInt; KeyNr : Integer) : Boolean;
    {-Remove a key}
  begin
    EraseKey := False;
    repeat
      BTDeleteKey(PfC, KeyNr, Rec, K);
      if LockAbort then
        Exit;
    until not Locked;
    if not IsamOK then
      IsamErrorNum(IsamError)
    else
      EraseKey := True;
  end;

  function ModKey(AltK, NeuK : IsamKeyStr; Rec : LongInt; KeyNr : Integer) : Boolean;
    {-Replace a key}
  begin
    ModKey := False;
    if EraseKey(AltK, Rec, KeyNr) then
      if AddKey(NeuK, Rec, KeyNr) then
        ModKey := True;
  end;

  procedure Reposition(UserKey : IsamKeyStr);
    {-Set sequential file pointer to another key}
  var
    Rec : LongInt;
  begin
    repeat
      BTFindKey(PfC, 1, Rec, UserKey);
      if LockAbort then
        Exit;
    until not Locked;
    if not IsamOK then
      CActRec := 0;
  end;

  function LockAll : Boolean;
    {-Lock all open files, returning true if successful}
  var
    OK : Boolean;
  begin
    LockAll := False;
    repeat
      BTLockAllOpenFileBlocks;
      if not IsamOK then begin
        if not YesNo('The file is presently in use. Try again?', 'Y') then
          Exit;
        OK := False;
      end
      else
        OK := True;
    until OK;
    LockAll := True;
  end;

  procedure NewStructure;
    {-Prompt for and add new record}
  label
    Retry;
  var
    CustomerTemp : CustomerDef;
    Key1, Key2 : IsamKeyStr;
    Rec : LongInt;
    KExists, OK : Boolean;
  begin
    WriteHeader(VBC, CActKeyNr, ' New Entry ', True);
    ClearCustomer(CustomerTemp);

Retry:
    {Get the new record}
    if not GetCustomer(CustomerTemp, True, 'Add Record', 0) then
      Exit;

    {make the index keys}
    Key1 := BuildCustomerKey(CustomerTemp, 1);
    Key2 := BuildCustomerKey(CustomerTemp, 2);

    {Lock the database in order to safely add the record}
    if not LockAll then
      Exit;

    {Assure it's not a duplicate key}
    repeat
      KExists := BTKeyExists(PfC, 1, Rec, Key1);
      if LockAbort then begin
        BTUnLockAllOpenFileBlocks;
        Exit;
      end;
    until not Locked;

    if KExists then begin
      BTUnLockAllOpenFileBlocks;
      if not YesNo('The customer# already exists. Try again?', 'Y') then
        Exit
      else
        goto Retry;
    end;

    {Add the record and its keys}
    OK := AddStructure(CustomerTemp, Rec);
    if OK then
      OK := AddKey(Key1, Rec, 1);
    if OK then
      OK := AddKey(Key2, Rec, 2);

    {$IFDEF Novell}
    if BTNetSupported = Novell then begin
      Sync.IndicateDirty(1);
      Sync.IndicateDirty(2);
    end;
    {$ENDIF}

    {Save global pointers to the current record}
    if OK then begin
      CActRec := Rec;
      case CActKeyNr of
        1 : CActKey := Key1;
        2 : CActKey := Key2;
      end;
      VBC.SetCurrentRecord(CActKey, CActRec);
    end;

    BTUnLockAllOpenFileBlocks;
  end;

  procedure NewRandomCustomer(CustomerTemp: CustomerDef);
  var
    Key1, Key2 : IsamKeyStr;
    Rec : LongInt;
    KExists, OK : Boolean;
  begin
    {make the index keys}
    Key1 := BuildCustomerKey(CustomerTemp, 1);
    Key2 := BuildCustomerKey(CustomerTemp, 2);

    {Lock the database in order to safely add the record}
    if not LockAll then
      Exit;

    {Assure it's not a duplicate key}
    repeat
      KExists := BTKeyExists(PfC, 1, Rec, Key1);
      if LockAbort then begin
        BTUnLockAllOpenFileBlocks;
        Exit;
      end;
    until not Locked;

    if KExists then Exit;

    {Add the record and its keys}
    OK := AddStructure(CustomerTemp, Rec);
    if OK then
      OK := AddKey(Key1, Rec, 1);
    if OK then
      OK := AddKey(Key2, Rec, 2);

    {$IFDEF Novell}
    if BTNetSupported = Novell then begin
      Sync.IndicateDirty(1);
      Sync.IndicateDirty(2);
    end;
    {$ENDIF}

    {Save global pointers to the current record}
    if OK then begin
      CActRec := Rec;
      case CActKeyNr of
        1 : CActKey := Key1;
        2 : CActKey := Key2;
      end;
    end;

    BTUnLockAllOpenFileBlocks;
  end;

  procedure Modify;
    {-Modify an existing record}
  label
    Retry;
  var
    CustomerTemp : CustomerDef;
    CustomerTemp1 : CustomerDef;
    KExists, OK : Boolean;
    Rec : LongInt;
    Escaped : Boolean;
    NoChanges : Boolean;
  begin
    WriteHeader(VBC, CActKeyNr, ' Modify ', True);
    CustomerTemp := Customer;

Retry:
    Escaped := not GetCustomer(CustomerTemp, True, 'Modifying', CActRec);
    NoChanges := CompCustomer(Customer, CustomerTemp);
    if Escaped and not NoChanges then
      NoChanges := YesNo('Ignore changes to record?', 'N');
    if NoChanges then begin
      DispMessageTemp('Files not changed.', 250);
      Exit;
    end;

    {Lock the database in order to safely modify the record}
    if not LockAll then
      Exit;

    if BuildCustomerKey(CustomerTemp, 1) <>
       BuildCustomerKey(Customer, 1) then begin
      KExists := BTKeyExists(PfC, 1, CActRec, BuildCustomerKey(CustomerTemp, 1));
      if not IsamOK then begin
        BTUnLockAllOpenFileBlocks;
        IsamErrorNum(IsamError);
        Exit;
      end;
      if KExists then begin
        BTUnLockAllOpenFileBlocks;
        if not YesNo('The customer# already exists. Try again?', 'Y') then
          Exit
        else
          goto Retry;
      end;
    end;

    Rec := CActRec;
    {Read actual disk data}
    BTGetVariableRec(PfC, Rec, CustomerTemp1, VRecLen);
    if not IsamOK then begin
      BTUnLockAllOpenFileBlocks;
      DispMessageTemp('Record could not be read from disk.', 1000);
      Exit;
    end;

    if CustomerTemp1.Dele <> LongInt(0) then begin
      BTUnLockAllOpenFileBlocks;
      DispMessageTemp('The record has been erased in the meantime.', 1000);
      Exit;
    end;

    if not CompCustomer(CustomerTemp1, Customer) then begin
      BTUnLockAllOpenFileBlocks;
      DispMessageTemp('The record has been changed in the meantime.', 1000);
      Customer := CustomerTemp1;
      Exit;
    end;

    OK := ModStructure(CustomerTemp, CActRec);
    if OK then
      if BuildCustomerKey(CustomerTemp, 1) <>
         BuildCustomerKey(Customer, 1) then begin
        OK := ModKey(BuildCustomerKey(Customer, 1),
              BuildCustomerKey(CustomerTemp, 1), CActRec, 1);
        if OK then
          Reposition(BuildCustomerKey(CustomerTemp, 1));
      end;
    if OK then
      if BuildCustomerKey(CustomerTemp, 2) <>
         BuildCustomerKey(Customer, 2) then
        OK := ModKey(BuildCustomerKey(Customer, 2),
              BuildCustomerKey(CustomerTemp, 2), CActRec, 2);

    BTUnLockAllOpenFileBlocks;
    if OK then begin
      Customer := CustomerTemp;
      VBC.SetCurrentRecord(BuildCustomerKey(Customer, CActKeyNr), CActRec);
      {$IFDEF Novell}
      if BTNetSupported = Novell then begin
        Sync.IndicateDirty(1);
        Sync.IndicateDirty(2);
      end;
      {$ENDIF}
    end;
  end;

  procedure Delete;
    {-Prompt for and delete a record}
  var
    Key,
    Key1, Key2 : IsamKeyStr;
    OK, Del    : Boolean;
    Ref        : LongInt;

  begin
    WriteHeader(VBC, CActKeyNr, ' Deleting ', True);

    {See if this customer has any related orders}
    {if so - don't delete}
    Key := BuildCustomerKey(Customer, 1);
    Key1 := BuildCustomerKey(Customer, 1);
    BTSearchKey(PfO, 1, Ref, Key);
    if (Key = Key1) and (IsamError <> 10210) then begin
      RingBell;
      DispMessageTemp(
      'This customer has order entries.  Delete orders first.', 1500);
      Exit;
    end;

    DisplayCustomer(Customer, 'Deleting', CActRec);
    Del := YesNo('Should the record really be deleted?', 'N');
    EraseWindows;
    if not Del then
      Exit;

    Key2 := BuildCustomerKey(Customer, 2);

    {Lock the database}
    if not LockAll then
      Exit;

    OK := EraseKey(Key1, CActRec, 1);
    if OK then
      OK := EraseKey(Key2, CActRec, 2);
    if OK then
      OK := DelStructure(CActRec);
    if not OK then
      IsamErrorNum(IsamError);

    {$IFDEF Novell}
    if OK and (BTNetSupported = Novell) then begin
      Sync.IndicateDirty(1);
      Sync.IndicateDirty(2);
    end;
    {$ENDIF}

    BTUnLockAllOpenFileBlocks;
  end;

  function MatchString(var SG, ST : String) : Boolean;
    {-Return true if SG and ST match}
  begin
    if Length(SG) = 0 then
      {Nothing to match against}
      MatchString := True
    else
      {Match if ST starts with SG}
      MatchString := (Pos(StUpCase(SG), StUpCase(ST)) = 1);
  end;

  function MatchCustomer(var PG, PT : CustomerDef) : Boolean;
    {-Compare two Customer records}
  begin
    MatchCustomer := False;
    if PT.Dele <> 0 then
      Exit;
    if not MatchString(PG.CustNum, PT.CustNum) then
      Exit;
    if not MatchString(PG.Name, PT.Name) then
      Exit;
    if not MatchString(PG.Company, PT.Company) then
      Exit;
    if not MatchString(PG.Address, PT.Address) then
      Exit;
    if not MatchString(PG.City, PT.City) then
      Exit;
    if not MatchString(PG.State, PT.State) then
      Exit;
    if not MatchString(PG.Zip, PT.Zip) then
      Exit;
    if not MatchString(PG.Telephone, PT.Telephone) then
      Exit;
    MatchCustomer := True;
  end;

  function GetNextRec(var Fptr       : IsamFileBlockPtr;
                      var Data       : CustomerDef;
                      KeyNr          : Integer;
                      var Rec        : LongInt;
                      var UserKey    : IsamKeyStr) : Boolean;
    {-Get next record in index order}
  begin
    GetNextRec := False;

    {Get next sequential key}
    repeat
      BTNextKey(Fptr, KeyNr, Rec, UserKey);
      if LockAbort then
        Exit;
    until not Locked;

    if not IsamOK and (IsamError = 10250) then
      {At end of list, try once more to wrap to beginning}
      repeat
        BTNextKey(Fptr, KeyNr, Rec, UserKey);
        if LockAbort then
          Exit;
      until not Locked
    else
      GetNextRec := True;
    if not IsamOK then
      Exit;

    {Get associated data}
    repeat
      BTGetVariableRec(Fptr, Rec, Data, VRecLen);
      if LockAbort then
        Exit;
    until not Locked;
  end;

  procedure Search;
    {-Search for a record}
  var
    R : LongInt;
    SearchKey : Integer;
    OK : Boolean;
    Found : Boolean;
    Key : IsamKeyStr;
    CustomerGoal : CustomerDef;
    CustomerTemp : CustomerDef;

    procedure NotFoundMessage;
    begin
      DispMessage('No matching record found', True, True);
    end;

  begin
    WriteHeader(VBC, CActKeyNr, ' Search Key ', True);
    ClearCustomer(CustomerGoal);
    ClearCustomer(CustomerTemp);

    {Get search target}
    ValidationOff := True;
    if not GetCustomer(CustomerGoal, False, 'Search', 0) or
    CompCustomer(CustomerTemp, CustomerGoal) then
      {Nothing entered}
      Exit;

    WriteFooter('','Searching... ');

    {See which key to search on, if any}
    if Length(CustomerGoal.CustNum) <> 0 then
      SearchKey := 1
    else if Length(CustomerGoal.Zip) <> 0 then
      SearchKey := 2
    else
      SearchKey := 0;

    if SearchKey <> 0 then begin
      {Use the index system to position to the nearest record}
      Key := BuildCustomerKey(CustomerGoal, SearchKey);
      repeat
        BTSearchKey(PfC, SearchKey, R, Key);
        if LockAbort then
          Exit;
      until not Locked;
      if not IsamOK then begin
        if IsamError = 10210 then
          NotFoundMessage
        else
          IsamErrorNum(IsamError);
        Exit;
      end;

      {Get the record}
      repeat
        BTGetVariableRec(PfC, R, CustomerTemp, VRecLen);
        if LockAbort then
          Exit;
      until not Locked;

      {Position current record pointer at least near to the goal}
      CActRec := R;
      CActKey := BuildCustomerKey(CustomerTemp, CActKeyNr);

      {Does it match the goal?}
      Found := MatchCustomer(CustomerGoal, CustomerTemp);
      if Found and VBC.IsFilteringEnabled then
        Found := MatchCustomer(CustomerFilter, CustomerTemp);
    end
    else begin
      {Start sequential search at the currently active record}
      R := CActRec;
      BTFindKeyAndRef(PfC, CActKeyNr, R, CActKey, 0);
      Found := False;
    end;

    if not Found then begin
      {Sequential search, starting one beyond current position}
      if SearchKey = 0 then
        SearchKey := CActKeyNr;
      repeat
        OK := GetNextRec(PfC, CustomerTemp, SearchKey, R, Key);
        if not IsamOK then
          Exit;
        Found := MatchCustomer(CustomerGoal, CustomerTemp);
        if Found and VBC.IsFilteringEnabled then
          Found := MatchCustomer(CustomerFilter, CustomerTemp);
      until Found or (R = CActRec);
    end;

    if Found then begin
      CActRec := R;
      CActKey := BuildCustomerKey(CustomerTemp, CActKeyNr);
      VBC.SetCurrentRecord(CActKey, CActRec);
    end
    else
      NotFoundMessage;
  end;

  procedure Status;
    {-Show the number of records}
  const
    ModeSt : array[OpenMode] of string[6] = ('Normal', 'Save');
  var
    F, U, K : LongInt;
  begin
    WriteHeader(VBC, CActKeyNr, ' Status ', True);
    repeat
      U := BTUsedRecs(PfC);
      if LockAbort then
        Exit;
    until not Locked;

    repeat
      F := BTFreeRecs(PfC);
      if LockAbort then
        Exit;
    until not Locked;
    repeat
      K := BTUsedKeys(PfC, 1);
      if LockAbort then
        Exit;
    until not Locked;
    DispMessage(
      'Records:'+Long2Str(K)+
      ', Sections:'+Long2Str(U)+
      ', Deleted:'+Long2Str(F)+
      ', Mode:'+ModeSt[Mode]+
      ', Station:'+Long2Str(BTGetInternalDialogID(PfC)),
      True, False);
  end;

  function Long2StrDigits(L : LongInt; NumDigits : Byte) : String;
  {-Convert a longint to a string, right justified to NumDigits}
  var
    S : String;
  begin
    Str(L:NumDigits,S);
    Long2StrDigits := S;
  end;

  {$F+}
  procedure UserStatusRoutine(KeyNr : Integer;
                              NumRecsRead,
                              NumRecsWritten : LongInt;
                              var Data;
                              Len : Word);
  {-Display information while rebuilding database}
  var
    StatStr : String[80];
  begin
    StatStr := 'Working on key --> '+Long2StrDigits(KeyNr,1)+
               '   records read --> '+Long2StrDigits(NumRecsRead,6)+
               '   written --> '+Long2StrDigits(NumRecsWritten,6);
    WriteFooter('',StatStr);
  end;
  {$F-}

  function Reconstruct : Boolean;
    {-Reconstruct the database from the datafile}
  var
    IID : IsamIndDescr;
  begin
    IID[1].KeyL := CKey1Len;
    IID[1].AllowDupK := False;
    IID[2].KeyL := CKey2Len;
    IID[2].AllowDupK := True;
    IsamRexUserProcPtr := @UserStatusRoutine;  {set user status procedure}
    RebuildVFileBlock(Customerfile, CSectionLength, 2, IID, @BuildCustomerKey);
    Reconstruct := IsamOK;
  end;

  function OpenedCustomerFiles(var Pf: IsamFileBlockPtr; FName: string) : Boolean;
    {-Try to open existing database files}
  var
    OK, OK1 : Boolean;
  begin
    OpenedCustomerFiles := False;
    repeat
      BTOpenFileBlock(Pf, FName, False, False, (Mode = SaveMode),
        BTNetSupported <> NoNet);
      OK := IsamOK;
      if not IsamOK then begin
        if IsamError = 10010 then begin
          if YesNo('Index file defective. Rebuild it?', 'Y') then
            OK1 := Reconstruct
          else
            Exit;
        end
        else if IsamError = 9903 then begin
          if YesNo('Customer data file does not exist. Create new one?', 'Y') then begin
            if not CreateCustomerFile then
              Exit;
          end
          else
            Exit;
        end
        else begin
          if YesNo('Data error '+Long2Str(IsamError)+'. Attempt rebuild?', 'Y') then
            OK1 := Reconstruct
          else
            Exit;
        end;
      end;
    until OK;
    OpenedCustomerFiles := True;
  end;

  procedure SwitchKeys;
    {-Make the other key active}
  begin
    CActKeyNr := (CActKeyNr and 1) + 1;
    CActKey := BuildCustomerKey(Customer, CActKeyNr);
    VBC.SetKeyNumber(CActKeyNr);
    VBC.SetCurrentRecord(CActKey, CActRec);
  end;

  {---------------------------filtering hooks-----------------------------
    The following routine is used to implement the special filtering
    capabilities of FBDEMO. When the F6 key is pressed, the user is
    prompted for information to be used to determine what records should
    appear in the browser.
  ------------------------------------------------------------------------}
  {$F+}
  function ValidateCustomer(Ref : LongInt; Key : IsamKeyStr;
                          FB : FBrowserPtr) : Boolean;
    {-Validate a data record against the current Browser filter}
  var
    Matched : Boolean;
  begin
    FB^.GetRecord(Ref, Customer, CDatLen);
    if not IsamOK then
      Matched := False
    else  {is it a match?}
      Matched := MatchCustomer(CustomerFilter, Customer);
    ValidateCustomer := Matched;
  end;
  {$F-}

  procedure Filter;
    {-Prompt for information used by Browser filtering routines}
  var
    CustomerGoal, CustomerTemp : CustomerDef;
  begin
    WriteHeader(VBC, CActKeyNr, ' Filtering Info ', True);

    {cancel existing filter}
    VBC.SetFilterFunc(NullFilterFunc);

    ClearCustomer(CustomerTemp);
    ClearCustomer(CustomerGoal);

    {get filtering information}
    if GetCustomer(CustomerGoal, False, 'Filter', 0) then
      {did user enter anything?}
      if not CompCustomer(CustomerTemp, CustomerGoal) then
        {confirm that user desires filtering}
        if YesNo('Enable filtering with this information?', 'Y') then begin
          CustomerFilter := CustomerGoal;
          VBC.SetFilterFunc(ValidateCustomer);
          VBC.UpdateContents;
        end;
  end;

  procedure RebuildData;
    {-Purge deleted records and rebuild indices}
  begin
    WriteHeader(VBC, CActKeyNr, ' Rebuild ', True);
    WriteFooter('','Please wait... ');
    BTCloseFileBlock(PfC);
    if not IsamOK then begin
      IsamErrorNum(IsamError);
      Halt;
    end;
    if not Reconstruct then begin
      DispMessage('Unable to rebuild data files!', True, True);
    end;

    if not OpenedCustomerFiles(PfC, CustomerFile) then begin
      IsamErrorNum(IsamError);
      Halt;
    end;
    CActRec := 0;
    CActKeyNr := 1;
    CActKey := '';

    {reset file block pointer in Browser, in case it changed}
    VBC.SetFileBlockPtr(PfC);
  end;

{$F+}
  procedure ErrorHandler(UnitCode : Byte; var ErrCode : Word; Msg : String);
    {-Display messages for errors reported by OPENTRY/OPMEMO/FBROWSE}
  var
    P : Pointer;
  begin
    {try to save underlying text}
    if not SaveWindow(1, ScreenHeight, ScreenWidth, ScreenHeight, True, P) then begin
      RingBell;
      Exit;
    end;

    if Msg = '' then
      Msg := 'Unknown error: '+Long2Str(ErrCode);

    {display the error message}
    if ErrCode = epFatal+ecIsamError then
      IsamErrorNum(IsamError)
    else
      DispMessage(Msg, True, True);

    {restore underlying text}
    RestoreWindow(1, ScreenHeight, ScreenWidth, ScreenHeight, True, P);
  end;

  procedure PreEdit(ESP : EntryScreenPtr);
    {-Display a help prompt for the current field}
  var
    S : String[40];
  begin
    case ESP^.GetCurrentID of
      idCustNum   : S := 'Enter customer number';
      idName      : S := 'Enter name';
      idCompany   : S := 'Enter company name';
      idAddress   : S := 'Enter street address';
      idCity      : S := 'Enter city of residence';
      idState     : S := 'Enter state of residence';
      idZipCode   : S := 'Enter a 5- or 9-digit zip code';
      idPhone     : S := 'Enter phone number';
      idNotes     : S := 'Press <Enter> to edit memo field';
    end;
    WriteFooter('',' <^Enter> Done  <Esc> Abort  '+S);
  end;

  procedure MemoFieldStatus(MP : MemoPtr);
    {-Display status line for memo field}
  const
    StatusLine : String[48] =
    {         1         2         3         4        }
    {123456789012345678901234567890123456789012345678}
    ' Line: xxx Column: xxx 100%  Insert Indent Wrap ';
    InsertSt : array[Boolean] of String[6] = (' Over ', 'Insert');
    IndentSt : array[Boolean] of String[6] = ('      ', 'Indent');
    WrapSt   : array[Boolean] of String[4] = ('    ', 'Wrap');
  var
    S  : String[5];
    {$IFDEF UseMouse}
    SaveMouse : Boolean;
    {$ENDIF}
  begin
    with FbColors, MP^ do begin
      {insert line number}
      S := Long2Str(meCurLine);
      S := Pad(S, 3);
      Move(S[1], StatusLine[8], 3);

      {insert column number}
      S := Long2Str(meCurCol);
      S := Pad(S, 3);
      Move(S[1], StatusLine[20], 3);

      {insert percentage of buffer used}
      S := Real2Str(Trunc((meTotalBytes*100.0)/(meBufSize-2)), 3, 0);
      Move(S[1], StatusLine[24], 3);

      {plug in state stuff}
      Move(InsertSt[meOptionsAreOn(meInsert)][1], StatusLine[30], 6);
      Move(IndentSt[meOptionsAreOn(meIndent)][1], StatusLine[37], 6);
      Move(WrapSt[meOptionsAreOn(meWordWrap)][1], StatusLine[44], 4);

      {$IFDEF UseMouse}
      HideMousePrim(SaveMouse);
      {$ENDIF}

      {display status line}
      FastWrite(
        StatusLine, MemoYH+1, MemoXL+1, ColorMono(PromptColor, PromptMono));

      {$IFDEF UseMouse}
      ShowMousePrim(SaveMouse);
      {$ENDIF}
    end;
  end;
{$F-}

  procedure InitEntryScreen;
    {-Set up for data entry screens}
  const
    Options     = wClear+wBordered;
    CustNumMask = '!!!!!';
    M15         = 'AAAAAAAAAAAAAAA';
    M25         = 'AAAAAAAAAAAAAAAAAAAAAAAAA';
    NotesMsg    : string[1] = #14;
  begin
    {clear the scrap record used for editing}
    ClearCustomer(ScrapCustomer);

    {.F-}
    {initialize the entry screen}
    if not ES.InitCustom(EntryXL,          {left column of window}
                         EntryYL,          {top row of window}
                         EntryXH,          {right column of window}
                         EntryYH,          {bottom row of window}
                         FbColors,         {color set}
                         Options)          {window options}
    then
      Abort;

    {add dummy header}
    ES.wFrame.AddHeader(' dummy ', heTC);

    {set field delimiters}
    ES.SetDelimiters('[', ']');

    {set entry screen options}
    ES.SetWrapMode(WrapAtEdges);

    {set field editing options}
    ES.esFieldOptionsOn(efBeepOnError+efClearFirstChar);

    {add each of the edit fields in order: left to right, top to bottom}
    {               Prompt               ---Field--- Help              }
    { Prompt        Row Col Picture      Row Col Len Index     Variable}

    ES.AddStringField(
      'Customer#',  01, 05, CustNumMask, 01, 21, 05, 00, ScrapCustomer.CustNum);

    ES.AddStringField(
      'Name',       02, 05, M25,         02, 21, 25, 01, ScrapCustomer.Name);

    ES.AddStringField(
      'Company',    03, 05, M25,         03, 21, 25, 02, ScrapCustomer.Company);

    ES.AddStringField(
      'Address',    04, 05, M25,         04, 21, 25, 03, ScrapCustomer.Address);

    ES.AddStringField(
      'City',       05, 05, M15,         05, 21, 15, 04, ScrapCustomer.City);

    ES.AddStringField(
      'State',      06, 05, 'AA',        06, 21, 02, 05, ScrapCustomer.State);
    ES.ChangeValidation(idState, ValidateState);

    ES.AddStringField(
      'Zip',        07, 05, ZipMask,     07, 21, 10, 06, ScrapCustomer.Zip);
    ES.ChangeConversion(idZipCode, PhoneZipConversion);
    ES.ChangeValidation(idZipCode, ValidateZip);

    ES.AddStringField(
      'Telephone',  08, 05, PhoneMask,   08, 21, 12, 07, ScrapCustomer.Telephone);
    ES.ChangeConversion(idPhone, PhoneZipConversion);
    ES.ChangeValidation(idPhone, ValidatePhone);

    ES.esFieldOptionsOff(efMapCtrls);
    ES.AddNestedStringField(
      'Notes',      09, 05, '',          09, 21, 01, 08, NotesMsg);
    {.F+}

    {install user-written event handlers}
    ES.SetPreEditProc(PreEdit);
    ES.SetErrorProc(ErrorHandler);

    {check for error}
    if ES.GetLastError <> 0 then
      Abort;
  end;

  procedure InitMemoFields;
    {-Set up for memo fields}
  const
    Options = wClear+wBordered;
  begin
    {deactivate <Esc>, use <^Enter> instead}
    MemoCommands.AddCommand(ccNone, 1, Ord(^[), 0);
    MemoCommands.AddCommand(ccQuit, 1, Ord(^J), 0);

    {.F-}
    {initialize the memo}
    if not M.InitCustom(MemoXL,                {left column of window}
                        MemoYL,                {top row of window}
                        MemoXH,                {right column of window}
                        MemoYH,                {bottom row of window}
                        FbColors,              {color set}
                        Options,               {window options}
                        SizeOf(CMemoField),    {size of edit buffer}
                        @ScrapCustomer.Notes)  {edit buffer}
    then
      Abort;
    {.F+}

    {add dummy header}
    M.wFrame.AddHeader(' Notes ', heTC);

    {set right margin}
    M.SetRightMargin(MemoXH-MemoXL);

    {install user-written event handlers}
    M.SetStatusProc(MemoFieldStatus);
    M.SetErrorProc(ErrorHandler);

    {check for error}
    if M.GetLastError <> 0 then
      Abort;
  end;

  procedure GenerateRandomCustomers;
  var
    I, j                : Integer;
    Key                 : IsamKeyStr;
    Ref                 : LongInt;
    HoldNum             : array[0..20] of Char;

    function ZeroPadNum(N : Word) : String;
    var
      I                   : Word;
      Tmp                 : String;
    begin
      Tmp := '';
      for I := 1 to N do
        Tmp := Tmp + Chr(Random(10) + Ord('0'));
      ZeroPadNum := Tmp;
    end;

    function RanStr(N : Word) : String;
    var
      I                   : Word;
      Tmp                 : String;
    begin
      Tmp := '';
      for I := 0 to Random(N) do
        Tmp := Tmp + Chr(Random(26) + Ord('A'));
      RanStr := Tmp;
    end;

  begin
    Randomize;
    for I := 1 to 10 do begin
      FillChar(Customer, SizeOf(Customer), #0);
      with Customer do begin
        CustNum := ZeroPadNum(5);
        OrderLinkKey := CustNum;
        Name := RanStr(25);
        Company := RanStr(25);
        Address := RanStr(25);
        City := RanStr(15);
        State := RanStr(1)+RanStr(1);
        Zip := ZeroPadNum(5);
        NotesLen := 1;
        Notes[1] := ^Z;
      end;
      NewRandomCustomer(Customer);
      GenerateRandomOrders;
    end;
    VBC.UpdateContents;
    FBO.UpdateContents;
  end;

  procedure InitCustomerBrowser;
    {-Set up for browsing}
  const
    {$IFDEF UseAdjustableWindows}
    Options = wClear+wBordered+wResizeable+wAltFrame+wAllMouseEvents;
    {$ELSE}
    Options = wClear+wBordered+wAltFrame+wAllMouseEvents;
    {$ENDIF}

  begin
    {add user-defined exit commands of both customer and order browsers}
    with FBrowserCommands do begin
      AddCommand(ccUser2,  1, F2,   0); {add record}
      AddCommand(ccUser3,  1, F3,   0); {delete record}
      AddCommand(ccUser4,  1, F4,   0); {search}
      AddCommand(ccUser5,  1, F5,   0); {switch keys}
      AddCommand(ccUser6,  1, F6,   0); {filter}
      AddCommand(ccUser7,  1, Tab,  0); {Show Orders}
      AddCommand(ccUser8,  1, F8,   0); {Show Orders}
      AddCommand(ccUser9,  1, F9,   0); {show status}
      AddCommand(ccUser10, 1, F10,  0); {purge}
      {$IFDEF UseAdjustableWindows}
      AddCommand(ccUser11, 1, AltR, 0); {resize window}
      AddCommand(ccUser12, 1, AltM, 0); {move window}
      AddCommand(ccUser13, 1, AltZ, 0); {zoom window}
      {$ENDIF}
      AddCommand(ccUser14, 1, AltC, 0); {random generate customers}
      AddCommand(ccUser15, 1, AltO, 0); {random generate orders}
    end;

    {initialize the browser}
    if not VBC.InitCustom(3,             {left column of window}
                         5,              {top row of window}
                         ScreenWidth-2,  {right column of window}
                         ScreenHeight div 2, {bottom row of window}
                         FbColors,       {color set}
                         Options,        {window options}
                         PfC,            {fileblock}
                         CActKeyNr,      {key number}
                         Customer,       {scrap variable}
                         0{ScreenHeight-5}, {maximum rows}
                         CRowsPerItem,   {rows per item}
                         CMaxCols)       {maximum columns}
    then
      Abort;

    {adjust frame coordinates}
    with VBC do begin

      {$IFDEF UseAdjustableWindows}
      {set the limits to use when moving/zooming/resizing the window}
      SetPosLimits(1, 2, ScreenWidth, ScreenHeight-2);
      {$ENDIF}

      with wFrame do begin
        AdjustFrameCoords(frXL, frYL-1, frXH, frYH);

        {$IFDEF UseAdjustableWindows}
        {set the limits to use when resizing the window}
        SetFrameLimits(30, 2, ScreenWidth, ScreenHeight-2);
        {$ENDIF}

        {$IFDEF UseScrollBars}
        {add scroll bars}
        AddCustomScrollBar(frBB, 0, MaxLongInt, 1, 1, #178, #176, fbColors);
        AddCustomScrollBar(frRR, 0, MaxLongInt, 1, 1, #178, #176, fbColors);
        {$ENDIF}

        {add headers}
        AddCustomHeader(#181, frTL,  1, 0, $1F, $0F);       {1}
        AddCustomHeader(#7,   frTL,  2, 0, $71, $70);       {2}
        AddCustomHeader(#198, frTL,  3, 0, $1F, $0F);       {3}
        AddCustomHeader(#181, frTR, -3, 0, $1F, $0F);       {4}
        AddCustomHeader(#24,  frTR, -2, 0, $71, $70);       {5}
        AddCustomHeader(#198, frTR, -1, 0, $1F, $0F);       {6}
        AddCustomHeader('+',  frBR,  0, 0, $17, $07);       {7}

        {$IFDEF UseHotSpots}
        {add hot spots}
        AddHotRegion(frTL, hsRegion0, 2, 0, 1, 1);          {Close}
        AddHotRegion(frTR, hsRegion1, -2, 0, 1, 1);         {Zoom}
        AddHotBar(frTT,    hsRegion2);                      {Move}
        AddHotRegion(frBR, hsRegion3, 0, 0, 1, 1);          {Resize}
        {$ENDIF}

      end;
      with aFrame do begin
        SetFrameType(SglWindowFrame);
      end;
    end;

    {install user-written event handlers}
    VBC.SetBuildItemProc(BuildRow);
    VBC.SetScreenUpdateProc(UpdateScreen);
    VBC.SetErrorProc(ErrorHandler);
    VBC.SetPreMoveProc(PreMoveCustomer);

    {$IFDEF Novell}
    if BTNetSupported = Novell then begin
      VBC.SetRefreshFunc(SemaphoreRefresh);
      RefreshPeriod := 18 div 2;
    end
    else
      VBC.SetRefreshFunc(RefreshPeriodically);
    {$ELSE}
    VBC.SetRefreshFunc(RefreshPeriodically);
    {$ENDIF}

    {options}
    VBC.fbOptionsOn(fbFlushKbd+fbProcessZero);

    {you might want to try uncommenting one or more of the following:}
    { VBC.fbOptionsOn(fbBellOnFlush); }
    { VBC.SetKeyRange('C'#0, 'K'#255); }
    { VBC.fbOptionsOff(fbAutoScale); }
    { VBC.fbOptionsOff(fbDrawActive); }
    { VBC.fbOptionsOn(fbScrollByPage); }
    { VBC.SetHorizScrollDelta(10); }
    { VBC.SetVertScrollDelta(5); }
    { VBC.fbOptionsOn(fbCenterCurrent); }
    { VBC.fbOptionsOn(fbSelectOnClick); }

    {check for error}
    if VBC.GetLastError <> 0 then
      Abort;

  end;

  procedure InitCustomers;
  begin
    {initialize screen}
    InitEntryScreen;
    InitMemoFields;

    {other initialization}
    CActRec := 0;
    CActKeyNr := 1;
    CActKey := '';

    if not OpenedCustomerFiles(PfC, CustomerFile) then begin
      DispMessageTemp('Files could not be opened. Aborting.', 2000);
      Halt;
    end;

    {$IFDEF Novell}
    if BTNetSupported = Novell then
      if Sync.Init(CustomerFile, 2) then
        RefreshPeriod := 9            {check every half of a second}
      else begin
        DispMessageTemp('Error initializing semaphore object. Aborting.', 2000);
        Halt;
      end;
    {$ENDIF}

    {initialize file browser}
    InitCustomerBrowser;

    {$IFDEF UseMouse}
    if MouseInstalled then begin
      {use a red diamond for our mouse cursor}
      with fbColors do
        SoftMouseCursor($0000, (ColorMono(MouseColor, MouseMono) shl 8)+$04);
      ShowMouse;

      {enable mouse support}
      EntryCommands.cpOptionsOn(cpEnableMouse);
      MemoCommands.cpOptionsOn(cpEnableMouse);
      FBrowserCommands.cpOptionsOn(cpEnableMouse);
    end;
    {$ENDIF}
  end;

  procedure CloseCustomers;
  begin
    {Close up the database}
    BTCloseFileBlock(PfC);
    if not IsamOK then
      DispMessageTemp('Data may be corrupt.', 2000);

    {$IFDEF Novell}
    if BTNetSupported = Novell then
      Sync.Done;
    {$ENDIF}
  end;

  procedure ProcessCustomers;
    {-Main body of FBDEMO}
  var
    BP      : LongInt;
    MicH    : Integer;
    MicV    : Integer;
    FP      : FramePosType;
    XAbs    : Byte;
    YAbs    : Byte;
    HC      : Byte;
    Clicked : Boolean;

  begin
    repeat
      {Update the screen and browse around the records}
      WriteHeader(VBC, CActKeyNr, ' Customer Menu ', True);
      WriteFooter(
        ' F2-Add F3-Del F4-Find F5-Key F6-Filter F8-Orders F9-Info F10-Purge Esc-Quit',
        ' Generate Random Data -- Alt-C for Customers & Orders, Alt-O for Orders only');

      {process commands}
      if VBC.IsActive and not VBC.IsCurrent then
        VBC.Select;

      VBC.Process;
      BrowExit := VBC.GetLastCommand;
      WriteFooter('','');

      {Check for errors}
      case VBC.GetLastError of
        0 :
          if (BrowExit <> ccQuit) and (BrowExit <> ccError) then begin
            {get current key and reference}
            VBC.GetCurrentKeyAndRef(CActKey, CActRec);

            {Customer already contains current record on ccSelect}
            if (BrowExit <> ccSelect) and (CActRec <> 0) then
              {get current record}
              VBC.GetCurrentRecord(Customer, CDatLen);

            {check for error}
            if not IsamOK then begin
              IsamErrorNum(IsamError);
              BrowExit := ccNone;
            end;
          end;
        epFatal+ecNoKeysFound :
          begin
            if VBC.IsFilteringEnabled then begin
              VBC.SetFilterFunc(NullFilterFunc);
              BrowExit := ccNone;
            end;
            VBC.ClearErrors;
          end;
      else
        DispMessageTemp('Aborting.', 2000);
        BrowExit := ccError;
      end;

      {Handle requests for action}
      case BrowExit of
        ccSelect : if CActRec = 0 then NewStructure else Modify;
        ccUser2  : NewStructure;
        ccUser3  : if CActRec <> 0 then Delete;
        ccUser4  : if CActRec <> 0 then Search;
        ccUser5  : SwitchKeys;
        ccUser6  : Filter;
        ccUser7,
        ccUser8  : ProcessOrders;
        ccUser9  : Status;
        ccUser10 : RebuildData;
        {$IFDEF UseAdjustableWindows}
        ccUser11 : ResizeBrowseWindow;
        ccUser12 : MoveBrowseWindow;
        ccUser13 : ToggleZoom;
        {$ENDIF}
        ccUser14 : GenerateRandomCustomers;
        ccUser15 : GenerateRandomOrders;
        {$IFDEF UseMouse}
        ccMouseSel :
          with VBC do begin
            XAbs := MouseLastX+MouseXLo;
            YAbs := MouseLastY+MouseYLo;
            EvaluatePos(XAbs, YAbs);
            BP := PosResults(FP, HC);
            if FP <> frOutsideFrame then begin
              case HC of
                hsRegion0 : {Close}
                  BrowExit := ccQuit;
                hsRegion1 : {Zoom}
                  ToggleZoom;
                hsRegion2 : {Move}
                  if not IsZoomed then begin
                    WriteFooter('',
                      ' Drag window to new location, then click left mouse button');
                    HideMouse;
                    Dec(XAbs, wFrame.frXL);
                    Dec(YAbs, wFrame.frYL);
                    GetMickeyCount(MicH, MicV);
                    repeat
                      GetMickeyCount(MicH, MicV);
                      MoveWindow(Delta(MicH), Delta(MicV));
                      if ClassifyError(GetLastError) = etFatal then
                        Abort;
                      if MousePressed then
                        Clicked := (MouseKeyWord = MouseLft)
                      else
                        Clicked := False;
                    until Clicked;
                    Inc(XAbs, wFrame.frXL);
                    Inc(YAbs, wFrame.frYL);
                    MouseGoToXY(XAbs, YAbs);
                    WriteFooter('','');
                    ShowMouse;
                  end;
                hsRegion3 : {Resize}
                  if not IsZoomed then begin
                    WriteFooter('',
                      ' Move mouse to resize window, then click left mouse button');
                    HideMouse;
                    GetMickeyCount(MicH, MicV);
                    repeat
                      GetMickeyCount(MicH, MicV);
                      ResizeWindow(Delta(MicH), Delta(MicV));
                      if ClassifyError(GetLastError) = etFatal then
                        Abort;
                      if MousePressed then
                        Clicked := (MouseKeyWord = MouseLft)
                      else
                        Clicked := False;
                    until Clicked;
                    MouseGoToXY(wFrame.frXH, wFrame.frYH);
                    WriteFooter('','');
                    ShowMouse;
                  end;
              end;
            end else begin
              {Was the click in the order window}
              XAbs := MouseLastX+MouseXLo;
              YAbs := MouseLastY+MouseYLo;
              FBO.EvaluatePos(XAbs, YAbs);
              BP := FBO.PosResults(FP, HC);
              if FP <> frOutsideFrame then
                ProcessOrders;
            end;
          end;
        {$ENDIF}
        ccQuit   : ;  {Quit}
      end;
    until (BrowExit = ccQuit) or (BrowExit = ccError);

  end;

end.
