
{$I-,V-,S-,R-,F-,B-}

     {*******************************************************************}
     {*                          TWOBRDOS.PAS                           *}
     {*                    Version 1.00 January 1993                    *}
     {*              Copyright (c) 1993 TurboPower Software             *}
     {*                                                                 *}
     {*                         By Lee Inman,                           *}
     {*                      TurboPower Software                        *}
     {*******************************************************************}

{$I BTDEFINE.INC}
{$I OPDEFINE.INC}

{$IFNDEF UseOPCRT}
  *ERROR* This program requires UseOPCRT to be defined in BTDEFINE.INC.
{$ENDIF}

program TwoBrDos;
  {-Demonstrates how to use FBrowse unit with two browse windows. The
  customer file uses variable length records and the order file uses
  fixed length records. The customer files is related to the order file
  by the customer number.}

uses
  {.......................... Object Professional units}
  OpCrt,                     {basic screen handling}
  {$IFDEF UseMouse}
  OpMouse,                   {mouse command processing}
  {$ENDIF}
  {.......................... B-Tree Filer units}
  Filer,                     {database management}
  VRec,                      {variable length records}
  FBrowse,                   {object-oriented database browser}
  {.......................... Demo DOS browser units}
  BrDosUtl,                  {Common utility functions}
  BrDosDat,                  {Global types, constants and variables}
  BrDosCus,                  {Unit for customer browser}
  BrDosOrd;                  {Unit for order browser}

begin
  {parse the command line}
  GetOptionsFromCommandLine;

  with FbColors do
    HeadFootAttr := ColorMono(FrameColor, FrameMono);

  SaveAttr := TextAttr;

  {clear the screen}
  TextChar := #176; {178}
  TextAttr := $07;
  ClrScr;

  CheckBreak := False;

  WriteHeader(VBC, 1, ' Initializing ', False);

  {allocate a buffer for variable length records}
  if not BTSetVariableRecBuffer(CSectionLength) then begin
    DispMessageTemp('Insufficient memory. Program aborting.', 2000);
    Halt;
  end;

  {Limit the number of index buffers}
  Free := 35000+(400*ScreenHeight);
  if MemAvail-Free > 200000 then
    Free := MemAvail-200000;
  PS := BTInitIsam(DynamicNetType, Free, 0);
  if not IsamOK then begin
    IsamErrorNum(IsamError);
    Halt;
  end;

  if YesNo('Should the files be handled using Save mode?', 'N') then
    Mode := SaveMode
  else
    Mode := NormalMode;

  InitCustomers;
  VBC.Draw;
  OrderLinkKey := CActKey;
  InitOrders;
  FBO.Draw;

  ProcessCustomers;

  {Won't return here until user quits}

  if VBC.IsActive and not VBC.IsCurrent then
    VBC.Select;
  CloseCustomers;
  VBC.Erase;

  if FBO.IsActive and not FBO.IsCurrent then
    FBO.Select;
  CloseOrders;
  FBO.Erase;

  BTExitIsam;
  BTReleaseVariableRecBuffer;

  {$IFDEF UseMouse}
  HideMouse;
  {$ENDIF}

  {clear the screen}
  TextAttr := SaveAttr;
  ClrScr;

end.

