unit TextWin;
{$B-}

interface

uses objects, drivers, views, textcoll;


const

{ TTextInterior.Status values: }
  tiOK             =  0;
  tiError          = -1;
  tiCollectionFull = -2;


type


  { TTextInterior
    Rollover    : Determines Append action when collection is full.
                  Rollover = true, then 1st line of collection is deleted
                                   and new line is append to end (Default).
                  Rollover = false, Status is set to -2 Collection Full

    ScrollFollow: Determines whether Append moves the scroller position.
                  ScrollFollow = true, then scroller is moved to bottom of
                                 display list and redrawn (default).
                  ScrollFollow = false, then no change is made to the
                                 scroller's position.
  }

  PTextInterior = ^TTextInterior;
  TTextInterior = object(TScroller)
    Lines: TTextCollection;
    RollOver: boolean;
    ScrollFollow: boolean;
    Status: integer;
    constructor Init( R: TRect; MaxLines: integer;
                      AHScrollbar, AVScrollbar: PScrollbar);
    destructor Done;  virtual;
    procedure Append(st: Pstring);  virtual;
    procedure Draw;  virtual;
    end;


  PTextWindow = ^TTextWindow;
  TTextWindow = object(TWindow)
    Interior: PTextInterior;
    constructor Init( R: TRect; NewTitle: string; Num, MaxLines: integer);
    procedure MakeInterior( MaxLines: integer);  virtual;
    end;




implementation

constructor TTextInterior.Init( R: TRect; MaxLines: integer;
                                AHScrollbar, AVScrollbar: PScrollbar);
  begin
  TScroller.Init(R, AHScrollbar, AVScrollbar);
  if MaxLines = 0 then
    Lines.Init(Size.X, 1)     { let it grow unchecked:  16K items max}
  else
    Lines.Init(Maxlines, 0);  { fix size and rollover when full }
  SetLimit(128,Size.X);
  GrowMode := gfGrowHiX + gfGrowHiY;
  RollOver := True;
  ScrollFollow := true;
  end;



destructor TTextInterior.Done;
  begin
  Lines.Done;
  TScroller.Done;
  end;



procedure TTextInterior.Append( st: PString);
  begin
  if Lines.Count < Lines.Limit then    { let it grow }
    begin
    Lines.Insert(st);
    if Lines.Count > Size.Y then
      begin
      SetLimit(128,Lines.Count);
      if ScrollFollow then
        VScrollbar^.SetValue(Lines.Count);
      end;
    end
  else
    { Lines.Count = Lines.Limit }
    if Rollover then
      begin
      Lines.Free(Lines.At(0));    { zap the old string }
      Lines.Insert(st);           { before adding new one }
      if ScrollFollow then
        VScrollBar^.SetValue(Lines.Count);
      end
    else
      Status := tiCollectionFull;

  DrawView;  { show the changes }
  end;



procedure TTextInterior.Draw;
  var color: byte;
      Y, I : integer;
      B: TDrawBuffer;
  begin                            { draw only what's visible }
  Color:= GetColor(1);
  for y:= 0 to Size.Y-1 do
    begin
    MoveChar(B,' ',Color,Size.X);
    I:= Delta.Y+Y;
    if (I < Lines.Count) and (Lines.At(I) <> nil) then
      MoveStr(B, Copy(PString(Lines.At(I))^,Delta.X+1, Size.X), Color);
    WriteLine(0,Y,Size.X,1,B);
    end;
  end;






constructor TTextWindow.Init( R: TRect; NewTitle: string;
                              Num, MaxLines: integer);
  begin
  TWindow.Init(R,NewTitle, Num);
  MakeInterior(MaxLines);
  end;



procedure TTextWindow.MakeInterior( MaxLines: integer);
  var R: TRect;

  begin
  GetExtent(R);
  R.Grow(-1,-1);
  Interior := new(PTextInterior, Init(R, MaxLines,
                                      StandardScrollBar(sbHorizontal),
                                      StandardScrollBar(sbVertical)));
  Insert( Interior );
  end;



end.