Unit HeapWin;

{************************************************************************}
{ A small window to display the amount of free memory.  Call the Update  }
{ method from your application's Idle method.                            }
{ Copyright (c) 1990 by Danny Thorpe                                     }
{************************************************************************}

interface

uses Dos, Objects, Views, App;

type

    PHeapWin = ^THeapWin;
    THeapWin = object (TWindow)
             OldMem : LongInt;
             constructor Init;
             procedure Draw; virtual;
             procedure UpDate;
             procedure SizeLimits (var Min, Max : TPoint); virtual;
    end;


const HeapWindow: PHeapWin = nil;

implementation

constructor THeapWin.Init;
var R : TRect;
begin
  Desktop^.GetExtent(R);
  R.Assign ( R.B.X-14,R.A.Y,R.B.X,R.A.Y+3);
  TWindow.Init (R, 'Heap', 0);
  Flags := wfMove;
  Options:= Options or ofFirstClick;
end;



procedure THeapWin.Draw;
var S : String;
begin
  TWindow.Draw;
  OldMem := MemAvail;
  Str (OldMem, S);
  WriteStr (4,1,S,1);
end;


procedure THeapWin.UpDate;
begin
  if (OldMem<>MemAvail) then DrawView;
end;


procedure THeapWin.SizeLimits (var Min, Max : TPoint);
begin
  Max.X := 14;
  Max.Y := 3;
  Min.X := 14;
  Min.Y := 3;
end;


end.