Unit MenuTick;

Interface uses Menus;

   Function NewCheckItem( Name, Param : TMenuStr; KeyCode, Command :Word;
                          AHelpCtx : Word; Checked : Boolean;
                          Next : PMenuItem ) : PMenuItem;

   Function CheckMenuItem( AMenu : PMenu; var Command : Word ) : Boolean;
   Function ClearMenuItem( AMenu : PMenu; var Command : Word ) : Boolean;
   Function MenuItemIsChecked( AMenu : PMenu; var Command : Word ) : Boolean;
   Function ToggleMenuItem( AMenu : PMenu; var Command : Word ) : Boolean;

const
   CheckMark : Char = #251;
   ClearMark : Char = ' ';

Implementation

Function NewCheckItem( Name, Param : TMenuStr; KeyCode, Command :Word;
                       AHelpCtx : Word; Checked : Boolean;
                       Next : PMenuItem ) : PMenuItem;
begin
   if Name <> '' then
   begin
      Name := ' ' + Name;
      if Checked then
         Name := CheckMark + Name else
         Name := ClearMark + Name;
   end;
   NewCheckItem := NewItem( Name, Param, KeyCode, Command, AHelpCtx, Next );
end;

Function FindMenuItem( AMenu : PMenu; Command : Word ) : PMenuItem;
var
   P, Q : PMenuItem;
begin
   P := AMenu^.Items;
   while P <> Nil do
   begin
      if ( P^.Command = 0 ) and ( P^.Name <> Nil ) then
      begin
         Q := FindMenuItem( P^.SubMenu, Command );
         if Q <> Nil then
         begin
            FindMenuItem := Q;
            Exit;
         end;
      end else
      begin
         if ( P^.Command = Command ) and not P^.Disabled then
         begin
            FindMenuItem := P;
            Exit;
         end;
      end;
      P := P^.Next;
   end;
   FindMenuItem := Nil;
end;

Function CheckMenuItem( AMenu : PMenu; var Command : Word ) : Boolean;
var
   MenuItem : PMenuItem;
begin
   CheckMenuItem := False;
   MenuItem := FindMenuItem( AMenu, Command );
   if MenuItem <> Nil then
   begin
     if MenuItem^.Name^[1] = ClearMark then
     begin
        MenuItem^.Name^[1] := CheckMark;
        CheckMenuItem := True;
      end;
   end else Command := 0;
end;

Function ClearMenuItem( AMenu : PMenu; var Command : Word ) : Boolean;
var
   MenuItem : PMenuItem;
begin
   ClearMenuItem := False;
   MenuItem := FindMenuItem( AMenu, Command );
   if MenuItem <> Nil then
   begin
      if MenuItem^.Name^[1] = CheckMark then
      begin
         MenuItem^.Name^[1] := ClearMark;
         ClearMenuItem := True;
      end;
   end else Command := 0;
end;

Function MenuItemIsChecked( AMenu : PMenu; var Command : Word ) : Boolean;
var
   MenuItem : PMenuItem;
begin
   MenuItemIsChecked := False;
   MenuItem := FindMenuItem( AMenu, Command );
   if MenuItem <> Nil then
   begin
      if MenuItem^.Name^[1] = CheckMark then
         MenuItemIsChecked := True;
   end else Command := 0;
end;

Function ToggleMenuItem( AMenu : PMenu; var Command : Word ) : Boolean;
begin
   if MenuItemIsChecked( AMenu, Command ) then
      ClearMenuItem( AMenu, Command ) else
      if Command <> 0 then CheckMenuItem( AMenu, Command );
end;

end.