                      (***********************)
                      (*      TURBO CAS      *)
                      (*     Version 1.0     *)
                      (*  Turbo Pascal Unit  *)
                      (*     Supporting      *)
                      (*    the DCA/Intel    *)
                      (*         CAS         *)
                      (***********************)
                      (*    Public Domain    *)
                      (*    by  Brian Corll  *)
                      (***********************)
                      (* ALL RIGHTS RESERVED *)
                      (***********************)
                      (*  Portions Copyright *)
                      (*     1988,1989 by    *)
                      (*       DCA/Intel     *)
                      (***********************)

(* CAS stands for Communicating Application Specification *)
(* CAS is Copyright 1988,1989 DCA/Intel                   *)
{$F+,O+}

{ This unit provides Turbo Pascal access to FAX cards such as Intel's
  Connection CoProcessor or similar cards which adhere to the DCA/Intel CAS }

UNIT TurboCAS;

INTERFACE

USES DOS;

TYPE

   EventTypes = (Completed,Pending,Dialed,Sending,
                 Receiving,Aborted,NoStatus);
   CFEventType = (CFSend,CFReceive,CFPolledSend,CFPolledReceive);
   Directions = (Fore,Back);
   QueueTypes = (Task,Receive,Log);

   FileName = String[79];
   FileNameArray = ARRAY[1..10] OF FileName;
   Str32 = String[32];
   Str80 = String[80];
   Str47 = String[47];

   CoverPageType = ARRAY[1..240] OF CHAR;

   CFRPtr = ^ControlFileRecordType;
   ControlFileRecordType = RECORD
        EventType      : BYTE;{User-defined}
        TransType      : BYTE;{User-defined}
        Status         : INTEGER;
        SendTime       : WORD;{User-defined}
        SendDate       : WORD;{User-defined}
        NumberOfFiles  : INTEGER;{User-defined}
        FTROffset      : WORD;{User-defined}
        PhoneNo        : ARRAY[1..47] OF CHAR;{User-defined}
        TagField       : ARRAY[1..64] OF CHAR;
        Unused1        : BYTE;{User-defined}
        CallSecs       : BYTE;
        CallMins       : BYTE;
        CallHrs        : BYTE;
        TotPages       : LONGINT;
        NumPagesSent   : LONGINT;
        NumFilesSent   : WORD;
        CoverFlag      : BYTE;{User-defined}
        NumErrors      : WORD;
        Unused2        : ARRAY[1..78] OF BYTE;{User-defined}
        CSID           : ARRAY[1..21] OF CHAR;
        Dest           : ARRAY[1..32] OF CHAR;{User-defined}
        Sender         : ARRAY[1..32] OF CHAR;{User-defined}
        PCXFile        : ARRAY[1..80] OF CHAR;{User-defined}
        END;

   FTRPtr = ^FileTransferRecordType;
   FileTransferRecordType = RECORD
        FAXType       : BYTE;
        TextSize      : BYTE;
        Status        : BYTE;
        BytesTrans    : LONGINT;
        SizeOfFile    : LONGINT;
        NumPagesTrans : INTEGER;
        NumPagesTot   : INTEGER;
        FAXFileName   : ARRAY[1..80] OF CHAR;
        Increments    : BYTE;
        Inches        : CHAR;
        Reserved      : ARRAY[1..31] OF CHAR;
        END;

   EDBPtr = ^ExternalDataBlock;
   ExternalDataBlock = RECORD
        CASMajor : BYTE;
        CASMinor : BYTE;
        ManagerPath : ARRAY[1..68] OF CHAR;
        PBookName : ARRAY[1..13] OF CHAR;
        LogoName  : ARRAY[1..13] OF CHAR;
        Sender    : ARRAY[1..32] OF CHAR;
        CSID      : ARRAY[1..21] OF CHAR;
        Reserved  : ARRAY[1..107] OF BYTE;
        END;

   SARPtr = ^StatusAreaRecord;
   StatusAreaRecord = RECORD
        EventType      : BYTE;{User-defined}
        TransType      : BYTE;{User-defined}
        Status         : INTEGER;
        SendTime       : WORD;{User-defined}
        SendDate       : WORD;{User-defined}
        NumberOfFiles  : INTEGER;{User-defined}
        FTROffset      : INTEGER;{User-defined}
        PhoneNo        : ARRAY[1..47] OF CHAR;{User-defined}
        TagField       : ARRAY[1..64] OF CHAR;
        Unused1        : BYTE;{User-defined}
        CallSecs       : BYTE;
        CallMins       : BYTE;
        CallHrs        : BYTE;
        TotPages       : LONGINT;
        NumPagesSent   : LONGINT;
        NumFilesSent   : INTEGER;
        CoverFlag      : BYTE;{User-defined}
        NumErrors      : INTEGER;
        Unused2        : ARRAY[1..78] OF BYTE;{User-defined}
        CSID           : ARRAY[1..21] OF BYTE;
        Dest           : ARRAY[1..32] OF CHAR;{User-defined}
        Sender         : ARRAY[1..32] OF CHAR;{User-defined}
        PCXFile        : ARRAY[1..80] OF CHAR;{User-defined}
        FAXType        : BYTE;
        TextSize       : BYTE;
        FTRStatus      : BYTE;
        BytesTrans     : LONGINT;
        SizeOfFile     : LONGINT;
        NumPagesTrans  : INTEGER;
        NumPagesTot    : INTEGER;
        FAXFileName    : ARRAY[1..80] OF CHAR;
        Increments     : BYTE;
        Inches         : BYTE;
        Reserved       : ARRAY[1..31] OF BYTE;
        END;

VAR
   CASError : WORD;
   AutoState : BYTE;
   EDB : EDBPtr;
   CFR : CFRPtr;
   FTR : FTRPtr;
   SAR : SARPtr;
   ControlFile : FILE;
   FileList : FileNameArray;


FUNCTION ManagerInstalled : BOOLEAN;
{CAS Function 00h}

FUNCTION SubmitTask(ControlFileName : FileName) : INTEGER;
{CAS Function 01h}

PROCEDURE AbortCurrentEvent;
{CAS Function 02h}

PROCEDURE FindFirstQEntry(EType : EventTypes;Direction : Directions;
          QueueType : QueueTypes;VAR EventHandle : INTEGER);
{CAS Function 05h}

PROCEDURE FindNextQEntry(QueueType : QueueTypes;VAR EventHandle : INTEGER);
{CAS Function 06h}

PROCEDURE OpenFile(QueueType : QueueTypes;VAR EventHandle : INTEGER;
             FileNumber : INTEGER;VAR DOSHandle : INTEGER);
{CAS Function 07h}

PROCEDURE DeleteFile(QueueType : QueueTypes;VAR EventHandle : INTEGER;
             FileNumber : INTEGER);
{CAS Function 08h}

PROCEDURE DeleteAllFiles(QueueType : QueueTypes);
{CAS Function 09h}

PROCEDURE GetEventDate(QueueType : QueueTypes;VAR EventHandle : INTEGER;
             VAR Year : INTEGER;VAR Month,Day : BYTE);
{CAS Function 0Ah}

PROCEDURE SetTaskDate(VAR EventHandle : INTEGER;VAR Year : INTEGER;
             VAR Month,Day : BYTE);
{CAS Function 0Bh}

PROCEDURE GetEventTime(VAR Hour,Minutes,Secs : BYTE;EventHandle : INTEGER;
             QueueType : QueueTypes);
{CAS Function 0Ch}

PROCEDURE SetTaskTime(VAR Hour,Minutes,Secs : BYTE;VAR EventHandle : INTEGER);
{CAS Function 0Dh}

PROCEDURE GetEDB;
{CAS Function 0Eh}

PROCEDURE DisposeEDB(VAR EDB : EDBPtr);

PROCEDURE GetAutoReceiveState;
{CAS Function 0Fh}

PROCEDURE SetAutoReceiveState(NumberOfRings : BYTE);
{CAS Function 0Fh}

PROCEDURE GetCurrentEventStatus;
{CAS Function 10h}

PROCEDURE DisposeSAR;

PROCEDURE GetQueueStatus(VAR NumChanges,NumFiles,NumReceived : INTEGER;
          QueueType : QueueTypes);
{CAS Function 11h}

PROCEDURE RunDiagnostics;
{CAS Function 13h}

PROCEDURE MoveFile(VAR FName : FileName;VAR EventHandle : INTEGER;
              VAR FileNumber : INTEGER);
{CAS Function 14h}

PROCEDURE SendSingleFile(D : Str32;S : Str80;P : Str47);
{CAS Function 15h}

PROCEDURE RemoveManager;
{CAS Function 16h}

FUNCTION CreateControlFile(CFEvent : CFEventType;TransferType : BYTE;
         CFRTime : WORD;CFRDate : WORD;NumFiles : INTEGER;Phone : Str47;
         CoverPageFlag : BYTE;Destination : Str32;SenderName : Str32;
         LogoName : Str80;VAR CoverPageText : CoverPageType) : FileName;

FUNCTION DOSTime(Hour,Minutes,Seconds : WORD) : WORD;

FUNCTION DOSDate(Month,Day,Year : WORD) : WORD;

IMPLEMENTATION

CONST
   MUX = $CB;

TYPE

   LIT = RECORD
       HI,LO : WORD;
       END;

   FDAPtr = ^FAXDataArea;
   FAXDataArea = RECORD
        TransType : BYTE;
        TextSize  : BYTE;
        SendTime  : INTEGER;
        SendDate  : INTEGER;
        Dest      : ARRAY[1..32] OF CHAR;
        SendFile  : ARRAY[1..80] OF CHAR;
        Phone     : ARRAY[1..47] OF CHAR;
        TagField  : ARRAY[1..64] OF CHAR;
        Reserved1 : BYTE;
        CoverFlag : BYTE;
        Reserved2 : ARRAY[1..23] OF BYTE;
        CoverPage : CoverPageType;
        END;



VAR
   Regs : Registers;
   FDA : FDAPtr;

   FUNCTION CheckError : WORD;
   VAR
      L : LONGINT;
   BEGIN
        L := LONGINT(-Regs.AX);
        CheckError := LIT(L).LO;
   END;


   FUNCTION ManagerInstalled : BOOLEAN;
   {CAS Function 00h}
   BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $00;
             Intr($2F,Regs);
             ManagerInstalled := (AL = $FF);
        END;
   END;

   FUNCTION SubmitTask(ControlFileName : FileName) : INTEGER;
   {CAS Function 01h}
   VAR
      TCFName : ARRAY[1..80] OF CHAR;
      X : BYTE;
   BEGIN
        FillChar(TCFName,SizeOf(TCFName),#0);
        FOR X := 1 TO Length(ControlFilename) DO
             TCFName[X] := ControlFileName[X];
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $01;
             DS := Seg(TCFName);
             DX := Ofs(TCFName);
             Intr($2F,Regs);
             IF AX < 32767 THEN
             BEGIN
                CASError := 0;
                SubmitTask := AX;
                EXIT;
             END
             ELSE
             BEGIN
                CASError := CheckError;
                SubmitTask := -1;
                EXIT;
             END;
        END;
   END;

   PROCEDURE AbortCurrentEvent;
   {CAS Function 02h}
   BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $02;
             Intr($2F,Regs);
             CASError := CheckError;
        END;
   END;

   PROCEDURE FindFirstQEntry(EType : EventTypes;Direction : Directions;
             QueueType : QueueTypes;VAR EventHandle : INTEGER);
   {CAS Function 05h}
   BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $05;
             CASE EType OF
                  Completed : CX := 0;
                  Pending   : CX := 1;
                  Dialed    : CX := 2;
                  Sending   : CX := 3;
                  Receiving : CX := 4;
                  Aborted   : CX := 5;
             END;
             CASE Direction OF
                  Fore      : DH := 0;
                  Back      : DH := 1;
             END;
             CASE QueueType OF
                  Task      : DL := 0;
                  Receive   : DL := 1;
                  Log       : DL := 2;
             END;
             Intr($2F,Regs);
             CASError := CheckError;
             EventHandle := BX;
        END;
   END;

   PROCEDURE FindNextQEntry(QueueType : QueueTypes;VAR EventHandle : INTEGER);
   {CAS Function 06h}
   BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $06;
             CASE QueueType OF
                  Task      : DL := 0;
                  Receive   : DL := 1;
                  Log       : DL := 2;
             END;
             Intr($2F,Regs);
             CASError := CheckError;
             EventHandle := BX;
        END;
   END;

   PROCEDURE OpenFile(QueueType : QueueTypes;VAR EventHandle : INTEGER;
             FileNumber : INTEGER;VAR DOSHandle : INTEGER);
   {CAS Function 07h}
   BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $07;
             BX := EventHandle;
             CX := FileNumber;
             CASE QueueType OF
                  Task      : DL := 0;
                  Receive   : DL := 1;
                  Log       : DL := 2;
             END;
             Intr($2F,Regs);
             CASError := CheckError;
             DOSHandle := BX;
        END;
   END;

   PROCEDURE DeleteFile(QueueType : QueueTypes;VAR EventHandle : INTEGER;
             FileNumber : INTEGER);
   {CAS Function 08h}
   BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $08;
             BX := EventHandle;
             CX := FileNumber;
             CASE QueueType OF
                  Task      : DL := 0;
                  Receive   : DL := 1;
                  Log       : DL := 2;
             END;
             Intr($2F,Regs);
             CASError := CheckError;
        END;
   END;

   PROCEDURE DeleteAllFiles(QueueType : QueueTypes);
   {CAS Function 09h}
   BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $09;
             CASE QueueType OF
                  Task      : DL := 0;
                  Receive   : DL := 1;
                  Log       : DL := 2;
             END;
             Intr($2F,Regs);
             CASError := CheckError;
        END;
   END;

   PROCEDURE GetEventDate(QueueType : QueueTypes;VAR EventHandle : INTEGER;
             VAR Year : INTEGER;VAR Month,Day : BYTE);
   {CAS Function 0Ah}
   BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $0A;
             BX := EventHandle;
             CASE QueueType OF
                  Task      : DL := 0;
                  Receive   : DL := 1;
                  Log       : DL := 2;
             END;
             Intr($2F,Regs);
             CASError := CheckError;
             Year := CX;
             Month := DH;
             Day := DL;
        END;
   END;

   PROCEDURE SetTaskDate(VAR EventHandle : INTEGER;VAR Year : INTEGER;
             VAR Month,Day : BYTE);
   {CAS Function 0Bh}
   BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $0B;
             BX := EventHandle;
             CX := Year;
             DH := Month;
             DL := Day;
             Intr($2F,Regs);
             CASError := CheckError;
        END;
   END;

   PROCEDURE GetEventTime(VAR Hour,Minutes,Secs : BYTE;EventHandle : INTEGER;
             QueueType : QueueTypes);
   {CAS Function 0Ch}
   BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $0C;
             BX := EventHandle;
             CASE QueueType OF
                  Task      : DL := 0;
                  Receive   : DL := 1;
                  Log       : DL := 2;
             END;
             Intr($2F,Regs);
             CASError := CheckError;
             Hour := CH;
             Minutes := CL;
             Secs := DH;
        END;
   END;


   PROCEDURE SetTaskTime(VAR Hour,Minutes,Secs : BYTE;VAR EventHandle : INTEGER);
   {CAS Function 0Dh}
   BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $0D;
             BX := EventHandle;
             CH := Hour;
             CL := Minutes;
             DH := Secs;
             Intr($2F,Regs);
             CASError := CheckError;
        END;
   END;

   PROCEDURE GetEDB;
   {CAS Function 0Eh}
   BEGIN
        NEW(EDB);
        FillChar(EDB^,SizeOf(EDB^),#0);
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $0E;
             DS := Seg(EDB^);
             DX := Ofs(EDB^);
             Intr($2F,Regs);
        END;
   END;

   PROCEDURE DisposeEDB(VAR EDB : EDBPtr);
   BEGIN
        DISPOSE(EDB);
        EDB := NIL;
   END;

   PROCEDURE GetAutoReceiveState;
   {CAS Function 0Fh}
   BEGIN
        WITH Regs DO
        BEGIN
           AH := MUX;
           AL := $0F;
           DL := 0;
           Intr($2F,Regs);
           AutoState := AX;
        END;
   END;

   PROCEDURE SetAutoReceiveState(NumberOfRings : BYTE);
   {CAS Function 0Fh}
   BEGIN
        WITH Regs DO
        BEGIN
           AH := MUX;
           AL := $0F;
           DL := 1;
           DH := NumberOfRings;
           Intr($2F,Regs);
           AutoState := AX;
        END;
   END;



   PROCEDURE GetCurrentEventStatus;
   {CAS Function 10h}
   BEGIN
        NEW(SAR);
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $10;
             DS := Seg(SAR);
             DX := Ofs(SAR);
             Intr($2F,Regs);
             CASError := CheckError;
        END;
   END;

   PROCEDURE DisposeSAR;
   BEGIN
        DISPOSE(SAR);
   END;


   PROCEDURE GetQueueStatus(VAR NumChanges,NumFiles,NumReceived : INTEGER;
             QueueType : QueueTypes);
   {CAS Function 11h}
   BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $11;
             CASE QueueType OF
                  Task      : DL := 0;
                  Receive   : DL := 1;
                  Log       : DL := 2;
             END;
             Intr($2F,Regs);
             NumChanges := AX;
             NumFiles := BX;
             NumReceived := CX;
        END;
   END;

    PROCEDURE RunDiagnostics;
    {CAS Function 13h}
    BEGIN
         WITH Regs DO
         BEGIN
              AH := MUX;
              AL := $13;
              DL := $01;
              Intr($2F,Regs);
              CASError := CheckError;
         END;
    END;

    PROCEDURE MoveFile(VAR FName : FileName;VAR EventHandle : INTEGER;
              VAR FileNumber : INTEGER);
    {CAS Function 14h}
    BEGIN
         WITH Regs DO
         BEGIN
              AH := MUX;
              AL := $14;
              BX := EventHandle;
              CX := FileNumber;
              DS := Seg(FName);
              DX := Ofs(FName);
              Intr($2F,Regs);
              CASError := CheckError;
         END;
    END;

    PROCEDURE SendSingleFile(D : Str32;S : Str80;P : Str47);
    {CAS Function 15h}
    VAR
      X : BYTE;
    BEGIN
        NEW(FDA);
        WITH FDA^ DO
        BEGIN
             TransType := 0;
             TextSize := 0;
             SendTime := 0;
             SendDate := 0;
             FillChar(Dest,SizeOf(Dest),#0);
             FillChar(SendFile,SizeOf(SendFile),#0);
             FillChar(Phone,SizeOf(Phone),#0);
             FOR X := 1 TO Length(D) DO
                 Dest[X] := D[X];
             FOR X := 1 TO Length(S) DO
                 SendFile[X] := S[X];
             FOR X := 1 TO Length(P) DO
                 Phone[X] := P[X];
             FillChar(TagField,SizeOf(TagField),#0);
             Reserved1 := 0;
             CoverFlag := 0;
             FillChar(Reserved2,SizeOf(Reserved2),0);
             FillChar(CoverPage,SizeOf(CoverPage),#0);
        END;
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $15;
             DS := Seg(FDA^);
             DX := Ofs(FDA^);
             Intr($2F,Regs);
             CASError := CheckError;
        END;
    END;


    PROCEDURE RemoveManager;
    {CAS Function 16h}
    BEGIN
        WITH Regs DO
        BEGIN
             AH := MUX;
             AL := $16;
             BX := $1234;
             CX := $5678;
             DX := $9ABC;
             Intr($2F,Regs);
             CASError := CheckError;
        END;
    END;


    FUNCTION CreateControlFile(CFEvent : CFEventType;TransferType : BYTE;
         CFRTime : WORD;CFRDate : WORD;NumFiles : INTEGER;Phone : Str47;
         CoverPageFlag : BYTE;Destination : Str32;SenderName : Str32;
         LogoName : Str80;VAR CoverPageText : CoverPageType) : FileName;
    VAR
       CFName : FileName;
       TempName : String[8];
       X,Y : BYTE;
       F : LONGINT;
    BEGIN
         FillChar(CFName,SizeOf(CFName),#0);
         FillChar(TempName,SizeOf(TempName),#0);
         WITH Regs DO
         BEGIN
              AH := $5A;
              CX := $00;
              DS := Seg(TempName);
              DX := Ofs(TempName);
              MsDOS(Regs);
         END;
         CFName := CFName + TempName;
         CFName[0] := CHR(8);
         CFName := CFName + '.CAS';
         Assign(ControlFile,CFName);
         ReWrite(ControlFile,1);
         NEW(CFR);
         FillChar(CFR^,SizeOf(CFR^),#0);
         WITH CFR^ DO
         BEGIN
              CASE CFEvent OF
              CFSend : EventType := 0;
              CFPolledsend : EventType := 2;
              CFPolledReceive : EventType := 3;
              END;
              TransType := TransferType;
              SendTime := CFRTime;
              SendDate := CFRDate;
              NumberOfFiles := NumFiles;
              FTROffset := 383;
              FOR X := 1 TO Length(Phone) DO
                  PhoneNo[X] := Phone[X];
              CoverFlag := CoverPageFlag;
              FOR X := 1 TO Length(Destination) DO
                  Dest[X] := Destination[X];
              FOR X := 1 TO Length(SenderName) DO
                  Sender[X] := SenderName[X];
              FOR X := 1 TO Length(LogoName) DO
                  PCXFile[X] := LogoName[X];
              FOR X := 1 TO Length(MyName) DO
                  TagField[X] := MyName[X];
              Unused1 := 0;
              CoverFlag := 0;
         END;
         BlockWrite(ControlFile,CFR^,SizeOf(CFR^));
         FOR X := 1 TO 10 DO
         BEGIN
              NEW(FTR);
              FillChar(FTR^,SizeOf(FTR^),#0);
              WITH FTR^ DO
              BEGIN
                   IF FileList[X][0] <> #0 THEN
                   BEGIN
                   FOR Y := 1 TO Length(FileList[X]) DO
                       FAXFileName[Y] := FileList[X,Y];
                       TextSize := 0;
                       Inches := CHR(0) ;
                       BlockWrite(ControlFile,FTR^,SizeOf(FTR^));
                   END;
              END;
              DISPOSE(FTR);
         END;
         Close(ControlFile);
         CreateControlFile := CFName;
    END;

FUNCTION DOSTime(Hour,Minutes,Seconds : WORD) : WORD;
BEGIN
     DOSTime := (Hour * 2048) + (Minutes * 32) + (Seconds DIV 2);
END;

FUNCTION DOSDate(Month,Day,Year : WORD) : WORD;
BEGIN
     DOSDate := ((Year - 1980) * 512) + (Month * 32) + Day;
END;


BEGIN
END.
                                                                                                                                                                                                                                                                                                                 