 {----------------------------------------------------------------------------
                    T U R B O   S T U F F   v 0 2 . 0 1 . 0 0
  ----------------------------------------------------------------------------
                             **** TS_STR Module ****
 
  The source code to Turbo Stuff is provided to REGISTERED USERS ONLY!  Source
  to this unit  file is distributed  only so users of other  versions of Turbo
  Pascal may recompile it for their system.  Please read the License Agreement
  contained in the documentation for conditions on distributing Turbo Stuff.

  ----------------------------------------------------------------------------
     (C) Copyright 1989 by Shenandoah Valley Software - All Rights Reserved   
  ----------------------------------------------------------------------------}

{$V-,F+}

UNIT TS_STR;

INTERFACE

  CONST     TSVersion = 'v02.01.00';

  FUNCTION  Ascii      ( St:string )                         : string  ;
  FUNCTION  AsciiZ     ( St:string )                         : string  ;
  FUNCTION  ATrim      ( St:string; Ch:char )                : string  ;
  FUNCTION  Center     ( St:string; Ch:char; Len:byte )      : string  ;
  FUNCTION  Change     ( St:string; Search,Replace:char )    : string  ;
  FUNCTION  Compare    ( St1,St2:string; UpperCase:boolean ) : boolean ;
  FUNCTION  DelCh      ( St:string; Ch:char )                : string  ;
  FUNCTION  Decrypt    ( St:string )                         : string  ;
  FUNCTION  Dup        ( Ch:char; Len:byte )                 : string  ;
  FUNCTION  DupStr     ( St:string; Len:byte )               : string  ;
  FUNCTION  Encrypt    ( St:string )                         : string  ;
  FUNCTION  FirstLower ( St:string )                         : char    ;
  FUNCTION  FirstUpper ( St:string )                         : char    ;
  FUNCTION  Format     ( St,Mask:string )                    : string  ;
  FUNCTION  IIf        ( TF:boolean; St1,St2:string )        : string  ;
  FUNCTION  IsAlpha    ( St:string )                         : boolean ;
  FUNCTION  IsLower    ( St:string )                         : boolean ;
  FUNCTION  IsUpper    ( St:string )                         : boolean ;
  FUNCTION  Left       ( St:string; Len:byte )               : string  ;
  FUNCTION  LFill      ( St:string; Ch:char; Len:byte )      : string  ;
  FUNCTION  LJust      ( St:string; Len:byte )               : string  ;
  FUNCTION  LoCase     ( Ch:char )                           : char    ;
  FUNCTION  Lower      ( St:string )                         : string  ;
  FUNCTION  LTrim      ( St:string; Ch:char )                : string  ;
  FUNCTION  Number     ( St:string; Num:byte )               : string  ;
  FUNCTION  Proper     ( St:string )                         : string  ;
  FUNCTION  RFill      ( St:string; Ch:char; Len:byte )      : string  ;
  FUNCTION  Right      ( St:string; Len:byte )               : string  ;
  FUNCTION  RJust      ( St:string; Len:byte )               : string  ;
  FUNCTION  Roman      ( Num:integer )                       : string  ;
  FUNCTION  RTrim      ( St:string; Ch:char )                : string  ;
  FUNCTION  Same       ( St1,St2 : string )                  : boolean ;
  FUNCTION  SoundDif   ( St1,St2 : string )                  : byte    ;
  FUNCTION  SoundEx    ( St:string )                         : string  ;
  FUNCTION  Space      ( Len:byte )                          : string  ;
  FUNCTION  Stuff      ( St1,St2:string; Start,Del:byte )    : string  ;
  PROCEDURE Swap       ( var St1,St2 : string );
  FUNCTION  Trim       ( St:string )                         : string  ;
  FUNCTION  Upper      ( St:string )                         : string  ;
  FUNCTION  Words      ( St:string )                         : integer ;

{----------------------------------------------------------------------------}

IMPLEMENTATION

  FUNCTION  Ascii      ; external;   {$L ASCII    }
  FUNCTION  AsciiZ     ; external;   {$L ASCIIZ   }
  FUNCTION  ATrim      ; external;   {$L ATRIM    }
  FUNCTION  Center     ; external;   {$L CENTER   }
  FUNCTION  Change     ; external;   {$L CHANGE   }
  FUNCTION  Compare    ; external;   {$L COMPARE  }
  FUNCTION  DelCh      ; external;   {$L DELCH    }
  FUNCTION  Decrypt    ; external;   {$L DECRYPT  }
  FUNCTION  Dup        ; external;   {$L DUP      }
  FUNCTION  DupStr     ; external;   {$L DUPSTR   }
  FUNCTION  Encrypt    ; external;   {$L ENCRYPT  }
  FUNCTION  FirstLower ; external;   {$L FLOWER   }
  FUNCTION  FirstUpper ; external;   {$L FUPPER   }
  FUNCTION  Format     ; external;   {$L FORMAT   }
  FUNCTION  IIf        ; external;   {$L IIF      }
  FUNCTION  IsAlpha    ; external;   {$L ISALPHA  }
  FUNCTION  IsLower    ; external;   {$L ISLOWER  }
  FUNCTION  IsUpper    ; external;   {$L ISUPPER  }
  FUNCTION  Left       ; external;   {$L LEFT     }
  FUNCTION  LFill      ; external;   {$L LFILL    }
  FUNCTION  LJust      ; external;   {$L LJUST    }
  FUNCTION  LoCase     ; external;   {$L LOCASE   }
  FUNCTION  Lower      ; external;   {$L LOWER    }
  FUNCTION  LTrim      ; external;   {$L LTRIM    }
  FUNCTION  Number     ; external;   {$L NUMBER   }
  FUNCTION  Proper     ; external;   {$L PROPER   }
  FUNCTION  RFill      ; external;   {$L RFILL    }
  FUNCTION  Right      ; external;   {$L RIGHT    }
  FUNCTION  RJust      ; external;   {$L RJUST    }
  FUNCTION  Roman      ; external;   {$L ROMAN    }
  FUNCTION  RTrim      ; external;   {$L RTRIM    }
  FUNCTION  Same       ; external;   {$L SAME     }
  FUNCTION  SoundDif   ; external;   {$L SOUNDDIF }
  FUNCTION  SoundEx    ; external;   {$L SOUNDEX  }
  FUNCTION  Space      ; external;   {$L SPACE    }
  FUNCTION  Stuff      ; external;   {$L STUFF    }
  PROCEDURE Swap       ; external;   {$L SWAP     }
  FUNCTION  Trim       ; external;   {$L TRIM     }
  FUNCTION  Upper      ; external;   {$L UPPER    }
  FUNCTION  Words      ; external;   {$L WORDS    }

{$F-} END.