{ (C) Copyright 1989 by Shenandoah Valley Software -- All Rights Reserved }

PROGRAM TS_Demo;

USES crt,ts_str;

CONST Ruler = '---------1---------2---------3---------4---------5---------6---------7---------';

VAR  FName, LName : string;
     Sex, Ch      : char;
     St, Name, St2: string;

PROCEDURE Header;
VAR TName : string;
BEGIN
  ClrScr;
  Writeln(Dup('-',79));
  Writeln(Center('T U R B O   S T U F F   v 0 2 . 0 1 . 0 0',' ',79));
  Writeln(Center('(C) Copyright 1989 by Shenandoah Valley Software -- All Rights Reserved',' ',79));
  Writeln(Dup('-',79));
  Writeln;
  TName := 'CONST Name : string = ''' + Name + '''';
  Writeln(Center(TName,' ',79));
  Writeln;
END;

PROCEDURE Title(TSt:string);
BEGIN
  Header;
  TSt := ' ' + TSt + ' ';
  Writeln(Center(TSt,'',79));
  Writeln;
END;

PROCEDURE Wait;
BEGIN
  GotoXY(1,25);
  Write(Center(' PRESS ANY KEY TO CONTINUE ','*',79));
  Ch := ReadKey;
END;

BEGIN
  ClrScr;
  Writeln('TS_STR Demonstration Program:');
  Writeln;
  Writeln;
  Write('What is your first name: ');
  Readln(FName);
  Write('What is your last name:  ');
  Readln(LName);
  Write('Sex? (M)ale or (F)emale: ');
  REPEAT
    Sex := UpCase(ReadKey);
  UNTIL Sex in ['M','F'];
  Name := IIf((Sex='M'),'Mr. ','Ms. ') + Trim(FName) + ' ' + Trim(LName);
  Name := Proper(Name);

  Title('ASCII and ASCIIZ');
  St := ASCIIZ(Name);
  Writeln('ASCIIZ(Name) ............... ',St);
  Writeln;
  Writeln('ASCII(Name) ................ ',ASCII(St));
  Writeln;
  Writeln('NOTE: ASCIIZ string is missing first digit, this is because Turbo Pascal');
  Writeln('      assumes the first byte to be the length, while this is not true for');
  Writeln('      an Asciiz string. Notice also that there may be garbage behind the');
  Writeln('      Asciiz string as well. See TS_STR.REF for more information');
  Wait;

  Title('ATRIM, LTRIM and RTRIM');
  St := '**********' + UPPER(Name) + '**********';
  Writeln('This is the working string (St): ',St);
  Writeln;
  Writeln('ATRIM(St,''*'') .............. ',ATrim(St,'*'));
  Writeln('LTRIM(St,''*'') .............. ',LTrim(St,'*'));
  Writeln('RTRIM(St,''*'') .............. ',RTrim(St,'*'));
  Wait;

  Title('CENTER, LJUST and RJUST');
  Writeln('CENTER(Name,'' '',79)');
  Writeln;
  Writeln(Center(Name,' ',79));
  Writeln(Dup('-',79));
  Writeln;
  Writeln('LJUST(Name,79)');
  Writeln;
  Writeln(LJUST(Name,79));
  Writeln(Dup('-',79));
  Writeln;
  Writeln('RJUST(Name,79)');
  Writeln;
  Writeln(RJUST(Name,79));
  Writeln(Dup('-',79));
  Wait;

  Title('CHANGE and DELCH');
  St := '********** THIS * IS * A * TEST **********';
  Writeln('This is the working string (St): ',St);
  Writeln;
  Write('Enter character to change astrik (*) to: ');
  Readln(Ch);
  Writeln;
  Write('CHANGE(St,''*'',''',Ch,''') ........... ');
  Writeln(CHANGE(St,'*',Ch));
  Writeln;
  Write('DELCH(St,''*'') ................ ',DELCH(St,'*'));
  Wait;

  Title('COMPARE and SAME');
  Write('COMPARE(''TURBO STUFF'',''turbo stuff'',false) ..... ');
  Writeln(Compare('TURBO STUFF','turbo stuff',false));
  Write('COMPARE(''TURBO STUFF'',''TURBO STUFF'',false) ..... ');
  Writeln(Compare('TURBO STUFF','TURBO STUFF',false));
  Write('COMPARE(''TURBO STUFF'',''turbo stuff'',true) ...... ');
  Writeln(Compare('TURBO STUFF','turbo stuff',true));
  Writeln;
  Write('SAME(''TURBO STUFF'',''TURBO*'') ................... ');
  Writeln(Same('TURBO STUFF','TURBO*'));
  Write('SAME(''TURBO STUFF'',''TURBO ??UFF'') .............. ');
  Writeln(Same('TURBO STUFF','TURBO ??UFF'));
  Wait;

  REPEAT
    Title('DECRYPT and ENCRYPT');
    Write('Enter a string (press return alone to continue): ');
    Readln(St);
    IF St <> '' THEN BEGIN
      St := Encrypt(St);
      Writeln('ENCRYPT(St) ......... ',St);
      Writeln;
      Writeln('DECRYPT(St) ......... ',Decrypt(St));
      Wait;
    END;
  UNTIL St = '';

  Title('DUP, DUPSTR and SPACE');
  Writeln('Ch := ''*''  -  DUP(Ch,40)');
  Writeln;
  Writeln(Ruler);
  Writeln(Dup('*',40));
  Writeln;
  Writeln;
  Writeln('St := ''--XXX--''  -  DUPSTR(St,50)');
  Writeln;
  Writeln(Ruler);
  Writeln(DupStr('--XXX--',50));
  Writeln;
  Writeln;
  Writeln('SPACE(60)');
  Writeln;
  Writeln(Ruler);
  Writeln(Space(60),'<-');
  Wait;

  Title('FIRSTLOWER and FIRSTUPPER');
  Writeln('FIRSTLOWER(Name) ......... ',FirstLower(Name));
  Writeln('FIRSTUPPER(Name) ......... ',FirstUpper(Name));
  Wait;

  Title('ISALPHA, ISLOWER and ISUPPER');
  St := 'TURBOSTUFF';
  Writeln('This is the working string (St): ',St);
  Writeln;
  Writeln('ISALPHA(St) .......... ',IsAlpha(St));
  Writeln('ISLOWER(St) .......... ',IsLower(St));
  Writeln('ISUPPER(St) .......... ',IsUpper(St));
  Wait;

  Title('FORMAT and NUMBER');
  St := '8005551212';
  Writeln('This is the working string (St): ',St);
  Writeln;
  Writeln('A phone number:  FORMAT(St,''(###)-###-####'') ..... ',Format(St,'(###)-###-####'));
  Writeln('A normal number: NUMBER(St,2) .................... ',Number(St,2));
  Wait;

  Title('IIF');
  Writeln('The IIF function was used in conjunction wish other functions to format');
  Writeln('your name. This is how it was done:');
  Writeln;
  Writeln('Name := IIf((Sex=''M''),''Mr. '',''Ms. '') + Trim(FName) + '' '' + Trim(LName)');
  Writeln('Name := Proper(Name)');
  Wait;

  Title('CENTER, LJUST and RJUST');
  Writeln('CENTER(Name,''*'',79)');
  Writeln;
  Writeln(Center(Name,'*',79));
  Writeln(Dup('-',79));
  Writeln;
  Writeln('LFILL(Name,''*'',79)');
  Writeln;
  Writeln(LFILL(Name,'*',79));
  Writeln(Dup('-',79));
  Writeln;
  Writeln('RFILL(Name,''*'',79)');
  Writeln;
  Writeln(RFILL(Name,'*',79));
  Writeln(Dup('-',79));
  Wait;

  Title('LEFT and RIGHT');
  Writeln('LEFT(Name,5) .......... ',Left(Name,5));
  Writeln('RIGHT(Name,5) ......... ',Right(Name,5));
  Wait;

  Title('LOCASE, LOWER, PROPER and UPPER');
  Writeln('LOCASE(''A'') .................. ',LoCase('A'));
  Writeln('LOWER(Name) .................. ',Lower(Name));
  Writeln('PROPER(Name) ................. ',Proper(Name));
  Writeln('UPPER(Name) .................. ',Upper(Name));
  Wait;

  LName := Upper(LName);
  REPEAT
    Title('SOUNDDIF and SOUNDEX');
    Writeln('Your last name .............. ',LName);
    Writeln('Soundex code ................ ',Soundex(LName));
    Writeln;
    Write('Enter your last name and spell it wrong (return alone continues): ');
    Readln(St);
    St := Upper(St);
    IF St <> '' THEN BEGIN
      Writeln;
      Writeln('Your entry .................. ',St);
      Writeln('Soundex code ................ ',Soundex(St));
      Writeln('SoundDif code ............... ',SoundDif(Soundex(LName),Soundex(St)));
      Wait;
    END;
  UNTIL St = '';

  Title('STUFF');
  Writeln('STUFF(''ABC'',''XYZ'',2,1) ............. ',Stuff('ABC','XYZ',2,1));
  Writeln('STUFF(''ABC'','''',2,1) ................ ',Stuff('ABC','',2,1));
  Writeln('STUFF(''ABC'',''XYZ'',2,0) ............. ',Stuff('ABC','XYZ',2,0));
  Writeln('STUFF(''ABC'',''XYZ'',0,1) ............. ',Stuff('ABC','XYZ',0,1));
  Wait;

  Title('SWAP and WORDS');
  Write('Enter a string ........ ');
  Readln(St);
  Write('Enter another string .. ');
  Readln(St2);
  Writeln;
  Writeln('1st string ..... ',St);
  Writeln('# of words ..... ',Words(St));
  Writeln('2nd string ..... ',St2);
  Writeln('# of words ..... ',Words(St2));
  Writeln;
  Writeln('SWAP(St,St2)');
  Writeln;
  Swap(St,St2);
  Writeln('1st string, after swap .... ',St);
  Writeln('2nd string, after swap .... ',St2);
  Wait;

  Title('THAT''S ALL FOLKS!');

END.
