PROGRAM CFG_Demo2;

USES crt,ts_confg;

VAR
  ch       : char    ;
  oldcolor : byte    ;
  newcolor : byte    ;
  oops     : integer ;


PROCEDURE ChangeColor ( X1,Y1,X2,Y2: integer; OldColor,NewColor : Byte );
  VAR
    OffSet        : integer;
    IndexX,IndexY : integer;
    C             : byte;
    Adapter       : word;
  BEGIN
    if lo(lastmode) = 7 then adapter := $B000 else adapter := $B800;
    FOR IndexY := Y1 TO Y2 DO BEGIN
      Offset := 2 * (( 80 * (IndexY - 1 )) + X1 - 1);
      FOR IndexX := 1 TO X2-X1+1 DO BEGIN
        C := mem[Adapter:Offset+(IndexX*2)-1];
        IF C = OldColor THEN mem[Adapter:Offset+(IndexX*2)-1] := NewColor;
      END;
    END;
  END;

PROCEDURE ShowScreen(ScreenData:pointer);
  VAR
    ScreenSegment:word;
  BEGIN
    if lo(LastMode) = 7 then ScreenSegment := $B000
    else ScreenSegment := $B800;
    move(ScreenData^,ptr(ScreenSegment,0)^,4000);
  END;

PROCEDURE SaveScreen(ScreenData:pointer);
  VAR
    ScreenSegment:word;
  BEGIN
    if lo(LastMode) = 7 then ScreenSegment := $B000
    else ScreenSegment := $B800;
    move(ptr(ScreenSegment,0)^,ScreenData^,4000);
  END;

PROCEDURE CFG_DEM2; external;
{$L CFG_DEM2.OBJ}

BEGIN
  ClrScr;
  ShowScreen(@CFG_DEM2);
  ch := readkey;
  if keypressed then ch := readkey;
  ClrScr;
  Write('OldColor (0..256): '); Readln(OldColor);
  Write('NewColor (0..256): '); Readln(NewColor);
  ShowScreen(@CFG_DEM2);
  ChangeColor(1,1,80,24,OldColor,NewColor);
  ch := readkey;
  if keypressed then ch := readkey;
  SaveScreen(@CFG_DEM2);
  ts_config('CFG_DEM2',seg(CFG_DEM2),ofs(CFG_DEM2),@CFG_DEM2,4000,oops);
  ClrScr;
END.