{**************************************************************************
*   IPX - unit of IPX functions                                           *
*   Copyright (c) 1991 Kim Kokkonen, TurboPower Software.                 *
*   May be freely distributed and used but not sold except by permission. *
*                                                                         *
*   Version 3.0 9/24/91                                                   *
*     first release                                                       *
*   Version 3.1 11/4/91                                                   *
*     no change                                                           *
*   Version 3.2 11/22/91                                                  *
*     no change                                                           *
*   Version 3.3 1/8/92                                                    *
*     no change                                                           *
***************************************************************************}

{$R-,S-,I-,V-,B-,F-,A-,E-,N-,G-,X-}

unit IPX;
  {-IPX functions needed for RELNET}

interface

type
  PhysicalNodeAddress = array[1..6] of Byte;

  FragmentDescriptor  =
    record
      Address         : Pointer;              {the data}
      Size            : Word;                 {the size of the data}
    end;

  IpxEcbPtr = ^IpxEcb;
  IpxEcb =
    record
      Link            : IpxEcbPtr;            {link to next IPXECB}
      EsrAddress      : Pointer;              {Event Service Routine}
      InUse           : Byte;                 {inuse semaphore}
      CompletionCode  : Byte;                 {error code}
      SocketNumber    : Word;                 {the session socket}
      IpxWorkSpace    : LongInt;              {reserved for internal use}
      DriverWorkSpace : Array[1..12] of Byte; {reserved}
      ImmediateAddress: PhysicalNodeAddress;  {the internet address}
      FragmentCount   : Word;                 {the number of buffers}
      FD1             : FragmentDescriptor;   {buffer 1}
      FD2             : FragmentDescriptor;   {buffer 2}
      FD3             : FragmentDescriptor;   {buffer 3}
      FD4             : FragmentDescriptor;   {buffer 4}
    end;

function IpxInstalled : Boolean;
  {-Return True if IPX is installed}

procedure CloseSocket(Socket : Word);
  {-Close specified socket number (after swapping hi-lo)}

function CancelEvent(var ECB : IPXECB) : Byte;
  {-Cancel IPX event}

procedure ScheduleSpecialEvent(Delay : Word; var ECB : IPXECB);
  {-Schedule a special event}

  {=======================================================================}

implementation

var
  IpxOfs : Word;
  IpxSeg : Word;

function IpxInstalled : Boolean; assembler;
asm
  MOV     AX,[IpxOfs]
  OR      AX,[IpxSeg]
  MOV     AL,00
  JZ      @Done
  INC     AL
@Done:
end;

procedure CloseSocket(Socket : Word); assembler;
asm
  MOV     AX,[IpxOfs]
  OR      AX,[IpxSeg]
  JZ      @Done
  MOV     BX,0001
  MOV     DX,Socket
  CALL    DWORD PTR [IpxOfs]
@Done:
end;

function CancelEvent(var ECB : IPXECB) : Byte; assembler;
asm
  MOV     AX,[IpxOfs]
  OR      AX,[IpxSeg]
  MOV     AL,$FF
  JZ      @Done
  MOV     BX,0006
  LES     SI,ECB
  CALL    DWORD PTR [IpxOfs]
@Done:
end;

procedure ScheduleSpecialEvent(Delay : Word; var ECB : IPXECB); assembler;
asm
  MOV     AX,[IpxOfs]
  OR      AX,[IpxSeg]
  JZ      @Done
  MOV     BX,0007
  MOV     AX,Delay
  LES     SI,ECB
  CALL    DWORD PTR [IpxOfs]
@Done:
end;

procedure CheckIpx; assembler;
asm
  MOV     AX,$7A00
  INT     $2F
  CMP     AL,$FF
  JZ      @StoreIpxPtr
  XOR     DI,DI
  MOV     ES,DI
@StoreIpxPtr:
  MOV     [IpxOfs],DI
  MOV     [IpxSeg],ES
end;

begin
  CheckIpx;
end.
