




















                        The Turbo-Screen System
                          Version TSS 1.0
                                 by

                        THE CONNELLY BROTHERS

                    "We Make Software Make Software"

                          Copyright 1988,1989









                   "If a man makes a better mousetrap,
                 the world will beat a path to his door."
                                        Ralph Waldo Emerson



     Documentation and User's Manual
     ============= === ====== ======
     Table of Contents
     ----- -- --------

     SECTION                                                    NO.
     -------                                                    ---
     License Statements                                         1
     Introduction to Turbo-Screen System                        2
     Installation                                               3
          System Requirements                                   3.1
               Hardware                                         3.1.1
               Software                                         3.1.2
          Performing the Installation                           3.2
     The TSS Panel Development Environment -- A Quick Overview  4
     Panel Design                                               5
          Creating a Panel File                                 5.1
          Panel Limitations                                     5.2
     Creating the Common User Interface Code                    6
          Running the TSS program                               6.1
          Debugging the Panel File                              6.2
          Running the Test Code                                 6.3
     Advanced Panel Building                                    7
          Cursor-Movement/Editing Control -- Key-Functions      7.1
          Screen Attributes Usage                               7.2
     Communication with Authors                                 8
     Warranty                                                   9
     Turbo-Screen Registered Version Order Form                 10



     Appendices
     ----------

     Appendix A.................Available Key-Functions
     Appendix B.................Extended key code definitions
     Appendix C.................Default Key-Function/Key Assignments
     Appendix D.................The Test File and Panel Call Variables
     Appendix E.................Screen Attributes
     Appendix F.................Turbo Pascal Version 4.0 Support

 1   License Statements
     ======= ==========

     This software is protected by both United States copyright law and
     international treaty provisions. Therefore you must treat this
     software just like a book, with the following exceptions.
     If you have legally acquired a copy of the Turbo-Screen System that
     is a REGISTERED version, then THE CONNELLY BROTHERS authorize you
     to make archived copies of the software for the sole purpose of
     backing-up the software to protect your investment from loss.

     The Turbo-Screen System consists of a CODE GENERATING PROGRAM
     (Called TSS.EXE),
     example panel design files, a Units file
     (Called TSSLIB.TPU or TSSLIB04.TPU),
     a documentation file (Called TSS.MAN),
     and installation files (Called TSSINST.EXE and TSSINST.HLP).

     If you have legally acquired a copy of the UNREGISTERED version of
     the Turbo-Screen System, then you may make copies of the COMPLETE
     TURBO-SCREEN SYSTEM for individuals that intend to use the
     Turbo-Screen System for their non-business and non-profit use.
     Those copies must contain this documentation as part of the copy
     procedure.  If those individuals intend to use the Turbo-Screen
     System to create profitable products or for profit or business,
     then the individual or legal entity must legally acquire the
     REGISTERED version from the THE CONNELLY BROTHERS (SEE SECTION
     10).  If any company or corporation intends to use the
     the Turbo-Screen System, then that company or corporation
     must acquire the REGISTERED version of the Turbo-Screen System.

     Programs that you write which use code that is generated by the
     REGISTERED version of Turbo-Screen System may be used, given away,
     or sold without additional license or fees.  Included in the
     Turbo-Screen System diskettes is a support file called TSSLIB.TPU
     in the REGISTERED version which is proprietary to THE CONNELLY
     BROTHERS.  You may use this file with the programs that you create
     using panels from the Turbo-Screen System for your own personal
     use.  In addition, to the extent the programs that you write and
     compile using code generated by TSS.EXE make use of this support
     file, you may distribute this support file in combination with such
     programs, provided that you do not use, give away, or sell the
     support file separately.
 
 2   Introduction to the Turbo-Screen System
     ============ == === ============ ======

     Turbo-Screen was conceived as a means to get programs running
     quickly while spending minimum time developing the screen panels
     for those programs.  Turbo-Screen generates Pascal code that
     performs the Common User Access for your application code.  Common
     User Access (CUA) is terminology used by the IBM Systems
     Application Architecture (SAA).  Even though Pascal is not a
     language that is accepted within SAA, we have tried to keep our
     general terminology compatible with the concepts and terminology of
     SAA.

     The Turbo-Screen System (Hereinafter called TSS) was developed
     to allow the easy definition and implementation of screen
     panels.  Implementation requires the TSS abilities to:


     1. Locate and place messages, and Entry or Menu panel variables
     (fields to be edited or chosen) on the screen.

     2. Control the editing of the panel fields through the positioning
     of a cursor with Cursor-Movement/Editing functions (called
     Key-Functions).

     3. Pass the panel field values to variables within the main
     program.

     An additional feature includes the ability to assign Key-Functions
     to any available keystroke(s).  The Key-Function key assignment, as
     well as the Key-Functions themselves, are supported by low-level
     (SOURCE AVAILABLE TO REGISTERED USERS) routines supplied with the
     TSS System as a Pascal Unit File called TSSLIB.TPU.

     The TSS System contains a CODE GENERATING PROGRAM program (called
     TSS.EXE) that generates Pascal procedures that interface your Menu
     Design (through a Menu Design File that you build) into a main
     Pascal program. TSS.EXE also produces sample test code as an
     example of menu inclusion in a main program.  This test code allows
     the user to quickly test menu and entry panel ideas.

 3   Installation
     ============

 3.1 TSS System Requirements
     --- ------ ------------

 3.1.1   Hardware: IBM PC or Compatible with 360 kb floppy disk drive
                   and 256K of memory.

 3.1.2   Software: DOS2.0 or higher operating system.
                   Borland's Turbo Pascal Versions 4.0 or 5.0.

 3.2 Performing the Installation
     ---------- --- ------------

     1. Edit Config.sys & make sure that files=20 is present
     2. Insert the installation diskette in the source drive
     3. Make the source drive the current drive
     4. At the DOS prompt type:
        TSSINST
     5. Insure that Borland's Turbo Pascal Command Line Compiler
        is in the Path.
     6. Execute SWAPTPU.BAT if you will be running Turbo Pascal
        Version 4.0 (See Appendix F).

     The installation program will then ask questions pertaining to the
     target drive name, directory, etc.

4    The TSS Panel Development Environment -- A Quick Overview
     === === ===== =========== ===========    = ===== ========

     The TSS system includes an executable program, called
     TSS.EXE which takes an input Panel Design File (See section
     on Panel Design), with an extension of PAN, and produces
     three additional files.  These files include a variable
     definitions file, with extension CON, an interface procedures
     file, with extension PRC, and a test file, with extension TST.
     For example, if we created a Panel Design File called XX.PAN and
     input that file to TSS.EXE which produces XX.CON, XX.PRC, and
     XX.TST.

     The XX.CON and XX.PRC could be included in your code for
     implementation.  A sample call of the interface procedures is
     included in the XX.TST file.

     The following diagram will help illuminate the above description:


                              XX.PAN
                        (Panel Design File)
                               \/
                               \/
                             TSS.EXE <---------------------- TSS.DEF
                     (Code Generating Program)             (Last input
          -----------(TSS executable Program)--------       file and
         \/                    \/                   \/     colors used)
         \/                    \/                   \/
        XX.TST                XX.CON               XX.PRC
     (Test Program)   (Variable Definitions)  (Interface Routines)
    (or Your Code?)            \/                   \/
         \/                    \/                   \/
         \/                    \/                   \/
      Program Test;            \/                   \/
      Uses DOS,CRT,TSSLIB;     \/                   \/
      {$I XX.CON} <--------------                   \/
      {$I XX.PRC} <-----------------------------------
      Begin
        (Variable Initialization Code)
        XX(... Screen Control Variables,Variables to return);
                      (SEE APPENDIX D)
      End.

     NOTE:  DOS and CRT Units are part of Borland's Turbo Pascal Library
     called TURBO.TPL.  TSSLIB is a Turbo- Screen Units file called
     TSSLIB.TPU.

 5   Panel Design
     ===== ======

     A panel is part of a communication link between user and program,
     between fingers with eyes and keyboard with screen.  A panel not
     only tells a program what to do, but also tells us what a program
     can do.  This function is performed using panels that give us
     choices and panels that allow us to enter values.  These panels
     are called MENU and ENTRY PANELS, respectively.  A Menu Panel,
     like the menu at a breakfast cafe, can give us a choice of items
     to pick, examine, or execute (eat).  In the cafe we might have a
     choice between coffee or milk, between bacon and eggs and/or
     pancakes with fruit.  In addition after we choose our meal we must
     enter our quantitative desires about the chosen items:  how many
     eggs; how well cooked; or how should they be cooked?  These values
     would be communicated through an Entry Panel.


5.1  Creating a Panel File
     -------- - ----- ----

     Both types of panels have two important characteristics.  First, we
     have an organized list of the items to choose or places to enter
     the pertinent data.  Second, we have other notes, instructions,
     labels, explanations, and titles (Breakfast Cafe) on our menu page
     (Computer Screen).  The first set of characteristics pertain to
     MENU or ENTRY VARIABLE FIELDS (hereinafter called just FIELDS)
     while the second set of characteristics refer to MESSAGES.  Fields
     are on the screen to be chosen or interacted with (an active thing)
     while the Messages are on the screen to merely inform (a passive
     thing).

     If we are to build panels, then we must be able to place our
     Messages and Fields on our screen and return the input data back to
     our program (or vice versa).  To accomplish this we must place
     specific information about our panel within a PANEL DESIGN FILE.
     The Panel Design File is an ASCII file with a file name extension
     of PAN.  This file can be created with Borland's Turbo Pascal
     Compiler's editor or any other simple text editor.  The Panel
     Design File holds both MESSAGE LOCATIONS, FIELD LOCATIONS, and
     contents of Messages as well as FIELD ATTRIBUTES, i.e., FIELD
     LENGTHS on the screen, VARIABLE TYPES, and the VARIABLE NAMES
     associated with the Fields.

     To specify the locations of Messages or Fields, one merely
     must place a character (chosen by the user) in the file to denote
     the beginning location of the Message or Field.  The chosen
     character for Messages is called a MESSAGE LOCATION CHARACTER and
     the chosen character for Variable Fields is called a FIELD
     LOCATION CHARACTER.

     These characters must be placed within the first 25 lines and
     first 80 characters to be meaningful for the normal sized screen
     (See Panel Limitations Section).

     Default location characters (which may be changed by the user) are
     @, Char(64), for Messages and ^, Char(94), for Fields.

     Messages and Field Attributes are entered as strings of
     characters within special (user denoted) characters called MESSAGE
     DELIMITER CHARACTERS and FIELD DELIMITER CHARACTERS.

     Default delimiter characters are #, Char(35), for Messages and |,
     Char(124), for Fields.  An example message is:

     #Here is a message!#

     The message length can vary between one and eighty characters.

     A Message must be specified for each Message Location Character.
     The Message may be placed anywhere within the Panel Design File.
     The Messages will be assigned to Message Locations based on reading
     order, i.e., reading from left to right and down the page.  This
     ordering rule will establish the first Message, which goes with the
     first Message Location Character and so forth.

     Field Attributes must also be associated with each Field Location
     Character.  The Field attributes are defined as follows:

     First, the Variable type must be specified by using the characters
     S,R,I for String,Real and Integer type variables. Next, the Field
     Length (between one and eighty characters in length) must be
     specified, and last, the Variable Name is entered along with the
     closing Variable Delimiter Character.  The Variable Type, Field
     Length, and Variable Name must separated by colons, :.

     An example Field Attribute definition would be:

     |S:15:DATA_STRING|


     This would define the first Field as a string of length 15 and the
     Variable Name of DATA_STRING is the variable that passes the
     string from the panel (TSS generated code) to your application
     code.  Alternately, real and integer types would be defined as
     follows:

     |R:10:Realvar|
     |I:5:Intvar|

     Example Panel Design files are included for both the Entry Panel
     and a Menu Panel.  These files are called ENTRY.PAN and MENU.PAN.

     Complete example panels, i.e., with variables initialized and the
     screen control set member, "editoff" (for Menu Panels), (see
     Advanced Panel Building Section), are available in the files
     ENTRY.PAS and MENU.PAS.

5.2  Panel Limitations
     ----- -----------

     TSS was specifically developed for applications which were programmed in
     Borland's Turbo Pascal 4.0 and 5.0 and that were executed on a DOS
     operating system.  Because of the DOS requirement TSS can only
     effectively support a screen that is one character (the last character
     on the screen -- the lower right hand character) less than the rated
     screen size.  TSS now supports 25 lines by 80 characters minus one
     character sized screens.  We lose the last character because DOS scrolls
     the entire screen one line when we write the last character to the
     screen.

     To overcome this limitation, one must design panels that do not
     write the last character.  Two simple rules that will accomplish
     this are:

          1.  Assume the screen is 24 lines by 80 characters in size.

          2.  Assume the screen is 25 lines by 79 characters in size.

     TSS can handle 50 Messages and 50 Fields along with their
     associated Locations.

     A Message, or Field length can be between one and eighty
     characters.

6    Creating the Common User Interface Code
     ======== === ====== ==== ========= ====
6.1  Running the TSS program
     ------- --- --- -------

     To create your user interface code you merely type in TSS at the
     DOS prompt.

     The program will present two entry panels for you to interact with.

     The first panel allows you to input the file name (EXTENSION OF PAN
     IS ASSUMED) of your Panel Design File and to alter the default
     Field or Message Delimiter and Location Characters.  You process
     the first panel by pressing the F3 key.

     The second panel allows you to change the colors of the
     inactive Fields, the highlights or reverse video of the actively
     edited Fields, the colors of the background, and the colors of the
     Messages on the screen.  You process the second panel by pressing
     the F3 key.

     The program will then continue into an ERROR CHECKING mode and
     will present an opportunity to produce executable code.

6.2  Debugging the Panel File
     --------- --- ----- ----

     When the Turbo-Screen System detects an error within the Panel
     Design File, it produces both screen error messages and a file of
     error messages that has an extension of ERR along with a prefix
     file name of your Panel Design File's prefix file name (XX.ERR if
     your Panel Design File's file name was XX.PAN).

     The error file will contain error messages concerning errors of the
     following type:

     1.  The number of Message Locations is not equal to the number
     of Messages.  This error means that either the number of Message
     Locations is incorrect or that the number of Messages is
     incorrect.  Inspect the Messages and Message locations for missing
     Message Delimiters and Message Location Characters.

     2.  The number of Field Locations is not equal to the number
     of Fields.  This error means that either the number of Field
     Locations is incorrect or that the number of Fields is
     incorrect.  Inspect the Fields and Field locations for missing
     Field Delimiters and Field Location Characters.

     3.  The number of Messages or Fields in the Panel Design File is
     too great for Turbo-Screen System support (SEE PANEL
     LIMITATIONS).

     4.  Variable names are RESERVED WORDS.  Change the name of the
     specific variables that have caused these errors.

6.3  Running the Test Code
     ------- --- ---- ----

     The Turbo-Screen System can utilize the Turbo Pascal Command Line
     Compiler to produce Panel test code directly from the TSS.EXE or
     TSSUR.EXE program execution.  That code (called XX.EXE where XX.PAN
     is the input Panel Design File) can be executed by typing in the
     Panel Design File prefix name (here XX).  Insure that Borland's
     Turbo Pascal Command Line Compiler is in the Path.

     You may also compile the Test Code File (XX.TST) using the standard
     Turbo Pascal version 4.0 or 5.0 Compiler.

     The Turbo-Screen System also creates compiler directives that will
     change the compiler parameters (memory allocations).  These
     directives could be referenced if you experience memory allocation
     errors within your application code.

7    Advanced Panel Building
     ======== ===== ========


7.1  Cursor-Movement/Editing Control--Key-Functions
     ----------------------- ------------------------

     Turbo-Screen contains Key-Functions for moving to or modifying
     Field values.  Some Key-Functions are clear to end of Field, exit
     Panel, break out (cancel program).  A Turbo-Screen user has the
     flexibility to change the assignment of any or all of the field
     movement or editing functions to any key.  This enables the
     programmer to conform to any local Key-Function customs or habits
     such as IBM's SAA function key standards.  In order for
     Turbo-Screen to keep track of the keystrokes that perform editing
     or movement functions on the screen, global data is kept in
     TSSLIB.TPU.  This data gives each key stroke an assigned
     Key-Function.

     Key-functions are panel movement or editing functions that normal
     menu or entry panels would perform.  Some simple editing or moving
     functions of an entry program would include a function that moved
     to the next field or deleted a field entry, etc..  Turbo-Screen has
     a complete set of Key-Functions for movement, editing and control.
     The complete set of Key-Functions are shown in the APPENDIX A.

     As described above, these Key-Functions are assigned to key strokes
     for the panel's control.  The assignment of each Key-Function to a
     key stroke is completely user configurable within the
     user's application code by use of the procedure set_key_fnc within
     TSSLIB.TPU.

     Set_key_fnc changes the Key-Function assigned to a key  within
     TSSLIB.TPU.  To assign a new Key-Function to a key, set_key_fnc is
     called before the TSS.EXE generated panel procedure is called.  The
     procedure is called as follows:

     set_key_fnc(KEYNUMBER, KEYFUNCTION);  ,

     where KEYNUMBER is an integer variable with the key number stored
     within it.  Key numbers are the standard ASCII ordinal number
     (KEYNUMBER:=ORD(CHAR(KEYNUMBER)) or the extended ASCII ordinal
     number plus 256.  See either the file SPECKEYS.H or APPENDIX B for
     some example key numbers.  An example of mapping the break_out key
     to the ^C key stroke would be accomplished by the following Pascal
     statement.

     set_key_fnc(CTLC,break_out);   or

     set_key_fnc((3+256),break_out);.

     So, until break_out is re-assigned to another key stroke, the key
     sequence of pressing the control key then a 'C' would halt the
     program.  See Appendix C for the default Key-Function/Key
     assignment upon usage of the unit TSSLIB.TPU.

7.2  Screen Attribute Usage
     ------ --------- -----

     Panel Screen Control is performed by utilizing a set of screen
     control variable members that mediate Screen Control Functions.
     The Screen Control Functions offer features that allow for the
     development of Entry, Menu, POP-UP, or PULL-DOWN Panels.

     Panel Screen Control is processed by adding/deleting control word
     set elements to the screen control set variable "sccn".  Each
     control word activates/deactivates a specific menu function. To add
     or delete functions use the following set operation:

     sccn:=sccn+[editoff]-[erron];

     This has the effect of turning off Field editing and turning off
     Field entry error checking.  A list of the set elements as defined
     for screen control GLOBAL set variable "sccn" is available in
     APPENDIX D.

     As a result of the above Panel screen control set elements, the
     Turbo-Screen user has a complete flexibility when presenting
     screens and can be used to develop POP-UP Panels.

8    Communication with Authors
     ------------- ---- -------

     The authors welcome your feedback.  If you have any comments,
     questions, or bugs to report, then please send them to:

     THE CONNELLY BROTHERS
     P.O. BOX  280527
     LAKEWOOD, CO.   80228-0527

     Unfortunately, and realistically, we will not be able to respond
     to all correspondence, but we will make an attempt to address
     important issues about the Turbo-Screen System.


9    Warranty for a REGISTERED Version of Turbo-Screen
     -------- --- - ---------- ------- -- ------------

     With respect to the physical diskette enclosed herein, THE
     CONNELLY BROTHERS warrants the same to be free of defects in
     materials and workmanship for a period of 60 days from the date of
     purchase provided that the physical diskette was acquired directly
     from THE CONNELLY BROTHERS.  If you need to return the diskette,
     then please mail the diskette to THE CONNELLY BROTHERS at the
     address provided above.  The remedy for breach of this warranty
     shall be limited to the replacement of the diskette and shall not
     encompass any other damages, including, but not limited to, the
     loss of profit, and any special, incidental, consequential, or
     other similar claims.

     THE CONNELLY BROTHERS specifically disclaim all other warranties,
     expressed or implied, including, but not limited to, implied
     warranties of merchantability and fitness for a particular purpose
     with respect to defects in the diskette and documentation, and the
     program license granted herein in particular, and without limiting
     operation of the program license with respect to any particular
     application, use, or purpose.  In no event shall THE CONNELLY
     BROTHERS be liable for any loss of profit or any other commercial
     damage, including, but not limited to, special, incidental,
     consequential, or other damages.

10   Turbo-Screen Registered Version Order Form
     ------------ ---------- ------- ----- ----

     If you like the results that you get from the UNREGISTERED version
     of the Turbo-Screen System, and need the Source for the Libraries
     of the REGISTERED version or use Turbo-Screen System for profit or
     business (See License Statements-Section 1.0), then you must acquire
     REGISTERED version for THIRTY DOLLARS (U.S. Dollars by check or
     money-order) plus Shipping, Handling, and any applicable Taxes.  To
     order the REGISTERED version of the The Turbo-Screen System:  print
     the following form, fill in the form, place the completed form in
     an envelope with the check or money-order, and mail the envelope to
     the address listed below.

     ----------------------Cut Here-------------------------------------

     TURBO-SCREEN SYSTEM REGISTERED VERSION ORDER FORM


     TO:
     ---
     THE CONNELLY BROTHERS
     P.O. BOX  280527
     LAKEWOOD, CO.   80228-0527

     ORDER:
     ------

     Number of Copies   Unit Cost                      Cost   (U.S. Dollars)
     ----------------   ----------------------------   ----------------------
                        $30.00 Plus $3.00 Shipping
     ________________   and Handling = $33.00 Each.    $_____________________
                        Colorado Residents add
                        3.1% State Tax                 $_____________________

                        TOTAL                          $_____________________

     FROM:
     -----
     NAME: _________________________________________________________

     TITLE:_________________________________________________________

     COMPANY:_______________________________________________________

     STREET ADDRESS: _______________________________________________

     CITY: _________________________________________________________

     STATE: __________________________  ZIP: _______________________



     ----------------------Cut Here-------------------------------------

     APPENDIX A
     -------- -

     Key-Functions:

     KEY-FUNCTION
     LITERAL       DEFINITION
     -----------   ----------
     backspace   - Backspace over a character or move backward.
     break_out   - When the key that is mapped to the break_out function is
                   pressed, the executing program is halted.
     clr_eol     - Clear to the end of a field.
     delete      - Delete a character.
     down        - Move down one field. Down is calculated as the closest field
                   below the current field occupied by the cursor.
     downr       - Move down one field until the cursor is at the bottom most
                   field, then move to the next column to the right.
                   (note: This could be a right or left downward field move)
     normal      - The key value read in will be acted upon as a normal
                   key, i.e., it will be passed to the program.
                   An 'a' key is pressed so, an a is generated
                   in a screen field.
     exit_panel  - Exit panel returns from the panel procedure to the
                   calling program.
     ins_toggle  - Allow insertion of text within a field.
     left        - Move to the closest left most field relative to the cursor.
     move_bol    - Move to the beginning of a field.
     move_eol    - Move to the end of a field.
     next_field  - Move to the next field.
     nullk       - Do nothing when this key is struck.
     prev_field  - Move to the previous field.
     right       - Move to the closest right most field relative to the cursor.
     up          - Move up one field. Up is calculated as the closest field
                   above the current field occupied by the cursor.
                   (note: This could be a right or left upward field move)
     upr         - Move up one field until the cursor is at the upper most
                   field, then move to the next column to the right.

     APPENDIX B
     -------- -

{speckeys.h --- Turbo Screen System keyboard map include}
{ 7/21/88}

     Special keys -- Extended key codes:

     Note: Extended 101-102 keyboard's function keys 11, 12 may not work
     correctly.
     This is a reported and confirmed bug within Turbo Pascal V 4.0 as of
     4/12/88.
     Some AT clones work fine but IBM-AT's do not.

     Syntax:
     <Program-reference> = <value>;   { description }

     CTLAT= 0;          { control-@                                 }
     CTLA=  1;          { control-a                                 }
     CTLB=  2;          { control-b                                 }
     CTLC=  3;          { control-c                                 }
     CTLD=  4;          { control-d                                 }
     CTLE=  5;          { control-e                                 }
     CTLF=  6;          { control-f                                 }
     CTLG=  7;          { control-g                                 }
     BS  =  8;          { backspace                                 }
     HT  =  9;          { horizontal Tab                            }
     CTLJ= 10;          { control-j                                 }
     VT  = 11;          { vertical Tab                              }
     CTLL= 12;          { control-l                                 }
     CR  = 13;          { carriage return                           }
     CTLN= 14;          { control-n                                 }
     CTLO= 15;          { control-o                                 }
     CTLP= 16;          { control-p                                 }
     CTLQ= 17;          { control-q                                 }
     CTLR= 18;          { control-r                                 }
     CTLS= 19;          { control-s                                 }
     CTLT= 20;          { control-t                                 }
     CTLU= 21;          { control-u                                 }
     CTLV= 22;          { control-v                                 }
     CTLW= 23;          { control-w                                 }
     CTLX= 24;          { control-x                                 }
     CTLY= 25;          { control-y                                 }
     CTLZ= 26;          { control-z                                 }
     ESC = 27;          { escape                                    }

     BHT =271;          { shifted horizontal tab                    }
     ALTQ=272;          { alternate-q                               }
     ALTW=273;          { alternate-w                               }
     ALTE=274;          { alternate-e                               }
     ALTR=275;          { alternate-r                               }
     ALTT=276;          { alternate-t                               }
     ALTY=277;          { alternate-y                               }
     ALTU=278;          { alternate-u                               }

     ALTI=279;          { alternate-i                               }

     ALTO=280;          { alternate-o                               }
     ALTP=281;          { alternate-p                               }
     ALTA=286;          { alternate-a                               }
     ALTS=287;          { alternate-s                               }
     ALTD=288;          { alternate-d                               }

     ALTF=289;          { alternate-f                               }
     ALTG=290;          { alternate-g                               }
     ALTH=291;          { alternate-h                               }

     ALTJ=292;          { alternate-j                               }
     ALTK=293;          { alternate-k                               }
     ALTL=294;          { alternate-l                               }

     ALTZ=300;          { alternate-z                               }
     ALTX=301;          { alternate-x                               }
     ALTC=302;          { alternate-c                               }
     ALTV=303;          { alternate-v                               }
     ALTB=304;          { alternate-b                               }
     ALTN=305;          { alternate-n                               }
     ALTM=306;          { alternate-m                               }

     F1 = 315;          { function key 1                            }
     F2 = 316;          { function key 2                            }
     F3 = 317;          { function key 3                            }
     F4 = 318;          { function key 4                            }
     F5 = 319;          { function key 5                            }
     F6 = 320;          { function key 6                            }
     F7 = 321;          { function key 7                            }
     F8 = 322;          { function key 8                            }
     F9 = 323;          { function key 9                            }
     F10= 324;          { function key 10                           }

     HOME=327;          { home                                      }
     UPA =328;          { up arrow                                  }
     PGUP=329;          { page up                                   }
     LEFTA=331;         { left arrow                                }
     RIGHTA=333;        { right arrow                               }
     ENDK=335;          { end key                                   }
     DOWNA=336;         { down arrow                                }
     PGDN=337;          { page down                                 }
     INS =338;          { insert                                    }
     DEL =339;          { delete                                    }

     EF11=389;          { function key 11 enhanced 101 keyboard     }
     EF12=390;          { function key 12 enhanced 101 keyboard     }

     F11 =340;          { shifted-function key 1                    }
     F12 =341;          { shifted-function key 2                    }
     F13 =342;          { shifted-function key 3                    }
     F14 =343;          { shifted-function key 4                    }
     F15 =344;          { shifted-function key 5                    }
     F16 =345;          { shifted-function key 6                    }
     F17 =346;          { shifted-function key 7                    }
     F18 =347;          { shifted-function key 8                    }
     F19 =348;          { shifted-function key 9                    }
     F20 =349;          { shifted-function key 10                   }

     F21 =350;          { alternate-function key 1                  }
     F22 =351;          { alternate-function key 2                  }
     F23 =352;          { alternate-function key 3                  }
     F24 =353;          { alternate-function key 4                  }
     F25 =354;          { alternate-function key 5                  }
     F26 =355;          { alternate-function key 6                  }
     F27 =356;          { alternate-function key 7                  }
     F28 =357;          { alternate-function key 8                  }
     F29 =358;          { alternate-function key 9                  }
     F30 =359;          { alternate-function key 10                 }

     F31 =360;          { control-function key 1                    }
     F32 =361;          { control-function key 2                    }
     F33 =362;          { control-function key 3                    }
     F34 =363;          { control-function key 4                    }
     F35 =364;          { control-function key 5                    }
     F36 =365;          { control-function key 6                    }
     F37 =366;          { control-function key 7                    }
     F38 =367;          { control-function key 8                    }
     F39 =368;          { control-function key 9                    }
     F40 =369;          { control-function key 10                   }

     CTL_PTRSC=370;     { control-print-screen                      }
     CTL_LEFT=371;      { control-left-arrow                        }
     CTL_RIGHT=372;     { control-right-arrow                       }
     CTL_END=373;       { control-end                               }
     CTL_PGDN=374;      { control-page-down                         }
     CTL_HOME=375;      { control-home                              }
                        { alternate                                 }
     ATL1=376;          { alternate-1                               }
     ATL2=377;          { alternate-2                               }
     ATL3=378;          { alternate-3                               }
     ATL4=379;          { alternate-4                               }
     ATL5=380;          { alternate-5                               }
     ATL6=381;          { alternate-6                               }
     ATL7=382;          { alternate-7                               }
     ATL8=383;          { alternate-8                               }
     ATL9=384;          { alternate-9                               }
     ATL0=385;          { alternate-0                               }
     ATL_=386;          { alternate--                               }
     ALT_EQ=387;        { alternate-=                               }
     CTL_PGUP=388;      { control-page-up                           }



     APPENDIX C
     -------- -

     Default Key-Function -> key mapping:

     Key                   Key-Function
     ----------            --------------

     CTLC               -> break_out
     BS                 -> backspace
     HT                 -> move_eol
     CR                 -> next_field
     F3                 -> exit_panel
     BHT                -> move_bol
     UPA                -> up
     LEFTA              -> left
     RIGHTA             -> right
     DOWNA              -> down
     INS                -> ins_toggle
     DEL                -> delete
     char(1)..char(255) -> normal
     all other keys     -> nullk

     APPENDIX D
     -------- -
     The Test File and Panel Call Variables

     Suppose we have the following Panel Design File (XX.PAN):
     (File begins on next line)

             @                           ^

             @                           ^

             @                           ^

            #Message One#
            #Message Two#
            #Message Three#
            |S:15:DATA_STRING|
            |R:10:Realvar|
            |I:5:Intvar|
     (File ends on the previous line)

     The above Panel Design File will create the following Test File:
     (We have added additional comments with (* and *) delimiters)

     (File begins on next line)
     {
     Turbo-Screen V1.00A test code generation --- 1-1-1976 12:00:00
     note memory allocations. Increase stack as needed for user programs
      }
     {$M 30500,0,655360}     (*Compiler Memory Allocation*)
     Program XX_generated_code;

     Uses Crt,Dos,TSSLIB;       { your code needs these units }

     {$I XX.con}             (*Panel Procedure Variable Definition*)

     {$I XX.prc}             (*The TSS.EXE Generated Code*)

     begin
          DATA_STRING:='               ';   (*String Data Initialization*)
          Realvar:=0.0;                     (*Real Data Initialization*)
          Intvar:=0;                        (*Integer Data Initialization*)
             (* Next Variable is Global Screen Control Variable which
               is initialized here*)
         sccn:=[cpcall,cvcall,cpret,cvret,upmsg,upvar];
     XX(
         sccn,          (*Global Screen Control Variable*)
         cerr,          (*Error Return Variable*)
         nfld,          (*Field Number upon Return to Calling Procedure*)
         ret_key,       (*Key Number of Exit_Panel Key*)
         DATA_STRING,   (* Your                                *)
         Realvar,       (* Data                                *)
         Intvar);       (* Variables from the Panel Design File*)

     end.
     (File ends on the previous line)


     Additional notes on the above XX.TST file:

     1.  Global Scrn_ctl Set Variable "sccn" stores the Screen
     Control set elements.

     2.  Global Integer Variable "cerr" returns last Field number, when
     the panel is exited, which could not be formatted into its specific
     format type.

     3.  Global Integer Variable "nfld" returns the Field number where
     the cursor was located when the panel was exited.   In addition, if
     you place the value of the Field that you wish for the cursor to
     start, and the value is a valid Field number (greater than zero and
     less than or equal to the maximum Field number), then the cursor
     will be located on the desired field number upon the call to the
     Panel.  If "nfld" is less than zero or greater than the maximum
     Field number for a Panel, then "nfld" is set to one upon the call
     to the Panel.


     APPENDIX E
     -------- -

     Screen Attribute Set Members:


     FEATURE    DESCRIPTION                                      DEFAULT

     -------    -----------                                      -------
     cpcall  -- Clears the entire screen                          ON
                when Panel is called
     cpret   -- Clears the entire screen                          ON
                when Panel returns to
                calling procedure
     cvcall  -- Clears all Fields                                 ON
                when Panel is called
     cvret   -- Clears all Fields                                 ON
                when Panel returns to
                calling procedure
     editoff -- Turns off Field editing.                          OFF
     erron   -- Turns on default Field                            OFF
                type error checking
     upmsg   -- Updates Messages only                             ON
                when Panel is called.
     upvar   -- Updates Fields only                               ON
                when Panel is called
     lvcrs   -- leave cursor in same Field                        OFF
                character location when
                cursor moves to next Field


     APPENDIX F
     -------- -

     Turbo Pascal Version 4.0 Supporting Unit

     Turbo Screen System supports both Turbo Pascal version 4.0 and 5.0
     through the use of the utility batch program SWAPTPU.BAT. TSS comes
     initially installed for version 5.0. To switch to version 4.0
     unit support change to the directory that TSS was originally
     installed into with the dos CD command.  Once your current working
     directory has TSSLIB.TPU and either TSSLIB04.TPU or TSSLIB05.TPU
     within it, then merely execute SWAPTPU.BAT at the dos prompt.

     An example scenario would be:

     C> CD \TSS
     C> DIR *.TPU

        Volume in drive C has no label
        Directory of  C:\TSS

        TSSLIB04 TPU    32064  12-11-88  12:25a
        TSSLIB   TPU    31776  12-11-88  12:52a
               2 File(s)   99999999 bytes free

     C> SWAPTPU

     SWAPTPU will inform the user as to the progress and conclusion
     of the TPU swapping.  If the user needs to revert back to version
     5.0 unit conventions merely execute SWAPTPU again.

     Possible Error Conditions and corrections
     -----------------------------------------

     Error #1 -- This condition arises when the tsslib.tpu is not
                 in the current directory. To remedy this situation,
                 copy tsslib.tpu into the current working directory
                 from the distribution diskette.

     Error #2 -- The alternative version TPU file tsslib04.tpu or
                 tsslib05.tpu cannot be found.  To fix this error
                 copy all tpu files from the distribution diskette
                 by executing COPY A:*.TPU with your current working
                 directory being the TSS installed directory.
