{ NESTTRC.PAS }
{ This program demonstrates the use of a local Trace Procedure.       }
{}
Program NestTrc;

Uses TRACE;

PROCEDURE Global;
 VAR LocalVar: Byte;

 FUNCTION NestedFunction: Byte;
 BEGIN
   NestedFunction := 215;
 END; {FUNCTION NestedFunction}

 PROCEDURE IncrementLocalVar;
 Var n:Byte;
 BEGIN
   FOR n := 1 TO 255 DO BEGIN
    Inc(LocalVar);
    Inline($90);
   END;
 END; {PROCEDURE IncrementLocalVar;}

{ CheckLocalVar }
{ This is the Pascal Trace Procedure.  Note that the Trace Procedure  }
{ can be a nested Procedure, which can inspect/write/modify/etc any   }
{ global or local variables which are known within the current scope, }
{ and can similarly call any global or local procedures or functions  }
{ which are known within the current scope.  Nested Trace procedures  }
{ must be local to the CURRENT block.                                 }
{ CheckLocalVar }
 PROCEDURE CheckLocalVar;
 BEGIN
   IF LocalVar = NestedFunction THEN TRelease;
   TReturn;   {- Return from Trace interrupt -}
 END; {PROCEDURE CheckLocalVar}

BEGIN {PROCEDURE Global}
 LocalVar := 0;
 TraceOn(@CheckLocalVar);
 IncrementLocalVar;
 TraceOff;    {- Deactivate trace by the end of the current block -}
END; {PROCEDURE Global}

BEGIN {MAIN}
  Global;
END.
