Unit DMX_FILE;  { incorporates file access methods into DMX }

{$V-,I- }

interface


uses   Dos, DMX2;

type
       Dwindow     =  object (DMXwindow)
                        bytesread            : word;

                        procedure LoadDataBlock (var Data;
                                                     BuffSize : longint;
                                                 var F );
                        procedure SaveDataBlock (var Data;  var F );
                      end;


implementation


  {  }


procedure DWindow.LoadDataBlock (var Data;
                                     BuffSize : longint;
                                 var F );
type  bytefile = file of byte;
var   fs  :  longint;
begin
  bytesread := 0;
  If recordsize > 0 then
    recordlimit := BuffSize div (recordsize + phantomdata)
   else
    recordlimit := 0;
  If recordlimit = 0 then
    DiskError := 13  { invalid data }
   else
    begin
    FillChar (Data, BuffSize, 0);
    If filerec (F).mode = fmClosed then
      begin
      Reset (bytefile (F));
      DiskError := IoResult;
      end
     else
      DiskError := 0;
    If DiskError = 0 then
      begin
      bytesread := BuffSize;
      ReadNextBlock (bytefile (F), Data, bytesread);
      If IoError then bytesread := 0;
      end;
    end;
  changemade := False;
end;  { LoadDataBlock }


  {  }


procedure DWindow.SaveDataBlock (var Data;  var F );
type  bytefile = file of byte;
begin
  If changemade and (recordlimit > 0) then
    begin
    If filerec (F).mode = fmClosed then
      begin
      Reset (bytefile (F));
      If IoError then
        begin
        ReWrite (bytefile (F));
        DiskError := IoResult;
        end;
      end
     else
      DiskError := 0;
    If DiskError = 0 then
      begin
      WriteNextBlock (bytefile (F), Data, recordlimit * (recordsize + phantomdata));
      DiskError := IoResult;
      end;
    changemade  := False;
    end;
end;  { SaveDataBlock }


  {  }


End.
