Program DMXAMPLE;

{ This is the example described in the READ.ME file.
  It uses no file I/O, and therefore cannot save the data.
  The entire database is kept in a memory array.

  The DataArray is defined as data type DataRec, but you may notice
  that it is the format string passed to DMXa.Init that determines
  how the database is formatted.

  The integer field is given a 'iiii' description.  This means that
  negative numbers cannot be entered.  Changing the string to all
  upper case will change this to allow both positive and negative numbers.

  Likewise, the underline characters ('_') can be changed to '^'s.
  This will force all strings to be entered in uppercase only.
  (This would not affect data that is already entered.)

  Just ensure that every field is separated by a '|'.
 }

uses Crt, DMX2;

type DataRec    = record
                    S :string [20];  I :integer;  R :real;
                  end;

var  Key,ext    : char;
     DataArray  : array [0..99] of DataRec;
     DMXa       : DMXwindow;  { the data entry object }

Begin
  ClrScr;
  Window (19,2,69,22);
  FillChar (DataArray, sizeof (DataArray), 0);  { clear the data }

  DMXa.Init (' Name                    ref      balance    ',
             ' ____________________ | iiii | ($RRR,RRR.RR) ',
             {     string [20]      integer      real      }
              2,1, Cyan,LightCyan,$3F);


  DMXa.OpenBuffer (DataArray, sizeof (DataArray));
             { This is the procedure that sets up the screen. }


  DMXa.EditData (DataArray, Key,ext, [#27],[]);
             { This is the procedure to edit the database. }
             { Pressing Esc (char 27) is the only way to exit. }

             { The last key pressed is returned in Key and ext }

  ClrScr;
End.

