UNIT TpzAsync;
(* Modem interface routines for Turbo Pascal Zmodem *)
(* (c)1988 by J.R.Louvau                            *)
(* You will need a copy of PIBASYN45 to compile     *)
(* this unit.                                       *)
(* I've included the Units in this Archive. CRansom *)
INTERFACE
USES Dos, PibAsync, PibTimer, GlobType;

FUNCTION Z_AsyncOn(zport: WORD; zbaud: LONGINT): BOOLEAN;
PROCEDURE Z_AsyncOff;
FUNCTION Z_CharAvail: BOOLEAN;
PROCEDURE Z_ClearInbound;
PROCEDURE Z_FlushOutbound;
PROCEDURE Z_ClearOutbound;
PROCEDURE Z_SendBreak;
FUNCTION Z_ReceiveByte: INTEGER;
PROCEDURE Z_SendByte(b: BYTE);
FUNCTION Z_Carrier: BOOLEAN;

IMPLEMENTATION

FUNCTION Z_CharAvail: BOOLEAN;
(* See if there is a character coming in *)
BEGIN
   Z_CharAvail := Async_Buffer_Check
END;

PROCEDURE Z_ClearInbound;
(* Throw away any pending input to clear the line *)
VAR
   n: INTEGER;
BEGIN
   WHILE (Async_Carrier_Detect) AND (Async_Buffer_Check) DO
      Async_Receive_With_Timeout(1,n)
END;

PROCEDURE Z_ClearOutbound;
(* Throw away any pending output in the buffer *)
BEGIN
   Async_Flush_Output_Buffer
END;

PROCEDURE Z_FlushOutbound;
BEGIN
   REPEAT UNTIL (NOT Async_Carrier_Detect) OR
                (Async_OBuffer_Head = Async_OBuffer_Tail)
END;

PROCEDURE Z_SendBreak;
(* Send a break signal *)
BEGIN
   Async_Send_Break
END;

PROCEDURE Z_SendByte(b: BYTE);
(* Output one byte *)
BEGIN
   Async_Send(Chr(b))
END;

FUNCTION Z_ReceiveByte: INTEGER;
(* Input one byte (N.B.: RETURNS AN INTEGER!) *)
VAR
   n: INTEGER;
BEGIN
   Async_Receive_With_Timeout(0,n);
   Z_ReceiveByte := (n AND $00FF)
END;

FUNCTION Z_Carrier: BOOLEAN;
(* Checks for the presence of a carrier *)
BEGIN
   Z_Carrier := (Async_Carrier_Detect)
END;

PROCEDURE Z_AsyncOff;
VAR
   I : INTEGER;
   M : INTEGER;
BEGIN  (* Async_Close *)
                   (* Read the RBR and reset any pending error conditions. *)
                   (* First turn off the Divisor Access Latch Bit to allow *)
                   (* access to RBR, etc.                                  *)
   INLINE($FA);  (* disable interrupts *)
   Port[UART_LCR + Async_Base] := Port[UART_LCR + Async_Base] AND $7F;
                   (* Read the Line Status Register to reset any errors *)
                   (* it indicates                                      *)
   I := Port[UART_LSR + Async_Base];
                   (* Read the Receiver Buffer Register in case it *)
                   (* contains a character                         *)
   I := Port[UART_RBR + Async_Base];
                   (* enable the irq on the 8259 controller *)
   I := Port[I8088_IMR];  (* get the interrupt mask register *)
   M := (1 SHL Async_Irq) XOR $00FF;
   Port[I8088_IMR] := I AND M;
                   (* enable OUT2 on 8250 *)
   I := Port[UART_MCR + Async_Base];
   Port[UART_MCR + Async_Base] := I OR $0B;
                   (* enable the data ready interrupt on the 8250 *)
   Port[UART_IER + Async_Base] := $0F;
                   (* Re-enable 8259 *)
   Port[$20] := $20;
   INLINE($FB); (* enable interrupts *)
   IF Async_Open_Flag THEN
      BEGIN
                     (* disable the IRQ on the 8259 *)
         INLINE($FA);                 (* disable interrupts *)
         I := Port[I8088_IMR];        (* get the interrupt mask register *)
         M := 1 SHL Async_Irq;        (* set mask to turn off interrupt  *)
         Port[I8088_IMR] := I OR M;
                     (* disable the 8250 interrupts *)
         Port[UART_IER + Async_Base] := 0;
                     (* Disable OUT2, RTS, OUT1 on the 8250, but *)
                     (* possibly leave DTR enabled.              *)
         Port[UART_MCR + Async_Base] := 1;
         INLINE($FB);                 (* enable interrupts *)
                     (* re-initialize our data areas so we know *)
                     (* the port is closed                      *)
         Async_Open_Flag := FALSE;
         Async_XOFF_Sent := FALSE;
                     (* Restore the previous interrupt pointers *)
         SetIntVec( Async_Irq + 8 , Async_Save_Iaddr );
			I := Port[UART_LSR + Async_Base];
                (* Read the Receiver Buffer Register in case it *)
                (* contains a character                         *)
         I := Port[UART_RBR + Async_Base];
             (* enable the irq on the 8259 controller *)
         I := Port[I8088_IMR];  (* get the interrupt mask register *)
         M := (1 SHL Async_Irq) XOR $00FF;
         Port[I8088_IMR] := I AND M;
            (* enable OUT2 on 8250 *)
         I := Port[UART_MCR + Async_Base];
         Port[UART_MCR + Async_Base] := I OR $0B;
            (* enable the data ready interrupt on the 8250 *)
         Port[UART_IER + Async_Base] := $0F;
            (* Re-enable 8259 *)
         Port[$20] := $20;
         INLINE($FB); (* enable interrupts *)
      END;
END    (* Async_Close *);

FUNCTION Z_AsyncOn(zport: WORD; zbaud: LONGINT): BOOLEAN;
BEGIN
   Async_Do_CTS := FALSE;
   Async_Do_DSR := FALSE;
   Async_Do_XonXoff := FALSE;
   Async_Hard_Wired_On := FALSE;
   Async_Break_Length := 500;
   Async_Init(2048,2048,0,0,0);
   Z_AsyncOn := Async_Open(zport,zbaud,'N',8,1)
END;
END.
