{$S-,R-,V-,I-,B-,F+,X+}
{$M 8192,0,655360}

{*********************************************************}
{*                    LISTVER.PAS 1.00                   *}
{*        Copyright (c) TurboPower Software 1992.        *}
{*                 All rights reserved.                  *}
{*********************************************************}

program ListVer;
  {-List version numbers in specified files}

uses
  Dos;
type
  VerInfo = record
    Increment : Word;
    Minor : Byte;
    Major : Byte;
  end;
  Long = record
    LowWord, HighWord : Word;
  end;
  String2 = String[2];
const
  Files = AnyFile and not (Directory or VolumeID);
  DosDelimSet : set of Char = ['\', ':', #0];
  Digits : array[0..$F] of Char = '0123456789ABCDEF';

var
  SRec : SearchRec;
  Mask : PathStr;
  Ver  : LongInt;
  VerI : VerInfo absolute Ver;
  FullName : PathStr;

  function Long2Str(L : LongInt) : string;
    {-Convert a long/word/integer/byte/shortint to a string}
  var
    S : string;
  begin
    Str(L, S);
    Long2Str := S;
  end;

  function StUpcase(S : String) : String;
  var
    I : Word;
  begin
    for I := 1 to Length(S) do
      S[I] := Upcase(S[I]);
    StUpcase := S;
  end;

  function HexW(W : Word) : string;
    {-Return hex string for word}
  begin
    HexW[0] := #4;
    HexW[1] := Digits[hi(W) shr 4];
    HexW[2] := Digits[hi(W) and $F];
    HexW[3] := Digits[lo(W) shr 4];
    HexW[4] := Digits[lo(W) and $F];
  end;

  function HexL(L : LongInt) : string;
    {-Return hex string for LongInt}
  begin
    with Long(L) do
      HexL := HexW(HighWord)+HexW(LowWord);
  end;

  function AddBackSlash(DirName : string) : string;
    {-Add a default backslash to a directory name}
  begin
    if DirName[Length(DirName)] in DosDelimSet then
      AddBackSlash := DirName
    else
      AddBackSlash := DirName+'\';
  end;

  function JustPathname(PathName : string) : string;
    {-Return just the drive:directory portion of a pathname}
  var
    I : Word;
  begin
    I := Succ(Word(Length(PathName)));
    repeat
      Dec(I);
    until (PathName[I] in DosDelimSet) or (I = 0);

    if I = 0 then
      {Had no drive or directory name}
      JustPathname[0] := #0
    else if I = 1 then
      {Either the root directory of default drive or invalid pathname}
      JustPathname := PathName[1]
    else if (PathName[I] = '\') then begin
      if PathName[Pred(I)] = ':' then
        {Root directory of a drive, leave trailing backslash}
        JustPathname := Copy(PathName, 1, I)
      else
        {Subdirectory, remove the trailing backslash}
        JustPathname := Copy(PathName, 1, Pred(I));
    end else
      {Either the default directory of a drive or invalid pathname}
      JustPathname := Copy(PathName, 1, I);
  end;

  procedure WriteHelp;
    {-Write help and halt}
  begin
    WriteLn;
    WriteLn('Usage: LISTVER FileMask');
    WriteLn('  Lists the FileVersionMS longint value from the VERINFO');
    WriteLn('  block of files matching FileMask');
    Halt;
  end;

  function GetFileVerMS(FName : PathStr; var Ver : Longint) : Boolean;
   {-Search for versioninfo resource in FName and return FileVersionMS}
  type
    {Old header snippet}
    OldHeader = record
      Junk1         : array[1..$18] of Char;
      NewHeaderFlag : Byte;
      Junk2         : array[1..$23] of Char;
      NewHeaderOfs  : Word;
    end;

    {New header snippet}
    NewHeader = record
      Junk : array[1..36] of Byte;
      ResTableOfs   : Word;
    end;

    {Resource table entry - used for skipping entries}
    ResourceNameInfo = record
      rnOffset : Word;
      rnLength : Byte;
      rnFlags  : Word;
      rnJunk1  : Byte;
      rnID     : Word;
      rnJunk2  : array[1..4] of Byte;
    end;

    {Fixed file info format of VERINFO resource}
    Tvs_FixedFileInfo = record
      dwStrucVersion     : Longint;
      dwFileVersionMS    : Longint;
      dwFileVersionLS    : Longint;
      dwProductVersionMS : Longint;
      dwProductVersionLS : Longint;
      dwFileFlagsMask    : Longint;
      dwFileFlags        : Longint;
      dwFileOS           : Longint;
      dwFileType         : Longint;
      dwFileSubtype      : Longint;
      dwFileDateMS       : Longint;
      dwFileDateLS       : Longint;
    end;

  const
    VerInfoRes = $8010;

  var
    F : File;
    OH : OldHeader;
    NH : NewHeader;
    RN : ResourceNameInfo;
    ResType : Word;
    Count : Word;
    Root : Tvs_FixedFileInfo;
    VerOfs : Word;
    Finished : Boolean;
    Align : Word;

    function ReadNextType : Boolean;
      {-Read the next resource type record}
    begin
      {Read resource type and count}
      BlockRead(F, ResType, 2);
      BlockRead(F, Count, SizeOf(Count));
      ReadNextType := Lo(ResType) <> 0;
    end;

    procedure SkipNextType;
      {-Skip all nameinfo entries for this resource type}
    var
      I : Word;
      Junk : array[1..5] of Word;
    begin
      BlockRead(F, Junk, 4);
      for I := 1 to Count do
        BlockRead(F, RN, SizeOf(RN));
    end;

    function Power(Exp : Byte) : LongInt;
    var
      L : LongInt;
      I : Word;
    begin
      L := 2;
      for I := 1 to Exp-1 do
        L := L * 2;
      Power := L;
    end;

    function ReadVerResource : LongInt;
      {-Read the VERINFO resourse and return FileVersionMS}
    var
      Junk : array[1..10] of Byte;
      Name : String[15];
      B : Byte;
      Adjust : Longint;
    begin
      BlockRead(F, Junk, 4);
      BlockRead(F, VerOfs, SizeOf(VerOfs));
      Adjust := Power(Align);
      Seek(F, LongInt(VerOfs)*Adjust);

      {Read cbBlock, cbValue}
      BlockRead(F, Junk, 4);

      {Read in the name, must be VS_VERSION_INFO}
      BlockRead(F, Name[1], 15);
      Name[0] := #15;
      if Name = 'VS_VERSION_INFO' then begin
        repeat
          BlockRead(F, B, 1);
        until B <> 0;
        BlockRead(F, Junk, 3);
        BlockRead(F, Root, SizeOf(Root));
        ReadVerResource := Root.dwFileVersionMS;
        GetFileVerMS := True;
        Exit;
      end;
    end;

  begin
    {Assume failure}
    GetFileVerMS := False;

    {Open file}
    Assign(F, FName);
    Reset(F, 1);
    if IoResult <> 0 then
      Exit;

    {Read in old-style header, done if no new style header}
    BlockRead(F, OH, SizeOf(OH));
    if OH.NewHeaderFlag < $40 then
      Exit;

    {Read in new header, seek to start of Resource Table}
    Seek(F, OH.NewHeaderOfs);
    BlockRead(F, NH, SizeOf(NH));
    Seek(F, OH.NewHeaderOfs+NH.ResTableOfs);

    {Read align shift word}
    BlockRead(F, Align, 2);

    {Scan for VERINFO resource}
    while ReadNextType do begin

      {Exit on errors}
      if IoResult <> 0 then begin
        Close(F);
        if IoResult <> 0 then ;
        Exit;
      end;

      {Handle this resource type}
      if ResType <> VerInfoRes then
        SkipNextType
      else
        Ver := ReadVerResource;
    end;

    {Close up and exit}
    Close(F);
    if IoResult <> 0 then ;
  end;

  function FormatMinor(B : Byte) : String2;
  var
    S : String2;
  begin
    S := Long2Str(B);
    if Length(S) = 1 then
      Insert('0', S, 1);
    FormatMinor := S;
  end;

begin
  {Show help if wrong number of parameters}
  if ParamCount <> 1 then
    WriteHelp;

  {Only parameter is file mask}
  Mask := StUpcase(ParamStr(1));

  FindFirst(Mask, Files, SRec);
  while DosError = 0 do begin
    FullName := AddBackSlash(JustPathName(Mask)) + SRec.Name;
    if GetFileVerMS(FullName, Ver) then begin
      Write(FullName, ':  FileVersionMS = ', HexL(Ver));
      with VerI do
        WriteLn('   (', Major, '.', FormatMinor(Minor), ' [', Increment, '])');
    end else
      WriteLn(FullName, ' doesn''t have a VERINFO block');
    FindNext(SRec);
  end;
end.
