
#log Printer status predicate

(* prnstat - check printer status *)

type
   prn_states =
      (unplugged, power_off, ready, offline, offline_pending, online_busy);


function prn_status: prn_states;
const
   printer_port = $3bd;  {printer 0 status register}
var
   data: integer;

begin
   data := port[printer_port];
   case data of
      $7f: prn_status := unplugged;
      $f7: prn_status := power_off;
      $df: prn_status := ready;
      $4f: prn_status := offline;
      $cf: prn_status := offline_pending;
      $5f: prn_status := online_busy;

      else {writeln(' prn_status: unknown printer status: ',data);}
           prn_status := ready;
   end;
end;

