
#log Integer to hex conversion

(******************************************************
 *
 * Procedure:  itoh
 *
 * Purpose:    converts an integer into a string of hex digits
 *
 * Example:    s := itoh(i);
 *
 *)

function itoh(i: integer): anystring;   {integer to hex conversion}
   function d(i: integer): char;
   begin
      i := i and 15;
      if i > 9 then i := i + 7;
      d := chr(i + ord('0'));
   end;
begin
   itoh := d(i shr 12) + d(i shr 8) + d(i shr 4) + d(i);
end;


(**)
(******************************************************
 *
 * Procedure:  i_to_ur
 *
 * Purpose:    converts an unsigned integer into an unsigned real
 *
 * Example:    r := i_to_ur(i);
 *
 *)

function i_to_ur(i: integer): real;  {integer to unsigned-real conversion}
var
   r: real;
begin
   r := int( i shr 1 );
   if (i and 1) <> 0 then
      r := r + r + 1.0
   else
      r := r + r;

   i_to_ur := r;
end;

(**)
(******************************************************
 *
 * Procedure:  ur_to_i
 *
 * Purpose:    converts an unsigned real into an integer
 *
 * Example:    i := ur_to_i(r);
 *
 *)

function ur_to_i(r: real): integer;  {unsigned-real to integer conversion}
var
   i:  integer;
   r2: real;
begin
   r := int(r);
   r2 := int(r / 2.0);
   if r2+r2 = r then
      i := trunc(r2) shl 1
   else
      i := (trunc(r2) shl 1) or 1;

   ur_to_i := i
end;


