
const gettime_tag: string[90]
   = #0'@(#)CURRENT_FILE LAST_UPDATE Get time of day as real 1.1'#0;
#log Get time of day as a real 1.1

(*
 * gettime - get time of day from system clock
 *
 *)

function get_time: real;
var
   reg:  regpack;
   time: real;
begin
   reg.ax := $2c00;          (* DOS get time function code *)
   msdos( reg );

   with reg do
   begin
      time := int(lo(dx)) / 100.0 +   {seconds/100}
              int(hi(dx)) +           {seconds}
              int(lo(cx)) * 60.0 +    {minutes}
              int(hi(cx)) * 3600.0;   {hours}

      {writeln(hi(cx),':',lo(cx),':',hi(dx),'.',lo(dx),'  ',time:0:2);}
   end;

   get_time := time;
end;
