{$A+,B-,D+,E+,F-,I+,L+,N+,O-,R-,S-,V-}
{$M 1024,5120,5120}
Program PopUpDice;

Uses Crt,           { use the BIOS for video - REQUIRED }
     Dice,          { dice rolling main unit            }
     PopUp,         { low-level popup control routines  }
     Windows;       { simple windowing package          }

Const
  Version = '1.0';
  Signature = $89;          { must be greater than $80 }

Var
  CommandLine : ^String;
  Hotkey      : Word;
  Result      : Word;
  Temp        : String[4];
  ErrorCode   : Byte;

{$F+}
Procedure UpperCase(Var Line : String); External; {$L upprcase.obj}
{$F-}

Procedure Copyright;

Begin
  WriteLn;
  WriteLn('PopDice Version ',Version,' (c) Copyright 1988 Ross Neilson Wentworth');
  WriteLn;
End;

Begin
  Copyright;                                  { display my name          }
  ErrorCode := Installed(Signature);          { see if we can install    }
  If ErrorCode <> 0 Then
  Begin                                       { already or can't install }
    Case ErrorCode Of
      1 : WriteLn('This program must be loaded before PRINT.COM');
      2 : WriteLn('Already Installed');
      3 : WriteLn('Internal error, can''t install');
    End;
    Halt(ErrorCode);                          { return an error code     }
  End;
  CommandLine := Ptr(PrefixSeg,$0080);        { point to command line    }
  UpperCase(CommandLine^);                    { convert to uppercase     }
  Hotkey := Alt + LeftShift + $20;            { default hot key          }
  If ParamCount > 0                           { user defined hot key?    }
    Then Begin
      Temp := ParamStr(1);             { convert command line to hot key }
      Val('$'+Temp,HotKey,Result);
      If (Result <> 0) or (Length(Temp) <> 4) Then
      Begin                          { if error, halt with error message }
        WriteLn('Error in HotKey definition!  Program aborted.',^G);
        Halt(4);                              { return code }
      End;
      WriteLn('User defined HotKey!');
    End
  Else WriteLn('Press ALT + LeftShift + D to activate');
{  ReleaseEnvironment;                          { release unneeded memory     }
  StayResident(Signature,@PopDice,Nil,HotKey); { terminate and stay resident }
End.
