{LAN Status sample program for LAN5x.PAS.}

uses Crt,
     Dos,
     {use version of LAN50, LAN55, or LAN60 depending on compiler }
     {$ifdef VER50} LAN50;
     {$else}
     {$ifdef VER55} LAN55;
     {$else}
     {$ifdef VER60} LAN60;
     {$endif}
     {$endif}
     {$endif}

(**************  GET DOS VERSION NUMBER ***************************)
{The DOS version must be greater than 3.1 to use LAN functions.}
function DosVersionOkay:boolean;
var DosInstalled : real;
begin
  DosInstalled:= hi(dosversion) div 10 +lo(dosversion) / 10;
  writeln('The DOS version is ',DosInstalled:3:2,'.');
  if DosInstalled<3.1 then
    begin
      writeln('The DOS version must be greater than 3.1.');
      DOSVersionOkay:= false;
    end
  else DosVersionOkay:= true;
end;

(********************* SHARE STATUS *********************************)
procedure ShowShareStatus;
begin
  write('Share is ');
  if not ShareInstalled then write('not ');
  writeln('installed.');
end;

(********************* NETBIOS STATUS *******************************)
procedure ShowNetBIOSstatus;
begin
  write('The INT 2Ah NetBIOS interface is ');
  if not NetBIOSavailable then write('not ');
  writeln('available.');
end;

(********************* STATION TYPE *********************************)
procedure ShowStationType;
begin
  write('This station is operating');
  if Server then write(^j^m,'    as a Server');
  if Redirector then write(^j^m,'    as a Redirector');
  if Messenger then write(^j^m,'    as a Messenger');
  if Receiver then write(^j^m,'    as a Receiver');
  writeln('.');
  writeln;
end;

(********************* MACHINE NAME *********************************)
procedure ShowMachineName;
begin
  writeln('The machine''s name is ',Machine_name,'.');
  writeln;
end;

(********************* REDIRECTION LIST *****************************)
procedure ShowRedirectionList;
begin
  if GetRedirList>0 then
    begin
      FreeRedirList; {paired with GetRedirList above.}
      writeln('The Redirection List is as follows:');
      ShowRedirList;
    end
  else writeln('No devices are redirected.');
end;

(********************* MAIN PROGRAM *********************************)
begin
  clrscr;
  writeln('Local Area Network Status Program');
  writeln('------------------------------------------------------------------------');
  if DOSVersionOkay then
    begin
      ShowShareStatus;
      ShowNetBIOSstatus;
      if LANinstalled then
        begin
          ShowStationType;
          ShowMachineName;
          ShowRedirectionList;
        end {if LANinstalled }
      else writeln('This station is operating as a stand-alone PC.')
    end; {of if DosVersionOkay }
  writeln('---------------------------------------------------------------------');
  writeln('End of Local Area Network Status Program.');
end.
