Unit strFuncs;

Interface

FUNCTION n2Str (n : Real; len, places : Integer) : String;

FUNCTION spaces (n : Integer) : String;

FUNCTION before (source, target : String) : String;

FUNCTION after (source, target : String) : String;

FUNCTION parse (VAR source : String; separator : String) : String;

FUNCTION stripTrailing (s : String) : String;

FUNCTION stripLeading (s : String) : String;

FUNCTION noBlanks (s : String) : String;

FUNCTION upCaseStr (s : String) : String;

FUNCTION yes : Boolean;

FUNCTION getPath (s: String) : String;

Implementation

Uses Crt;

VAR blanks : String[255];
    i      : Integer;

FUNCTION n2Str;
  VAR t : String[80];
      c : Integer;
  BEGIN
      Str (n: len: places, t);
      n2Str := t;
  END;

FUNCTION spaces;
  BEGIN
    spaces := copy (blanks,1,n);
  END;

FUNCTION before;
  BEGIN
    if Pos (target, source) = 0 Then
      before := source
    Else
      before := Copy (source, 1, Pos (target, source) - 1);
  END;

FUNCTION after;
  BEGIN
    If pos (target, source) = 0 Then
      after := ''
    Else
      after := Copy (source, Pos (target, source) + Length (target),
                     Length (source));
  END;

FUNCTION parse;
  BEGIN
    parse := before (source, separator);
    source := after (source, separator);
  END;

FUNCTION stripTrailing;
  VAR trail  : Integer;
  BEGIN
    trail := Length(s);
    while s[trail] = ' ' do trail := trail - 1;
    stripTrailing := Copy(s,1,trail);
  END;

FUNCTION stripLeading;
  VAR lead   : Integer;
  BEGIN
    lead := 1;
    while s[lead] = ' ' do lead := lead +1;
    stripLeading := copy (s,lead,Length(s) - lead + 1);
  END;


FUNCTION noBlanks;
  BEGIN
    noBlanks := stripLeading (stripTrailing (s) );
  END;

FUNCTION upCaseStr;
  VAR i : Integer;
      t : String;
  BEGIN
    t := s;
    for i := 1 to Length (t) Do t[i] := UpCase (t[i]);
    upCaseStr := t;
  END;

FUNCTION yes;
  VAR t : Boolean;
      c : Char;
  BEGIN
    REPEAT
      c := UpCase(ReadKey);
      If Not (c In ['N','Y']) Then Write(#7);
    UNTIL c In ['N','Y'];
    Write(c);
    yes := c = 'Y';
  END;

FUNCTION getPath;
  VAR trail  : Integer;
  BEGIN
    trail := Length(s);
    while s[trail] <> '\' do trail := trail - 1;
    getPath := Copy(s,1,trail);
  END;

BEGIN
  blanks := '';
  For I := 1 To 255 Do blanks := blanks + ' ';
END.

