Unit PSPU;
(***********************************************************)
Interface
(***********************************************************)
Uses DOS,CRT,KYBRDu;
Type
  ParamRec = Record
    Len  : Byte;
    List : Array [1..127] of Char;
    End;

  PSPType = Record
    Int32Inst         : Word;                    (* Len   2 Ofs    0 *)
    TopOfDos          : Word;                    (* Len   2 Ofs    2 *)
    Reserved1         : Byte;                    (* Len   1 Ofs    4 *)
    DosDisp           : Array [1..5] of Byte;    (* Len   5 Ofs    5 *)
    TerminateVec      : Pointer;                 (* Len   4 Ofs   10 *)
    BreakVec          : Pointer;                 (* Len   4 Ofs   14 *)
    ErrorVec          : Pointer;                 (* Len   4 Ofs   18 *)
    ParentPSPSeg      : Word;                    (* Len   2 Ofs   22 *)
    FileHandleArray   : Array [1..20] of Byte;   (* Len  20 Ofs   24 *)
    EnvStrSeg         : Word;                    (* Len   2 Ofs   44 *)
    DOSStackSaveArea  : Pointer;                 (* Len   4 Ofs   46 *)
    FHTableSize       : Word;                    (* Len   2 Ofs   50 *)
    FHTableAddress    : Pointer;                 (* Len   4 Ofs   52 *)
    Reserved2         : Array [1..24] of byte;   (* Len  24 Ofs   56 *)
    Int33             : Array [1..3] of Byte;    (* Len   3 Ofs   80 *)
    Reserved3         : Word;                    (* Len   2 Ofs   83 *)
    FCB1Ext           : Array [1..7] of Byte;    (* Len   7 Ofs   85 *)
    FCB1              : Array [1..9] of Byte;    (* Len   9 Ofs   92 *)
    FCB2Ext           : Array [1..7] of Byte;    (* Len   7 Ofs  101 *)
    FCB2              : Array [1..20] of Byte;   (* Len  20 Ofs  108 *)
      Case Byte of                               (* Len 180 Ofs  128 *)
      0: (Param : ParamRec);
      1: (Dta: Array [1..128] of Byte);
    End;

Const
  MaxFiles = 30; (* Size of New File Table *)

Var
  PSP : ^PSPtype;
  MyFileTable : Array [1..MaxFiles] of Byte;
  OldFHAddress : Pointer;
  OldFHTableSize : Word;
  EnvStrOfs : Word;
  TableSwitched : Boolean;

  LastEnvStr : Boolean;

Function CommandLine : String;

Procedure FirstEnvironmentString(var s : string);

Procedure NextEnvironmentString(var s : string);

Procedure ExpandFileTable;

Procedure ResetFHTable;

Procedure DosShell;

(***********************************************************)
Implementation
(***********************************************************)

Var
  Regs : Registers;

Function CommandLine : String;
Var
  i : Word;
  s : String;
Begin
s := '';
With PSP^ Do
For i := 1 To Param.Len Do
  s := s + Param.List[i];
CommandLine := s;
End;

(**********************************************)

Procedure FirstEnvironmentString(Var s : String);
Begin
s := '';
EnvStrOfs := 0;
With PSP^ Do
While Mem[EnvStrSeg:EnvStrOfs] > 0 do
  Begin
  s := s + Chr(mem[EnvStrSeg:EnvStrOfs]);
  EnvStrOfs := EnvStrOfs + 1;
  End;
EnvStrOfs := EnvStrOfs + 1;
LastEnvStr := Mem[PSP^.EnvStrSeg:EnvStrOfs] = 0;
End;

(********************************************************)

Procedure NextEnvironmentString(Var s : string);
Begin
s := '';
With PSP^ Do
While Mem[EnvStrSeg:EnvStrOfs] <> 0 do
  Begin
  s := s + Chr(Mem[EnvStrSeg:EnvStrOfs]);
  EnvStrOfs := EnvStrOfs + 1;
  End;
EnvStrOfs := EnvStrOfs + 1;
LastEnvStr := Mem[PSP^.EnvStrSeg:EnvStrOfs] = 0;
End;

(********************************************************)

Procedure ExpandFileTable;
Begin
If TableSwitched Then Exit;
TableSwitched := True;
With PSP^ Do
  Begin
  FillChar(MyFileTable,SizeOf(MyFileTable),255);

  OldFHAddress := FHTableAddress;
  OldFHTableSize := FHTableSize;

  FHTableSize := MaxFiles;
  FHTableAddress := @MyFileTable;

  Move(FileHandleArray,MyFileTable,20);
  End;
End;

(*********************************************************)

Procedure ResetFHTable;
Begin
If Not TableSwitched Then Exit;
TableSwitched := False;
With PSP^ Do
  Begin
  FHTableAddress := OldFHAddress;
  FHTableSize    := OldFHTableSize;
  Move(MyFileTable,FileHandleArray,20);
  End;
End;

(**********************************************************)

Procedure DosShell;
Var
  st : String;
  fk : Boolean;
  ch : Char;

Begin
FirstEnvironmentString(st);
While Not LastEnvStr and (Pos('COMSPEC=',st) <> 1) Do
  NextEnvironmentString(st);
Delete(st,1,8);
If st[1] In ['A','B'] Then
  Begin
  WriteLn('Make sure boot disk is in drive ',st[1],':');
  Write('When ready press C)ontinue, A)bort...');
    Repeat
    Inkey(ch,fk,key);
    ch := UpCase(ch);
    Until ch In ['C','A'];
  End;

If ch = 'A' Then exit;

ClrScr;
WriteLn('Type EXIT To return To program...');
Exec(st,'');
ClrScr;
If DosError <> 0 Then
  WriteLn('Can not run Dos shell.');
End;

(******************************************************)

Begin
PSP := Ptr(PrefixSeg,0);
TableSwitched := False;
End.
