Unit MOUSU;

{ Transcribed and modified by: Steve T. Jones                            }
{                              Indiana University at Kokomo              }
{                              2300 South Washington Street              }
{                              Kokomo, IN 46902                          }
{                              (317) 453-2000                            }
{                              KCDZ100@INDYCMS                           }
{                              June 5, 1989                              }
{                                                                        }
{ Based on O'Brien, S. K. "Turbo Pascal Advanced Programmer's Guide",    }
{            Berkeley, CA: Osborne/McGraw-Hill (1988).                   }
{                                                                        }

(************************************************************)
Interface
(************************************************************)

Uses CRT,DOS, VIDEOU, BINU;

Type
  GraphCursMaskType = Record
    Mask : Array [0..1,0..15] of Word;
    HorzHotSpot,
    VertHotSpot : Integer;
    End;

Var
  StandardShapeCurs,
  UpArrowCurs,
  LeftArrowCurs,
  CheckMarkCurs,
  PointingHandCurs,
  DiagonalCrossCurs,
  RectangularCrossCurs,
  HourGlassCurs : GraphCursMaskType;

  MouseX,
  MouseY,
  ButtonPressCount,
  ButtonReleaseCount,
  TextScrMask,
  TextCursMask : Word;

  NumMouseKeys : Byte;

  MousePresent : Boolean;

  MKey  : (None,Left,Right,Both);

Procedure ResetMouse;

Procedure VirtualScreenSize(Var MaxX,
                                MaxY,
                                CellSizeX,
                                CellSizeY : Word);

Procedure ShowMouseCursor;

Procedure HideMouseCursor;

Procedure GetButtonStatus;

Procedure SetMouseCursorPos(x,y : Word);

Procedure GetButtonPressInfo(KeyNum : Word);

Procedure GetButtonReleaseInfo(KeyNum : Word);

Procedure SetMinMaxHorzCursPos(Min,Max: Word);

Procedure SetMinMaxVertCursPos(Min,Max: Word);

Procedure SetGraphicsCursor(Var Mask: GraphCursMaskType);

Procedure SetSoftTextCursor(TextScrMask,
                            TextCursMask : Word);

Procedure SetHardTextCursorBig;

Procedure SetHardTextCursorSmall;

Procedure ReadMouseMotionCounters(Var Hcount,
                                  Vcount: Integer);

Procedure LightPenEmulOn;

Procedure LightPenEmulOff;

Procedure SetMickeyToPixels(HRatio,VRatio : Word);

Procedure ConditionalOff(x1,y1,x2,y2 : Word);

Procedure SetDoubleSpeed(Speed : Word);

Procedure SaveMouseDriverState;

Procedure RestoreMouseDriverState;

Procedure SetCrtPageNumber(Page : Word);

Procedure GetCrtPageNumber(Var Page : Word);

Function AnyMouseKeyPressed : Boolean;

Function LeftMouseKeyPressed : Boolean;

Function RightMouseKeyPressed : Boolean;

Function BothMouseKeysPressed : Boolean;

(************************************************************)
Implementation
(************************************************************)

Const
  MouseDelay = 250;
Var
  MouseSaveBuffer : Pointer;
  MKP,
  MouseVisible : Boolean;
  MouseBufferSize: Word;
  Regs : Registers;
  
Procedure DefineStandardShape;
Begin
With StandardShapeCurs Do
  Begin
  Mask[0,0]  := BinToWord('0011111111111111');
  Mask[0,1]  := BinToWord('0001111111111111');
  Mask[0,2]  := BinToWord('0000111111111111');
  Mask[0,3]  := BinToWord('0000011111111111');
  Mask[0,4]  := BinToWord('0000001111111111');
  Mask[0,5]  := BinToWord('0000000111111111');
  Mask[0,6]  := BinToWord('0000000011111111');
  Mask[0,7]  := BinToWord('0000000001111111');
  Mask[0,8]  := BinToWord('0000000000111111');
  Mask[0,9]  := BinToWord('0000000000011111');
  Mask[0,10] := BinToWord('0000000111111111');
  Mask[0,11] := BinToWord('0001000011111111');
  Mask[0,12] := BinToWord('0011000011111111');
  Mask[0,13] := BinToWord('1111100001111111');
  Mask[0,14] := BinToWord('1111100001111111');
  Mask[0,15] := BinToWord('1111110000111111');

  Mask[1,0]  := BinToWord('0000000000000000');
  Mask[1,1]  := BinToWord('0100000000000000');
  Mask[1,2]  := BinToWord('0110000000000000');
  Mask[1,3]  := BinToWord('0111000000000000');
  Mask[1,4]  := BinToWord('0111100000000000');
  Mask[1,5]  := BinToWord('0111110000000000');
  Mask[1,6]  := BinToWord('0111111000000000');
  Mask[1,7]  := BinToWord('0111111100000000');
  Mask[1,8]  := BinToWord('0111111110000000');
  Mask[1,9]  := BinToWord('0111111111000000');
  Mask[1,10] := BinToWord('0111110000000000');
  Mask[1,11] := BinToWord('0100011000000000'); 
  Mask[1,12] := BinToWord('0000011000000000');
  Mask[1,13] := BinToWord('0000001100000000');
  Mask[1,14] := BinToWord('0000001100000000');
  Mask[1,15] := BinToWord('0000000110000000');

  HorzHotSpot := -1;
  VertHotSpot := -1;
  End;
End;

(************************************************************)

Procedure DefineUpArrow;
Begin
With UpArrowCurs Do
  Begin
  Mask[0,0]  := BinToWord('1111100111111111');
  Mask[0,1]  := BinToWord('1111000011111111');
  Mask[0,2]  := BinToWord('1110000001111111'); 
  Mask[0,3]  := BinToWord('1110000001111111');
  Mask[0,4]  := BinToWord('1100000000111111');
  Mask[0,5]  := BinToWord('1100000000111111');
  Mask[0,6]  := BinToWord('1000000000011111');
  Mask[0,7]  := BinToWord('1000000000011111');
  Mask[0,8]  := BinToWord('0000000000001111');
  Mask[0,9]  := BinToWord('0000000000001111');
  Mask[0,10] := BinToWord('1111000011111111');
  Mask[0,11] := BinToWord('1111000011111111');
  Mask[0,12] := BinToWord('1111000011111111');
  Mask[0,13] := BinToWord('1111000011111111'); 
  Mask[0,14] := BinToWord('1111000011111111');
  Mask[0,15] := BinToWord('1111000011111111');

  Mask[1,0]  := BinToWord('0000000000000000');
  Mask[1,1]  := BinToWord('0000011000000000');
  Mask[1,2]  := BinToWord('0000111100000000');
  Mask[1,3]  := BinToWord('0000111100000000');
  Mask[1,4]  := BinToWord('0001111110000000');
  Mask[1,5]  := BinToWord('0001111110000000');
  Mask[1,6]  := BinToWord('0011111111000000');
  Mask[1,7]  := BinToWord('0011111111000000');
  Mask[1,8]  := BinToWord('0111111111100000');
  Mask[1,9]  := BinToWord('0000011000000000');
  Mask[1,10] := BinToWord('0000011000000000');
  Mask[1,11] := BinToWord('0000011000000000');
  Mask[1,12] := BinToWord('0000011000000000');
  Mask[1,14] := BinToWord('0000011000000000');
  Mask[1,15] := BinToWord('0000000000000000');

  HorzHotSpot := 5;
  VertHotSpot := 0;
  end
End;

(*****************************************************)

Procedure DefineLeftArrow;
Begin
With LeftArrowCurs do
  Begin
  Mask[0,0]  := BinToWord('1111111000011111');
  Mask[0,1]  := BinToWord('1111000000011111');
  Mask[0,2]  := BinToWord('0000000000000000');
  Mask[0,3]  := BinToWord('0000000000000000');
  Mask[0,4]  := BinToWord('0000000000000000');
  Mask[0,5]  := BinToWord('1111000000011111');
  Mask[0,6]  := BinToWord('1111111000011111');
  Mask[0,7]  := BinToWord('1111111111111111');
  Mask[0,8]  := BinToWord('1111111111111111');
  Mask[0,9]  := BinToWord('1111111111111111');
  Mask[0,10] := BinToWord('1111111111111111');
  Mask[0,11] := BinToWord('1111111111111111');
  Mask[0,12] := BinToWord('1111111111111111');
  Mask[0,13] := BinToWord('1111111111111111');
  Mask[0,14] := BinToWord('1111111111111111');
  Mask[0,15] := BinToWord('1111111111111111');

  Mask[1,0]  := BinToWord('0000000000000000');
  Mask[1,1]  := BinToWord('0000000011000000');
  Mask[1,2]  := BinToWord('0000011111000000');
  Mask[1,3]  := BinToWord('0111111111111110');
  Mask[1,4]  := BinToWord('0000011111000000');
  Mask[1,5]  := BinToWord('0000000011000000');
  Mask[1,5]  := BinToWord('0000000000000000');
  Mask[1,7]  := BinToWord('0000000000000000');
  Mask[1,8]  := BinToWord('0000000000000000');
  Mask[1,9]  := BinToWord('0000000000000000');
  Mask[1,10] := BinToWord('0000000000000000');
  Mask[1,11] := BinToWord('0000000000000000');
  Mask[1,12] := BinToWord('0000000000000000');
  Mask[1,13] := BinToWord('0000000000000000');
  Mask[1,14] := BinToWord('0000000000000000');
  Mask[1,15] := BinToWord('0000000000000000');

  HorzHotSpot := 0;
  VertHotSpot := 3;
  End;
End;

(****************************************************)

Procedure DefineCheckMark;
Begin
With CheckMarkCurs Do
  Begin
  Mask[0,0]  := BinToWord('1111111111110000');
  Mask[0,1]  := BinToWord('1111111111100000');
  Mask[0,2]  := BinToWord('1111111111000000');
  Mask[0,3]  := BinToWord('1111111110000001');
  Mask[0,5]  := BinToWord('1111111100000011');
  Mask[0,5]  := BinToWord('0000011000000111');
  Mask[0,6]  := BinToWord('0000000000001111');
  Mask[0,7]  := BinToWord('0000000000011111');
  Mask[0,8]  := BinToWord('1100000000111111');
  Mask[0,9]  := BinToWord('1111000001111111');
  Mask[0,10] := BinToWord('1111111111111111');
  Mask[0,11] := BinToWord('1111111111111111');
  Mask[0,12] := BinToWord('1111111111111111');
  Mask[0,13] := BinToWord('1111111111111111');
  Mask[0,14] := BinToWord('1111111111111111');
  Mask[0,15] := BinToWord('1111111111111111');

  Mask[1,0]  := BinToWord('0000000000000000');
  Mask[1,1]  := BinToWord('0000000000000110');
  Mask[1,2]  := BinToWord('0000000000001100');
  Mask[1,3]  := BinToWord('0000000000011000');
  Mask[1,4]  := BinToWord('0000000000110000');
  Mask[1,5]  := BinToWord('0000000001100000');
  Mask[1,6]  := BinToWord('0111000011000000');
  Mask[1,7]  := BinToWord('0001110110000000');
  Mask[1,8]  := BinToWord('0000011100000000');
  Mask[1,9]  := BinToWord('0000000000000000');
  Mask[1,10] := BinToWord('0000000000000000');
  Mask[1,11] := BinToWord('0000000000000000');
  Mask[1,12] := BinToWord('0000000000000000');
  Mask[1,13] := BinToWord('0000000000000000');
  Mask[1,14] := BinToWord('0000000000000000');
  Mask[1,15] := BinToWord('0000000000000000');
  HorzHotSpot := 6;
  VertHotSpot := 7;
  End;
End;

(*******************************************************)

Procedure DefinePointingHand;
Begin
With PointingHandCurs Do
  Begin
  Mask[0,0]  := BinToWord('1110000111111111');
  Mask[0,1]  := BinToWord('1110000111111111');
  Mask[0,2]  := BinToWord('1110000111111111');
  Mask[0,3]  := BinToWord('1110000111111111');
  Mask[0,4]  := BinToWord('1110000111111111');
  Mask[0,5]  := BinToWord('1110000000000000');
  Mask[0,6]  := BinToWord('1110000000000000');
  Mask[0,7]  := BinToWord('1110000000000000');
  Mask[0,8]  := BinToWord('0000000000000000');
  Mask[0,9]  := BinToWord('0000000000000000');
  Mask[0,10] := BinToWord('0000000000000000');
  Mask[0,11] := BinToWord('0000000000000000');
  Mask[0,12] := BinToWord('0000000000000000');
  Mask[0,13] := BinToWord('0000000000000000');
  Mask[0,14] := BinToWord('0000000000000000');
  Mask[0,15] := BinToWord('0000000000000000');

  Mask[1,0]  := BinToWord('0001111000000000');
  Mask[1,1]  := BinToWord('0001001000000000');
  Mask[1,2]  := BinToWord('0001001000000000');
  Mask[1,3]  := BinToWord('0001001000000000');
  Mask[1,4]  := BinToWord('0001001000000000');
  Mask[1,5]  := BinToWord('0001001111111111');
  Mask[1,6]  := BinToWord('0001001001001001');
  Mask[1,7]  := BinToWord('0001001001001001');
  Mask[1,8]  := BinToWord('1111001001001001');
  Mask[1,9]  := BinToWord('1001000000000001');
  Mask[1,10] := BinToWord('1001000000000001');
  Mask[1,11] := BinToWord('1001000000000001');
  Mask[1,12] := BinToWord('1000000000000001');
  Mask[1,13] := BinToWord('1000000000000001');
  Mask[1,14] := BinToWord('1000000000000001');
  Mask[1,15] := BinToWord('1111111111111111');

  HorzHotSpot := 5;
  VertHotSpot := 0;
  end;
End;

(*****************************************************)

Procedure DefineDiagonalCross;
Begin
With DiagonalCrossCurs Do
  Begin
  Mask[0,0]  := BinToWord('0000011111100000');
  Mask[0,1]  := BinToWord('0000000110000000');
  Mask[0,2]  := BinToWord('0000000000000000');
  Mask[0,3]  := BinToWord('1100000000000011');
  Mask[0,4]  := BinToWord('1111000000001111');
  Mask[0,5]  := BinToWord('1100000000000011');
  Mask[0,6]  := BinToWord('0000000000000000');
  Mask[0,7]  := BinToWord('0000000110000000');
  Mask[0,8]  := BinToWord('0000001111000000');
  Mask[0,9]  := BinToWord('1111111111111111');
  Mask[0,10] := BinToWord('1111111111111111');
  Mask[0,11] := BinToWord('1111111111111111');
  Mask[0,12] := BinToWord('1111111111111111');
  Mask[0,13] := BinToWord('1111111111111111');
  Mask[0,14] := BinToWord('1111111111111111');
  Mask[0,15] := BinToWord('1111111111111111');

  Mask[1,0]  := BinToWord('0000000000000000');
  Mask[1,1]  := BinToWord('0111000000001110');
  Mask[1,2]  := BinToWord('0001110000111000');
  Mask[1,3]  := BinToWord('0000011001100000');
  Mask[1,4]  := BinToWord('0000001111000000');
  Mask[1,5]  := BinToWord('0000011001100000');
  Mask[1,6]  := BinToWord('0001110000111000');
  Mask[1,7]  := BinToWord('0111000000001110');
  Mask[1,8]  := BinToWord('0000000000000000');
  Mask[1,9]  := BinToWord('0000000000000000');
  Mask[1,10] := BinToWord('0000000000000000');
  Mask[1,11] := BinToWord('0000000000000000');
  Mask[1,12] := BinToWord('0000000000000000');
  Mask[1,13] := BinToWord('0000000000000000');
  Mask[1,14] := BinToWord('0000000000000000');
  Mask[1,15] := BinToWord('0000000000000000');

  HorzHotSpot := 7;
  VertHotSpot := 4;
  End;
End;

(*****************************************************)

Procedure DefineRectangularCross;
Begin
With RectangularCrossCurs Do
  Begin
  Mask[0,0]  := BinToWord('1111110000111111');
  Mask[0,1]  := BinToWord('1111110000111111');
  Mask[0,2]  := BinToWord('1111110000111111');
  Mask[0,2]  := BinToWord('1111110000111111');
  Mask[0,3]  := BinToWord('0000000000000000');
  Mask[0,4]  := BinToWord('0000000000000000');
  Mask[0,5]  := BinToWord('0000000000000000');
  Mask[0,6]  := BinToWord('1111110000111111');
  Mask[0,7]  := BinToWord('1111110000111111');
  Mask[0,8]  := BinToWord('1111110000111111');
  Mask[0,9]  := BinToWord('1111111111111111');
  Mask[0,10] := BinToWord('1111111111111111');
  Mask[0,11] := BinToWord('1111111111111111');
  Mask[0,12] := BinToWord('1111111111111111');
  Mask[0,13] := BinToWord('1111111111111111');
  Mask[0,14] := BinToWord('1111111111111111');
  Mask[0,15] := BinToWord('1111111111111111');

  Mask[1,0]  := BinToWord('0000000000000000');
  Mask[1,1]  := BinToWord('0000000110000000');
  Mask[1,2]  := BinToWord('0000000110000000');
  Mask[1,3]  := BinToWord('0000000110000000');
  Mask[1,4]  := BinToWord('1111111111111111');
  Mask[1,5]  := BinToWord('0000000110000000');
  Mask[1,6]  := BinToWord('0000000110000000');
  Mask[1,7]  := BinToWord('0000000110000000');
  Mask[1,8]  := BinToWord('0000000000000000');
  Mask[1,9]  := BinToWord('0000000000000000');
  Mask[1,10] := BinToWord('0000000000000000');
  Mask[1,11] := BinToWord('0000000000000000');
  Mask[1,12] := BinToWord('0000000000000000');
  Mask[1,13] := BinToWord('0000000000000000');
  Mask[1,14] := BinToWord('0000000000000000');
  Mask[1,15] := BinToWord('0000000000000000');

  HorzHotSpot := 7;
  VertHotSpot := 4;
  End;
End;

(*****************************************************)

Procedure DefineHourGlass;
Begin
With HourGlassCurs Do
  Begin
  Mask[0,0]  := BinToWord('0000000000000000');
  Mask[0,1]  := BinToWord('0000000000000000');
  Mask[0,2]  := BinToWord('0000000000000000');
  Mask[0,3]  := BinToWord('0000000000000000');
  Mask[0,4]  := BinToWord('1000000000000001');
  Mask[0,5]  := BinToWord('1100000000000011');
  Mask[0,6]  := BinToWord('1110000000000111');
  Mask[0,7]  := BinToWord('1111000000001111');
  Mask[0,8]  := BinToWord('1110000000000111');
  Mask[0,9]  := BinToWord('1100000000000011');
  Mask[0,10] := BinToWord('1000000000000001');
  Mask[0,11] := BinToWord('0000000000000000');
  Mask[0,12] := BinToWord('0000000000000000');
  Mask[0,13] := BinToWord('0000000000000000');
  Mask[0,14] := BinToWord('0000000000000000');
  Mask[0,15] := BinToWord('1111111111111111');

  Mask[1,0]  := BinToWord('0000000000000000');
  Mask[1,1]  := BinToWord('0111111111111110');
  Mask[1,2]  := BinToWord('0110000000000110');
  Mask[1,3]  := BinToWord('0011000000001100');
  Mask[1,4]  := BinToWord('0001100000011000');
  Mask[1,5]  := BinToWord('0000110000110000');
  Mask[1,6]  := BinToWord('0000011001100000');
  Mask[1,7]  := BinToWord('0000001111000000');
  Mask[1,8]  := BinToWord('0000011001100000');
  Mask[1,9]  := BinToWord('0000110000110000');
  Mask[1,10] := BinToWord('0001100000011000');
  Mask[1,11] := BinToWord('0011000000000110');
  Mask[1,12] := BinToWord('0011000000000110');
  Mask[1,13] := BinToWord('0111111111111110');
  Mask[1,14] := BinToWord('0000000000000000');
  Mask[1,15] := BinToWord('0000000000000000');

  HorzHotSpot := 7;
  VertHotSpot := 7;
  End;
End;

(**********************************************************)

Procedure SetKeyStatus(Mstatus : Word);
Begin
  Case Mstatus of
  0: Mkey := None;
  1: Mkey := Left;
  2: Mkey := Right;
  3: Mkey := Both;
  End;
End;

(************************************************************)

Procedure ResetMouse;
Begin
Regs.AX := 0;
Intr($33,Regs);
With Regs Do
  Begin
  MousePresent := AX > 0;
  if MousePresent Then
    NumMouseKeys := BX
  Else
    NumMouseKeys := 0;
  End;
MouseVisible := False;
End;

(**************************************************************)

Procedure VirtualScreenSize(Var MaxX,
                                MaxY,
                                CellSizeX,
                                CellSizeY : Word);
Begin
(* Determine The Video Mode *)
Regs.AH := $0F;
Intr($10,Regs);

  Case Regs.AL Of

  0,1:
    Begin
    MaxX       := 640;
    MaxY       := 200;
    CellSizeX  := 16;
    CellSizeY  := 8;
    End;

  2,3,7:
    Begin
    MaxX       := 640;
    MaxY       := 200;
    CellSizeX  := 8;
    CellSizeY  := 8;
    End;

  4,5:
    Begin
    MaxX       := 640;
    MaxY       := 200;
    CellSizeX  := 2;
    CellSizeY  := 1;
    End;

  6:
    Begin
    MaxX       := 640;
    MaxY       := 200;
    CellSizeX  := 1;
    CellSizeY  := 1;
    End;

 13:
    Begin
    MaxX       := 640;
    MaxY       := 200;
    CellSizeX  := 16;
    CellSizeY  := 8;
    End;
 14,15:
   Begin
   MaxX        := 640;
   MaxY        := 350;
   CellSizeX   := 1;
   CellSIzeY   := 1;
   End;

 End;
End;

(***************************************************)

Procedure ShowMouseCursor;
Begin
If Not MouseVisible Then
  Begin
  Regs.AX  := 1;
  Intr($33,Regs);
  MouseVisible := True;
  End;
End;

(****************************************************)

Procedure HideMouseCursor;
Begin
If MouseVisible Then
  Begin
  Regs.AX := 2;
  Intr($33,Regs);
  MouseVisible := False;
  End;
End;

(******************************************************)

Procedure GetButtonStatus;
Begin
Regs.AX := 3;
Intr($33,Regs);
With Regs Do
  Begin
  SetKeyStatus(BX);
  MouseX := CX;
  MouseY := DX;
  End;
End;

(********************************************************)

Procedure SetMouseCursorPos(x,y : Word);
Begin
With Regs Do
  Begin
  AX := 4;
  CX := x;
  DX := y;
  End;

Intr($33,Regs);
MouseX := x;
MouseY := y;
End;

(*********************************************************)

Procedure GetButtonPressInfo(KeyNum : Word);
Begin
With Regs Do
  Begin
  AX := 5;
  BX := KeyNum-1;
  End;
Intr($33,Regs);
With Regs Do
  Begin
  SetKeyStatus(AX);
  ButtonPressCount := BX;
  MouseX := CX;
  MouseY := DX;
  End;
End;

(**********************************************************)

Procedure GetButtonReleaseInfo(KeyNum : Word);
Begin
With Regs Do
  Begin
  AX := 6;
  BX := KeyNum-1;
  End;
Intr($33,Regs);
With Regs Do
  Begin
  SetKeyStatus(AX);
  ButtonReleaseCount := BX;
  MouseX := CX;
  MouseY := DX;
End;
End;
(***********************************************************)

Procedure SetMinMaxHorzCursPos(Min,Max: Word);
Begin
With Regs Do
  Begin
  AX := 7;
  CX := Min;
  DX := Max;
  End;
Intr($33,Regs);
End;

(************************************************************)

Procedure SetMinMaxVertCursPos(Min,Max: Word);
Begin
With Regs Do
  Begin
  AX := 7;
  CX := Min;
  DX := Max;
  End;
Intr($33,Regs);
End;

(*************************************************************)

Procedure SetGraphicsCursor(Var Mask: GraphCursMaskType);
Begin
With Regs Do
  Begin
  AX := 9;
  BX := Word(Mask.HorzHotSpot);
  CX := Word(Mask.VertHotSpot);
  DX := Ofs(Mask);
  ES := Seg(Mask);
  End;
Intr($33,Regs);
End;

(***************************************************************)

Procedure SetSoftTextCursor(TextScrMask,
                            TextCursMask : Word);
(* TextScrMask defines which character and color attributes are 
*)
(*     after the software mouse cursor is moved.                
*)
(* TextCursMask defines how the character and colors are        
*)
(*     changed in order to display the software mouse cursor.   
*)
Begin
With Regs Do
  Begin
  AX := 10;
  BX := 0;
  CX := TextScrMask;
  DX := TextCursMask;
  End;
Intr($33,Regs);
End;

(****************************************************************
***)


Procedure SetHardTextCursorBig;
Begin
  With Regs Do
  Begin
  AX := 10;
  BX := 1;
  If Stype = Mono Then
    Begin
    CX := 0;
    DX := 13;
    End
  Else
    Begin
    CX := 0;
    DX := 7;
    End;
  End;
Intr($33,Regs);
End;

(***********************************************************)

Procedure SetHardTextCursorSmall;
Begin
With Regs Do
  Begin
  AX := 10;
  BX := 1;
  If Stype = Mono Then
    Begin
    CX := 12;
    DX := 13;
    End
  Else
    Begin
    CX := 6;
    DX := 7;
    End;
  End;
Intr($33,Regs);
End;

(*************************************************************)

Procedure ReadMouseMotionCounters(Var Hcount,
                                      Vcount: Integer);
Begin
Regs.AX := 11;
Intr($33,Regs);
With Regs Do
  Begin
  Hcount := CX;
  Vcount := DX;
  End;
End;

(*************************************************************)

Procedure LightPenEmulOn;
Begin
Regs.AX := 13;
Intr($33,Regs);
End;

(**************************************************************)

Procedure LightPenEmulOff;
Begin
Regs.AX := 14;
Intr($33,Regs);
End;

(**************************************************************)

Procedure SetMickeyToPixels(HRatio,VRatio : Word);
Begin
With Regs Do
  Begin
  AX := 15;
  CX := HRatio;
  DX := VRatio;
  End;
Intr($33,Regs);
End;

(***************************************************************)

Procedure ConditionalOff(x1,y1,x2,y2 : Word);
Begin
With Regs Do
  Begin
  AX := 16;
  CX := x1;
  DX := y1;
  SI := x2;
  DI := y2;
  End;
Intr($33,Regs);
End;

(****************************************************************
*)

Procedure SetDoubleSpeed(Speed : Word);
Begin
With Regs Do
  Begin
  AX := 19;
  DX := Speed;
  End;
Intr($33,Regs);
End;
(****************************************************************
*)

Procedure GetMouseSaveSize;
Begin
Regs.AX := 21;
Intr($33,Regs);
MouseBufferSize := Regs.BX;
End;

(****************************************************************
**)

Procedure SaveMouseDriverState;
Begin
GetMem(MouseSaveBuffer,MouseBufferSize);
With Regs Do
  Begin
  AX := 22;
  DX := Ofs(MouseSaveBuffer^);
  ES := Seg(MouseSaveBuffer^);
  End;
Intr($33,Regs);
End;

(****************************************************************
***)

Procedure RestoreMouseDriverState;
Begin
With Regs Do
  Begin
  AX := 23;
  DX := Ofs(MouseSaveBuffer^);
  ES := Seg(MouseSaveBuffer^);
  End;
Intr($33,Regs);
FreeMem(MouseSaveBuffer,MouseBufferSize);
End;

(****************************************************************
****)

Procedure SetCrtPageNumber(Page : Word);
Begin
With Regs Do
  Begin
  AX := 29;
  BX := Page;
  End;
Intr($33,Regs);
End;

(****************************************************************
*****)

Procedure GetCrtPageNumber(Var Page : Word);
Begin
Regs.AX := 23;
Intr($33,Regs);
Page := Regs.BX;
End;

(****************************************************************
******)

Function AnyMouseKeyPressed : Boolean;
Begin
If MKP Then
  Delay(MouseDelay);
GetButtonStatus;
MKP := Mkey <> None;
AnyMouseKeyPressed := MKP;
End;

(****************************************************************
*******)

Function LeftMouseKeyPressed : Boolean;
Begin
If MKP Then
  Delay(MouseDelay);
GetButtonStatus;
MKP := Mkey = Left;
LeftMouseKeyPressed := MKP;
End;

(****************************************************************
*******)

Function RightMouseKeyPressed : Boolean;
Begin
If MKP Then
  Delay(MouseDelay);
GetButtonStatus;
MKP := Mkey = Right;
RightMouseKeyPressed := MKP;
End;

(****************************************************************
******)

Function BothMouseKeysPressed : Boolean;
Begin
If MKP Then
  Delay(MouseDelay);
GetButtonStatus;
MKP := Mkey = Both;
BothMouseKeysPressed := MKP;
End;

(****************************************************************
*******)

Begin
ResetMouse;
DefineStandardShape;
DefineUpArrow;
DefineLeftArrow;
DefineCheckMark;
DefinePointingHand;
DefineDiagonalCross;
DefineRectangularCross;
DEfineHourGlass;
MKP := False;
End.
