Program makeCFG;

(*************************************************************************)
(*                                                                       *)
(*                                                                       *)
(*             W A R N I N G   - -   T H I S   P R O G R A M             *)
(*                                                                       *)
(*           is dreadfully unstructured and nearly unreadable.           *)
(*           It seems to work, however, and it does fill a need.         *)
(*                                                                       *)
(*************************************************************************)

Uses CRT, videoU, dewindu, kybrdu, strFuncs;

TYPE
  objects  = (border,winText,button,hiliter);

CONST
  noBorder    : BorderStrType = '        ';
  defTextF    = Yellow;
  defTextB    = Blue;
  defBordF    = White;
  defBordB    = Black;
  defButtonF  = LightCyan;
  defButtonB  = Blue;
  defHiliteF  = White;
  defHiliteB  = Red;
  defBordKind = SingleBorder;
  defHelpBorF = White;
  defHelpborB = Red;
  defHelpF    = White;
  defHelpB    = Black;
  defHelpBord = DoubleBorder;
  colNames : Array [0..15] Of String =
             ('Black','Blue','Green','Cyan','Red','Magenta',
              'Brown','LightGray','DarkGray','LightBlue',
              'LightGreen','LightCyan','LightRed','LightMagenta',
              'Yellow','White');
  infoWin  = 1;
  colorWin = 2;
  textWin  = 3;
  bordWin  = 4;
  descWin  = 5;
  cfgWin   = 6;
  fileWin  = 7;
  errWin   = 8;
  info2Win = 9;
  helpWin  = 10;
  defWin   = 11;
  uArrow   = #24;
  dArrow   = #25;
  rArrow   = #26;
  lArrow   = #27;
  objCols  : Array[objects] Of Integer = (3,23,43,63);
  objTags  : Array[objects] Of String  = (' BORDER ',' TEXT ',
                                          ' BUTTONS ',' HIGHLIGHTER ');
VAR
  bordType : Integer;
  item     : objects;
  keyCh    : Char;
  keyFk    : Boolean;
  key      : KeyType;
  x,y      : Integer;
  TextF,
  TextB,
  BordF,
  BordB,
  ButtonF,
  ButtonB,
  HiliteF,
  HiliteB  : Byte;
  bordKind : BorderStrType;
  cfgFile  : String;

FUNCTION exists (n : String) : Boolean;
  VAR f : Text;
      c : Integer;
  BEGIN
    Assign(f,n);
    {$I-}
    Reset(f);
    c := IoResult;
    {$I+}
    exists := (c = 0);
  END;

PROCEDURE setDefaults;
  BEGIN
    TextF    := defTextF;
    TextB    := defTextB;
    BordF    := defBordF;
    BordB    := defBordB;
    ButtonF  := defButtonF;
    ButtonB  := defButtonB;
    HiliteF  := defHiliteF;
    HiliteB  := defHiliteB;
    bordKind := defBordKind;
    bordType := 1;
  END;

PROCEDURE XYcolorStr (x,y,f,b : Byte; s : String);
  BEGIN
    TextColor(f);
    TextBackground(b);
    GotoXY(x,y);
    Write(s);
    TextColor(LightGray);
    TextBackground(Black);
  END;

PROCEDURE XYcolorCh (x,y,f,b : Byte; c: Char);
  BEGIN
    TextColor(f);
    TextBackground(b);
    GotoXY(x,y);
    Write(c);
    TextColor(LightGray);
    TextBackground(Black);
  END;

PROCEDURE makeColorWin;
  BEGIN
    DefineWindow(colorWin,1,16,52,24,0,'        ',0,
                 '',0,Center,'',0,Center,
                 DefaultFlag+WriteOnBorder,'',0);
    OpenWindow(colorWin);
    For y := 0 To 7 Do
      For x := 0 To 15 Do Begin
        XYcolorStr(1,y+2,0,7,n2Str(y,2,0));
        XYcolorStr(x*3+4,y+2,x,y,'Aa0');
      End;
    XYcolorStr(1,1,0,7,'     0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15');
  END;

PROCEDURE makeOtherWins;
  BEGIN
    DefineWindow(descWin,1,15,50,15,Attr(7,0),'        ',0,'',0,Center,
                 '',0,Center,WriteOnBorder,'',0);
    DefineWindow(cfgWin,6,12,48,23,Attr(7,0),SingleBorder,Attr(7,0),
                 ' CONFIGURATION FILE ',Attr(0,7),Center,
                 '',0,Center,DefaultFlag,'',0);
    DefineWindow(defWin,22,14,46,22,Attr(7,0),NoBorder,Attr(7,0),
                 '',0,Center,'',0,Center,WriteOnBorder,'',0);
    DefineWindow(errWin,5,11,76,15,Attr(7,0),DoubleBorder,Attr(7,0),
                 ' ** WARNING ** ',Attr(0,7),Center,
                 '',0,Center,DefaultFlag,'',0);
    OpenWindow(descWin);
  END;

PROCEDURE makeInfoWin;
  VAR o : objects;
  BEGIN
    DefineWindow(infoWin,1,1,80,13,Attr(7,0),SingleBorder,Attr(7,0),
                 ' MAKECFG v1.21 INFORMATION AND INSTRUCTIONS ',Attr(0,7),Center,
                 '',0,Center,DefaultFlag,'',0);
    OpenWindow(infoWin);
    GotoXY(1,2);
    Write('  MAKECFG will create a HyperText Compiler configuration file.  ');
    WriteLn('You select ');
    Write('  which color combination you want to modify (border, text, ');
    WriteLn('button, or ');
    Write('  highlighter) by pressing [spacebar].  Choose color ');
    WriteLn('combinations by using');
    Write('  the up and down arrow keys to select the foreground color ');
    WriteLn('and the left');
    Write('  and right arrow keys to select the background color.  ');
    WriteLn('All changes are ');
    Write('  shown in the sample window below right.  Press the [Enter] ');
    WriteLn('key when you ');
    Write('  are finished selecting colors.  The next step will be to ');
    WriteLn('preview the ');
    Write('  appearance of the help screens using these ');
    WriteLn('color combinations.');
    XYcolorStr(objCols[border],11,0,7,objTags[border]);
    For o := winText To hiliter Do
    XYcolorStr(objCols[o],11,7,0,objTags[o]);
    item := border;
  END;

PROCEDURE makeInfo2Win;
  BEGIN
    DefineWindow(info2Win,2,2,79,12,Attr(7,0),NoBorder,Attr(7,0),
                 '',0,Center,
                 '',0,Center,DefaultFlag,'',0);
    OpenWindow(info2Win);
    GotoXY(1,1);
    Write(' In order to make the PC-Hypertext help screens stand out');
    WriteLn(' from the ');
    Write(' underlying hypertext windows, different color combinations are ');
    WriteLn('used.  The');
    Write(' help windows will always have a border made up of the ');
    WriteLn('hypertext windows'' ');
    Write(' highlighter colors; the help text will be in the hypertext ');
    WriteLn('windows'' border');
    Write(' colors.  If the effect of the SAMPLE HELP screen is acceptable, ');
    WriteLn('press the ');
    Write(' [Enter] key to go on to the next step (selecting a border ');
    WriteLn('style).  Press ');
    Write(' the [spacebar] to go back to selecting colors for the text ');
    WriteLn('windows.');
  END;

PROCEDURE makeHelpWin;
  BEGIN
    DefineWindow(helpWin,40,11,64,21,Attr(bordF,bordB),DoubleBorder,
                 Attr(hiliteF,hiliteB),' SAMPLE HELP ',
                 Attr(hiliteF,hiliteB),Center,
                 '',0,Center,DefaultFlag+WriteOnBorder,'',0);
    OpenWindow(helpWin);
    GotoXY(2,2);WriteLn('  OPERATION        KEY');
    GotoXY(2,3);Write('');
    GotoXY(2,4);Write('             Ŀ Ŀ ');
    GotoXY(2,5);Write('lighter bar  ',Chr(27),' ',Chr(26),' ');
    GotoXY(2,6);Write('               ');
    GotoXY(2,7);Write('');
    GotoXY(2,8);Write('                  ');
    GotoXY(2,9);Write('ghted topic        ',Chr(17),'');
    GotoXY(2,10);Write('                  ');
  END;

PROCEDURE showXpos;
  BEGIN
    SelectWindow(colorWin);
    XYcolorStr(x*3+4,1,LightGray,Black,n2Str(x,3,0));
  END;

PROCEDURE showYpos;
  BEGIN
    SelectWindow(colorWin);
    XYcolorStr(1,y+2,LightGray,Black,n2Str(y,2,0));
  END;

PROCEDURE eraseXpos;
  BEGIN
    SelectWindow(colorWin);
    XYcolorStr(x*3+4,1,Black,LightGray,n2Str(x,3,0));
  END;

PROCEDURE eraseYpos;
  BEGIN
    SelectWindow(colorWin);
    XYcolorStr(1,y+2,Black,LightGray,n2Str(y,2,0));
  END;

PROCEDURE writeButton;
  BEGIN
    SelectWindow(textWin);
    XYcolorStr(16,6,buttonF,buttonB,'buttons');
    XYcolorStr(11,9,buttonF,buttonB,'buttons');
  END;

PROCEDURE writeHiliter;
  BEGIN
    SelectWindow(textWin);
    XYcolorStr(7,7,hiliteF,hiliteB,'highlighter');
  END;

PROCEDURE writeDescription;
  BEGIN
    SelectWindow(descWin);
    ClrScr;
    Write(NoBlanks(objTags[item]),': ');
    Write(colNames[x],' (',x,') on ',colNames[y],' (',y,')');
  END;

PROCEDURE writeWinText;
  BEGIN
    SelectWindow(textWin);
    XYcolorStr(1,2,textF,textB,'  This sample window     ');
    XYcolorStr(1,3,textF,textB,'  shows the effect of    ');
    XYcolorStr(1,4,textF,textB,'  various foreground and ');
    XYcolorStr(1,5,textF,textB,'  background colors for  ');
    XYcolorStr(1,6,textF,textB,'  window text, ');
    XYcolorStr(23,6,textF,textB,',  ');
    XYcolorStr(1,7,textF,textB,'  the ');
    XYcolorStr(18,7,textF,textB,' bar,   ');
    XYcolorStr(1,8,textF,textB,'  and the border.  There ');
    XYcolorStr(1,9,textF,textB,'  are two ');
    XYcolorStr(18,9,textF,textB,' in the ');
    XYcolorStr(1,10,textF,textB,'  window which make it   ');
    XYcolorStr(1,11,textF,textB,'  look more realistic.   ');
  END;

PROCEDURE showEffect;
  BEGIN
    CASE item Of
       border  : Begin
                    CloseWindow(bordWin);
                    DeleteWindow(bordWin);
                    bordF := x;
                    bordB := y;
                    DefineWindow(bordWin,54,14,79,25,0,
                                 BordKind,Attr(bordF,bordB),
                                 ' SAMPLE ',Attr(bordF,bordB),
                                 Center,'',0,Center,
                                 DisplayBorder,'',0);
                    OpenWindow(bordWin);
                 End;
       winText : Begin
                   CloseWindow(bordWin);
                   textF := x;
                   textB := y;
                   writeWinText;
                   OpenWindow(bordWin);
                 End;
       button  : Begin
                   buttonF := x;
                   buttonB := y;
                   writeButton;
                 End;
       hiliter : Begin
                   hiliteF := x;
                   hiliteB := y;
                   writeHiliter;
                 End;
    END { CASE } ;
  END;

PROCEDURE getBorderOpt;
  BEGIN
    x := bordF;
    y := bordB;
    SelectWindow(infoWin);
    ClrScr;
    GotoXY(1,2);
    Write('  The border may by made up of one or two ');
    WriteLn('lines or it may by left blank ');
    Write('  (although the title will still be ');
    WriteLn('displayed).   Type a "0", a "1", or a');
    Write('  "2" to see how the different types look.  ');
    WriteLn('Press the [Enter] key when you ');
    WriteLn('  are finished.');
    WriteLn;
    Write('  Press [0], [1], or [2], [Enter] when ');
    Write('finished => ');
    gotoXY(52,7);
    Write(bordType);
    CursorBig;
    REPEAT
      gotoXY(52,7);
      InKey(keyCh,keyFk,key);
      CASE keyCh Of
        '0' : Begin bordType := 0; bordKind := noBorder;     End;
        '1' : Begin bordType := 1; bordKind := SingleBorder; End;
        '2' : Begin bordType := 2; bordKind := doubleBorder; End;
      END;
      GotoXY(52,7);
      Write(keyCh);
      item := border;
      showEffect;
      SelectWindow(infoWin);
    UNTIL key = CarriageReturn;
    ClrScr;
  END;

PROCEDURE showCFGfile;
  BEGIN
    OpenWindow(cfgWin);
    WriteLn;
    WriteLn('  ',colNames[textB]);
    WriteLn('  ',colNames[textF]);
    WriteLn('  ',colNames[bordB]);
    WriteLn('  ',colNames[bordF]);
    WriteLn('  ',colNames[buttonB]);
    WriteLn('  ',colNames[buttonF]);
    WriteLn('  ',colNames[hiliteB]);
    WriteLn('  ',colNames[hiliteF]);
    If bordKind = noBorder Then bordType := 0
    Else
      If bordKind = SingleBorder Then bordType := 1
      Else bordType := 2;
    Write('  ',bordType);
    OpenWindow(defWin);
    WriteLn(Chr(17),' Text Background');
    WriteLn(Chr(17),' Text Foreground');
    WriteLn(Chr(17),' Border Background');
    WriteLn(Chr(17),' Border Foreground');
    WriteLn(Chr(17),' Button Background');
    WriteLn(Chr(17),' Button Foreground');
    WriteLn(Chr(17),' Highlighter Background');
    WriteLn(Chr(17),' Highlighter Foreground');
    Write(Chr(17),' Border Style');
  END;

PROCEDURE writeCFGfile;
  VAR  t   : Text;
  BEGIN
    Assign(t,cfgFile);
    Rewrite(t);
    WriteLn(t,colNames[textB]);
    WriteLn(t,colNames[textF]);
    WriteLn(t,colNames[bordB]);
    WriteLn(t,colNames[bordF]);
    WriteLn(t,colNames[buttonB]);
    WriteLn(t,colNames[buttonF]);
    WriteLn(t,colNames[hiliteB]);
    WriteLn(t,colNames[hiliteF]);
    WriteLn(t,n2Str(bordType,1,0));
    Close(t);
  END;

PROCEDURE makeFile;
  VAR Ok  : Boolean;
      msg : String;
      Ch  : Char;
      Fk  : Boolean;
      key : KeyType;
  BEGIN
    SelectWindow(infoWin);
    GotoXY(1,2);
    Write('  The content of the configuration file is ');
    WriteLn('shown below.  The information ');
    Write('  shown corresponds to the colors in the sample ');
    WriteLn('window.  In order to save');
    Write('  this information to a file, you must provide ');
    WriteLn('a name for the file.  The');
    Write('  name may be up to');
    WriteLn(' eight characters in length (no blanks, commas, or');
    Write('  periods allowed).  The extension ".CFG" will be ');
    WriteLn('added automatically.  To ');
    Write('  cancel this session without creating a file, just ');
    WriteLn('press the [Enter] key.');
    WriteLn;
    Ok := True;
    REPEAT
      CursorBig;
      GotoXY(1,9);
      Write('  Enter the file name =>                         ');
      cfgFile := '';
      GotoXY(26,9);
      ReadLn(cfgFile);
      cfgFile := UpCaseStr(cfgFile);
      If WindowOpen(errWin) Then CloseWindow(errWin);
      Ok := (Pos(',',cfgFile) = 0);
      IF Ok Then Begin
         Ok := (Pos('.',cfgFile) = 0);
         IF Ok Then Begin
            Ok := (Pos(' ',cfgFile) = 0);
            IF Ok Then Begin
               Ok := Length(cfgFile) < 9;
               If Not Ok Then
                  msg := 'File name cannot exceed eight characters.';
            END
            Else msg := 'No blanks allowed in file names.';
         END
         Else msg := 'No periods allowed in file names.';
      END
      Else msg := 'No commas allowed in file names.';
      IF Not Ok Then Begin
        OpenWindow(errWin);
        GotoXY(3,2);
        Write(#7,cfgFile,' -- ',msg);
      END
      ELSE Begin
        IF Length(cfgFile) = 0 Then Begin
          OpenWindow(errWin);
          CursorOff;
          GotoXY(1,1);
          Write('  If you cancel this session without writing a file, ');
          WriteLn('the window');
          Write('  configuration that you have created will be lost.  ');
          WriteLn('Press the [Esc]');
          Write('  key to end this session.  Any other key ');
          Write('will resume processing.  ');
          InKey(ch,fk,key);
          Ok := (key = EscapeKey);
          CloseWindow(errWin);
        END
        ELSE Begin
          cfgFile := cfgFile + '.CFG';
          IF exists(cfgFile) Then Begin
            OpenWindow(errWin);
            Write('  File (',cfgFile,') already exists.  ');
            Write('Overwrite? [Y]es or [N]o');
            REPEAT
              GotoXY(1,2);
              Write('  Type "Y" or "N" => ');
              InKey(ch,fk,key);
              ch := UpCase(ch);
            UNTIL (ch In ['N','Y']);
            CloseWindow(errWin);
            Ok := (ch = 'Y');
            If Ok Then writeCFGfile;
          END
          Else writeCFGfile;
        END;
      END;
      SelectWindow(infoWin);
    UNTIL Ok

  END;

BEGIN
  CursorOff;
  TextColor(LightGray);
  TextBackground(Black);
  ClrScr;
  setDefaults;
  makeInfoWin;
  makeColorWin;
  makeOtherWins;
  item := border;
  DefineWindow(textWin,54,14,79,25,Attr(textF,textB),'        ',0,
               '',0,Center,'',0,Center,0,'',0);
  OpenWindow(textWin);
  writeWinText;
  writeButton;
  writeHiliter;
  DefineWindow(bordWin,54,14,79,25,0,defBordKind,Attr(bordF,bordB),
               ' SAMPLE ',Attr(bordF,bordB),Center,'',0,Center,
               DisplayBorder,'',0);
  OpenWindow(bordWin);
  x := bordF;
  y := bordB;
  showXpos;
  showYpos;
  writeDescription;
  REPEAT
    InKey(keyCh,keyFk,key);
    CASE key Of
       UpArrow    : Begin
                      eraseYpos;
                      If y = 0 Then y := 7 Else y := y - 1;
                      showYpos;
                      writeDescription;
                    End;
       DownArrow  : Begin
                      eraseYpos;
                      If y = 7 Then y := 0 Else y := y + 1;
                      showYpos;
                      writeDescription;
                    End;
       LeftArrow  : Begin
                      eraseXpos;
                      If x = 0 Then x := 15 Else x := x - 1;
                      showXpos;
                      writeDescription;
                    End;
       RightArrow : Begin
                      eraseXpos;
                      If x = 15 Then x := 0 Else x := x + 1;
                      showXpos;
                      writeDescription;
                    End;
       SpaceKey   : Begin
                      SelectWindow(infoWin);
                      XYcolorStr(objCols[item],11,7,0,objTags[item]);
                      If item = hiliter Then item := border
                      Else inc(item);
                      eraseXpos;
                      eraseYpos;
                      CASE item of
                         border  : Begin x := bordF;   y := bordB;   End;
                         winText : Begin x := textF;   y := textB;   End;
                         button  : Begin x := buttonF; y := buttonB; End;
                         hiliter : Begin x := hiliteF; y := hiliteB; End;
                      END;
                      writeDescription;
                      SelectWindow(infoWin);
                      XYcolorStr(objCols[item],11,0,7,objTags[item]);
                      showXpos;
                      showYpos;
                    End;
       CarriageReturn : Begin
                      SelectWindow(descWin);
                      ClrScr;
                      eraseXpos;
                      eraseYpos;
                      If WindowDefined(info2Win) Then DisplayWindow(info2Win)
                      Else makeInfo2Win;
                      HideWindow(colorWin);
                      HideWindow(descWin);
                      makeHelpWin;
                      REPEAT
                      InKey(keyCh,keyFk,key);
                      UNTIL (key = CarriageReturn) Or
                        (key = SpaceKey);
                      IF key = SpaceKey Then Begin
                        CloseWindow(helpWin);
                        DeleteWindow(helpWin);
                        HideWindow(info2Win);
                        DisplayWindow(descWin);
                        DisplayWindow(colorWin);
                        showXpos;
                        showYpos;
                        writeDescription;
                        SelectWindow(infoWin);
                      END
                      ELSE Begin
                        CloseWindow(helpWin);
                        getBorderOpt;
                        showCFGfile;
                        makeFile;
                      END;
                    End;
    END { CASE } ;
    showEffect;
  UNTIL key = CarriageReturn;
  SelectWindow(0);
  ClrScr;
  CursorSmall;
END.
