Unit KyBrdU;


{ Transcribed and modified by: Steve T. Jones                            }
{                              Indiana University at Kokomo              }
{                              2300 South Washington Street              }
{                              Kokomo, IN 46902                          }
{                              (317) 453-2000                            }
{                              KCDZ100@INDYCMS                           }
{                              June 5, 1989                              }
{                                                                        }
{ Based on O'Brien, S. K. "Turbo Pascal Advanced Programmer's Guide",    }
{            Berkeley, CA: Osborne/McGraw-Hill (1988).                   }
{                                                                        }

(***********************************************************)
Interface
(***********************************************************)

Uses Crt, VideoU, MousU;
Type

  KeyType = (NullKey, F1, F2, F3, F4, F5, F6, F7, F8, F9, F10,
         CarriageReturn, TabKey, BackSpaceKey, UpArrow,
         DownArrow, RightArrow, LeftArrow, DelKey, InsertKey,
         HomeKey, EndKey, TextKey, NumberKey, SpaceKey,
         PgUp, PgDn, EscapeKey);

  KeySetType = Set of KeyType;

Var
  Key : KeyType;
  InsertOn : Boolean;

Procedure InKey(Var ch : Char;
                Var fk : Boolean;
                Var Key : KeyType);

Procedure InKeyOrMouse(Var ch : Char;
                       Var fk : Boolean;
                       Var Key : KeyType);

Procedure InputString(Var S : String;
                      x,y,l : Byte;
                      fg,bg : Byte;
                      KeySet : KeySetType);

(***************************************************************)

Procedure InputNumeric(Var s  : String;
                       x,y    : Byte;
                       Mask   : String;
                       fg,bg  : Byte;
                       KeySet : KeySetType);

Procedure InputSpecial(Var s  : String;
                       x,y    : Byte;
                       Mask   : String;
                       fg,bg  : Byte;
                       KeySet : KeySetType);

Type
  ChoicesType = Array [1..10] of String[30];

Procedure InputDefined(Var S : String;
                       x,y : Byte;
                       Choices : ChoicesType;
                       Var Choice : Word;
                       MaxChoice : Word;
                       InputFG,InputBG : Byte;
                       KeySet : KeySetType);

Function FormatMaskNumeric(s,Mask : String) : String;

Function FormatMaskSpecial(s,Mask : String) : String;

Function FormatDefinedField(Choices : ChoicesType;
                            Var Choice : Word;
                            MaxChoice : Word) : String;

(*************************************************************)
Implementation
(*************************************************************)

{
Variables for use with masked input routines.
}
Var
  MaskMax : Word;
  MaskMap : Array [1..30] of Byte;
  p, code, i : Integer;
  ch : Char;
  fk : Boolean;

Procedure InKey(Var ch  : Char;
                Var fk  : Boolean;
                Var Key : KeyType);
{
Gets a key from the user and returns the character.  If the key
was a function key, fk is set to true.  This procedure also sets
Key equal to the type of key pressed.
}
Begin
ch := ReadKey;
fk := False;
If ch = #0 Then
  Begin
  fk := True;
  ch := ReadKey;
  End;

If fk Then
  Case ch Of
  #72 : key := UpArrow;          (* up arrow *)
  #80 : key := DownArrow;        (* down arrow *)
  #82 : key := InsertKey;        (* Insert key *)
  #75 : key := LeftArrow;        (* left arrow *)
  #77 : key := RightArrow;       (* right arrow *)
  #73 : key := PgUp;             (* pge up *)
  #81 : key := PgDn;             (* pge down *)
  #71 : key := HomeKey;          (* home *)
  #79 : key := EndKey;           (* End *)
  #83 : key := DelKey;           (* delete *)
  #82 : key := InsertKey;        (* Insert *)
  #59 : key := F1;               (* F1 *)
  #60 : key := F2;               (* F2 *)
  #61 : key := F3;               (* F3 *)
  #62 : key := F4;               (* F4 *)
  #63 : key := F5;               (* F5 *)
  #64 : key := F6;               (* F6 *)
  #65 : key := F7;               (* F7 *)
  #66 : key := F8;               (* F8 *)
  #67 : key := F9;               (* F9 *)
  #68 : key := F10;              (* F10 *)
  End (* of case *)
Else
  Case ch Of
   #8 : key := BackSpaceKey;       (* Back Space Key *)
   #9 : key := TabKey;             (* Tab key 8 *)
  #13 : key := CarriageReturn;     (* Carriage Return *)
  #27 : key := EscapeKey;          (* escape *)
  #32 : key := SpaceKey;           (* Space bar *)

  #33..#47,
  #58..#255 :
        key := TextKey;            (* text character *)

  #48..#57 : key := NumberKey;     (* number character *)
  End;
End;

(***************************************************************)

Procedure InKeyOrMouse(Var ch  : Char;
                       Var fk  : Boolean;
                       Var Key : KeyType);
{
Gets a key from the user and returns the character.  If the key
was a function key, fk is set to true.  This procedure also sets
Key equal to the type of key pressed.
}
VAR  x, y : Integer;
     done : Boolean;
Begin
done := False;
GetButtonStatus;
x := MouseX;
y := MouseY;
Repeat
   IF KeyPressed Then Begin
      done := True;
      ch := ReadKey;
      fk := False;
      IF ch = #0 Then Begin
          fk := True;
          ch := ReadKey;
      END;
      If fk Then
         CASE ch Of
            #72 : key := UpArrow;          (* up arrow *)
            #80 : key := DownArrow;        (* down arrow *)
            #82 : key := InsertKey;        (* Insert key *)
            #75 : key := LeftArrow;        (* left arrow *)
            #77 : key := RightArrow;       (* right arrow *)
            #73 : key := PgUp;             (* pge up *)
            #81 : key := PgDn;             (* pge down *)
            #71 : key := HomeKey;          (* home *)
            #79 : key := EndKey;           (* End *)
            #83 : key := DelKey;           (* delete *)
            #82 : key := InsertKey;        (* Insert *)
            #59 : key := F1;               (* F1 *)
            #60 : key := F2;               (* F2 *)
            #61 : key := F3;               (* F3 *)
            #62 : key := F4;               (* F4 *)
            #63 : key := F5;               (* F5 *)
            #64 : key := F6;               (* F6 *)
            #65 : key := F7;               (* F7 *)
            #66 : key := F8;               (* F8 *)
            #67 : key := F9;               (* F9 *)
            #68 : key := F10;              (* F10 *)
         END (* of case *)
      Else
         CASE ch Of
            #8  : key := BackSpaceKey;       (* Back Space Key *)
            #9  : key := TabKey;             (* Tab key 8 *)
            #13 : key := CarriageReturn;     (* Carriage Return *)
            #27 : key := EscapeKey;          (* escape *)
            #32 : key := SpaceKey;           (* Space bar *)
            #33..#47,
            #58..#255 :
                  key := TextKey;            (* text character *)
            #48..#57 :
                  key := NumberKey;     (* number character *)
         END;
   END
      ELSE Begin
        done := True;
        IF MousePresent Then Begin
           IF LeftMouseKeyPressed Then Begin
              key := CarriageReturn;
              fk := False;
              ch := #13;
           END
           ELSE Begin
              IF RightMouseKeyPressed Then Begin
                 key := BackSpaceKey;
                 fk := False;
                 ch := #8;
              END
              ELSE Begin
                 IF BothMouseKeysPressed Then Begin
                    key := EscapeKey;
                    fk := False;
                    ch := #27;
                 END
                 ELSE Begin
                    GetButtonStatus;
                    IF (MouseX < x) (* Or (MouseY < y)*) Then Begin
                          key := LeftArrow;
                          fk := True;
                       ch := #75;
                    END
                    ELSE Begin
                          IF (MouseX > x) (* Or (MouseY > y)*) Then Begin
                             key := RightArrow;
                          fk := True;
                          ch := #77;
                       END
                       Else done := False;
                    END;
                 END;
              END;
           END;
        END
        Else done := False;
      END;
   Until done;
End;

(***************************************************************)

Procedure InputString(Var S  : String;
                      x,y,l  : Byte;
                      fg,bg  : Byte;
                      KeySet : KeySetType);
{
This procedure allows the user to input string S at coordinates
x:y with a maximum length of 1.  The string is displayed in foreground
color fg and background color bg.  KeySet defines the set of keys that
can be used to terminate the procedure.
}
Const
  Fill : Char = #176;

Var
  p   : Byte;
  i,j : Word;
  ch : Char; 
  fk : Boolean;

Begin
i := Length(s) + 1;
If i > 1 Then
  s := Copy(s,1,1)
Else
  Begin
  For j := i To 1 Do
    s[j] := Fill;
  s[0] := Chr(1);
  End;

p := 1;
  Repeat
  XYstring(x,y,s,fg,bg);
  GoToXY(x+p-1,y);

  If InsertOn Then
    CursorSmall
  Else
    CursorBig;

InKey(ch,fk,key);

CursorOff;

  Case Key of

  TextKey,
  NumberKey,
  SpaceKey :
    Begin
    If InsertOn Then
      Begin
      Insert(ch,s,p);
      s[0] := Chr(1);
      If p < 1 Then
        p := p + 1;
      End
    Else
      Begin
      s[p] := ch;
      If p < 1 Then
        p := p + 1;
      End;
    End;

InsertKey:
  Begin
  InsertOn := Not InsertOn;
  End;

DelKey:
  Begin
  Delete(s,p,1);
  s := s + #176;
  End;

LeftArrow:
  Begin
  If p > 1 Then
    p := p - 1;
  End;

RightArrow:
  Begin
  If (Pos(#176,s) > 0) Then
    Begin
    If (p < Pos(#176,s)) Then
      p := p + 1
  End
Else If (p < 1) Then
  p := p + 1;
End;

BackSpaceKey:
  Begin
  If p > 1 Then
    Begin
    p := p - 1;
    Delete(s,p,1);
    s := S + #176;
    End;
  End;
    End; { of case }
  Until Key in KeySet;

i := Pos(#176,s);
If i > 0 Then
  s := Copy(s,1,i-1);
End;

(*****************************************************************)

Procedure ConvertMask(Var Mask : String);
{
This procedure changes dashes in the mask
to space characters (#176).
}
Var
  i : Integer;
Begin
For i := 1 To length(Mask) Do
  Begin
  if Mask[i] =  '_' Then
    Mask[i] := #176;
  End;
End;

(****************************************************************
**)

Procedure AddCharNumeric(ch : Char;
                       Var Mask : String);
{
This procedures adds a character to the masked
input that starts from the right.
}
Var
  i : Word;
Begin
If p = MaskMax Then
  Exit;
p := p + 1;
For i := p DownTo 2 Do
  Mask[MaskMap[i]] := Mask[MaskMap[i-1]];
Mask[MaskMap[1]] := ch;
End;

(****************************************************************
***)

Procedure DelCharNumeric(Var Mask : String);
{
This procedures deletes a character to the masked input
that starts from the right.
}
Var
  i : Word;
Begin
If p = 0 Then
  Exit;
For i := 1 To p-1 Do
  Mask[MaskMap[i]] := Mask[MaskMap[i+1]];
Mask[MaskMap[p]] := #176;
p := p - 1;
End;

(****************************************************************
***)

Procedure MapMaskNumeric(Mask : String);
{
This procedure maps the input positions
within the mask for entering data starting
from the right.
}
Var
  i : Word;
Begin
FillChar(MaskMap,SizeOf(MaskMap),0);
MaskMax := 0;
For i := Length(Mask) DownTo 1 Do
  Begin
  If Mask[i] = #176 Then
    Begin
    MaskMax := MaskMax + 1;
    MaskMap[MaskMax] := i;
    End;
  End;
End;

(****************************************************************
*)

Function FormatMaskNumeric(s,Mask : String) : String;
{
This places the input data, if any exists,
into the mask, ready to be displayed.
}
Begin
ConvertMask(Mask);
MapMaskNumeric(Mask);

p := 0;
For i := 1 To Length(S) Do
If s[i] In ['0'..'9'] Then
  AddCharNumeric(s[i],Mask);

FormatMaskNumeric := Mask;
End;

(****************************************************************
*)

Procedure InputNumeric(Var s  : String;
                      x,y    : Byte;
                      Mask   : String;
                      fg,bg  : Byte;
                      KeySet : KeySetType);

{
This procedure accepts numeric input starting from
the right side of the masked field.
}
Begin
Mask := FormatMaskNumeric(s,Mask);
CursorSmall;
  Repeat
  GoToXY(x+MaskMap[1]-1,y);

  XYstring(x,y,Mask,fg,bg);
  InKey(ch,fk,Key);

   Case key Of

   NumberKey :
     Begin
     If ch In ['0'..'9'] Then
       AddCharNumeric(ch,Mask)
     Else If (ch = '-') and (p = 0) Then
       AddCharNumeric(ch,Mask);
     End;

   DelKey,
   BackSpaceKey :
     DelCharNumeric(Mask);

   End;

 Until Key In KeySet;

s := Mask;
End;

(***********************************************************)

Procedure AddCharSpecial(ch : Char;
                      Var Mask : String);
{
This procedures adds a character to the masked
input that starts from the left.
}
Var
  i : Word;
Begin
If p = MaskMax Then
  Exit;
p := p + 1;
Mask[MaskMap[p]] := ch;
End;

(************************************************************)

Procedure DelCharSpecial(Var Mask : String);
{
This procedures deletes a character to the masked input
that starts from the left.
}
Var
  i : Word;
Begin
If p = 0 Then
  Exit;
Mask[MaskMap[p]] := #176;
p := p - 1;
End;

(**************************************************************)

Procedure MapMaskSpecial(Mask : String);
{
This procedure maps the input positions
within the mask for entering data starting
from the left.
}
Var
  i : Word;
Begin
FillChar(MaskMap,SizeOf(MaskMap),0);
MaskMax := 0;
For i := 1 To Length(Mask) Do
  Begin
  If Mask[i] = #176 Then
    Begin
    MaskMax := MaskMax + 1;
    MaskMap[MaskMax] := i;
    End;
  End; 
End;

(************************************************************)

Function FormatMaskSpecial(s,Mask : String) : String;
{
This places the input dta, if any exists,
into the mask, ready to be displayed.
}
Begin
ConvertMask(Mask);
MapMaskSpecial(Mask);

p := 0;
For i := 1 To Length(S) Do
If s[i] In ['0'..'9'] Then
  AddCharSpecial(s[i],Mask);

FormatMaskSpecial := Mask;
End;

(************************************************************)

Procedure InputSpecial(Var s  : String;
                       x,y    : Byte;
                       Mask   : String;
                       fg,bg  : Byte;
                       KeySet : KeySetType);
{
This procedure accepts numeric input starting from 
the left side of the masked field.
}
Begin
Mask := FormatMaskSpecial(s,Mask);
CursorSmall;

  Repeat
  If p < MaskMax Then
    GoToXY(x + MaskMap[p+1] - 1,y)
  Else
    GoToXY(x + MaskMap[p] - 1,y);

  XYstring(x,y,Mask,fg,bg);
  InKey(ch,fk,Key);

    Case key Of

    TextKey,
    NumberKey :
       AddCharSpecial(ch,Mask);

    DelKey,
    BackSpaceKey:
      DelCharSpecial(Mask);

    End;

  Until Key In KeySet;
s := Mask;
End;

(************************************************************)

Function FormatDefinedField(Choices : ChoicesType;
                            Var Choice : Word;
                            MaxChoice : Word) : String;
Var
  i,l : Word;
  s : String;
Begin
l := 0;
For i := 1 to MaxChoice Do
If Length(Choices[i]) > 1 Then
  l := Length(Choices[i]);

s := Choices[Choice];
While Length(s) < 1 Do
  s := s + ' ';
FormatDefinedField := s;
End;

(*************************************************************)

Procedure InputDefined(Var S : String;
                       x,y : Byte;
                       Choices : ChoicesType;
                       Var Choice : Word;
                       MaxChoice : Word;
                       InputFG,InputBG : Byte;
                       KeySet : KeySetType);
Var
  L : Word;
Begin
CursorOff;
  Repeat
  s := FormatDefinedField(Choices,Choice,MaxChoice);
  XYstring(x, y, s, Black, LightGray);
  InKey(ch, fk, key);
  If Key = TabKey Then
    Begin
    Choice := Choice + 1;
    If Choice > MaxChoice Then
      Choice := 1;
    End;
  Until Key in KeySet;

XYstring(x, y, s, InputFG, InputBG);
s := Choices[Choice];
CursorSmall;
End;

(***********************************************************)
BEGIN
   insertOn := True;
   Key := nullKey;
END.