Unit HTCU3;

Interface

Uses Printer, strFuncs, HTCDEU0, HTCU1, HTCU2;

PROCEDURE compileText (    s : symbolTable ; VAR src : Text    ;
                       VAR d : dbFile      ; VAR   x : idxFile);

PROCEDURE initDB (VAR d : dbFile; c : colors; b : borders; v : Real);

(***************************************************************************)
(**)                                                                     (**)
(**)                            Implementation                           (**)
(**)                                                                     (**)
(***************************************************************************)

TYPE
  buttonList = Array[1..200] Of buttonRec;

PROCEDURE writeHdrRecs(      i : Integer;        s : symbolTable;
                       VAR  df : dbFile;    VAR xf : idxFile   );
  VAR d : dbRec;
      x : idxRec;
  BEGIN
     d.tag         := s.ptrs[i]^.symTag;
     d.frameColors := s.ptrs[i]^.winColors;
     d.frameBord   := s.ptrs[i]^.border;
     d.frameWidth  := s.ptrs[i]^.width;
     d.frameLines  := s.ptrs[i]^.lines;
     d.buttonCount := s.ptrs[i]^.buttons;
     d.recdCount   := s.ptrs[i]^.size;
     Write(df,d);
     x.tag     := s.ptrs[i]^.symTag;
     x.fileLoc := s.ptrs[i]^.frameLoc;
     Write(xf,x);
  END; (* writeWinRec *)

PROCEDURE writeButtons (list : buttonList; t: Integer; VAR db : dbFile);
  VAR d : dbRec;
      i : Integer;

  BEGIN
     FOR i := 1 To t Do Begin

        If Odd(i) Then d.button1 := list[i]
        Else d.button2 := list[i];
        If Not Odd(i) Then Write(db,d);
     END;
     IF Odd(t) Then Begin
        d.button2.tag := '';
        d.button2.xCoord := 0;
        d.button2.yCoord := 0;
        d.button2.fileLoc := -1;
        Write(db,d);
     END;
  END;

FUNCTION getFrameTag (buf : String) : buttonTag;
  VAR s : String;
  BEGIN
     s := buf;
     s := NoBlanks(Before(After(buf,defChar),defChar));
     getFrameTag := s;
  END;

FUNCTION findSymbol (s : symbolTable; t : buttonTag) : Integer;
  VAR i  : Integer;
      tt : buttonTag;
  BEGIN
     tt := UpCaseStr(t);
     i := 1;
     While (i < s.next) And (UpCaseStr(s.ptrs[i]^.symTag) <> tt) Do
        i := i + 1;
     findSymbol := i
  END;

PROCEDURE fixButtons( VAR buf : String;   s : symbolTable; l : Integer;
                      VAR  bl : buttonList;  VAR t : Integer);
  VAR i : Integer;
      b : buttonRec;
  BEGIN
     WHILE Pos(delimChar,buf) > 0 Do Begin
        t := t + 1;
        bl[t].tag := Before(After(buf,delimChar),delimChar);
        bl[t].xCoord := Pos(delimChar,buf);
        bl[t].yCoord := l;
        bl[t].fileLoc := s.ptrs[findSymbol(s,bl[t].tag)]^.frameLoc;
        Delete(buf,Pos(delimChar,buf),1);
        Delete(buf,Pos(delimChar,buf),1);
     END;
  END;

PROCEDURE writeText (buf : String; VAR df : dbFile);
  VAR d : dbRec;
  BEGIN
      d.winText := buf;
      Write(df,d);
  END;

PROCEDURE compileText;
  VAR  bl     : buttonList;
       top, i,
       lines  : Integer;
       buffer : String;
       lType  : srcLines;
  BEGIN
     g_printSource := False;
     g_Lines := 0;
     top := 0;
     lines := 0;
     getLine(src,g_printSource,buffer,lType,g_Lines);
     If Ltype = textLine Then writeHdrRecs(1,s,d,x);
     WHILE Not (lType = EndOfFile) Do Begin
        IF lType = buttonId Then Begin
           If top > 0 Then writeButtons (bl,top,d);
           top := 0;
           lines := 0;
           writeHdrRecs(findSymbol(s,getFrameTag(buffer)),s,d,x);
        END
        ELSE Begin
           lines := lines + 1;
           If Pos(textChar,buffer) <> 1 Then
              fixButtons (buffer, s, lines, bl, top)
           Else
              buffer := After(buffer,textChar);
           If lines <= MaxLines Then writeText(buffer,d);
        END;
        getLine(src,g_printSource,buffer,lType,g_Lines);
     END;
     If top > 0 Then writeButtons (bl,top,d);
  END; (* compileText *)

PROCEDURE initDB;
  VAR r : dbRec;
  BEGIN
     r.HTCVers   := v;
     r.defColors := c;
     r.defBord   := b;
     Write(d,r);
  END;


BEGIN
END.


