Unit HTCU2;

Interface

Uses Crt, Printer, strFuncs, HTCDEU0, HTCU1;

TYPE

   sPtr  = ^symbolTable;

PROCEDURE buildSymTab (VAR src : Text; prt : Boolean; dc  : Colors;
                       db      : Borders;        VAR  s   : SymbolTable);

PROCEDURE errDisplay (m : String; showLine : Boolean);

(***************************************************************************)
(**)                                                                     (**)
(**)                            Implementation                           (**)
(**)                                                                     (**)
(***************************************************************************)

PROCEDURE errDisplay;
  BEGIN
    IF (g_errDisplay = onScreen) Or (g_errDisplay = both) Then Begin
       If showLine Then WriteLn(g_Lines:5,' ',Copy(g_buffer,1,73));
       WriteLn('***   ',m);
    END;
    IF (g_errDisplay = toPrint) Or (g_errDisplay = both) Then Begin
       If Not g_printSource Then
          If showLine Then WriteLn(Lst,g_Lines:5,' ',Copy(g_buffer,1,73));
       WriteLn(Lst,'***   ',m);
    END;
  END;

PROCEDURE err01BadParm;
  BEGIN
     errDisplay('Non-numeric or out-of-range parameters specified above '+
                '-- using defaults.',True);
  END;  (* err01BadParm *)

PROCEDURE fErr02MultDef (t : buttonTag);
  BEGIN
     g_Abort := True;
     errDisplay('FATAL: Frame tag (' + t + ') defined more than once.',True);
  END;  (* fErr02MultDef *)

PROCEDURE err03UnBal;
  BEGIN
     errDisplay('Above line contains unbalanced "' + delimChar +
                '" -- all buttons ignored.',True);
  END;  (* err03UnBal *)

PROCEDURE err04Lines (c : Integer);
  VAR s : String;
  BEGIN
     If c Mod 10 = 1 Then s := 'st'
     Else If c Mod 10 = 2 Then s := 'nd'
     Else If c Mod 10 = 3 Then s := 'rd'
     Else s := 'th';
     errDisplay('Maximum of ' + n2Str(maxLines,0,0) +
                ' lines allowed per frame -- ' +
                n2Str(c,0,0) + s +' line ignored.',True);
  END;  (* err04Lines *)

PROCEDURE err05NoRef (t : buttonTag; i : Integer);
  BEGIN
     errDisplay('Frame (' + t + ', line ' + n2Str(i,0,0) +
                ') never referenced.',False);
  END; (* err05NoRef *)

PROCEDURE err06NoFrame;
  BEGIN
     errDisplay('Found defintion character (' + defChar +
                ') but no frame tag -- line ignored.',True);
  END;  (* err06NoFrame *)

PROCEDURE err08NoLines (t : buttonTag);
  BEGIN
     errDisplay('Warning -- previous frame contained no lines of text.',
                False);
  END;  (* err08NoLines *)

PROCEDURE err09BigTag (VAR t : string);
  BEGIN
     t := Copy (t, 1, maxButton);
     errDisplay('Frame tag exceeds maximum allowed size (' +
                n2Str(maxButton,0,0) + ') -- truncating.',True)
  END;  (* err09BigTag *)

PROCEDURE fErr10TooBig (VAR s : String) ;
  BEGIN
     s := '';
     g_Abort := True;
     errDisplay('FATAL: Too many characters (' + n2Str(maxButton,0,0) +
                 ' maximum allowed ) between "' + delimChar + '".',True);
  END;  (* fErr10TooBig *)

PROCEDURE err12Chars (VAR c : Integer);
  BEGIN
     errDisplay('Too many characters in line (' + n2Str(maxChars,0,0) +
                 ' maximum allowed) -- truncating.',True);
  END;  (* err12Chars *)

PROCEDURE fErr11TooMuch;
  BEGIN
    errDisplay('Too many frame tags or buttons -- Program Terminating',True);
    Halt;
  END;  (* fErr11TooMuch *)

PROCEDURE fErr13NoDef (t : buttonTag; i : Integer);
  BEGIN
     g_Abort := True;
     errDisplay('FATAL: frame (' + t + ') referenced in line ' +
                n2Str(i,0,0) + ' never defined.',False);
  END;

FUNCTION BiggerInteger (i,j : Integer) : Integer;
  BEGIN
     If i > j Then BiggerInteger := i
     Else BiggerInteger := j;
  END;

PROCEDURE getFrameInfo (  buf : string; VAR t : buttonTag;
                        VAR c : Colors; VAR b : Borders);
  VAR   a   : Array[0..8] Of Integer;
        i,e : Integer;
        s   : String;
        ok  : Boolean;
  BEGIN
     For i := 0 To 8 Do a[i] := -1;
     s := NoBlanks(Before(After(buf,defChar),defChar));
     If length(s) > maxButton Then err09BigTag(s);
     t := s;
     s := After(Copy(buf,2,255),defChar);
     IF Length(s) > 0 Then Begin
        i := 0;
        ok := True;
        WHILE (s <> '') And (i < 8) And ok Do Begin
           Val(Parse(s,','),a[i],e);
           If ok Then ok := (e = 0) And (a[i] >= 0) And (a[i] <= 15);
           i := i + 1;
        END;
        IF ok And (s <> '') Then Begin
           Val(s,a[8],e);
           Ok := (e = 0) And (a[8] >=0) And (a[8] <= 2);
        END;
        IF Ok Then Begin
           For i := 0 To 7 Do
              If a[i] >= 0 Then c[colorSpecs(i)] := a[i];
           If a[8] >= 0 Then b := Borders(a[8]);
        END
        Else err01BadParm;
     END;
  END;  (* getFrameInfo *)

PROCEDURE initSymTabs (VAR s   : SymbolTable;    r : sPtr;
                           t   : buttonTag;   fPos : Integer;
                           c   : Colors;         b : Borders);
  VAR i : Integer;
  BEGIN
     FOR i := 1 To maxSymbols Do begin
        s.ptrs[i] := Nil;
        r^.ptrs[i] := Nil;
     END;
     New(s.ptrs[1]);
     s.ptrs[1]^.symTag := t;
     s.ptrs[1]^.winColors := c;
     s.ptrs[1]^.border := b;
     s.ptrs[1]^.frameLoc := fPos;
     s.ptrs[1]^.refFound := False;
     If t = '' Then s.ptrs[1]^.def := 0
     Else s.ptrs[1]^.def := 1;
     s.next := 2;
     r^.next := 1;
  END;  (* initSymTab *)

PROCEDURE addSymDef (VAR s   : SymbolTable;    r : sPtr;
                         t   : buttonTag;   fPos : Integer;
                         c   : Colors;         b : Borders);
  VAR i  : Integer;
      tt : buttonTag;
  BEGIN
     tt := UpCaseStr(t);
     i := 1;
     While (i < s.next) And (UpCaseStr(s.ptrs[i]^.symTag) <> tt) Do
        i := i + 1;
     If (s.ptrs[i] <> Nil) And (UpCaseStr(s.ptrs[i]^.symTag) = tt) Then
        fErr02MultDef(t)
     ELSE Begin
        i := 1;
        While (i < r^.next) And (UpCaseStr(r^.ptrs[i]^.symTag) <> tt) Do
           i := i + 1;
        If (r^.ptrs[i] <> Nil)
           AND (UpCaseStr(r^.ptrs[i]^.symTag) = tt) Then Begin
              s.ptrs[s.next] := r^.ptrs[i];
              s.ptrs[s.next]^.symTag := t;
              r^.ptrs[i] := Nil;
              r^.next := r^.next - 1;
              If i < r^.next Then
                 REPEAT
                    r^.ptrs[i] := r^.ptrs[i+1];
                    i := i + 1;
                 UNTIL i = r^.next;
           END
        ELSE Begin
           New(s.ptrs[s.next]);
           s.ptrs[s.next]^.symTag := t;
           s.ptrs[s.next]^.refFound := False;
        END;
        s.ptrs[s.next]^.winColors := c;
        s.ptrs[s.next]^.border := b;
        s.ptrs[s.next]^.frameLoc := fPos;
        s.ptrs[s.next]^.def := g_Lines;
        s.next := s.next + 1;
        If s.next > maxSymbols Then fErr11TooMuch;
     END;
  END;  (* addSymDef *)

PROCEDURE addRefToSym (VAR s : SymbolTable; r : sPtr; t : buttonTag);
  VAR i  : Integer;
      tt : buttonTag;
  BEGIN
     tt := UpCaseStr(t);
     i := 1;
     While (i < s.next) And (UpCaseStr(s.ptrs[i]^.symTag) <> tt) Do
        i := i + 1;
     IF (s.ptrs[i] <> Nil) And (UpCaseStr(s.ptrs[i]^.symTag) = tt) Then Begin
        s.ptrs[i]^.refFound := True;
        s.ptrs[i]^.ref := g_Lines;
     END
     ELSE Begin
        i := 1;
        While (i < r^.next) And (UpCaseStr(r^.ptrs[i]^.symTag) <> tt) Do
              i := i + 1;
        If i = r^.next Then Begin
           New(r^.ptrs[r^.next]);
           r^.ptrs[r^.next]^.symTag := t;
           r^.ptrs[r^.next]^.refFound := True;
           r^.ptrs[r^.next]^.ref := g_Lines;
           r^.next := r^.next + 1;
           If r^.next > maxSymbols Then fErr11TooMuch;
        END;
     END;
  END;  (* addRefToSym *)

PROCEDURE findButtons (VAR s     : SymbolTable;         r : sPtr;
                           buf   : String;      VAR b, c  : Integer);
  VAR i,j : Integer;
      t,u : String;
      CH : CHAR;
  BEGIN
    j := 0;
    IF Pos(textChar,buf) <> 1 Then Begin
       For i := 1 To Length(buf) Do If buf[i] = delimChar Then j := j + 1;
       If Odd(j) Then err03UnBal
       Else
         IF j > 0 Then Begin
            u := After(buf,delimChar);
            REPEAT
               t := Before(u,delimChar);
               If Length(t) > maxButton Then fErr10TooBig(u)
               ELSE Begin
                   addRefToSym(s,r,t);
                  u := After(u,delimChar);
                  u := After(u,delimChar);
               END;
            UNTIL u = '';
            c := Length(buf) - j;
            b := b + (j Div 2);
         END
         Else
            c := Length(buf);
    END
    Else
       c := Length(buf) - 1;
  END;  (* findButtons *)

PROCEDURE finishSymbol (s : SymbolTable; t : buttonTag; w, l, b : Integer);
  VAR i  : Integer;
      tt : buttonTag;
  BEGIN
     tt := UpCaseStr(t);
     i := 1;
     While (i < s.next) And (UpCaseStr(s.ptrs[i]^.symTag) <> tt) Do
        i := i + 1;
     IF (s.ptrs[i] <> Nil) And (UpCaseStr(s.ptrs[i]^.symTag) = tt) Then Begin
        s.ptrs[i]^.width := BiggerInteger(w,Length(s.ptrs[i]^.symTag)+14);
        s.ptrs[i]^.lines := l;
        s.ptrs[i]^.buttons := b;
        s.ptrs[i]^.Size := l + ((b + 1) Div 2);
     END;
  END;  (* finishSymbol *)

PROCEDURE scanTable (s : SymbolTable; r : sPtr);
  VAR i : Integer;
  BEGIN
     For i := 1 To s.next - 1 Do
        If s.ptrs[i]^.def > 0 Then
           If Not s.ptrs[i]^.refFound Then
              err05NoRef (s.ptrs[i]^.symTag,s.ptrs[i]^.def);
     i := 1;
     WHILE i < r^.next Do Begin
        fErr13NoDef(r^.ptrs[i]^.symTag,r^.ptrs[i]^.ref);
        i := i + 1;
     END;
  END;

PROCEDURE dumpTable (s : SymbolTable; r : sPtr);
  VAR i : Integer;
      c : colorSpecs;
  BEGIN
     WriteLn(Lst,'');
     FOR i := 1 To s.next - 1 Do Begin
        WriteLn(Lst,'FRAME TAG: ',s.ptrs[i]^.symTag);
        Write(Lst,'Frame location: ',s.ptrs[i]^.frameLoc);
        Write(Lst,', width: ',s.ptrs[i]^.width);
        Write(Lst,', lines: ',s.ptrs[i]^.lines);
        WriteLn(Lst,', buttons: ',s.ptrs[i]^.buttons,' size: ',s.ptrs[i]^.size);
        Write(Lst,'Frame records: 1, text records: ',s.ptrs[i]^.lines);
        Write(Lst,', button records: ',
              ((s.ptrs[i]^.buttons+1) Div 2),', total: ');
        WriteLn(Lst,1+s.ptrs[i]^.lines+((s.ptrs[i]^.buttons+1) Div 2));
        Write(Lst,'Colors: ');
        For c := textB To HiLiteF Do Write(Lst,s.ptrs[i]^.winColors[c],' ');
        Write(Lst,'Border: ',Ord(Borders(s.ptrs[i]^.border)),'  Referenced: ');
        If s.ptrs[i]^.refFound Then WriteLn(Lst,'True')
        Else WriteLn(Lst,'False');
        WriteLn(Lst,'');
     END;
     IF r^.next > 1 Then Begin
        WriteLn(Lst,'');
        WriteLn(Lst,'*** UNDEFINED BUTTONS ***');
        WriteLn(Lst,'');
        i := 1;
        REPEAT
           WriteLn(Lst,r^.ptrs[i]^.symTag);
           i := i + 1;
        UNTIL i = r^.next;
     END;
  END;  (* dumpTable *)

PROCEDURE buildSymTab;
  CONST
      nullFrame : buttonTag = '';
  VAR lType     : srcLines;
      fPos, btnCt,
      linCt, wid,
      charCt    : Integer;
      cols      : Colors;
      bord      : Borders;
      tag       : ButtonTag;
      r         : sPtr;
  BEGIN
     getMem (r, sizeOf(symbolTable));
     fPos   := 1;
     btnCt  := 0;
     linCt  := 0;
     wid    := 0;
     g_Lines := 0;
     getLine(src,prt,g_buffer,lType,g_Lines);
     IF lType = buttonId Then Begin
        cols := dc;
        bord := db;
        getFrameInfo(g_buffer,tag,cols,bord);
        If Length(tag) > 0 Then initSymTabs(s,r,tag,fPos,cols,bord)
        Else initSymTabs(s,r,nullFrame,fPos,cols,bord);
        getLine(src,prt,g_buffer,lType,g_Lines);
     END
     ELSE Begin
        tag := nullFrame;
        initSymTabs(s,r,tag,fPos,dc,db);
     END;
     WHILE Not (lType = EndOfFile) Do Begin
        IF lType = textLine Then Begin
           linCt := linCt + 1;
           If linCt > MaxLines Then err04Lines(linCt)
           ELSE Begin
             findButtons(s,r,g_buffer,btnCt,charCt);
             If charCt > MaxChars Then err12Chars (charCt);
             If charCt > wid Then wid := charCt;
           END
        END
        ELSE Begin
           If linCt = 0 Then err08NoLines (tag);
           If linCt > MaxLines Then linCt := MaxLines;
           finishSymbol(s,tag,wid,linCt,btnCt);
           fPos := fPos + 1 + linCt + ((btnCt + 1) Div 2);
           btnCt  := 0;
           linCt  := 0;
           wid    := 0;
           cols   := dc;
           bord   := db;
           getFrameInfo(g_buffer,tag,cols,bord);
           If Length(tag) > 0 Then addSymDef(s,r,tag,fPos,cols,bord)
           Else err06NoFrame;
        END;
        getLine(src,prt,g_buffer,lType,g_Lines);
     END;
     if linCt = 0 Then err08NoLines (tag);
     If linCt > MaxLines Then linCt := MaxLines;
     finishSymbol(s,tag,wid,linCt,btnCt);
     scanTable (s,r);

     {$IFDEF Debugging}
     dumpTable (s,r);
     {$ENDIF}

  END;  (* buildSymTab *)


BEGIN
END.

