Unit htcu1;

Interface

Uses Dos, HTCDEU0 ,Crt, Printer, strFuncs, DEwindU, videoU;

CONST
  maxSymbols  = 1000;
  delimChar   = '\';
  defChar     = ':';
  commChar    = '.';
  textChar    = '!';
  infoWin     = 1;
  procWin     = 4;

TYPE
  srcLines    = (textLine, buttonId, endOfFile);
  parms       = (srcName, dbName, idxName, prt, errs, cfgName, build);
  param       = String[80];
  parmArray   = Array[parms] Of param;
  displayOpts = (onScreen, toPrint, both);
  symbolPtr   = ^symbol;

  symbol      = Record
                  symTag     : buttonTag;
                  winColors  : colors;
                  border     : borders;
                  ref,
                  def,
                  width,
                  lines,
                  buttons,
                  size,
                  frameLoc   : Integer;
                  tFileName  : String[12];
                  refFound   : Boolean;
                End;

  symbolTable = Record
                  next,top   : Integer;
                  ptrs       : Array [1..maxSymbols] Of symbolPtr;
                End;



VAR

  g_Lines         : Integer;
  g_buffer        : String;
  g_errDisplay    : DisplayOpts;
  g_Abort         : Boolean;
  g_printSource   : Boolean;


PROCEDURE parseCmdLine (VAR p : parmArray);

FUNCTION setWinDefaults (   p : param;
                         VAR c: colors; VAR b : borders) : Integer;

PROCEDURE getLine (VAR f : Text;     p : Boolean;
                   VAR s : String;   VAR t : SrcLines; VAR l : Integer);

FUNCTION exists (n : fileNameStr) : Boolean;

PROCEDURE bldBatchFile (p : parmArray);

(***************************************************************************)
(**)                                                                     (**)
(**)                            Implementation                           (**)
(**)                                                                     (**)
(***************************************************************************)

CONST
  prtKind     : Set Of Char =['N','Y'];
  errsKind    : Set Of Char =['S','P','B'];
  bordKind    : Set Of Char =['0','1','2'];
  digits      : Set Of Char =[',','0'..'9'];
  defDbExt    = 'HYP';
  defIdxExt   = 'HYX';
  defCfgName  = 'HTC.CFG';
  fileWin     = 2;
  optWin      = 3;
  defWin      = 5;
  cfgWin      = 6;
  bldWin      = 7;

VAR
  cmd   : String;

FUNCTION exists;
  VAR f : Text;
      c : Integer;
  BEGIN
     Assign(f,n);
     {$I-}
     Reset(f);
     c := IoResult;
     {$I+}
     exists := (c = 0);
  END;

PROCEDURE termPgm (c : Integer);
  BEGIN
    WriteLn(#7,'Program terminating with return code ',c,'.');
    Halt(c);
  END;

PROCEDURE getLine;
   VAR foundLine : Boolean;
   BEGIN
      IF Eof(f) Then Begin
         s := '';
         t := EndOfFile;
      END
      ELSE Begin
         foundLine := False;
         REPEAT
            ReadLn(f,s);
            l := l + 1;
            If (l Mod 30) = 0 Then Write('.');
            IF p Then Begin
               WriteLn(Lst,l:5,' ',Copy(s,1,74));
               If Length(s) > 74 Then WriteLn(Lst,'      ',Copy(s,75,148));
            END;
            If Length(s) > 0 Then s := stripTrailing(s);
            If length(s) = 0 Then s := ' ';
            IF s[1] <> commChar Then Begin
               foundLine := True;
               If s[1] = defChar Then t := buttonId
               Else t := textLine;
            END
            Else
               IF Eof(f) Then Begin
                  s := '';
                  t := endOfFile;
                  foundLine := True;
               END;
         UNTIL foundLine;
      END;
   END;

PROCEDURE displayTheOpts (p: parmArray);
  VAR t : parms;
      i : Integer;
  BEGIN
    selectWindow(infoWin);
    FOR t := srcName to cfgName Do Begin
        GotoXY(12,Ord(t)+2);
        Write(p[t]);
        If (t = srcName) Or (t = dbName)
           Or (t = idxName) Or (t = cfgName) Then
              Write(spaces(Length(p[t])-77));
        If (t = prt) And (p[t] <> '') Then
           If p[t] = 'N' Then Write(' (Source file not echoed to printer)')
           Else Write(' (Source file echoed to printer)');
        If (t = errs) And (p[t] <> '') Then
           If p[t] = 'S' Then
               Write(' (Error messages displayed on screen only)')
           Else If p[t] = 'P' Then
               Write(' (Error messages sent to printer only)')
           Else
               Write(' (Error messages displayed on both screen and printer)');

    END;
    GotoXY(12,8);
    If Length(cmd) < 68 Then Write(cmd)
    ELSE Begin
        i := 69;
        REPEAT
            i := i - 1
        UNTIL cmd[i] = ' ';
        Write(Copy(cmd,1,i),'...');
    END;
  END;

PROCEDURE getPrintOpt (VAR p : parmArray);
   VAR c : Char;
    ps    : String;
   BEGIN
      OpenWindow(OptWin);
      GotoXY(1,2);
      Write(' The source file can be printed on the printer as the ');
      Write('compiler processes it.');
      GotoXY(1,3);
      Write(' If you want the source file printed, answer "Y"; ');
      WriteLn('if not, answer "N".');
      REPEAT
         GotoXY(1,5);
         Write(' Do you want the source sent to the printer? [Y] or [N] => ');
         CursorBig;
         c := UpCase(ReadKey);
         CursorOff;
         IF Not (c In prtKind) Then Begin
            GotoXY(1,7);
            WriteLn(#7,' Please press either the "Y" key or the "N" key.');
         END;
      UNTIL c In prtKind;
      p[prt] := c;
      CloseWindow(optWin);
      cmd := cmd + ' /P' + p[prt];
      DisplayTheOpts(p);
   END;

PROCEDURE getErrorOpt (VAR p : parmArray);
   VAR c : Char;

   BEGIN
      OpenWindow(optWin);
      GotoXY(1,2);
      Write(' Error messages produced by the compiler can be displayed ');
      Write('on the screen, sent');
      GotoXY(1,3);
      Write(' to the printer, or both.  Answer "S" (Screen), "P" ');
      Write('(Printer) or "B" (Both).');
      REPEAT
         GotoXY(1,5);
         Write(' Error messages to [S]creen, [P]rinter, or [B]oth? => ');
         CursorBig;
         c := UpCase(ReadKey);
         CursorOff;
         IF Not (c In errsKind) Then Begin
            GotoXY(1,7);
            Write(#7,' Please press the "S" key, the "P" key, or the ');
            Write('"B" key.');
         END;
      UNTIL c In errsKind;
      p[errs] := c;
      CloseWindow(optWin);
      cmd := cmd + ' /E' + p[errs];
      DisplayTheOpts(p);
   END;

PROCEDURE getSourceName (VAR p : parmArray);
   VAR i   : Integer;
       tmp : String;
   BEGIN
      CursorOff;
      OpenWindow(fileWin);
      GotoXY(1,2);
      Write(' The HyperText Compiler requires the names of three files ');
      Write('-- the file');
      GotoXY(1,3);
      Write(' containing the source text, the hypertext database file ');
      Write('and the hypertext ');
      GotoXY(1,4);
      Write(' index file.');
      GotoXY(1,6);
      Write(' Please enter the name of the source text file and ');
      WriteLn('press [Enter].');
      GotoXY(1,7);
      Write(' Source => ');
      CursorBig;
      ReadLn(tmp);
      CursorOff;
      tmp := UpCaseStr(tmp);
      IF Length(tmp) = 0 Then Begin
         WriteLn(' No source text file name entered');
         termPgm(3);
      END;
      p[srcName] := tmp;
      CloseWindow(fileWin);
      cmd := cmd + ' /S' + p[srcName];
      DisplayTheOpts(p);
   END;

PROCEDURE getDbName(VAR p : parmArray);
   VAR tmp : String;
   BEGIN
      CursorOff;
      OpenWindow(fileWin);
      GotoXY(1,2);
      Write(' Please enter the name of the hypertext database file.  If you');
      Write(' wish to use');
      GotoXY(1,3);
      Write(' the default file name in the DEFAULT FILE window, just');
      Write(' press [Enter].');
      p[dbName] := Before(p[srcName],'.') + '.HYP';
      OpenWindow(Defwin);
      SelectWindow(defWin);
      Write(' ',p[dbName]);
      SelectWindow(fileWin);
      GotoXy(1,5);
      Write (' Hypertext => ');
      CursorBig;
      ReadLn(tmp);
      CloseWindow(defWin);
      CursorOff;
      If Length(tmp) > 0 Then p[dbName] := UpCaseStr(tmp);
      CloseWindow(fileWin);
      cmd := cmd + ' /D' + p[dbName];
      DisplayTheOpts(p);
   END;

PROCEDURE getIdxName (VAR p : parmArray);
   VAR tmp : String;
   BEGIN
      CursorOff;
      OpenWindow(fileWin);
      GotoXY(1,2);
      Write(' Please enter the name of the hypertext index file.  If you');
      Write(' wish to use the');
      GotoXY(1,3);
      Write(' default file name in the DEFAULT FILE window, just');
      Write(' press [Enter].');
      p[idxName] := Before(p[dbName],'.') + '.HYX';
      OpenWindow(Defwin);
      SelectWindow(defWin);
      Write(' ',p[idxName]);
      SelectWindow(fileWin);
      GotoXy(1,5);
      Write (' Index => ');
      CursorBig;
      tmp := '';
      ReadLn(tmp);
      CloseWindow(defWin);
      CursorOff;
      If Length(tmp) > 0 Then p[idxName] := UpCaseStr(tmp);
      CloseWindow(fileWin);
      cmd := cmd + ' /I' + p[idxName];
      DisplayTheOpts(p);
  END;

PROCEDURE getCfgName(VAR p : parmArray);
    VAR tmp : String;
    BEGIN
      CursorOff;
      OpenWindow(cfgWin);
      GotoXY(1,2);
      Write(' As the HyperText Compiler creates the HyperText database, ');
      Write('it includes window');
      GotoXY(1,3);
      Write(' information for each frame.  Some of this information');
      Write('--default colors and');
      GotoXY(1,4);
      Write(' border type--must be in a configuration file.  Please');
      Write(' enter the file name.');
      GotoXY(1,5);
      Write(' If you wish to use the default configuration file named ');
      Write('in the DEFAULT FILE');
      GotoXY(1,6);
      Write(' window, just press [Enter].');
      p[cfgName] := defCfgName;
      GotoXY(1,8);
      Write(' Config => ');
      OpenWindow(Defwin);
      SelectWindow(defWin);
      Write(' ',defCfgName);
      SelectWindow(cfgWin);
      CursorBig;
      tmp := '';
      ReadLn(tmp);
      CursorOff;
      If Length(tmp) > 0 Then p[cfgName] := UpCaseStr(tmp);
      CloseWindow(cfgWin);
      CloseWindow(defWin);
      cmd := cmd + ' /C' + p[cfgName];
      DisplayTheOpts(p);
    END;

PROCEDURE parseCmdLine (VAR p : parmArray);
  VAR
    i     : Integer;
    t     : parms;
    c     : Char;
    s     : param;
    ps    : String;
  BEGIN  (* parseCmdLine *)

    DefineWindow(defWin,15,20,75,25,Attr(LightGray,Black),
                 SingleBorder,Attr(LightGray,Black),
                 ' DEFAULT FILE ',Attr(Black,LightGray),Right,
                 '',0,Center,DefaultFlag,'',0);
    DefineWindow(infoWin,1,1,80,8,Attr(LightGray,Black),
                 '        ',Attr(LightGray,Black),
                 ' PC-HYPERTEXT COMPILER OPTIONS ',Attr(Black,LightGray),
                 Left,'',0,Center,15,'',0);
    OpenWindow(infoWin);
    GotoXY(1,2);
    WriteLn('   Source: ');
    WriteLn('HyperText: ');
    WriteLn('    Index: ');
    WriteLn('    Print: ');
    WriteLn('   Errors: ');
    WriteLn('   Config: ');
    Write  ('  Command: ');

  {Make all parms = null}
    For t := srcName to build Do p[t] := '';

  {Retrieve command-line parms}
    IF ParamCount > 0 Then Begin
       FOR i := 1 To ParamCount Do Begin
          s := UpCaseStr(NoBlanks(After(ParamStr(i),'/')));
          c := s[1];
          s := Copy(s,2,255);
          CASE c Of
              'S' : p[srcName] := s;
              'D' : p[dbName]  := s;
              'I' : p[idxName] := s;
              'C' : p[cfgName] := s;
              'P' : p[prt]     := s;
              'E' : p[errs]    := s;
              'B' : p[build]   := s;
          END;
       END;
    END;

    cmd := 'HTC120';

  {Take all defaults?}
    IF (p[srcName] <> '') And
       (p[dbName] = '') And
       (p[idxName] = '') And
       (p[cfgName] = '') And
       (p[prt] = '') And
       (p[errs] = '') Then Begin

  {Then set up all defaults}
         p[dbName] := Before(p[srcName],'.') + '.HYP';
         p[idxName] := Before(p[dbName],'.') + '.HYX';
         p[cfgName] := defCfgName;
         p[prt] := 'N';
         p[errs] := 'S';
         If p[build] <> 'Y' Then p[build] := 'N';
         cmd := cmd + ' /S' + p[srcName] + ' /D' + p[dbName] + ' /I'
                + p[idxName] + ' /P' + p[prt] + ' /E' + p[errs]
                + ' /C' + p[cfgName];
         displayTheOpts(p);
    END
    ELSE Begin

  {No? then work through individual parms}

       DisplayTheOpts(p);

       DefineWindow(fileWin,1,11,80,21,Attr(LightGray,Black),
                    DoubleBorder,Attr(LightGray,Black),
                    ' SOURCE AND DATABASE FILE NAMES ',
                    Attr(Black,LightGray),Left,
                    '',0,Center,DefaultFlag,'',0);
       DefineWindow(optWin,1,11,80,21,Attr(LightGray,Black),
                    DoubleBorder,Attr(LightGray,Black),
                    ' SOURCE PRINT AND ERROR MESSAGE OPTIONS ',
                    Attr(Black,LightGray),Left,
                    '',0,Center,DefaultFlag,'',0);
       DefineWindow(cfgWin,1,11,80,21,Attr(LightGray,Black),
                    DoubleBorder,Attr(LightGray,Black),
                    ' CONFIGURATION FILE NAME ',
                    Attr(Black,LightGray),Left,
                    '',0,Center,DefaultFlag,'',0);

    {No source file? then get file name}
      If p[srcName] = '' Then getSourceName(p);

    {No db file? then then get file name}
      If p[dbName] = '' Then getDbName(p);

    {No idx file? then get file name}
      If p[idxName] = '' Then getIdxName(p);

      DeleteWindow(fileWin);

    {No printer option? then get one}
      If (p[prt] = '')
         Or Not (UpCase(p[prt,1]) In prtKind)
            Then getPrintOpt(p);

    {No error option? then get one}
      If (p[errs] = '')
         Or Not (UpCase(p[errs,1]) In errsKind) Then
             getErrorOpt(p);

      DeleteWindow(optWin);

    {No configuration file name? then get name}
      If p[cfgName] = '' Then getCfgName(p);

      DeleteWindow(cfgWin);

    END;

 END; (* parseCmdLine *)

FUNCTION setWinDefaults;
  VAR cfg : Text;
      t   : String;
      ch  : Char;
      ok  : Boolean;
      i,j,
      k   : Integer;
  BEGIN  (* setWinDefaults *)
     setWinDefaults := 0;
     DefineWindow(procWin,1,5,80,24,Attr(LightGray,Black),
                 SingleBorder,Attr(LightGray,Black),
                 ' PC-HYPERTEXT COMPILER  ',
                 Attr(Black,LightGray),Left,
                 '',0,Center,DefaultFlag,'',0);
     OpenWindow(procWin);
     WriteLn('Using default window information in ',p);
     Assign(cfg,p);
     Reset(cfg);
     ok := True;
     FOR i := 0 To 7 Do Begin
        IF Not Eof(cfg) Then Begin
           ReadLn(cfg,t);
           If Pos('BLACK',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 0
           Else If Pos('BLUE',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 1
           Else If Pos('GREEN',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 2
           Else If Pos('CYAN',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 3
           Else If Pos('RED',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 4
           Else If Pos('MAGENTA',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 5
           Else If Pos('BROWN',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 6
           Else If Pos('LIGHTGRAY',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 7
           Else If Pos('DARKGRAY',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 8
           Else If Pos('LIGHTBLUE',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 9
           Else If Pos('LIGHTGREEN',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 10
           Else If Pos('LIGHTCYAN',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 11
           Else If Pos('LIGHTRED',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 12
           Else If Pos('LIGHTMAGENTA',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 13
           Else If Pos('YELLOW',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 14
           Else If Pos('WHITE',UpCaseStr(t)) = 1 Then
              c[ColorSpecs(i)] := 15
           ELSE Begin
              Val(t,j,k);
              If ok Then ok := (k = 0) And (j <= 15) and (j >= 0);
              If (k = 0) And (j <= 15) and (j >= 0) Then
                 c[ColorSpecs(i)] := j
              Else
                 WriteLn('Invalid color specification (',t,
                         ') in line ',i+1,' of ',p,'.');
           END;
        END;
     END;
     IF not ok Then Begin
         setWinDefaults := 4;
         Exit;
     END;
     IF Not Eof(cfg) Then Begin
        ReadLn(cfg,t);
        ch := t[1];
        CASE ch Of
           '0' : b := noBord;
           '1' : b := singleBord;
           '2' : b := doubleBord;
           '3' : b := singleUp;
           '4' : b := doubleUp;
           ELSE Begin
              WriteLn('Invalid border specification (',ch,') in ',p);
              setWinDefaults := 5;
              Exit;
           END;
        END;
        Write('Default window border is ');
        CASE b Of
           noBord     : WriteLn('none.');
           singleBord : WriteLn('single line.');
           doubleBord : WriteLn('double line.');
           singleUp   : WriteLn('single top and bottom, double sides.');
           doubleUp   : WriteLn('double top and bottom, single sides.');
        END;
     END
     ELSE Begin
        WriteLn('No default border specified in ',p,'.');
        setWinDefaults := 6;
        Halt;
     END;
  END;  (* setWinDefaults *)

PROCEDURE bldBatchFile (p : parmArray);
  VAR  ch  : Char;
       nam,
       msg,
       tmp,
       def : String;
       f   : Text;
       Ok  : Boolean;
  BEGIN
     DefineWindow(bldWin,1,10,80,21,Attr(LightGray,Black),
                 DoubleBorder,Attr(LightGray,Black),
                 ' CREATE COMMAND LINE ',
                 Attr(Black,LightGray),Left,
                 '',0,Center,DefaultFlag,'',0);
     OpenWindow(bldWin);
     Write(' The command line which would invoke the compiler with the ');
     WriteLn('options specified');
     Write(' is shown above ("Command: ... ").  This command line can be ');
     WriteLn('stored in a');
     Write(' batch file so that one simple command will repeat this ');
     WriteLn('compilation with the');
     Write(' same options.  If you would like to have the batch file ');
     WriteLn('created, type "Y",');
     Write(' if not, type "N".');
     REPEAT
        GotoXY(1,7);
        Write(' Create the file? [Y] or [N] => ');
        CursorBig;
        ch := UpCase(ReadKey);
        CursorOff;
        IF Not ((ch = 'N') Or ( ch = 'Y')) Then Begin
           GotoXY(1,9);
           WriteLn(#7,' Please press either the "Y" key or the "N" key.');
        END;
     UNTIL ((ch = 'N') Or ( ch = 'Y'));
     IF ch = 'Y' Then Begin
        ClrScr;
        OpenWindow(defWin);
        nam := After(p[dbName],getPath(p[dbName]));
        def := Copy(Before(nam,'.'),1,6) + p[prt] + p[errs];
        Write(' ',def,' (.BAT)');
        SelectWindow(bldWin);
        Write(' Enter the name of the batch file (no more than eight ');
        WriteLn('characters, do not');
        Write(' include the ".BAT" extension).  If you wish to use the ');
        WriteLn('file name in the ');
        Write(' DEFAULT FILE window, just press [Enter].  (This name ');
        WriteLn('was created from the');
        Write(' HyperText database name and the print and error ');
        WriteLn('message options.)');
        Ok := True;
        REPEAT
          CursorBig;
          GotoXY(1,6);
          Write(' Enter the file name =>                         ');
          tmp := '';
          GotoXY(25,6);
          ReadLn(tmp);
          CursorOff;
          GotoXY(1,8);
          Write(spaces(77));
          tmp := UpCaseStr(tmp);
          Ok := (Pos(',',tmp) = 0);
          IF Ok Then Begin
             Ok := (Pos('.',tmp) = 0);
             IF Ok Then Begin
                Ok := (Pos(' ',tmp) = 0);
                IF Ok Then Begin
                   Ok := Length(tmp) < 9;
                   If Not Ok Then
                      msg := 'File name cannot exceed eight characters.';
                END
                Else msg := 'No blanks allowed in file names.';
             END
             Else msg := 'No periods allowed in file names.';
          END
          Else msg := 'No commas allowed in file names.';
          IF Not Ok Then Begin
            GotoXY(1,8);
            Write(#7,' ',tmp,' -- ',msg);
          END
       UNTIL Ok;
       CloseWindow(defWin);
       DeleteWindow(defWin);
       If Length(tmp) = 0 Then tmp := def + '.BAT'
       Else tmp := tmp + '.BAT';
       GotoXY(1,8);
       Write(spaces(77));
       GotoXY(1,8);
       Write(' Writing ',tmp);
       Assign(f,tmp);
       ReWrite(f);
       WriteLn(f,cmd + ' /BN');
       Close(f);
     END;
     CloseWindow(bldWin);
     DeleteWindow(bldWin);
  END;

BEGIN
END.



