Program HTC120;

{$M 32000,0,35000}

Uses Crt, Printer, videou, strFuncs, HTCDEU0, HTCU1, HTCU2, HTCU3, DEwindU;

CONST
  HTCVersion = 1.2;

VAR

  sourceFileName,
  dbFileName,
  indexFileName   : String;
  source          : Text;
  db              : dbFile;
  idx             : idxFile;
  defaultColors   : Colors;
  defaultBord     : Borders;
  symTab          : SymbolTable;
  refTab          : sPtr;
  parameters      : ParmArray;
  cfgResult       : Integer;
  ch              : Char;


BEGIN (* MAIN *)
  ClrScr;
  parseCmdLine (parameters);

  If parameters [build] <> 'N' Then bldBatchFile (parameters);

  IF exists(parameters[srcName]) Then Begin
     Assign(source,parameters[srcName]);
     Reset(source);
  END
  ELSE Begin
     WriteLn('Source text file (',parameters[srcName],') not found.');
     WriteLn('HyperText Compiler terminating with code 1');
     Halt(1);
  END;

  Assign(db,parameters[dbName]);
  Assign(idx,parameters[idxName]);
  Rewrite(db);
  Rewrite(idx);
  If exists(parameters[cfgName]) Then
     cfgResult := setWinDefaults (parameters[cfgName],
                                  defaultColors, defaultBord)
  ELSE Begin
     WriteLn('Configuration file (',parameters[cfgName],') not found.');
     WriteLn('HyperText Compiler terminating with code 2');
     Close(source);
     Close(db);
     Close(idx);
     Halt(2);
  END;

  IF cfgResult > 0 Then Begin
     Close(source);
     Close(db);
     Close(idx);
     Halt(cfgResult);
  END;

  CASE parameters[errs,1] Of
     'S' : g_errDisplay := onScreen;
     'P' : g_errDisplay := toPrint;
     'B' : g_errDisplay := both;
  END;

  g_printSource := parameters[prt] = 'Y';

  SelectWindow(procWin);

  WriteLn;
  WriteLn('PC-HyperText Compiler Version ',HTCVersion:4:2);
  WriteLn;
  InitDB(db,defaultColors,defaultBord,HTCVersion);
  IF g_printSource Then Begin
     WriteLn(Lst,'Listing of HTC Source File -- ',sourceFileName);
     Write(Lst,'      ----+----1----+----2----+----3----+----4');
     WriteLn(Lst,'----+----5----+----6----+----7----');
  END;
  g_Abort := False;

  buildSymTab(source,g_printSource,defaultColors,DefaultBord,symTab);
  If g_printSource Then WriteLn(Lst,'*** End of File ***');

  IF Not g_Abort Then Begin
     Reset(source);
     compileText (symTab, source, db, idx);
  END
  ELSE Begin
     WriteLn;
     WriteLn('Fatal errors detected -- compilation aborted with code 3');
  END;

  Close(source);
  Close(db);
  Close(idx);

  SelectWindow(0);
  CursorSmall;
  GotoXY(1,24);
  If g_Abort Then Halt(3);
END.  (* MAIN *)


