unit dewindu ;

      INTERFACE

uses
   Crt, Dos, HTCDEU0;
const
   Diagnostics = True;  { Set to false to suppress error message display }

   SingleBorder   = 'Ŀ';
   DoubleBorder   = 'ͻȺ';
   SingleUpBorder = 'ķӺ';
   DoubleUpBorder = '͸Գ';

   ClearScreen   = 1;
   SaveContents  = 2;
   DisplayBorder = 4;
   WriteOnBorder = 8;
   DefaultFlag   = 7;   { ClearScreen+SaveContents+DisplayBorder }


type
   BorderStrType = string[8];    { Specifies the eight characters that are   }
   TitleStrType  = string[80];   { String of characters for header and }
   JustifyType   = (Left, Center, Right); { Specifies that a header or    }
   DirectionType = (UpDir, DownDir, LeftDir, RightDir);
   Switch = (On, Off);  { Used in SetCursor to turn cursor On and Off. }
   buttonDisp    = Record
                     tag        : buttonTag;
                     bb, bf,
                     hb, hf,
                     x,  y      : Byte;
                     loc        : Integer;
                   End;
   buttons       = Array[0..127] Of buttonDisp;
   buttonArray   = ^buttons;

procedure DefineWindow
   (WindowID   : byte;            { Window ID number                    }
    LeftCol    : byte;            { Left column coordinate              }
    TopRow     : byte;            { Top row coordinate                  }
    RightCol   : byte;            { Right column coordinate             }
    BottomRow  : byte;            { Bottom row coordinate               }
    WindowAttr : byte;            { Attribute for window writes         }
    BorderStr  : BorderStrType;   { String to use for border characters }
    BorderAttr : byte;            { Attribute for border characters     }
    HeaderStr  : TitleStrType;    { String for header text              }
    HeaderAttr : byte;            { Attribute for header text           }
    HeaderJust : JustifyType;     { Justification for header string     }
    FooterStr  : TitleStrType;    { String for footer text              }
    FooterAttr : byte;            { Attribute for footer text           }
    FooterJust : JustifyType;     { Justification for footer string     }
    UserFlags  : byte;            { User flags                          }
    Tag        : buttonTag;
    buttonCnt  : Byte);

function WindowButtonList
   (WindowID : byte) : buttonArray;

function WindowButtonCount
   (WindowID : byte) : Byte;

function WindowTag
   (WindowID : byte) : buttonTag;

procedure WindowButtonSelected
   (WindowID, btn : Byte);

function WindowLastButton
   (WindowID : Byte) : Byte;

procedure DeleteWindow
   (WindowID : byte);   { Window ID number }

procedure OpenWindow
   (WindowID : byte);   { Window ID number }

procedure CloseWindow
   (WindowID : byte);   { Window ID number }

procedure SelectWindow
   (WindowID : byte);   { Window ID number }

procedure HideWindow
   (WindowID : byte);   { Window ID number }

procedure DisplayWindow
   (WindowID : byte);   { Window ID number }

procedure RelocateWindow
   (WindowID   : byte;  { Window ID number }
    NewLeftCol : byte;  { New left column  }
    NewTopRow  : byte); { New top row      }

procedure MoveWindow
   (WindowID: byte;              { Window ID number                  }
    Direction: DirectionType);   { Direction to move window WindowID }

function WindowDefined
   (WindowID : byte): boolean;   { Window ID number }

function WindowOpen
   (WindowID : byte): boolean;   { Window ID number }

function WindowHidden
   (WindowID : byte): boolean;   { Window ID number }

function ActiveWindow
   (WindowID : byte): byte;      { Window ID number }

function WinError: byte;

function Attr
   (Foreground: byte;         { Foreground color }
    Background: byte): byte;  { Background color }

procedure SetCursor
   (OnOff: Switch);

function Mono: boolean;

function EGAInstalled : boolean;

procedure MoveToScreen
   (var Source, Dest; Len: word);

procedure MoveFromScreen
   (var Source, Dest; Len: word);

{$F+}
function HeapFunc
   (Size: word): integer;
{$F-}

      IMPLEMENTATION

const
   WinOpen   = 1;
   WinHidden = 2;

   WinOk       =  0;    { Window operation successful                    }
   WinDefZero  =  1;    { Attempt to redefine Window 0                   }
   WinDefMem   =  2;    { Memory allocation error when creating WDR      }
   WinDefRedef =  3;    { Attempt to redefine an already defined window  }
   WinDefCoor  =  4;    { Illegal window coordinates                     }
   WinDelZero  =  5;    { Attempt to delete Window 0                     }
   WinDelUndef =  6;    { Attempt to delete an undefined window          }
   WinDelOpen  =  7;    { Attempt to delete an open window               }
   WinOpnZero  =  8;    { Attempt to reopen Window 0                     }
   WinOpnUndef =  9;    { Attempt to open an undefined window            }
   WinOpnOpen  = 10;    { Attempt to open an already opened window       }
   WinOpnMem   = 11;    { Memory allocation error when opening window    }
   WinClsZero  = 12;    { Attempt to close Window 0                      }
   WinClsUndef = 13;    { Attempt to close an undefined window           }
   WinClsClose = 14;    { Attempt to close an already closed window      }
   WinSlcUndef = 15;    { Attempt to select an undefined window          }
   WinSlcClose = 16;    { Attempt to select a closed window              }
   WinSlcHidden= 17;    { Attampt to select a hidden window              }
   WinHidZero  = 18;    { Attempt to hide Window 0                       }
   WinHidUndef = 19;    { Attempt to hide an undefined window            }
   WinHidClose = 20;    { Attempt to hide a closed window                }
   WinHidHidden= 21;    { Attempt to hide a hidden window                }
   WinHidMem   = 22;    { Memory allocation error when hiding window     }
   WinDspZero  = 23;    { Attempt to display Window 0                    }
   WinDspUndef = 24;    { Attempt to display an undefined window         }
   WinDspClose = 25;    { Attempt to dislay a closed window              }
   WinDspHidden= 26;    { Attempt to display a non-hidden window         }
   WinDspMem   = 27;    { Memory allocation error when displaying window }
   WinRelUndef = 28;    { Attempt to relocate an undefined window        }
   WinRelClose = 29;    { Attempt to relocate a closed window            }
   WinRelCoor  = 30;    { Illegal window coordinates                     }
   WinMovUndef = 31;    { Attempt to move an undefined window            }
   WinMovClose = 32;    { Attempt to move a closed window                }
   WinMovHidden= 33;    { Attempt to move a hidden window                }
   WinMovCoor  = 34;    { Illegal move outside of screen attempted       }
   WinMovMem   = 35;    { Memory allocation error when moving window     }

type
   ScreenLine     = array[1..80] of word;
   ScreenArray    = array[1..43] of ScreenLine;
   ScreenBlock    = array[1..3440] of word;
   ScreenArrayPtr = ^ScreenArray;
   ScreenBlockPtr = ^ScreenBlock;

   BorderDefType = record         { Window border definition        }
      BorderStr  : BorderStrType; { Border string (8 chars long)    }
      HeaderStr  : TitleStrType;  { Header title                    }
      FooterStr  : TitleStrType;  { Footer title                    }
      HeaderJust : JustifyType;   { Header justification            }
      FooterJust : JustifyType;   { Footer justification            }
      BorderAttr : byte;          { Text attribute for border chars }
      HeaderAttr : byte;          { Text attribute for header chars }
      FooterAttr : byte           { Text attribute for footer chars }
      end;

   WindowDefinitionRecord = record    { Window Definition Record           }
      LeftCol       : byte;           { Left column coordinate             }
      TopRow        : byte;           { Top row coordinate                 }
      RightCol      : byte;           { Right column coordinate            }
      BottomRow     : byte;           { Bottom row coordinate              }
      WindowAttr    : byte;           { Text attribute for window contents }
      BorderDef     : BorderDefType;  { Border definition record           }
      UserFlags     : byte;           { User control flags                 }
      SysFlags      : byte;           { System status flags                }
      SaveCursorCol : byte;           { Cursor column for restore          }
      SaveCursorRow : byte;           { Cursor row for restore             }
      SaveTextAttr  : byte;           { Text attribute for restore         }
      SaveScreen    : ScreenBlockPtr; { Points to screen buffer block      }
      Tag           : buttonTag;
      buttonCnt     : Byte;
      buttonList    : buttonArray;
      selectedBtn   : Byte;
      end;

   WindowDefinitionRecordPtr = ^WindowDefinitionRecord;

   WindowArray = array [0..255] of WindowDefinitionRecordPtr;

var
   Screen            : ScreenArrayPtr; { Allows access to video memory       }
   ActiveWin         : byte;           { Currently active window             }
   NumDefinedWindows : byte;           { Number of defined windows           }
   NumOpenWindows    : byte;           { Number of open windows              }
   NumHiddenWindows  : byte;           { Number of hidden windows            }
   WinArray          : WindowArray;    { Stores pointers to all defined WDRs }
   NewWDR : WindowDefinitionRecordPtr; { Used to allocate WDR for Window 0   }
   WError            : byte;           { Holds error status of last operation}
   MaxRows           : byte;           { Maximum row coordinate              }
   MaxCols           : byte;           { Maximum column coordinate           }
   i                 : byte;           { Counter to index WinArray           }

procedure MoveToScreen;   external;    { From MicroCalc }
procedure MoveFromScreen; external;    { From MicroCalc }
{$L MCMVSMEM.OBJ}

function Attr;
   begin
      Attr:= (Background shl 4) + Foreground
   end;  { of func Attr }

procedure SetCursor;
   var
      Regs: Registers;
   begin
      with Regs do
         begin
         AX:= $0100;
         BX:= $0000;
         if OnOff = On then
            CX:= $0607
         else
            CX:= $2000;
         end;
      Intr ($10,Regs)
   end;  { of SetCursor }

function Max (A,B: word): word;
   begin
      if A>B then
           Max:= A
      else
         Max:= B
   end;  { of func Max }

function Min (A,B: word): word;
   begin
      if A<B then
         Min:= A
      else
         Min:= B
   end;  { of func Min }

function Mono;
   var
      Regs: Registers;
   begin
      Intr($11,Regs);
      Mono:= (Regs.AL and $30) = $30;
   end;  { of func Mono }

function EGAInstalled;
   var
     Regs : Registers;
   begin
     Regs.AX := $1200;
     Regs.BX := $0010;
     Regs.CX := $FFFF;
     Intr($10, Regs);
     EGAInstalled := Regs.CX <> $FFFF;
   end; { of func EGAInstalled }

function HeapFunc;
   begin
      HeapFunc := 1
   end;  { of HeapFunc }

procedure WindowError (ErrorCode: byte);
   var
      ErrMsg: string[80];
   begin
      WError:= ErrorCode;
      if (ErrorCode<>WinOk) and Diagnostics then
         begin
         case ErrorCode of
             1: ErrMsg:= 'Attempt to redefine Window 0';
             2: ErrMsg:= 'Memory allocation error when creating WDR';
             3: ErrMsg:= 'Attempt to redefine an already defined window';
             4: ErrMsg:= 'Illegal window coordinates';
             5: ErrMsg:= 'Attempt to delete Window 0';
             6: ErrMsg:= 'Attempt to delete an undefined window';
             7: ErrMsg:= 'Attempt to delete an open window';
             8: ErrMsg:= 'Attempt to reopen Window 0';
             9: ErrMsg:= 'Attempt to open an undefined window';
            10: ErrMsg:= 'Attempt to open an already opened window';
            11: ErrMsg:= 'Memory allocation error when opening window';
            12: ErrMsg:= 'Attempt to close Window 0';
            13: ErrMsg:= 'Attempt to close an undefined window';
            14: ErrMsg:= 'Attempt to close an already closed window';
            15: ErrMsg:= 'Attempt to select an undefined window';
            16: ErrMsg:= 'Attempt to select a closed window';
            17: ErrMsg:= 'Attampt to select a hidden window';
            18: ErrMsg:= 'Attempt to hide Window 0';
            19: ErrMsg:= 'Attempt to hide an undefined window';
            20: ErrMsg:= 'Attempt to hide a closed window';
            21: ErrMsg:= 'Attempt to hide a hidden window';
            22: ErrMsg:= 'Memory allocation error when hiding window';
            23: ErrMsg:= 'Attempt to display Window 0';
            24: ErrMsg:= 'Attempt to display an undefined window';
            25: ErrMsg:= 'Attempt to dislay a closed window';
            26: ErrMsg:= 'Attempt to display a non-hidden window';
            27: ErrMsg:= 'Memory allocation error when displaying window';
            28: ErrMsg:= 'Attempt to relocate an undefined window';
            29: ErrMsg:= 'Attempt to relocate a closed window';
            30: ErrMsg:= 'Illegal window coordinates';
            31: ErrMsg:= 'Attempt to move an undefined window';
            32: ErrMsg:= 'Attempt to move a closed window';
            33: ErrMsg:= 'Attempt to move a hidden window';
            34: ErrMsg:= 'Illegal move outside of screen attempted';
            35: ErrMsg:= 'Memory allocation error when moving window';
            end; {case}
         Writeln(ErrMsg)
         end;
   end;  { of WindowError }

function FlagSet
   (Flag: byte;
    Mask: byte): boolean;
   begin
      FlagSet := ((Flag and Mask) = Mask)
   end;  { of FlagSet }

function WindowDefined;
   begin
      WindowDefined:= not (WinArray[WindowID] = nil)
   end;  { of WindowDefined }

function WindowOpen;
   begin
      with WinArray[WindowID]^ do
         WindowOpen:= FlagSet(SysFlags,WinOpen)
   end;  { of WindowOpen }

function WindowHidden;
   begin
      with WinArray[WindowID]^ do
         WindowHidden:= FlagSet(SysFlags,WinHidden)
   end;  { of WindowHidden }

function ActiveWindow;
   begin
      ActiveWindow:= ActiveWin
   end;  { of ActiveWindow }

function WinError;
   begin
      WinError:= WError;
      WError:= WinOk
   end;  { of WinError }

function WindowButtonList;
   begin
      WindowButtonList := WinArray[WindowID]^.buttonList;
   end;

function WindowButtonCount;
   begin
      WindowButtonCount := WinArray[WindowID]^.buttonCnt;
   end;

function WindowTag;
   begin
      WindowTag := WinArray[WindowID]^.tag;
   end;

procedure WindowButtonSelected;
   begin
      WinArray[WindowID]^.selectedBtn := btn;
   end;

function WindowLastButton;
   begin
      WindowLastButton := WinArray[WindowID]^.selectedBtn;
   end;

procedure DefineWindow;
   var
      NewWDR : WindowDefinitionRecordPtr;  { Pointer to new WDR }

   begin
      if WindowID = 0 then
         begin
         WindowError(WinDefZero);
         Exit
         end;
      if NumDefinedWindows = 1 then
         begin
         MaxCols:= Lo(WindMax)+1;
         MaxRows:= Hi(WindMax)+1;
         with WinArray[0]^ do
            begin
            RightCol:= MaxCols;
            BottomRow:= MaxRows
            end
         end;
      if (LeftCol<1) or (LeftCol>MaxCols) or (RightCol<1)
         or (RightCol>MaxCols) or (TopRow<1) or (TopRow>MaxRows)
         or (BottomRow<1) or (BottomRow>MaxRows) or (LeftCol>RightCol)
         or (TopRow>BottomRow) then
         begin
         WindowError(WinDefCoor);
         Exit
         end;
      if WindowDefined(WindowID) then
         begin
         WindowError(WinDefRedef);
         Exit
         end;
      New(NewWDR);
      if NewWDR = nil then
         begin
         WindowError(WinDefMem);
         Exit
         end;
      NewWDR^.LeftCol              := LeftCol;
      NewWDR^.TopRow               := TopRow;
      NewWDR^.RightCol             := RightCol;
      NewWDR^.BottomRow            := BottomRow;
      NewWDR^.WindowAttr           := WindowAttr;
      NewWDR^.BorderDef.BorderStr  := BorderStr;
      NewWDR^.BorderDef.BorderAttr := BorderAttr;
      NewWDR^.BorderDef.HeaderStr  := HeaderStr;
      NewWDR^.BorderDef.HeaderAttr := HeaderAttr;
      NewWDR^.BorderDef.HeaderJust := HeaderJust;
      NewWDR^.BorderDef.FooterStr  := FooterStr;
      NewWDR^.BorderDef.FooterAttr := FooterAttr;
      NewWDR^.BorderDef.FooterJust := FooterJust;
      NewWDR^.UserFlags            := UserFlags;
      NewWDR^.SysFlags      := 0;
      NewWDR^.SaveCursorCol := 1;
      NewWDR^.SaveCursorRow := 1;
      NewWDR^.SaveTextAttr  := 0;
      NewWDR^.SaveScreen    := nil;
      NewWDR^.tag           := tag;
      NewWDR^.buttonCnt     := buttonCnt;
      GetMem(NewWDR^.buttonList,buttonCnt*SizeOf(buttonDisp));
      WinArray[WindowID]:= NewWDR;
      Inc(NumDefinedWindows);
      WindowError(WinOk);
   end;  { of DefineWindow }

procedure DeleteWindow;
   begin
      if WindowID = 0 then
         begin
         WindowError(WinDelZero);
         Exit
         end;
      if not WindowDefined(WindowID) then
         begin
         WindowError(WinDelUndef);
         Exit
         end;
      if WindowOpen(WindowID) then
         begin
         WindowError(WinDelOpen);
         Exit
         end;
      With WinArray[WindowID]^ Do
      FreeMem(buttonList,buttonCnt*SizeOf(buttonDisp));
      Dispose(WinArray[WindowID]);
      WinArray[WindowID]:= nil;
      Dec(NumDefinedWindows);
      WindowError(WinOk);
   end;  { of DeleteWindow }

procedure SelectWindow;
   begin
      if not WindowDefined(WindowID) then
         begin
         WindowError(WinSlcUndef);
         Exit
         end;
      if not WindowOpen(WindowID) then
         begin
         WindowError(WinSlcClose);
         Exit
         end;
      if WindowHidden(WindowID) then
         begin
         WindowError(WinSlcHidden);
         Exit
         end;
      with WinArray[ActiveWin]^ do
         begin
         SaveCursorCol := WhereX;
         SaveCursorRow := WhereY;
         SaveTextAttr  := TextAttr
         end;
      with WinArray[WindowID]^ do
         if not FlagSet(UserFlags,DisplayBorder) or
                FlagSet(UserFlags,WriteOnBorder) then
            Window(LeftCol, TopRow, RightCol, BottomRow)
         else
            Window(LeftCol+1, TopRow+1, RightCol-1, BottomRow-1);
      with WinArray[WindowID]^ do
         begin
         GotoXY(SaveCursorCol,SaveCursorRow);
         TextAttr:= SaveTextAttr
         end;
      ActiveWin:= WindowID;
      WindowError(WinOk);
   end;  { of SelectWindow }

procedure SaveArea
   (LeftCol    : byte;              { Left column coordinate  }
    TopRow     : byte;              { Top row coordinate      }
    RightCol   : byte;              { Right column coordinate }
    BottomRow  : byte;              { Bottom row coordinate   }
    var MemPtr : ScreenBlockPtr);   { Pointer to memory block }
   var
      LineLen : byte;   { Stores the width of the window         }
      Ndx     : word;   { Indexes the heap memory block by lines }
      i       : byte;   { Indexes the row counter when saving    }
   begin
      LineLen:= RightCol - LeftCol + 1;
      GetMem(MemPtr,LineLen*(BottomRow-TopRow+1)*2);
      if MemPtr = nil then
         Exit;
      Ndx:= 1;    { Start at the top of MemPtr block }
      for i:= TopRow to BottomRow do   { Iterate for each row }
         begin
         MoveFromScreen(Screen^[i,LeftCol],MemPtr^[Ndx],LineLen*2);
         Inc(Ndx,LineLen)  { Move index to spot for next line }
         end;
   end;  { of SaveArea }

procedure RestoreArea
   (LeftCol    : byte;              { Left column coordinate  }
    TopRow     : byte;              { Top row coordinate      }
    RightCol   : byte;              { Right column coordinate }
    BottomRow  : byte;              { Bottom row coordinate   }
    var MemPtr : ScreenBlockPtr);   { Pointer to memory block }
   var
      LineLen : byte;   { Stores the width of the window         }
      Ndx     : word;   { Indexes the heap memory block by lines }
      i       : byte;   { Indexes the row counter when restoring }
   begin
      LineLen:= RightCol - LeftCol + 1;
      Ndx:= 1;    { Start at the top of MemPtr block }
      for i:= TopRow to BottomRow do   { Iterate for each row }
         begin
         MoveToScreen(MemPtr^[Ndx],Screen^[i,LeftCol],LineLen*2);
         Inc(Ndx,LineLen)  { Move index to spot for next line }
         end;
      FreeMem(MemPtr,LineLen*(BottomRow-TopRow+1)*2);
      MemPtr:= nil;
   end;  { of RestoreArea }

procedure DrawBorder
   (X1, Y1, X2, Y2 : byte;             { border coordinates }
    BorderDef      : BorderDefType);   { border definition record }
   var
      BAttr        : word;            { border attribute }
      HAttr        : word;            { header attribute }
      FAttr        : word;            { footer attribute }
      LineLength   : byte;
      HeaderStart  : byte;
      FooterStart  : byte;
      HeaderLen    : byte;
      FooterLen    : byte;
      HeaderNdx    : byte;
      FooterNdx    : byte;
      LeftSideWord : word;
      RightSideWord: word;
      TopLine      : ScreenLine;
      BottomLine   : ScreenLine;
      i            : byte;            { counter }
      LastPos      : byte;            { last legal position in BorderStr }
   begin
      with BorderDef do
         begin
         if Length(BorderStr) = 0 then
            BorderStr:= ' ';
         LastPos:= Length(BorderStr);
         LineLength:= Succ(X2-X1);
         BAttr:= BorderAttr shl 8;
         HAttr:= HeaderAttr shl 8;
         FAttr:= FooterAttr shl 8;
         HeaderLen:= Length(HeaderStr);
         FooterLen:= Length(FooterStr);
         case HeaderJust of
            Left:   HeaderStart:= 2;
            Right:  HeaderStart:= LineLength-HeaderLen;
            Center: HeaderStart:= (LineLength-HeaderLen) div 2 + 1
            end;
         case FooterJust of
            Left:   FooterStart:= 2;
            Right:  FooterStart:= LineLength-FooterLen;
            Center: FooterStart:= (LineLength-FooterLen) div 2 + 1
            end;
         HeaderNdx:= 1;
         FooterNdx:= 1;
         for i:= 2 to LineLength-1 do
            begin
            if (i >= HeaderStart) and (i <= HeaderStart+HeaderLen-1) then
               begin
               TopLine[i]:= HAttr + Byte(HeaderStr[HeaderNdx]);
               Inc(HeaderNdx)
               end
            else
               TopLine[i]:= BAttr + Byte(BorderStr[Min(2,LastPos)]);
            if (i >= FooterStart) and (i <= FooterStart+FooterLen-1) then
               begin
               BottomLine[i]:= FAttr + Byte(FooterStr[FooterNdx]);
               Inc(FooterNdx)
               end
            else
               BottomLine[i]:= BAttr + Byte(BorderStr[Min(6,LastPos)]);
            end;
         TopLine[1]:= BAttr + Byte(BorderStr[Min(1,LastPos)]);
         TopLine[LineLength]:= BAttr + Byte(BorderStr[Min(3,LastPos)]);
         BottomLine[1]:= BAttr + Byte(BorderStr[Min(7,LastPos)]);
         BottomLine[LineLength]:= BAttr + Byte(BorderStr[Min(5,LastPos)]);
         MoveToScreen(TopLine,Screen^[Y1,X1],LineLength*2);
         MoveToScreen(BottomLine,Screen^[Y2,X1],LineLength*2);
         LeftSideWord:= BAttr + Byte(BorderStr[Min(8,LastPos)]);
         RightSideWord:= BAttr + Byte(BorderStr[Min(4,LastPos)]);
         for i:= Y1+1 to Y2-1 do
            begin
            MoveToScreen(LeftSideWord,Screen^[i,X1],2);
            MoveToScreen(RightSideWord,Screen^[i,X2],2)
            end;
         end;  {with}
   end;  { of DrawBorder }

procedure OpenWindow;
   begin
      if WindowID = 0 then
         begin
         WindowError(WinOpnZero);
         Exit
         end;
      if not WindowDefined(WindowID) then
         begin
         WindowError(WinOpnUndef);
         Exit
         end;
      if WindowOpen(WindowID) then
         begin
         WindowError(WinOpnOpen);
         Exit
         end;
      with WinArray[WindowID]^ do
         if FlagSet(UserFlags,SaveContents) then
            begin
            SaveArea(LeftCol,TopRow,RightCol,BottomRow,SaveScreen);
            if SaveScreen = nil then
               begin
               WindowError(WinOpnMem);
               Exit
               end
            end;
      with WinArray[ActiveWin]^ do
         begin
         SaveCursorCol := WhereX;
         SaveCursorRow := WhereY;
         SaveTextAttr  := TextAttr
         end;
      WITH WinArray[WindowID]^ Do Begin
         IF FlagSet(UserFlags,DisplayBorder) Then Begin
            DrawBorder(LeftCol, TopRow, RightCol, BottomRow, BorderDef);
            IF (FlagSet(UserFlags,ClearScreen))
            AND ((BottomRow - TopRow) > 1) Then Begin
               { Set the viewport and clear it }
               Window(LeftCol+1, TopRow+1, RightCol-1, BottomRow-1);
               TextAttr := WindowAttr;
               ClrScr;
            END;
         END
         Else
            IF FlagSet(UserFlags,ClearScreen) Then Begin
               Window(LeftCol, TopRow, RightCol, BottomRow);
               TextAttr := WindowAttr;
               ClrScr;
            END;
      END;
      with WinArray[WindowID]^ do
         if not FlagSet(UserFlags,DisplayBorder) or
                FlagSet(UserFlags,WriteOnBorder) then
            Window(LeftCol, TopRow, RightCol, BottomRow)
         else
            Window(LeftCol+1, TopRow+1, RightCol-1, BottomRow-1);
      with WinArray[WindowID]^ do
         Inc(SysFlags,WinOpen);
      ActiveWin:= WindowID;
      Inc(NumOpenWindows);
      WindowError(WinOk);
   end;  { of OpenWindow }

procedure CloseWindow;
   begin
      if WindowID = 0 then
         begin
         WindowError(WinClsZero);
         Exit
         end;
      if not WindowDefined(WindowID) then
         begin
         WindowError(WinClsUndef);
         Exit
         end;
      if not WindowOpen(WindowID) then
         begin
         WindowError(WinClsClose);
         Exit
         end;
      with WinArray[WindowID]^ do
         if not WindowHidden(WindowID) and
            FlagSet(UserFlags,SaveContents) then
            RestoreArea(LeftCol,TopRow,RightCol,BottomRow,SaveScreen);
      with WinArray[WindowID]^ do
         if WindowHidden(WindowID) then
            begin
            FreeMem(SaveScreen,(RightCol-LeftCol+1)*(BottomRow-TopRow+1)*2);
            SaveScreen:= nil
            end;
      if ActiveWin = WindowID then
         SelectWindow(0);
      with WinArray[WindowID]^ do
         begin
         Dec(SysFlags,WinOpen);
         if WindowHidden(WindowID) then
            Dec(SysFlags,WinHidden)
         end;
      Dec(NumOpenWindows);
      with WinArray[WindowID]^ do
         if WindowHidden(WindowID) then
            Dec(NumHiddenWindows);
      WindowError(WinOk);
   end;  { of CloseWindow }

procedure HideWindow;
   var
      SaveWindow: ScreenBlockPtr;   { Pointer to contents of current window }
   begin
      if WindowID = 0 then
         begin
         WindowError(WinHidZero);
         Exit
         end;
      if not WindowDefined(WindowID) then
         begin
         WindowError(WinHidUndef);
         Exit
         end;
      if not WindowOpen(WindowID) then
         begin
         WindowError(WinHidClose);
         Exit
         end;
      if WindowHidden(WindowID) then
         begin
         WindowError(WinHidHidden);
         Exit
         end;
      with WinArray[WindowID]^ do
         SaveArea(LeftCol,TopRow,RightCol,BottomRow,SaveWindow);
      if SaveWindow = nil then
         begin
         WindowError(WinHidMem);
         Exit
         end;
      with WinArray[WindowID]^ do
         if FlagSet(UserFlags,SaveContents) then
            RestoreArea(LeftCol,TopRow,RightCol,BottomRow,SaveScreen);
      with WinArray[WindowID]^ do
         SaveScreen:= SaveWindow;
      with WinArray[WindowID]^ do
         Inc(SysFlags,WinHidden);
      if ActiveWin = WindowID then
         SelectWindow(0);
      Inc(NumHiddenWindows);
      WindowError(WinOk);
   end;  { of HideWindow }

procedure DisplayWindow;
   var
      SaveWindow: ScreenBlockPtr;   { Pointer to contents of area under }
                                    { window                            }
   begin
      if WindowID = 0 then
         begin
         WindowError(WinDspZero);
         Exit
         end;
      if not WindowDefined(WindowID) then
         begin
         WindowError(WinDspUndef);
         Exit
         end;
      if not WindowOpen(WindowID) then
         begin
         WindowError(WinDspClose);
         Exit
         end;
      if not WindowHidden(WindowID) then
         begin
         WindowError(WinDspHidden);
         Exit
         end;
      with WinArray[WindowID]^ do
         if FlagSet(UserFlags,SaveContents) then
            begin
            SaveArea(LeftCol,TopRow,RightCol,BottomRow,SaveWindow);
            if SaveScreen = nil then
               begin
               WindowError(WinDspMem);
               Exit
               end
            end;
      with WinArray[WindowID]^ do
         if FlagSet(UserFlags,SaveContents) then
            RestoreArea(LeftCol,TopRow,RightCol,BottomRow,SaveScreen);
      with WinArray[WindowID]^ do
         if FlagSet(UserFlags,SaveContents) then
            SaveScreen:= SaveWindow;
      with WinArray[WindowID]^ do
         Dec(SysFlags,WinHidden);
      Dec(NumHiddenWindows);
      WindowError(WinOk);
   end;  { of DisplayWindow }

procedure RelocateWindow;
   var
      WinWidth    : byte;
      WinHeight   : byte;
      NewRightCol : byte;
      NewBottomRow: byte;
   begin
      if not WindowDefined(WindowID) then
         begin
         WindowError(WinRelUndef);
         Exit
         end;
      if not WindowOpen(WindowID) then
         begin
         WindowError(WinRelClose);
         Exit
         end;
      with WinArray[WindowID]^ do
         begin
         WinWidth    := RightCol - LeftCol + 1;
         WinHeight   := BottomRow - TopRow + 1;
         NewRightCol := NewLeftCol + WinWidth - 1;
         NewBottomRow:= NewTopRow + WinHeight - 1;
         if (NewLeftCol<1) or (NewLeftCol>MaxCols) 
            or (NewRightCol<1) or (NewRightCol>MaxCols)  
            or (NewTopRow<1) or (NewTopRow>MaxRows)  
            or (NewBottomRow<1) or (NewBottomRow>MaxRows) then
            begin
            WindowError(WinRelCoor);
            Exit
            end
         end;
      with WinArray[WindowID]^ do
         if WindowHidden(WindowID) then
            begin
            LeftCol  := NewLeftCol;
            RightCol := NewRightCol;
            TopRow   := NewTopRow;
            BottomRow:= NewBottomRow;
            end
         else
            begin    { be sure and check for errors after Hide and Display }
            HideWindow(WindowID);
            LeftCol  := NewLeftCol;
            RightCol := NewRightCol;
            TopRow   := NewTopRow;
            BottomRow:= NewBottomRow;
            DisplayWindow(WindowID)
            end;
      WindowError(WinOk);
   end;  { of RelocateWindow }

procedure MoveWindow;
   var
      LineLength: byte;             { Character length of a window line }
      LineBytes : byte;             { Length of window line in bytes    }
      ColLength : byte;             { Height of window in rows          }
      ColBytes  : byte;             { Height in bytes                   }
      WinWords  : word;             { Number of words in window area    }
      WinBytes  : word;             { Number of bytes in window area    }
      SaveLine  : ScreenBlockPtr;   { Holds a line of characters        }
      SaveCol   : ScreenBlockPtr;   { Holds a column of characters      }
      TempLine  : ScreenBlockPtr;   { Temporary line holder for copying }
      CurX      : byte;             { Current cursor X coordinate       }
      CurY      : byte;             { Current cursor Y coordinate       }
      i         : byte;             { Indexes for loops                 }
   begin
      if not WindowDefined(WindowID) then
         begin
         WindowError(WinMovUndef);
         Exit
         end;
      if not WindowOpen(WindowID) then
         begin
         WindowError(WinMovClose);
         Exit
         end;
      if WindowHidden(WindowID) then
         begin
         WindowError(WinMovHidden);
         Exit
         end;
      with WinArray[WindowID]^ do
         begin
         LineLength:= RightCol - LeftCol + 1;
         ColLength := BottomRow - TopRow + 1;
         LineBytes := LineLength * 2;
         ColBytes  := ColLength * 2;
         WinWords  := LineLength * ColLength;
         WinBytes  := WinWords * 2;
         CurX      := WhereX;
         CurY      := WhereY;
         case Direction of
            UpDir:         { Move up one row. }
               begin
               if TopRow = 1 then
                  begin
                  WindowError(WinMovCoor);
                  Exit
                  end;
               SaveArea(LeftCol,TopRow-1,RightCol,TopRow-1,SaveLine);
               if SaveLine = nil then
                  begin
                  WindowError(WinMovMem);
                  Exit
                  end;
               GetMem(TempLine,LineBytes);
               if TempLine = nil then
                  begin
                  WindowError(WinMovMem);
                  Exit
                  end;
               for i:= TopRow to BottomRow do
                  begin
                  MoveFromScreen(Screen^[i,LeftCol],TempLine^,LineBytes);
                  MoveToScreen  (TempLine^,Screen^[i-1,LeftCol],LineBytes)
                  end;
               FreeMem(TempLine,LineBytes);
               MoveToScreen(SaveScreen^[WinWords-LineLength+1],
                            Screen^[BottomRow,LeftCol],LineBytes);
               Move(SaveScreen^,SaveScreen^[LineLength+1],WinBytes-LineBytes);
               Move(SaveLine^,SaveScreen^,LineBytes);
               FreeMem(SaveLine,LineBytes);
               Dec(TopRow);
               Dec(BottomRow);
               if WindowID = ActiveWin then
                  begin
                  Window(Lo(WindMin)+1,   { Upper-left  X             }
                         Hi(WindMin)+0,   { Upper-left  Y decremented }
                         Lo(WindMax)+1,   { Lower-right X             }
                         Hi(WindMax)+0);  { Lower-right Y decremented }
                  GotoXY(CurX,CurY)
                  end
               end;
            DownDir:         { Move down one row. }
               begin
               if BottomRow = MaxRows then
                  begin
                  WindowError(WinMovCoor);
                  Exit
                  end;
               SaveArea(LeftCol,BottomRow+1,RightCol,BottomRow+1,SaveLine);
               if SaveLine = nil then
                  begin
                  WindowError(WinMovMem);
                  Exit
                  end;
               GetMem(TempLine,LineBytes);
               if TempLine = nil then
                  begin
                  WindowError(WinMovMem);
                  Exit
                  end;
               for i:= BottomRow downto TopRow do
                  begin
                  MoveFromScreen(Screen^[i,LeftCol],TempLine^,LineBytes);
                  MoveToScreen  (TempLine^,Screen^[i+1,LeftCol],LineBytes)
                  end;
               FreeMem(TempLine,LineBytes);
               MoveToScreen(SaveScreen^,Screen^[TopRow,LeftCol],LineBytes);
               Move(SaveScreen^[LineLength+1],SaveScreen^,WinBytes-LineBytes);
               Move(SaveLine^,SaveScreen^[WinWords-LineLength+1],LineBytes);
               FreeMem(SaveLine,LineBytes);
               Inc(TopRow);
               Inc(BottomRow);
               if WindowID = ActiveWin then
                  begin
                  Window(Lo(WindMin)+1,   { Upper-left  X             }
                         Hi(WindMin)+2,   { Upper-left  Y incremented }
                         Lo(WindMax)+1,   { Lower-right X             }
                         Hi(WindMax)+2);  { Lower-right Y incremented }
                  GotoXY(CurX,CurY)
                  end
               end;
            LeftDir:         { Move left one column. }
               begin
               if LeftCol = 1 then
                  begin
                  WindowError(WinMovCoor);
                  Exit
                  end;
               GetMem(SaveCol,ColBytes);
               if SaveCol = nil then
                  begin
                  WindowError(WinMovMem);
                  Exit
                  end;
               GetMem(TempLine,LineBytes);
               if TempLine = nil then
                  begin
                  WindowError(WinMovMem);
                  Exit
                  end;
               for i:= TopRow to BottomRow do
                  MoveFromScreen(Screen^[i,LeftCol-1],SaveCol^[i-TopRow+1],2);
               for i:= TopRow to BottomRow do
                  begin
                  MoveFromScreen(Screen^[i,LeftCol],TempLine^,LineBytes);
                  MoveToScreen  (TempLine^,Screen^[i,LeftCol-1],LineBytes)
                  end;
               FreeMem(TempLine,LineBytes);
               for i:= TopRow to BottomRow do
                  MoveToScreen(SaveScreen^[(i-TopRow+1)*LineLength],
                               Screen^[i,RightCol],2);
               for i:= 0 to ColLength-1 do
                  begin
                  Move(SaveScreen^[i*LineLength+1],
                       SaveScreen^[i*LineLength+2],
                       LineBytes-2);
                  SaveScreen^[i*LineLength+1]:= SaveCol^[i+1]
                  end;
               FreeMem(SaveCol,ColBytes);
               Dec(LeftCol);
               Dec(RightCol);
               if WindowID = ActiveWin then
                  begin
                  Window(Lo(WindMin)+0,   { Upper-left  X decremented }
                         Hi(WindMin)+1,   { Upper-left  Y             }
                         Lo(WindMax)+0,   { Lower-right X decremented }
                         Hi(WindMax)+1);  { Lower-right Y             }
                  GotoXY(CurX,CurY)
                  end
               end;
            RightDir:      { Move right one column. }
               begin
               if RightCol = MaxCols then
                  begin
                  WindowError(WinMovCoor);
                  Exit
                  end;
               GetMem(SaveCol,ColBytes);
               if SaveCol = nil then
                  begin
                  WindowError(WinMovMem);
                  Exit
                  end;
               GetMem(TempLine,LineBytes);
               if TempLine = nil then
                  begin
                  WindowError(WinMovMem);
                  Exit
                  end;
               for i:= TopRow to BottomRow do
                  MoveFromScreen(Screen^[i,RightCol+1],SaveCol^[i-TopRow+1],2);
               for i:= TopRow to BottomRow do
                  begin
                  MoveFromScreen(Screen^[i,LeftCol],TempLine^,LineBytes);
                  MoveToScreen  (TempLine^,Screen^[i,LeftCol+1],LineBytes)
                  end;
               FreeMem(TempLine,LineBytes);
               for i:= TopRow to BottomRow do
                  MoveToScreen(SaveScreen^[(i-TopRow)*LineLength+1],
                               Screen^[i,LeftCol],2);
               for i:= 0 to ColLength-1 do
                  begin
                  Move(SaveScreen^[i*LineLength+2],
                       SaveScreen^[i*LineLength+1],
                       LineBytes-2);
                  SaveScreen^[(i+1)*LineLength]:= SaveCol^[i+1]
                  end;
               FreeMem(SaveCol,ColBytes);
               Inc(LeftCol);
               Inc(RightCol);
               if WindowID = ActiveWin then
                  begin
                  Window(Lo(WindMin)+2,   { Upper-left  X incremented }
                         Hi(WindMin)+1,   { Upper-left  Y             }
                         Lo(WindMax)+2,   { Lower-right X incremented }
                         Hi(WindMax)+1);  { Lower-right Y             }
                  GotoXY(CurX,CurY)
                  end
               end;
            end; {case}
         end; {with}
      WindowError(WinOk);
   end;  { of MoveWindow }


begin
   MaxCols:= Lo(WindMax)+1;
   MaxRows:= Hi(WindMax)+1;
   HeapError := @HeapFunc;
   for i:= 0 to 255 do
      WinArray[i]:= nil;
   New(NewWDR);
   with NewWDR^ do
      begin
      LeftCol:= 1;
      TopRow:= 1;
      RightCol:= MaxCols;
      BottomRow:= MaxRows;
      WindowAttr:= TextAttr;
      UserFlags:= 0;
      SysFlags:= WinOpen;
      SaveCursorCol:= 1;
      SaveCursorRow:= 1;
      SaveTextAttr:= TextAttr;
      SaveScreen:= nil
      end;
   WinArray[0]:= NewWDR;
   ActiveWin         := 0;
   NumDefinedWindows := 1;
   NumOpenWindows    := 1;
   NumHiddenWindows  := 0;
   if Mono then
      begin
      Screen:= Ptr($B000,0);
      CheckSnow:= false
      end
   else
      begin
      Screen:= Ptr($B800,0);
      if EGAInstalled then
         CheckSnow:= false
      end;
end.  { of unit Windows }

