Unit DEU1;

{ Written by Steve T. Jones                                              }
{            Indiana University at Kokomo                                }
{            2300 South Washington Street                                }
{            Kokomo, IN 46902                                            }
{            (317) 453-2000                                              }
{            KCDZ100@INDYCMS                                             }
{            June 5, 1989                                                }

Interface

Uses Crt,          { Turbo Pascal }
     Dos,          { Turbo Pascal }
     StrFuncs,     { Miscellaneous string functions, Steve T. Jones   }
     DEWindU,      { Window routines, modified version TWIND20        }
     VideoU,       { Display routines, based on O'Brien (see source)  }
     KyBrdU,       { Keyboard routines, also based on O'Brien         }
     HTCDEU0,      { Common definitions for both compiler and display }
     MousU;        { Mouse routines, based on O'Brien                 }

TYPE
  fileNameStr = String[67];

VAR
   hyperDbName,
   hyperIndexName    : FileNameStr;
   hyperDataBase     : dbFile;
   hyperIndex        : idxFile;

FUNCTION displayHypertext (VAR  ixf : idxFile;  VAR ix  : Pointer;
                           VAR  dbf : dbFile ;       t  : buttonTag)
                          : Integer;

{ Returns error code: 1XX: not enough memory for frame index           }
{                     2XX: requested frame not in index                }
{                     3XX: not enough memory (less than minHeap below) }
{                     4XX: version number conflict                     }
{                 X00-X35: window error                                }

(***************************************************************************)
(**)                                                                     (**)
(**)                            Implementation                           (**)
(**)                                                                     (**)
(***************************************************************************)

CONST
   DEVersion = 1.21;  { Must be >= g_HTCDefs.HTCVers }
   minHeap   = 4512;  { Minimum memory set aside for displayHelp and  }
                      { freeMemory functions                          }

TYPE
   idxPtr      = ^dbIndexRec;
   dbIndexRec  = Record
                   entry      : idxRec;
                   next, prev : idxPtr;
                 End;
   inBuffer    = Array[1..125] Of dbRec;

VAR
   pgmErr     : Integer;
   winErr     : Integer;
   g_HTCdefs  : dbRec;
   g_FreePtr  : Pointer;


PROCEDURE freeMemory (VAR w : Byte; tag : buttonTag);

{ Called from displayFrame when MemAvail < minHeap.  Allows user to cancel }
{ the requested display, (2) back up to the first frame and start over, or }
{ (3) back up to one of several previous frames chosen by this routine.    }
{ Option display and selection are done with buttons in the same way as    }
{ button display and selection.                                            }
{                                                                          }
{ Selection criteria are: selects up to maxFrames (CONST) previous frames  }
{ including the topFrames (CONST) moust recent; selects an earlier copy of }
{ the requested frame; selects an earlier copy of the current frame;       }
{ selects frames which contain a reference to the requested frame.         }

CONST
  req = #2;
  dup = #240;
  ref = #15;
  maxFrames = 15;
  topFrames = 7;
  i1 = ' ERROR: Unable to display "';
  i2 = '  Due to limited computer memory, the '
       + 'requested topic cannot be displayed.';
  i3 = '  You can (1) cancel the request and '
       + 'back up a few frames on your own, ';
  i4 = '  (2) return to the first screen and '
       + 'start over, or (3) back up to one of ';
  i5 = '  the frames listed below.  Make your '
       + 'choice in the usual manner.';
  i6 = '          '+req+' Requested Frame        '+dup
       + ' Duplicate of Current Frame';
  i7 = '          '+ref+' Contains a Reference to the Requested Frame';
  o1 = 'Cancel request';
  o2 = 'Return to the first screen';
  f  = ' TO SELECT: Use '+#24+' '+#27+' '+#26+' '+#25+' '+#17
       +' or Corresponding Mouse Buttons ';
TYPE
  frameLine   = Record
                   txt : String[60];
                   num : Byte;
                End;
  coords      = Record
                  x, y : Byte;
                End;

VAR
  ch          : Char;
  fk          : Boolean;
  ky          : KeyType;
  displayFrs  : Array[1..maxFrames] Of frameLine;
  i,j,k       : Byte;
  currTag,
  srchTag,
  prevTag     : buttonTag;
  ba          : buttonArray;
  opts        : Array[1..maxFrames+2] Of coords;

BEGIN (* freeMemory *)
    { Set up coordinates for first two option buttons }
    opts[1].x := 13;
    opts[1].y := 5;
    opts[2].x := 36;
    opts[2].y := 5;
    { Make requested and current frame tags upper case }
    srchTag := UpCaseStr(tag);
    currTag := UpCaseStr(WindowTag(w));
    { Retreive memory previously reserved by setUpHelpWins }
    FreeMem(g_FreePtr,minHeap);
    defineWindow (254,1,1,80,25,
                  Attr(g_HTCdefs.defColors[TextF],
                  g_HTCdefs.defColors[TextB]),DoubleBorder,
                  Attr(g_HTCdefs.defColors[BordF],
                  g_HTCdefs.defColors[BordB]),
                  i1+tag+'" ',Attr(g_HTCdefs.defColors[BordF],
                  g_HTCdefs.defColors[BordB]),
                  Center,f,
                  Attr(g_HTCdefs.defColors[BordF],
                  g_HTCdefs.defColors[BordB]),
                  Center,DeFaultFlag,'',0);
    OpenWindow(254);
    { Display instructions }
    WriteLn(i2);
    WriteLn(i3);
    WriteLn(i4);
    WriteLn(i5);
    GotoXY(24-(Length(WindowTag(w)) Div 2),23);
    Write('Currently Viewing "',WindowTag(w),'" [Frame ',w,']');
    TextColor(g_HTCDefs.defColors[buttonF]);
    TextBackGround(g_HTCDefs.defColors[buttonB]);
    { Display first two options buttons }
    GotoXY(opts[1].x,opts[1].y);
    Write(o1);
    GotoXY(opts[2].x,opts[2].y);
    Write(o2);
    j := w;
    i := 1;
    { Work backwards from current window looking for appropriate frames }
    REPEAT
      displayFrs[i].txt := '';
      j := j - 1;
      prevTag := UpCaseStr(WindowTag(j));
      { Tag from previous window [j] = tag of current window? }
      IF prevTag = currTag Then Begin
         displayFrs[i].txt := dup + ' Back Up To [Frame'
                          + spaces(4-Length(N2Str(j,1,0)))
                          + N2Str(j,1,0) + '] '
                          + WindowTag(j);
         displayFrs[i].num := j;
         GotoXY(11,5+i);
         Write(displayFrs[i].txt);
         opts[2+i].x := 11;
         opts[2+i].y := 5+i;
         i := i + 1;
      END
      Else
         { Tag from previous window [j] = tag of requested frame? }
         IF prevTag = srchTag Then Begin
            displayFrs[i].txt := req + ' Back Up To [Frame'
                             + spaces(4-Length(N2Str(j,1,0)))
                             + N2Str(j,1,0) + '] '
                             + WindowTag(j);
            displayFrs[i].num := j;
            GotoXY(11,5+i);
            Write(displayFrs[i].txt);
            opts[2+i].x := 11;
            opts[2+i].y := 5+i;
            i := i + 1;
         END
         ELSE Begin
            { Point to button list of previous window [j]
            ba := WindowButtonList(j);
            { Any buttons = tag of requested frame? }
            For k := 0 To (WindowButtonCount(j) - 1) Do
               IF UpCaseStr(ba^[k].tag) = srchTag Then Begin
                  displayFrs[i].txt := ref + ' Back Up To [Frame'
                                   + spaces(4-Length(N2Str(j,1,0)))
                                   + N2Str(j,1,0) + '] '
                                   + WindowTag(j);
                  displayFrs[i].num := j;
                  GotoXY(11,5+i);
                  Write(displayFrs[i].txt);
                  opts[2+i].x := 11;
                  opts[2+i].y := 5+i;
               END;
            { Increment options index if one was found }
            If displayFrs[i].txt <> '' Then i := i + 1;
         END;
         { If none of above, Then ... }
         If displayFrs[i].txt = '' Then
            { Room to display all frames? Or Still looking at most recent? }
            IF (w <= maxFrames) Or (i < topFrames) Then Begin
               displayFrs[i].txt := '  Back Up To [Frame'
                                + spaces(4-Length(N2Str(j,1,0)))
                                + N2Str(j,1,0) + '] '
                                + WindowTag(j);
               displayFrs[i].num := j;
               GotoXY(11,5+i);
               Write(displayFrs[i].txt);
               opts[2+i].x := 11;
               opts[2+i].y := 5+i;
               i := i + 1;
            END;
    UNTIL (i > maxFrames) Or (j = 2);
    { i is 1 greater than number of frames selected for display }
    { i - 1 is correct number, + options 1 and 2, so ... }
    i := i + 1;
    j := 1;
    { Hilite first option }
    TextColor(g_HTCDefs.defColors[TextF]);
    TextBackGround(g_HTCDefs.defColors[TextB]);
    WriteLn;
    WriteLn(i6);
    Write(i7);
    TextColor(g_HTCDefs.defColors[HiliteF]);
    TextBackGround(g_HTCDefs.defColors[HiliteB]);
    GotoXY(opts[1].x,opts[1].y);
    Write(o1);
    { Cycle through options until carriage return }
    REPEAT
       InKeyOrMouse(ch,fk,ky);
       CASE ky Of
          LeftArrow,
          UpArrow        : Begin
                              GotoXY(opts[j].x,opts[j].y);
                              TextColor(g_HTCDefs.defColors[buttonF]);
                              TextBackGround(g_HTCDefs.defColors[buttonB]);
                              CASE j Of
                                 1 : Write(o1);
                                 2 : Write(o2);
                              Else Write(displayFrs[j-2].txt);
                              END;
                              If j = 1 Then j := i
                              Else j := j - 1;
                              GotoXY(opts[j].x,opts[j].y);
                              TextColor(g_HTCDefs.defColors[HiliteF]);
                              TextBackGround(g_HTCDefs.defColors[HiliteB]);
                              CASE j Of
                                 1 : Write(o1);
                                 2 : Write(o2);
                              Else Write(displayFrs[j-2].txt);
                              END;
                           End;
          RightArrow,
          DownArrow      : Begin
                              GotoXY(opts[j].x,opts[j].y);
                              TextColor(g_HTCDefs.defColors[buttonF]);
                              TextBackGround(g_HTCDefs.defColors[buttonB]);
                              CASE j Of
                                 1 : Write(o1);
                                 2 : Write(o2);
                              Else Write(displayFrs[j-2].txt);
                              END;
                              If j = i Then j := 1
                              Else j := j + 1;
                              GotoXY(opts[j].x,opts[j].y);
                              TextColor(g_HTCDefs.defColors[HiliteF]);
                              TextBackGround(g_HTCDefs.defColors[HiliteB]);
                              CASE j Of
                                 1 : Write(o1);
                                 2 : Write(o2);
                              Else Write(displayFrs[j-2].txt);
                              END;
                           End;
          CarriageReturn : Begin End;
       Else
          Write(#7);
       END;
    UNTIL ky = CarriageReturn;
    { Get rid of this window }
    CloseWindow(254);
    DeleteWindow(254);
    { User pick something other than cancel? }
    If j > 1 Then
       { Back up to first frame? }
       If j = 2 Then
          REPEAT
             CloseWindow(w);
             DeleteWindow(w);
             w := w - 1;
          UNTIL w = 1
       { Back up to selected frame }
       Else
          REPEAT
             CloseWindow(w);
             DeleteWindow(w);
             w := w - 1;
          UNTIL w = displayFrs[j-2].num;
    { Re-reserve memory }
    GetMem(g_FreePtr,minHeap);
END; (* freeMemory *)

PROCEDURE determineLoc (hdrW, hdrL : Byte; tag : buttonTag; VAR x, y : Byte);

{ Determine coordinates of the new window relative to the position of the }
{ button which selected it                                                }

  VAR buttonL, buttonR,
      buttonY, buttonC,
      winULX,  winULY,
      winLRX,  winLRY,
      maxTop,  minBot,
      maxL,    minR      : Byte;

  BEGIN (* determineLoc *)
    { Maximum height? }
    If hdrL = MaxLines Then y := 1
    ELSE Begin
       { Figure out where the current button is on the physical screen }
       buttonY := Hi(WindMin) + WhereY + 1;
       winULY  := Hi(WindMin);
       winLRY  := Hi(WindMax) + 2;
       { Figure out max upper coordinate and min lower coordinate }
       maxTop  := 1 + (25 - (hdrL + 2));
       minBot  := hdrL + 2;
       { Try to put new window (1) on bottom of current frame (2) on top  }
       { of current frame (3) below button, (4) above button, (5) in      }
       { opposite half of screen from button                              }
       If maxTop >= winLRY Then y := winLRY
       Else
          If minBot <= winULY Then y := 1 + (winULY - minBot)
          Else
             If maxTop > buttonY Then y := maxTop
             Else
                If minBot < buttonY Then y := 1
                Else
                   If buttonY < 13 Then y := maxTop
                   Else y := 1;
    END;
    { Maximum width? }
    If hdrW = MaxChars Then x := 1
    ELSE Begin
       { Figure out where the current button is on the physical screen }
       winULX  := Lo(WindMin);
       winLRX  := Lo(WindMax) + 2;
       buttonL := winULX + WhereX - Length(tag);
       buttonR := winULX + WhereX - 1;
       buttonC := buttonL + (Length(tag) Div 2);
       { Figure out max left coordinate and min right coordinate }
       maxL    := 1 + (80 - (hdrW + 4));
       minR    := hdrW + 4;
       { Try to put new window (1) on right of current frame (2) on bottom }
       { of current frame (3) right of button, (4) left of button, (5) in  }
       { opposite half of screen from button                               }
       If maxL >= winLRX Then x := winLRX
       Else
          If minR <= winULX Then x := 1 + (winULX - minR)
          Else
             If maxL > buttonR Then x := maxL
             Else
                If minR < buttonL Then x := 1
                Else
                   If buttonC < 40 Then x := maxL
                   Else x := 1;
    END;
  END; (* determineLoc *)

PROCEDURE displayHelp (w : Byte; buttons : Boolean);

{ Display Help/Instructions when invalid key is pressed }

  VAR  ch    : Char;
       fk    : Boolean;
       k     : KeyType;
       x,y,
       lines : Byte;
       b     : BorderStrType;
  CONST
    h1 = '                 OPERATION        KEY        MOUSE  ';
    h2 = ' ';
    m1 = '                            Ŀ Ŀ Ŀ Ŀ  Ŀ  ';
    m2 = '      Move highlighter bar  '
         + Chr(24)
         + ' '
         + Chr(27)
         + ' '
         + Chr(26)
         + ' '
         + Chr(25)
         + ' '
         + Chr(27)
         + ' '
         + Chr(26)
         + ' ';
    m3 = '                               ٳ    ';
    s1 = '                                 Ŀ       Ŀ  ';
    s2 = '  Select highlighted topic       '
         + Chr(17)
         + 'ٳ          ';
    s3 = '                                          ';
    b1 = '                              Ŀ    Ŀ  ';
    b2 = ' Back up to previous frame    Backspace     ۳  ';
    b3 = '                                    ';
    r1 = '                                 Ŀ       Ŀ  ';
    r2 = '     Return to first frame       Esc        ۳  ';
    r3 = '                                          ';
    f  = ' ';
    q1 = ' To quit, return to the first frame, then back up once';
    q2 = ' more (Backspace/Esc or corresponding mouse buttons). ';
    l  = ' ';
    q3 = '                              Ŀ    Ŀ  ';
    q4 = '                      Quit    Backspace     ۳  ';
    q5 = '                                    ';
    q6 = '                                 Ŀ       Ŀ  ';
    q7 = '                      Quit       Esc        ۳  ';
    q8 = '                                          ';

  BEGIN (* displayHelp *)
    { Need to display move and select keys? }
    If buttons Then lines := 11
    Else lines := 3;
    { Need to differentiate between Backspace and Esc? }
    If w = 1 Then lines := lines + 8
    Else lines := lines + 10;
    { Use default border style }
    CASE g_HTCdefs.defBord Of
       nobord     : b := '        ';
       singleBord : b := SingleBorder;
       doubleBord : b := DoubleBorder;
       singleUp   : b := singleUpBorder;
       doubleUp   : b := doubleUpBorder;
    END;
    determineLoc(57,23,'',x,y);
    { Free reserved memory }
    FreeMem(g_FreePtr,minHeap);
    { Use default hilite colors for border, default border colors for text }
    defineWindow (255,x,y,x+56,y+lines+2,
                  Attr(g_HTCdefs.defColors[BordF],
                  g_HTCdefs.defColors[BordB]),b,
                  Attr(g_HTCdefs.defColors[HiLiteF],
                  g_HTCdefs.defColors[HiLiteB]),
                  ' INSTRUCTIONS ',Attr(g_HTCdefs.defColors[HiLiteF],
                  g_HTCdefs.defColors[HiLiteB]),
                  Center,' Press a key or mouse button to continue ',
                  Attr(g_HTCdefs.defColors[HiLiteF],
                  g_HTCdefs.defColors[HiLiteB]),
                  Center,DeFaultFlag,'',0);
    OpenWindow(255);
    { Display appropriate text }
    GotoXY(1,2);
    WriteLn(h1);
    WriteLn(h2);
    IF buttons Then Begin
       WriteLn(m1);
       WriteLn(m2);
       WriteLn(m3);
       WriteLn(l);
       WriteLn(s1);
       WriteLn(s2);
       WriteLn(s3);
       WriteLn(l);
    END;
    IF w = 1 Then Begin
       WriteLn(q3);
       WriteLn(q4);
       WriteLn(q5);
       WriteLn(l);
       WriteLn(q6);
       WriteLn(q7);
       WriteLn(q8);
       Write(f);
    END
    ELSE Begin
       WriteLn(b1);
       WriteLn(b2);
       WriteLn(b3);
       WriteLn(l);
       WriteLn(r1);
       WriteLn(r2);
       WriteLn(r3);
       WriteLn(f);
       WriteLn(q1);
       Write(q2);
    END;
    InKeyOrMouse(ch,fk,k);
    CloseWindow(255);
    DeleteWindow(255);
    { Re-reserve memory }
    GetMem(g_FreePtr,minHeap);
  END; (* displayHelp *)

PROCEDURE setUpHelpWins (VAR d : dbFile);

{ Retrieve window defaults and reserve memory }

  BEGIN
     { Retrieve first DB record }
     Seek(d,0);
     { Read default window colors and border}
     Read(d,g_HTCdefs);
     { Reserve memory for displayHelp and freeMemory }
     GetMem(g_FreePtr,minHeap);
     { No room? }
     If g_FreePtr = Nil Then pgmErr := 300;
  END; (* setUpHelpWins *)

FUNCTION buildIndex (VAR f : idxFile) : idxPtr;

{ Build index of frame entries -- required only if the inital frame to  }
{ be displayed has a name -- an initial frame of '' refers to location  }
{ 1 in the database                                                     }

  VAR t,u,v : idxPtr;
      r     : idxRec;
  BEGIN
      New(t);
      v := t;
      Read(f,t^.entry);
      t^.prev := Nil;
      t^.next := Nil;
      WHILE Not Eof(f) Do Begin
         IF MaxAvail < SizeOf(t) Then Begin
            pgmErr := 100;
            buildIndex := Nil;
            Exit;
         END;
         u := t;
         New(t);
         Read(f,t^.entry);
         t^.prev := u;
         u^.next := t;
         t^.next := Nil;
      END;
      buildIndex := v;
  END; (* buildIndex *)

FUNCTION getFileLoc (t : buttonTag; i : idxPtr) : Integer;

{ Read internal index of frame tags and find the location of the frame }
{ header record for it                                                 }

  VAR p  : idxPtr;
      tt : buttonTag;

  BEGIN
     tt := UpCaseStr(t);
     p := i;
     While (p^.next <> Nil) And (UpCaseStr(p^.entry.tag) <> tt)
        Do p := p^.next;
     If UpCaseStr(p^.entry.tag) = tt Then getFileLoc := p^.entry.fileLoc
     Else pgmErr := 200;
  END; (* getFileLoc *)

PROCEDURE displayFrame (         l : Integer;     VAR   f : dbFile;
                          VAR    w : Byte;        VAR buf : inBuffer);

{ Display a frame in a new window }

  VAR i,j,k : Integer;
      b     : borderStrType;
      hdr   : dbRec;
      x,y   : Byte;
      t     : String;
      ba    : buttonArray;

  BEGIN
      { Retreive header record for requested frame }
      Seek(f,l);
      Read(f,hdr);
      { Memory available? if not, call freeMemory and exit }
      IF MaxAvail < minHeap Then Begin
         freeMemory(w,hdr.tag);
         Exit;
      END;
      CASE hdr.frameBord Of
        nobord     : b := '        ';
        singleBord : b := SingleBorder;
        doubleBord : b := DoubleBorder;
        singleUp   : b := singleUpBorder;
        doubleUp   : b := doubleUpBorder;
      END;
      w := w + 1;
      { The first window is centered on the screen }
      If w > 1 Then
         determineLoc(hdr.frameWidth,hdr.frameLines,hdr.tag,x,y)
      ELSE Begin
         x := 1 + (80 - (hdr.frameWidth + 4)) Div 2;
         y := 1 + (25 - (hdr.frameLines + 2)) Div 2;
      END;
      { Make window title }
      If Length(hdr.tag) > 0 Then
         t := ' '+hdr.tag+ ' [Frame '+N2Str(w,1,0)+'] '
      Else t := '';
      defineWindow (w, x, y,hdr.frameWidth + 3 + x, hdr.frameLines + 1 + y,
                    Attr(hdr.frameColors[TextF],hdr.frameColors[TextB]),
                    b,Attr(hdr.frameColors[BordF],hdr.frameColors[BordB]),
                    t,Attr(hdr.frameColors[BordF],hdr.frameColors[BordB]),
                    Center,' Press H for Help ',
                    Attr(hdr.frameColors[BordF],hdr.frameColors[BordB]),
                    Center,DeFaultFlag,hdr.tag,hdr.buttonCount);
      winErr := WinError;
      { This should NOT happen! }
      IF winErr > 0 Then Begin
         w := w - 1;
         Exit;
      END;
      OpenWindow(w);
      winErr := WinError;
      { This should NOT happen! }
      IF winErr > 0 Then Begin
         DeleteWindow(w);
         w := w - 1;
         Exit;
      END;
      { Any text in this frame? }
      IF hdr.frameLines > 0 Then Begin
         { Read all records (text and button) for this frame }
         For i := 1 To hdr.recdCount Do Read(f,buf[i]);
         { Write all text but the last line, padding with blanks }
         For i := 1 To hdr.frameLines-1 Do
             Write(' ',buf[i].wintext,
                  spaces(hdr.frameWidth-Length(buf[i].wintext)),' ');
         { Write last line without padding }
         Write(' ',buf[hdr.frameLines].wintext);
      END;
      { Any buttons in this frame? }
      IF hdr.buttonCount > 0 Then Begin
         { Point index to first button line }
         i := hdr.frameLines + 1;
         ba := WindowButtonList(w);
         { For buttons 1..n (0..n-1) ... }
         FOR j := 0 To (hdr.buttonCount - 1) Do Begin
            { store button and hilite colors }
            ba^[j].bb  := hdr.frameColors[buttonB];
            ba^[j].bf  := hdr.frameColors[buttonF];
            ba^[j].hb  := hdr.frameColors[hiLiteB];
            ba^[j].hf  := hdr.frameColors[hiLiteF];
            { button records contain info on two buttonss }
            IF Odd(j) Then Begin
               { store other button info }
               ba^[j].tag := buf[i].button2.tag;
               ba^[j].x   := buf[i].button2.xCoord;
               ba^[j].y   := buf[i].button2.yCoord;
               ba^[j].loc := buf[i].button2.fileLoc;
               i := i + 1;
            END
            ELSE Begin
               { store other button info }
               ba^[j].tag := buf[i].button1.tag;
               ba^[j].x   := buf[i].button1.xCoord;
               ba^[j].y   := buf[i].button1.yCoord;
               ba^[j].loc := buf[i].button1.fileLoc;
            END;
         END;
         TextColor(ba^[0].bf);
         TextBackground(ba^[0].bb);
         { Rewrite buttons }
         FOR i := 0 To (hdr.buttonCount - 1) Do Begin
            GotoXY(ba^[i].x+1,ba^[i].y);
            Write(ba^[i].tag);
         END;
         WindowButtonSelected(w,0);
      END;
  END; (* displayFrame *)

PROCEDURE processKeys  (      l : Integer;   VAR   f : dbFile;
                          VAR w : Byte;      VAR buf : inBuffer);

{ Process keystrokes when window is displayed }

  VAR  ch  : Char;
       fk  : Boolean;
       k   : KeyType;
       c,p : Byte;
       ba  : buttonArray;

  BEGIN
     REPEAT
        c := WindowButtonCount(w);
        { Any buttons in this window?  If not, we got here by selection }
        { from the previous frame, nothing to do but back up            }
        IF c = 0 Then Begin
           { Get a key }
           InKeyOrMouse(ch,fk,k);
           CASE k Of
                  EscapeKey      : If w > 1 Then
                                      REPEAT
                                         CloseWindow(w);
                                         DeleteWindow(w);
                                         w := w - 1;
                                      UNTIL w = 1
                                   ELSE Begin
                                      CloseWindow(w);
                                      DeleteWindow(w);
                                      w := 0;
                                   END;
                  BackSpaceKey   : Begin
                                      CloseWindow(w);
                                      DeleteWindow(w);
                                      w := w - 1;
                                   End;
           Else displayHelp(w,False);
           END;
        END
        ELSE Begin
           { We got here either by selection from a previous window or }
           { by backing up from a now-closed window                    }
           SelectWindow(w);
           { Hilite current button (first if we arrived by selection,  }
           { last one pressed if we arrived by backing up or if we are }
           { cycling through buttons                                   }
           p := WindowLastButton(w);
           ba := WindowButtonList(w);
           TextColor(ba^[p].hf);
           Textbackground(ba^[p].hb);
           GotoXY(ba^[p].x+1,ba^[p].y);
           Write(ba^[p].tag);
           { Get a key }
           InKeyOrMouse(ch,fk,k);
           CASE k Of
                  { Back up in button list }
                  LeftArrow,
                  UpArrow        : Begin
                                      { Rewrite current button in button }
                                      { colors                           }
                                      TextColor(ba^[p].bf);
                                      TextBackground(ba^[p].bb);
                                      GotoXY(ba^[p].x+1,ba^[p].y);
                                      Write(ba^[p].tag);
                                      { Store new current button }
                                      If p = 0 Then p := c - 1
                                      Else p := p - 1;
                                      WindowButtonSelected(w,p);
                                   End;
                  RightArrow,
                  DownArrow      : Begin
                                      { Rewrite current button in button }
                                      { colors                           }
                                      TextColor(ba^[p].bf);
                                      TextBackground(ba^[p].bb);
                                      GotoXY(ba^[p].x+1,ba^[p].y);
                                      Write(ba^[p].tag);
                                      { Store new current button }
                                      If p = (c - 1) Then p := 0
                                      Else p := p + 1;
                                      WindowButtonSelected(w,p)
                                   End;
                  CarriageReturn : Begin
                                      { Store selected button            }
                                      { Rewrite current button in button }
                                      { colors                           }
                                      WindowButtonSelected(w,p);
                                      TextColor(ba^[p].bf);
                                      Textbackground(ba^[p].bb);
                                      GotoXY(ba^[p].x+1,ba^[p].y);
                                      Write(ba^[p].tag);
                                      { Display frame associated with }
                                      { selected button               }
                                      displayFrame(ba^[p].loc, f, w, buf);
                                      If winErr > 0 Then Exit;
                                   End;
                  EscapeKey      : If w > 1 Then
                                      REPEAT
                                         CloseWindow(w);
                                         DeleteWindow(w);
                                         w := w - 1;
                                      UNTIL w = 1
                                   ELSE Begin
                                      CloseWindow(w);
                                      DeleteWindow(w);
                                      w := 0;
                                   END;
                  BackSpaceKey   : Begin
                                      CloseWindow(w);
                                      DeleteWindow(w);
                                      w := w - 1;
                                   End;
           Else displayHelp(w,True);
           END;
        END;
     UNTIL w = 0;
  END; (* processKeys *)

FUNCTION displayHypertext;

{ Hypertex Display Engine }

  VAR loc,i    : Integer;
      winCtr   : Byte;
      buffer   : inBuffer;
      saveX,
      saveY,
      saveAttr : Byte;

  BEGIN
     winErr := 0;
     pgmErr := 0;
     saveAttr := TextAttr;
     saveX := WhereX;
     saveY := WhereY;
     CursorOff;
     winCtr := 0;
     { Frame title null? If so ... }
     If t = '' Then
        loc := 1
     { Otherwise, create index }
     ELSE Begin
        If ix = Nil Then ix := buildIndex(ixf);
        If pgmErr = 0 Then loc := getFileLoc(t, ix);
     END;
     { Index created OK? }
     IF pgmErr = 0 Then Begin
       setUpHelpWins(dbf);
       { Enough memory? }
       If pgmErr = 0 Then Begin
         { Version conflict? }
         If g_HTCDefs.HTCVers > DEVersion Then pgmErr := 400
         ELSE Begin
           SelectWindow(0);
           winErr := winError;
           IF winErr = 0 Then Begin
             { This should ALWAYS happen! }
             GotoXY(1,1);
             displayFrame (loc, dbf, winCtr, buffer);
             IF winErr = 0 Then Begin
               { This should ALWAYS happen! }
               processKeys (loc, dbf, winCtr, buffer);
             END;
           END;
         END;
       END;
     END;
     { This should NOT happen!  It means that processKeys resulted in }
     { a window error                                                 }
     If winCtr > 0 Then
        REPEAT
           CloseWindow(winCtr);
           winCtr := winCtr - 1;
        UNTIL winCtr = 0;
     TextAttr := saveAttr;
     CursorSmall;
     GotoXY(saveX,saveY);
     displayHypertext := winErr + pgmErr;
  END; (* displayHypertext *)

BEGIN
   { De-sensitize mouse }
   If MousePresent Then SetMickeyToPixels(128,128);
END.



