Program DE120;

Uses Crt, Dos, StrFuncs, DEU1, PSPU;

{ Written by Steve T. Jones                                              }
{            Indiana University at Kokomo                                }
{            2300 South Washington Street                                }
{            Kokomo, IN 46902                                            }
{            (317) 453-2000                                              }
{            KCDZ100@INDYCMS                                             }
{            June 5, 1989                                                }
{                                                                        }
{  This program imports the following from DEU1:                         }
{  TYPE                                                                  }
{     FileNameStr                                                        }
{  VAR                                                                   }
{     HyperDbName, HyperDataBase                                         }
{     HyperIndexName, HyperIndex                                         }
{  FUNCTION                                                              }
{     DisplayHypertext : Integer                                         }
{                                                                        }
{  The program must declare a pointer variable to be passed to the       }
{  DisplayHyptertext function.                                           }
{                                                                        }


CONST
  null        : String[1] = #0;

TYPE
  parms       = (dbNm, idxNm, frNm, fr1);  (* These are used for parsing *)
  param       = String[80];                (* the command line -- not    *)
  parmArray   = Array[parms] Of param;     (* needed by DisplayHypertext *)

VAR
{ "first" and "indPtr" are variables used to hold the name of the first  }
{ frame and the pointer to the frame index, respectively,  The names are }
{ not important but the variables are required.  See (* MAIN *).         }

  first    : String;    (* Required string variable for DisplayHypertext  *)
  indPtr   : Pointer;   (* Required pointer variable for DisplayHypertext *)
  params   : parmArray; (* for parsing command line                       *)
  errCode  : Integer;   (* DisplayHypertext returns an integer            *)
  shown    : Boolean;   (* glohal -- for display purposes                 *)

FUNCTION exists (n : FileNameStr) : Boolean;
  VAR f : Text;
      c : Integer;
  BEGIN
     Assign(f,n);
     {$I-}
     Reset(f);
     c := IoResult;
     {$I+}
     exists := (c = 0);
  END;

PROCEDURE pause;
  VAR    ch       : Char;
  BEGIN
     WriteLn;
     Write('Press any key to continue ...');
     ch := ReadKey;
  END;

PROCEDURE parseCmdLine (VAR p : parmArray);
  VAR
    c        : Char;
    s        : param;
    cmdLine  : String;
  BEGIN  (* parseCmdLine *)

{ Command-line parameters are:                                           }
{   /D<hypertext database name>                                          }
{   /I<hypertext index name>                                             }
{   /F<first frame to be displayed>                                      }
{   /1       ("/1" means to display the first frame--no name required    }
{ D and I are required.  Either F or 1 is required; if both are used,    }
{ "/F" takes precedence.  Any missing parameters are prompted-for in the }
{ main program.                                                          }

    p[dbNm] := '';
    p[idxNm] := '';
    p[frNm] := Null;
    p[fr1] := Null;
    cmdLine := CommandLine; (* from PSPU unit *)
    cmdLine := After(cmdLine,'/');
    WHILE Length(cmdLine) > 0 Do Begin
       c := UpCase(cmdLine[1]);
       cmdLine := StripLeading(Copy(cmdLine,2,255));
       s := StripTrailing(Before(cmdLine,'/'));
       CASE c Of
           'D' : p[dbNm]  := UpCaseStr(s);
           'I' : p[idxNm] := UpCaseStr(s);
           'F' : p[frNm]  := UpCaseStr(s);
           '1' : p[fr1]  := '1';
       END;
       cmdLine := After(cmdLine,'/');
    END;
  END; (* parseCmdLine *)

FUNCTION getFirstFrame : String;
  VAR t : String;
  BEGIN
     WriteLn;
     Write('You must tell this program which frame is to be displayed ');
     WriteLn('first.  It may');
     Write('be the first frame in the HypertText database or it may be ');
     WriteLn('a particular');
     Write('(named) frame.  To display the first frame, just press ');
     WriteLn('[Enter]; to specify');
     WriteLn('another frame, type its name and press [Enter].');
     WriteLn;
     Write ('First frame => ');
     ReadLn(t);
     WriteLn;
     IF Length(t) = 0 Then Begin
        WriteLn('You chose the first frame in the database.');
        WriteLn;
        WriteLn('You can also do this by including');
        WriteLn('    "/1"');
        WriteLn('on the command line when you start DE120.');
     END
     ELSE Begin
        WriteLn('You chose "',t,'"');
        WriteLn;
        WriteLn('You can also do this by including');
        WriteLn('    "/F ',t,'"');
        WriteLn('on the command line when you start DE120.');
     END;
     getFirstFrame := UpCaseStr(StripTrailing(t));
     shown := True;
  END;

FUNCTION getDbName : String;
  VAR t : String;
  BEGIN
     WriteLn;
     WriteLn('Please enter the name of the HyperText database.');
     WriteLn;
     Write('Database => ');
     ReadLn(t);
     WriteLn;
     Write('You can specify this name on the command line when you ');
     WriteLn('start DE120 by');
     WriteLn('including "/D ',t,'".');
     getDbName := UpCaseStr(StripTrailing(t));
     shown := True;
  END;

FUNCTION getIdxName : String;
  VAR t : String;
  BEGIN
     WriteLn;
     WriteLn('Please enter the name of the HyperText index file.');
     WriteLn;
     Write('Index File => ');
     ReadLn(t);
     WriteLn;
     Write('You can specify this name on the command line when you ');
     WriteLn('start DE120 by');
     WriteLn('including "/I ',t,'".');
     getIdxName := UpCaseStr(StripTrailing(t));
     shown := True;
  END;

BEGIN (* MAIN *)

   {  It is the program's responsibility to get the names of the         }
   {  hypertext database and index, verify that the files exist,         }
   {  and execute the Assign and Reset statements below.                 }

   shown := False;
   ClrScr;

   ParseCmdLine(params);

   If params[dbNm] = '' Then HyperDbName := getDbName
   Else HyperDbName := params[dbNm];
   If HyperDbName = '' Then Begin
      Write('No database specified -- program terminating with code 51');
      Halt(51);
   End;

   If params[idxNm] = '' Then HyperIndexName := getIdxName
   Else HyperIndexName := params[idxNm];
   If HyperIndexName = '' Then Begin
      Write('No index specified -- program terminating with code 52');
      Halt(52);
   End;

   IF exists(HyperDbName) Then Begin
      Assign (HyperDataBase, HyperDbName);
      Reset  (HyperDataBase);
   END
   ELSE Begin
      Write('HyperText database (',HyperDbName,') not found -- ');
      WriteLn('program terminating with code 53');
      Halt(53);
   END;

   IF exists(HyperIndexName) Then Begin
      Assign (HyperIndex, HyperIndexName);
      Reset  (HyperIndex);
   END
   ELSE Begin
      Write('HyperText index (',HyperIndexName,') not found -- ');
      WriteLn('program terminating with code 54');
      Halt(54);
   END;

   {  The program must also initialize the pointer variable mentioned    }
   {  above to Nil and determine the name (tag) of the first frame to be }
   {  displayed.  (A null first frame tag avoids the time and memory     }
   {  penalty of actually creating the index because the display         }
   {  function will simply display the first frame in the database.)     }

   indptr := Nil;

   If (params[frNm] = Null) And (params[fr1] = Null) Then
      first := getFirstFrame
   Else
      If params[frNm] <> Null Then
         first := params[frNm]
      Else
         first := '';

   {  The program initiates the display function by assigning the        }
   {  result of the function call to DisplayHypertex to an integer       }
   {  variable.  The program must determine what to do if a value        }
   {  greater than 0 is returned by DisplayHypertext.                    }

   If shown Then Pause;

   errCode := displayHypertext (HyperIndex, indptr, HyperDataBase, first);
   {******    ----------------  ----------  ******  -------------  ***** }
   {                                                                     }
   {  Items underlined with --- are imported from DEU1, those underlined }
   {  with *** are the responsibility of the program.                    }

   WriteLn('DisplayHypertext ended with an error code of ',errCode);

END. (* MAIN *)

