{$R-,S-}
program HelpTest;
  {-Demonstration of Object Professional help system}
uses
  Dos,
  OpInline,
  OpString,
  OpRoot,
  OpDos,
  OpCrt,
  OpCmd,
  OpFrame,
  OpWindow,
  OpPick,
  OpHelp;

const
  OurColorSet : ColorSet = (
    TextColor       : $30; TextMono       : $07;
    CtrlColor       : $30; CtrlMono       : $07;
    FrameColor      : $71; FrameMono      : $07;
    HeaderColor     : $71; HeaderMono     : $70;
    ShadowColor     : $30; ShadowMono     : $07;
    HighlightColor  : $30; HighlightMono  : $07;
    PromptColor     : $30; PromptMono     : $07;
    SelPromptColor  : $30; SelPromptMono  : $07;
    ProPromptColor  : $30; ProPromptMono  : $07;
    FieldColor      : $30; FieldMono      : $07;
    SelFieldColor   : $30; SelFieldMono   : $07;
    ProFieldColor   : $30; ProFieldMono   : $07;
    ScrollBarColor  : $30; ScrollBarMono  : $07;
    SliderColor     : $30; SliderMono     : $07;
    HotSpotColor    : $30; HotSpotMono    : $07;
    BlockColor      : $1E; BlockMono      : $70;
    MarkerColor     : $30; MarkerMono     : $07;
    DelimColor      : $30; DelimMono      : $07;
    SelDelimColor   : $30; SelDelimMono   : $07;
    ProDelimColor   : $30; ProDelimMono   : $07;
    SelItemColor    : $5E; SelItemMono    : $70;
    ProItemColor    : $30; ProItemMono    : $07;
    HighItemColor   : $30; HighItemMono   : $07;
    AltItemColor    : $30; AltItemMono    : $07;
    AltSelItemColor : $30; AltSelItemMono : $07;
    FlexAHelpColor  : $1F; FlexAHelpMono  : $70;
    FlexBHelpColor  : $3E; FlexBHelpMono  : $0F;
    FlexCHelpColor  : $31; FlexCHelpMono  : $09;
    UnselXrefColor  : $3B; UnselXrefMono  : $01;
    SelXrefColor    : $5E; SelXrefMono    : $70;
    MouseColor      : $30; MouseMono      : $07
  );

var
  H : ScrollingHelpWindow;
  Finished : Boolean;
  HelpFile : PathStr;

  function KeyboardMove(var CW : CommandWindow) : Boolean;
    {-Move a window using the keyboard. Returns False if there's insufficient
      memory.}
  const
    Step = 1;
  var
    AllDone : Boolean;
  begin
    KeyboardMove := True;
    AllDone := False;
    with CW do
      repeat
        case ReadKeyWord of
          $4700 : MoveWindow(-Step, -Step); {Home}
          $4800 : MoveWindow(0, -Step);     {Up arrow}
          $4900 : MoveWindow(Step, -Step);  {PgUp}
          $4B00 : MoveWindow(-Step, 0);     {Left Arrow}
          $4D00 : MoveWindow(Step, 0);      {Right Arrow}
          $4F00 : MoveWindow(-Step, Step);  {End}
          $5000 : MoveWindow(0, Step);      {Down arrow}
          $5100 : MoveWindow(Step, Step);   {PgDn}

          $4737 : ResizeWindow(-Step, -Step); {Shift-Home}
          $4838 : ResizeWindow(0, -Step); {Shift-Up}
          $4939 : ResizeWindow(Step, -Step); {Shift-PgUp}
          $4B34 : ResizeWindow(-Step, 0); {Shift-Lf}
          $4D36 : ResizeWindow(Step, 0);  {Shift-Rt}
          $4F31 : ResizeWindow(-Step, Step); {Shift-End}
          $5032 : ResizeWindow(0, Step);  {Shift-Dn}
          $5133 : ResizeWindow(Step, Step); {Shift-PgDn}

          $1C0D : AllDone := True;            {Enter}
        end;

        if GetLastError = wOutOfHeap then begin
          KeyboardMove := False;
          AllDone := True;
        end;
      until AllDone;
  end;

begin
  ClrScr;

  if ParamCount < 1 then begin
    WriteLn('Help file name required');
    Halt(1);
  end else
    HelpFile := ParamStr(1);

  {AltM will move or resize help window}
  HelpCommands.AddCommand(ccUser0, 1, $3200, 0);

  HelpFile := DefaultExtension(HelpFile, 'HLP');

  DefWindowOptions := (DefWindowOptions or wBordered) and not wSaveContents;

  with H do begin
    if not InitCustom(2, 8, 79, 23,
                      OurColorSet, DefWindowOptions,
                      HelpFile, PickVertical) then begin
      WriteLn('Constructor error ', InitStatus);
      Halt;
    end;

    EnableExplosions(10);
    SetPickPadSize(2);
    AddTopicHeader(1, 60, heTC);
    wFrame.AddHeader(' Topic Index ', heTC);
    AddMoreHeader(' || for more ', heBR, #24, #25, '', 2, 3, 0);
    SetSearchMode(PickAltStringSearch);
    AddTopicHeader(1, 60, heTC);
    wFrame.AddHeader(' Topic Index ', heTC);
    AddMoreHelpHeader(' || for more ', heBR, #24, #25, '', 2, 3, 0);
    AddMoreHeader(' || for more ', heBR, #24, #25, '', 2, 3, 0);
    if GetLastError <> 0 then begin
      WriteLn('Internal error: insufficient memory');
      Halt(1);
    end;

    Finished := False;
    repeat
      {Pick a help topic to start}
      SetTopic(0);
      Process;
      if (cwGetLastError = 0) and (GetLastCommand = ccSelect) then begin
        SetTopic(GetTopicChoice);
        repeat
          Process;
          if cwGetLastError <> 0 then
            Finished := True
          else if (GetLastCommand = ccQuit) and not InHelpMode then
            {Escaped from pick window within help}
            Finished := True
          else if GetLastCommand = ccUser0 then
            Finished := not KeyboardMove(H);
        until Finished or (GetLastCommand <> ccUser0);

      end else if GetLastCommand = ccUser0 then
        Finished := not KeyboardMove(H)

      else
        Finished := True;
    until Finished;

    Erase;

    if cwGetLastError <> 0 then
      Writeln('cwError=', cwGetLastError);
    Done;
  end;
end.
