uses crt,tpfast;

type
    wholescreen           = array [1..(80 * 25) * 2] of byte;

var str                   :stype;
    scrn1                 :wholescreen;
    scrn2                 :wholescreen;
    flag                  :boolean;
    ch                    :word;


{ -------------------------------------------------------------------------- }
procedure init;

begin
  str := 'Strings examples using the TPFAST toolbox.';
end;

{ -------------------------------------------------------------------------- }
procedure screen1;

begin
  clrscr;
  init;
  dspln(str);
  changechar(str,'s','@');
  dspln(str);
  init;
  deletechar(str,'e');
  dspln(str);
  init;
  deleteleft(str,'x');
  dspln(str);
  init;
  deleteright(str,'A');
  dspln(str);
  init;
  str := leftend(str,'u');
  dspln(str);
  init;
  str := rightend(str,'u');
  dspln(str);
  init;
  uppercase(str);
  dspln(str);
  init;
  lowercase(str);
  dspln(str);
  init;
  overwrite(str,'THE',24);
  dspln(str);
  init;
  replace(str,'fastest',28,6);
  dspln(str);

  dspat('line 1,               - standard string.',1,13,yellow);
  dspat('line 2,  changechar   - changes all "s" to "@"',1,14,yellow);
  dspat('line 3,  deletechar   - deletes all occurances of "e"',1,15,yellow);
  dspat('line 4,  deleteleft   - from the left deletes all chars upto "x"',1,16,yellow);
  dspat('line 5,  deleteright  - from the right deletes all chars upto "A"',1,17,yellow);
  dspat('line 6,  leftend      - left end of a string uto char "u"',1,18,yellow);
  dspat('line 7,  rightend     - right end of a string uto char "u"',1,19,yellow);
  dspat('line 8,  uppercase    - converted to upper case',1,20,yellow);
  dspat('line 9,  lowercase    - converted to lower case',1,21,yellow);
  dspat('line 10, overwrite    - overwrote "THE" at position 24',1,22,yellow);
  dspat('line 11, replace      - replaced "TPFAST" with "fastest"',1,23,yellow);
  fillscreen(' ',1,25,80,25,blue+_cyan);
  dspat('Strings demo  screen 1  - press + and - keys to toggle screens',1,25,blue+_cyan);
  savescreen(@scrn1,1,1,80,25);
end;

{ -------------------------------------------------------------------------- }
procedure screen2;

begin
  clrscr;
  init;
  padleft(str,'_',60);
  dspln(str);
  init;
  padright(str,'_',60);
  dspln(str);
  init;
  padcentre(str,'_',30,60);
  dspln(str);
  init;
  padends(str,'_',60);
  dspln(str);
  init;
  str := stringend(str,10);
  dspln(str);
  init;
  str := stringof('hello ',60);
  dspln(str);
  init;
  writeln('String "the" found at pos = ',seekstring(str,'the',1));
  init;
  writeln('Number of words           = ',wordcount(str));
  writeln('Compare strings           = ',compare(str,str));

  dspat('line 1,  padleft      - padded left to 60 with char "_"',1,13,yellow);
  dspat('line 2,  padright     - padded right to 60 with char "_"',1,14,yellow);
  dspat('line 3,  padcentre    - padded from "TP"  to 60 with char "_"',1,15,yellow);
  dspat('line 4,  padends      - padded ends to 60 with char "_"',1,16,yellow);
  dspat('line 5,  stringend    - the last 10 chars',1,17,yellow);
  dspat('line 6,  stringof     - made a string[60] of "hello "',1,18,yellow);
  dspat('line 7,  seekstring   - search for substring in string',1,19,yellow);
  dspat('line 8,  wordcount    - number of words in string',1,20,yellow);
  dspat('line 9,  compare      - compares two strings',1,21,yellow);
  fillscreen(' ',1,25,80,25,blue+_cyan);
  dspat('Strings demo  screen 2  - press + and - keys to toggle screens',1,25,blue+_cyan);
  savescreen(@scrn2,1,1,80,25);
end;

{ -------------------------------------------------------------------------- }

begin
  textattr := white;
  cursoroff;
  flag := true;
  screen1;
  screen2;
   repeat
   ch := getkey;
    if (chr(lo(ch))) in ['+','-'] then
    begin
    if flag then
          begin
              restorescreen(@scrn1,1,1,80,25);
              flag := false;
          end
        else
          begin
              restorescreen(@scrn2,1,1,80,25);
              flag := true;
          end;
    end;
   until ch = Esc;
 cursoron;
end.