;   _______________________________________________________________
;  |                                                               |
;  |            CopyRight (c) 1989,1990  Steven Lutrov             |
;  |_______________________________________________________________|____
;  |                                                               |    |
;  |  program title : fastkbd.asm                                  |    | ___
;  |  author        : Steven Lutrov                                |    |    |
;  |  revision      : 4.00                                         |    |    |
;  |  date          : 1991-11-01                                   |    |    |
;  |  language      : turbo assembler                              |    |    |
;  |                                                               |    |    |
;  |                                                               |    |    |
;  |  description   : assembly functions  for keyboard operations. |    |    |
;  |                : using int 16h or dos 21h.                    |    |    |
;  |                : tested on turbo pascal 5.0 & 5.5             |    |    |
;  |_______________________________________________________________|    |    |
;      |                                                                |    |
;      |________________________________________________________________|    |
;          |                                                                 |
;          |_________________________________________________________________|
;


code segment word public

assume cs:code, ds:data

public  altkeydown,capslockdown,capslockon,freshchar,clearbuffer
public  clearcapslock,clearins,clearnumlock,clearscrolllock,ctrlkeydown
public  ekeypressed,getekey,getkey
public  inskeydown,inskeyon,keypause
public  leftshiftdown,nextkey,lastkey,numlockdown,numlockon
public  rightshiftdown,scrolllockdown,scrolllockon,setcapslock
public  setins,setnumlock,setscrolllock

data    segment
        extrn  TPFError  :byte;
data    ends


;-------------------------------------------------------------------------------
;function altkeydown: boolean;
;-------------------------------------------------------------------------------
;
altkeydown proc far
                mov  ah,2                       ;bios kybd status func
                int  16h                        ;call the interrupt
                mov  bl,1                       ;true value
                test al,8                       ;test bit 3
                jnz  altkeydownl1               ;jump if true
                mov  bl,0                       ;false value
altkeydownl1:   mov  al,bl                      ;place value for return
                ret
altkeydown endp



;-------------------------------------------------------------------------------
;function capslockdown: boolean;
;-------------------------------------------------------------------------------
;
capslockdown proc far
                sub  ax,ax                      ;clear ax
                mov  es,ax                      ;point es to 0000:0000
                mov  si,418h                    ;offset of status byte
                mov  bl,64                      ;test bit 6
                mov  al,1                       ;true value
                test es:[si],bl                 ;test the bit
                jnz  capslockdownl1             ;jump if true
                mov  al,0                       ;false value
capslockdownl1: ret
capslockdown endp


;-------------------------------------------------------------------------------
;function capslockon: boolean;
;-------------------------------------------------------------------------------
;
capslockon proc far
                mov  ah,2                       ;bios kybd status func
                int  16h                        ;call the interrupt
                mov  bl,1                       ;true value
                test al,64                      ;test bit 6
                jnz  capslockonl1               ;jump if true
                mov  bl,0                       ;false value
capslockonl1:   mov  al,bl                      ;place value for return
                ret
capslockon endp


;-------------------------------------------------------------------------------
;function freshchar :char;
;-------------------------------------------------------------------------------
;
freshchar proc far
                mov  ah,0ch                     ;dos function number
                mov  al,7                       ;keyboard read function
                int  21h                        ;wait for a keystroke
                ret
freshchar endp


;-------------------------------------------------------------------------------
;procedure clearbuffer;
;-------------------------------------------------------------------------------
;
clearbuffer proc far
clrbufferl1:    mov  ah,6                       ;function number
                mov  dl,0ffh                    ;subfunction number
                int  21h                        ;seek keystroke
                jnz  clrbufferl1                ;repeat if one found
                ret
clearbuffer endp


;-------------------------------------------------------------------------------
;procedure clearcapslock;
;-------------------------------------------------------------------------------
;
clearcapslock proc far
                sub  ax,ax                      ;clear ax
                mov  es,ax                      ;es pts to 0000:0000
                mov  al,10111111b               ;bit 6
                and  es:[417h],al               ;clear the bit
                ret
clearcapslock endp


;-------------------------------------------------------------------------------
;procedure clearins;
;-------------------------------------------------------------------------------
;
clearins  proc far
                sub  ax,ax                      ;clear ax
                mov  es,ax                      ;es pts to 0000:0000
                mov  al,01111111b               ;bit 7
                and  es:[417h],al               ;clear the bit
                ret
clearins  endp


;-------------------------------------------------------------------------------
;procedure clearnumlock;
;-------------------------------------------------------------------------------
;
clearnumlock proc far
                sub  ax,ax                      ;clear ax
                mov  es,ax                      ;es pts to 0000:0000
                mov  al,11011111B               ;bit 5
                and  es:[417H],al               ;clear the bit
                ret
clearnumlock endp


;-------------------------------------------------------------------------------
;procedure clearscrolllock;
;-------------------------------------------------------------------------------
;
clearscrolllock proc far
                sub  ax,ax                      ;clear ax
                mov  es,ax                      ;es pts to 0000:0000
                mov  al,11101111B               ;bit 4
                and  es:[417h],al               ;clear the bit
                ret
clearscrolllock endp


;-------------------------------------------------------------------------------
;function ctrlkeydown: boolean;
;-------------------------------------------------------------------------------
;
ctrlkeydown proc far
                mov  ah,2                       ;bios kybd status func
                int  16h                        ;call the interrupt
                mov  bl,1                       ;true value
                test al,4                       ;test bit 2
                jnz  ctrlkeydownl1              ;jump if true
                mov  bl,0                       ;false value
ctrlkeydownl1:  mov  al,bl                      ;place value for return
                ret
ctrlkeydown endp



;-----------------------------------------------------------------------------
; function ekeypressed    :boolean;
;-----------------------------------------------------------------------------
ekeypressed   proc far
                mov     Ah,011H                 ;extended keyboard service
                int     16H                     ;go to bios
                jz      ekey1                   ;jump if no key ready
                mov     Al,1                    ;set Al to equal true (1)
                ret                             ;return from sub
ekey1:          xor     Al,Al                   ;set Al to false (0)
                ret                             ;return from sub
endp    ekeypressed


;-----------------------------------------------------------------------------
; function getekey   :word;
;-----------------------------------------------------------------------------
getekey  proc  far
                mov     Ah,010H                 ;extended keyboard char read
                int     16H                     ;go to bios
                ret                             ;return from sub
endp    getekey


;-----------------------------------------------------------------------------
;function getkey  :word;
;-----------------------------------------------------------------------------
getkey  proc far
                mov     ah,00H                  ;get next keyboard char
                int     16H                     ;go to bios
                ret                             ;return from sub
endp    getkey


;-------------------------------------------------------------------------------
;function inskeydown: boolean;
;-------------------------------------------------------------------------------
;
inskeydown proc far
                sub  ax,ax                      ;clear ax
                mov  es,ax                      ;point es to 0000:0000
                mov  si,418h                    ;offset of status byte
                mov  bl,128                     ;test bit 7
                mov  al,1                       ;true value
                test es:[si],bl                 ;test the bit
                jnz  inskeydownl1               ;jump if true
                mov  al,0                       ;false value
inskeydownl1:   ret
inskeydown endp


;-------------------------------------------------------------------------------
;function inskeyon: boolean;
;-------------------------------------------------------------------------------
;
inskeyon proc far
                mov  ah,2                       ;bios kybd status func
                int  16h                        ;call the interrupt
                mov  bl,1                       ;true value
                test al,128                     ;test bit 7
                jnz  inskeyonl1                 ;jump if true
                mov  bl,0                       ;false value
inskeyonl1:     mov  al,bl                      ;place value for return
                ret
inskeyon endp


;-------------------------------------------------------------------------------
;procedure keypause(code :char; ascii: boolean; wait_a,wait_b :byte;);
;-------------------------------------------------------------------------------
;
keypause proc far
                sti                             ;enable interrupts
                push bp                         ;save bp
                mov  bp,sp                      ;set up stack frame
                mov  bh,[bp+12]                 ;code to bh
                mov  bl,[bp+10]                 ;extended code flag to bl
                sub  ax,ax                      ;get wait_a
                mov  al,[bp+8]                  ;
                mov  si,ax                      ;first char delay
keypausel1:     mov  ah,0                       ;function to read timer
                int  1ah                        ;time to cx:dx
                add  dx,si                      ;add delay to low word
                mov  di,dx                      ;copy to di
keypausel2:     int  1ah                        ;keep reading time...
                cmp  dx,di                      ;delay complete?
                jne  keypausel2                 ;jump if not
                mov  ah,1                       ;bios func to chk buffer
                int  16h                        ;check for character
                jz   keypausel5                 ;quit if buffer empty
                cmp  al,bl                      ;see if extended code
                jne  keypausel3                 ;jump if not extended
                mov  al,ah                      ;else shift code to al
keypausel3:     cmp  al,bh                      ;is it the right code?
                jne  keypausel5                 ;quit routine if not
keypausel4:     mov  ah,6                       ;now clear buffer
                mov  dl,0ffh                    ;dos func to read char
                int  21h                        ;read char w.o. waiting
                jnz  keypausel4                 ;read again if char found
                sub  ax,ax                      ;fetch wait_b
                mov  al,[bp+6]                  ;
                mov  si,ax                      ;typematic delay
                jmp  short keypausel1           ;go check buffer again
keypausel5:     pop  bp                         ;restore bp and quit
                ret  4
keypause endp


;-------------------------------------------------------------------------------
;function leftshiftdown: boolean;
;-------------------------------------------------------------------------------
;
leftshiftdown proc far
                mov  ah,2                       ;bios kybd status func
                int  16h                        ;call the interrupt
                mov  bl,1                       ;true value
                test al,2                       ;test bit 1
                jnz  lsdownl1                   ;jump if true
                mov  bl,0                       ;false value
lsdownl1:       mov  al,bl                      ;place value for return
                ret
leftshiftdown endp



;-------------------------------------------------------------------------------
;function nextkey :char;
;-------------------------------------------------------------------------------
;
nextkey proc far
                mov  TPFError,2                ;2 = no keystroke in buffer
                mov  al,0ffh                    ;assume no keystroke
                mov  ah,1                       ;bios func to chk buffer
                int  16h                        ;chk for keystroke
                jz   nextkeyl1                  ;jump if buffer empty
                mov  TPFError,0                ;0 = not extended code
                or   al,al                      ;test for extended code
                jne  nextkeyl1                  ;quit if ascii code
                inc  TPFError                  ;1 = extended code
                mov  al,ah                      ;move extended code to al
nextkeyl1:      ret     
nextkey endp


;-------------------------------------------------------------------------------
;function lastkey :char;
;-------------------------------------------------------------------------------
;
lastkey proc far
                mov  ah,6                       ;dos func to chk for key
                mov  dl,0ffh                    ;subfunction number
                int  21h                        ;seek a keystroke
                jnz  lastkey1                   ;jump if keystroke found
                mov  al,0ffh                    ;else flag  that no char
lastkey1:       ret
lastkey endp


;-------------------------------------------------------------------------------
;function numlockdown: boolean;
;-------------------------------------------------------------------------------
;
numlockdown proc far
                sub  ax,ax                      ;clear ax
                mov  es,ax                      ;point es to 0000:0000
                mov  si,418h                    ;offset of status byte
                mov  bl,32                      ;test bit 5
                mov  al,1                       ;true value
                test es:[si],bl                 ;test the bit
                jnz  nl1                        ;jump if true
                mov  al,0                       ;false value
nl1:            ret

numlockdown endp


;-------------------------------------------------------------------------------
;function numlockon: boolean;
;-------------------------------------------------------------------------------
;
numlockon proc far
                mov  ah,2                       ;bios kybd status func
                int  16h                        ;call the interrupt
                mov  bl,1                       ;true value
                test al,32                      ;test bit 5
                jnz  numlockonl1                ;jump if true
                mov  bl,0                       ;false value
numlockonl1:    mov  al,bl                      ;place value for return
                ret
numlockon endp


;-------------------------------------------------------------------------------
;function rightshiftdown: boolean;
;-------------------------------------------------------------------------------
;
rightshiftdown proc far
                mov  ah,2                       ;bios kybd status func
                int  16h                        ;call the interrupt
                mov  bl,1                       ;true value
                test al,1                       ;test bit 0
                jnz  rightshiftdownl1           ;jump if true
                mov  bl,0                       ;false value
rightshiftdownl1:       mov  al,bl              ;place value for return
                ret
rightshiftdown endp


;-------------------------------------------------------------------------------
;function scrolllockdown: boolean;
;-------------------------------------------------------------------------------
;
scrolllockdown proc far
                sub  ax,ax                      ;clear ax
                mov  es,ax                      ;point es to 0000:0000
                mov  si,418h                    ;offset of status byte
                mov  bl,16                      ;test bit 4
                mov  al,1                       ;true value
                test es:[si],bl                 ;test the bit
                jnz  scrollldownl1              ;jump if true
                mov  al,0                       ;false value
scrollldownl1:  ret
scrolllockdown endp


;-------------------------------------------------------------------------------
;function scrolllockon: boolean;
;-------------------------------------------------------------------------------
;
scrolllockon proc far
                mov  ah,2                       ;bios kybd status func
                int  16h                        ;call the interrupt
                mov  bl,-1                      ;true value
                test al,16                      ;test bit 4
                jnz  scrolllockonl1             ;jump if true
                mov  bl,0                       ;false value
scrolllockonl1: mov  al,bl                      ;place value for return
                ret
scrolllockon endp


;-------------------------------------------------------------------------------
;procedure setcapslock;
;-------------------------------------------------------------------------------
;
setcapslock proc far
                sub  ax,ax                      ;clear ax
                mov  es,ax                      ;es pts to 0000:0000
                mov  al,64                      ;bit 6
                or   es:[417h],al               ;set the bit
                ret
setcapslock endp


;-------------------------------------------------------------------------------
;procedure setins;
;-------------------------------------------------------------------------------
;
setins  proc far
                sub  ax,ax                      ;clear ax
                mov  es,ax                      ;es pts to 0000:0000
                mov  al,128                     ;bit 7
                or   es:[417h],al               ;set the bit
                ret
setins  endp



;-------------------------------------------------------------------------------
;procedure setnumlock;
;-------------------------------------------------------------------------------
;
setnumlock proc far
                sub  ax,ax                      ;clear ax
                mov  es,ax                      ;es pts to 0000:0000
                mov  al,32                      ;bit 5
                or   es:[417h],al               ;set the bit
                ret
setnumlock endp


;-------------------------------------------------------------------------------
;procedure setscrolllock;
;-------------------------------------------------------------------------------
;
setscrolllock proc far
                sub  ax,ax                      ;clear ax
                mov  es,ax                      ;es pts to 0000:0000
                mov  al,16                      ;bit 4
                or   es:[417h],al               ;set the bit
                ret
setscrolllock endp

code    ends
        end
