;   _______________________________________________________________
;  |                                                               |
;  |            CopyRight (c) 1989,1990  Steven Lutrov             |
;  |_______________________________________________________________|____
;  |                                                               |    |
;  |  program title : fastfile.asm                                 |    | ___
;  |  author        : Steven Lutrov                                |    |    |
;  |  revision      : 2.02                                         |    |    |
;  |  date          : 1991-11-01                                   |    |    |
;  |  language      : turbo assembler                              |    |    |
;  |                                                               |    |    |
;  |                                                               |    |    |
;  |  description   : assembly functions for primitive file        |    |    |
;  |                : handeling.                                   |    |    |
;  |                : tested on turbo pascal turbo pascal 5.5      |    |    |
;  |                                                               |    |    |
;  |_______________________________________________________________|    |    |
;      |                                                                |    |
;      |________________________________________________________________|    |
;          |                                                                 |
;          |_________________________________________________________________|
;



code segment word public

assume cs:code,ds:data


public fclose,fcreate,ferase,fseek,fopen,fread,
public fwrite,getverify,readsector,setverify,writesector



;-------------------------------------------------------------------------------
;function getverify: boolean;
;-------------------------------------------------------------------------------
;
getverify proc far
        mov  ah,54h                     ;dos func to get verify
        int  21h                        ;get status
        ret
getverify endp


;-------------------------------------------------------------------------------
;procedure readsector(segment,offset,drive,sector,number: word);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  TPFError :byte
data    ends
;
;
readsector proc far
                push  bp                        ;save bp
                mov   bp,sp                     ;set up stack frame
                push  ds                        ;save ds
                lds   bx,dword ptr[bp+12]       ;get buffer address
                mov   al,[bp+10]                ;drive code
                dec   al                        ;adjust for turbo
                mov   dx,[bp+8]                 ;logical sector number
                mov   cx,[bp+6]                 ;number sectors to read
                int   25h                       ;read the sector(s)
                mov   bl,0                      ;0 = no error
                jnc   rsec1                     ;test for error
                mov   bl,ah                     ;error code to bl
rsec1:          pop   cx                        ;balance stack
                pop   ds                        ;restore ds
                pop   bp                        ;restore bp
                mov   TPFError,bl              ;set error code
                ret   10
readsector endp


;-------------------------------------------------------------------------------
;procedure setverify(setting: boolean);
;-------------------------------------------------------------------------------
;
setverify proc far
                mov  bx,sp                      ;
                sub  dl,dl                      ;dl must = 0
                mov  al,ss:[bx+4]               ;1 = on, 0 = off
                mov  ah,2eh                     ;dos func to set verify
                int  21h                        ;set verification
                ret  2
setverify endp


;-------------------------------------------------------------------------------
;procedure writesector(segment,offset,drive,sector,number: word;);
;-------------------------------------------------------------------------------
;
data    segment
        extrn  TPFError :byte
data    ends
;
;
writesector proc far
                push  bp                        ;save bp
                mov   bp,sp                     ;set up stack frame
                push  ds                        ;save ds
                lds   bx,dword ptr[bp+12]       ;get buffer address
                mov   al,[bp+10]                ;drive code
                dec   al                        ;adjust for turbo
                mov   dx,[bp+8]                 ;logical sector number
                mov   cx,[bp+6]                 ;number sectors to write
                int   26h                       ;write the sector(s)
                mov   bl,0                      ;0 = no error
                jnc   wsec1                     ;test for error
                mov   bl,ah                     ;error code to bl
wsec1:          pop   cx                        ;balance stack
                pop   ds                        ;restore ds
                pop   bp                        ;restore bp
                mov   TPFError,bl              ;set error code
                ret   10                        ;
writesector endp

;-------------------------------------------------------------------------------
;function fcreate(fname:string; attribute :integer) :integer;
;-------------------------------------------------------------------------------
;
fcname     equ        dword ptr [bp+8]
fcattr     equ        word  ptr [bp+6]
fcsize     equ        4 + 2

fcreate    proc far
                push bp                      ; save bp
                mov  bp,sp                   ; setup stack frame
                push ds                      ; save ds
                lds  si,fcname               ; get fcname address
                mov  bl,[si]                 ; get length of string in dx
                inc  si                      ; skip pascal string[0] length byte
                xor  bh,bh                   ; bx=$00xx, where xx is length
                mov  [si+bx],bh              ; end string with asciz
                mov  dx,si                   ; fname asciz ptr in ds:dx
                mov  cx,fcattr               ; attribute to set in created file
                mov  ah,3ch                  ; create
                int  21h                     ; do it
                jnc  fc01                    ; jump if no error
                neg  ax                      ; ax:=-ax
fc01:           pop  ds                      ;
                pop  bp                      ;
                ret  fcsize
fcreate    endp

;-------------------------------------------------------------------------------
;function fopen(name:string; access :integer) :integer;
;-------------------------------------------------------------------------------
;
foname     equ        dword ptr [bp+8]
foacce     equ        word  ptr [bp+6]
fosize     equ        4 + 2

fopen      proc far
                push bp                      ; save bp
                mov  bp,sp                   ; set up stack frame
                push ds                      ; save ds
                lds  si,foname               ; get foname address
                mov  bl,[si]                 ; get length of string in dx
                inc  si                      ; skip pascal string[0] length byte
                xor  bh,bh                   ; bx=$00xx, where xx is length
                mov  [si+bx],bh              ; end string with asciz
                mov  dx,si                   ; fname asciz ptr in ds:dx
                mov  ax,foacce               ; file access code
                mov  ah,3dh                  ; open file
                int  21h                     ; do it
                mov  bx,0                    ; boolean false
                jnc  fo01                    ; jump if no error
                neg  ax                      ; ax:=-ax;
fo01:           pop  ds                      ; restore ds
                pop  bp                      ; restore bp
                ret  fosize
fopen      endp



;-------------------------------------------------------------------------------
;function fclose(handle :integer):boolean;
;-------------------------------------------------------------------------------
;
fclhandle  equ  word ptr [bp+6]
fclsize    equ  2

fclose     proc far
                push bp                      ; save bp stack
                mov  bp,sp                   ; set up stack frame
                mov  bx,fclhandle            ; file handler identifier
                mov  ah,3eh                  ; close
                int  21h                     ; do it
                mov  ax,0                    ; boolean false
                jc   fcl01                   ; jump if error
                mov  ax,1                    ; boolean true
fcl01:          pop  bp
                ret  fclsize
fclose     endp



;-------------------------------------------------------------------------------
;function fwrite(handle :integer; nwrite:word; var buff) :integer;
;-------------------------------------------------------------------------------
;
fwhandle   equ  word ptr [bp+12]
fwwrite    equ  word ptr [bp+10]
fwbuff     equ  dword ptr [bp+6]
fwsize     equ  2 + 2 + 4

fwrite     proc far
                push bp                      ; save bp stack
                mov  bp,sp                   ; set up stack frame
                push ds                      ; save ds
                mov  bx,fwhandle             ; file handler identifier
                lds  dx,fwbuff               ; data buffer
                mov  cx,fwwrite              ; number of bytes to write
                cmp  cx,07fffh               ; above 7fff
                ja   fw02                    ; to many bytes to write
                mov  ah,40h                  ; write
                int  21h                     ; do it
                jnc  fw01                    ; jump if no error
fw02:           neg  ax                      ; ax:=-ax;
fw01:           pop  ds                      ; restore bs
                pop  bp                      ; restore bp
                ret  fwsize
fwrite     endp


;-------------------------------------------------------------------------------
;function fread(handle:word; amount:word; var buff) :integer;
;-------------------------------------------------------------------------------
;
frhandle   equ  word ptr [bp+12]
framount   equ  word ptr [bp+10]
frbuff     equ  dword ptr [bp+6]
frsize     equ  2 + 2 + 4

fread      proc far
                push bp                      ; store bp
                mov  bp,sp                   ; setup stack frame
                push ds                      ; save ds
                mov  bx,frhandle             ; file handler identifier
                lds  dx,frbuff               ; data buffer
                mov  cx,framount               ; number of bytes to read
                cmp  cx,07fffh               ; above 7fff
                ja   fr02                    ; too many bytes to read
                mov  ah,3fh                  ; read
                int  21h                     ; do it
                jnc  fr01                    ; jump if no error
fr02:           neg  ax                      ; make ax negative
fr01:           pop  ds                      ; restore ds
                pop  bp                      ; restore bp
                ret  frsize
fread      endp


;-------------------------------------------------------------------------------
;function fseek(handle :integer; mode :integer; offset:longint;
;                      var location:longint):boolean;
;-------------------------------------------------------------------------------
;
fshandle   equ  word ptr [bp+16]
fsmode     equ  word ptr [bp+14]
fsofshi    equ  word ptr [bp+12]
fsofslo    equ  word ptr [bp+10]
fslocation equ  dword ptr [bp+6]

fssize     equ  2 + 2 + 4 + 4

fseek      proc far
                push bp                      ; save bp
                mov  bp,sp                   ; set up stack frame
                push ds                      ; save ds
                mov  bx,fshandle             ; file handler identifier
                mov  cx,fsofshi              ; file offset in cx
                mov  dx,fsofslo              ; file offset in cx:dx
                mov  ax,fsmode               ; load method code
                mov  ah,42h                  ; seek
                int  21h                     ; do it
                mov  bx,1                    ; boolean true
                jnc  fs01                    ; jump if not error
                mov  bx,0                    ; boolean false
                mov  dx,0                    ; high word in location=$0000
fs01:           les  di,fslocation           ; point to fslocation
                cld                          ; set direction flag
                stosw                        ; low word to location
                mov  ax,dx                   ;
                stosw                        ; high word to location
                mov  ax,bx                   ; return false or true
                pop  ds                      ; restore ds
                pop  bp                      ; restore bp
                ret  fssize
fseek      endp



;-------------------------------------------------------------------------------
;function ferase(name:string) :integer;
;-------------------------------------------------------------------------------
;
fename     equ  dword ptr [bp+6]
fesize     equ  4

ferase     proc far
                push bp                      ; save bp
                mov  bp,sp                   ; set up stack frame
                push ds                      ; save ds
                lds  si,fename               ; get address of fename
                mov  bl,[si]                 ; get length of string in dx
                inc  si                      ; skip pascal string[0] length byte
                xor  bh,bh                   ; bx=$00xx, where xx is length
                mov  [si+bx],bh              ; end string with asciz
                mov  dx,si                   ; fname asciz ptr in ds:dx
                mov  ah,41h                  ; erase file
                int  21h                     ; do it
                mov  bx,0                    ; boolean false
                jnc  fe01                    ; jump if no error
                neg  ax                      ; make ax -ax;
                jmp  fe02                    ; restore and exit
fe01:           mov  ax,0                    ;
fe02:           pop  ds                      ; restore ds
                pop  bp                      ; restore bp
                ret  fesize
ferase     endp


code    ends
        end

