{$R-,S-}

{Demonstration program for TPENV. See TPENV.DOC for more information}

{Disable the following define if you don't have Turbo Professional}
{$DEFINE UseTPro}

program TestEnv;
  {-Demonstrate the TPENV unit}

uses
  {$IFDEF UseTpro}
  TpString,
  Dos,
  TpDos,
  {$ENDIF}
  TpEnv;

var
  E : EnvRec;
  SS : string;
  VS : string;
  Status : Integer;

begin
  {Get the program name if available}
  SS := ProgramStr;
  if Length(SS) <> 0 then
    WriteLn('Program name: ', SS, ^M^J);

  {$IFDEF UseTpro}
  {Demonstrate a DOS shell with a custom prompt}
  Write('Press <Enter> for a prompted DOS shell');
  ReadLn;
  Status := ShellWithPrompt('Type EXIT to return'^M^J'[TpEnv-$p] ');
  if Status <> 0 then begin
    WriteLn('Exec status: ', Status);
    Halt;
  end;
  WriteLn;
  {$ENDIF}

  {Dump the current environment}
  CurrentEnv(E);
  if E.EnvSeg = 0 then begin
    WriteLn('Current environment not found');
    Halt;
  end;
  Write('Current environment (', E.EnvLen, ' bytes)'
        {$IFDEF UseTPro}
        , ' at ', HexW(E.EnvSeg)
        {$ENDIF}
        );
  DumpEnv(E);
  WriteLn;

  {Dump the master environment}
  MasterEnv(E);
  if E.EnvSeg = 0 then begin
    WriteLn('Master environment not found');
    Halt;
  end;
  Write('Master environment (', E.EnvLen, ' bytes)'
        {$IFDEF UseTPro}
        , ' at ', HexW(E.EnvSeg)
        {$ENDIF}
        );
  DumpEnv(E);
  WriteLn;

  {Demonstrate changes to the master environment}
  WriteLn('Change the master environment. Enter empty string to quit');
  repeat
    WriteLn;
    Write('String to set: ');
    ReadLn(SS);
    if Length(SS) <> 0 then begin
      Write('Value: ');
      ReadLn(VS);
      if not SetEnvStr(E, SS, VS) then
        WriteLn('Insufficient environment space')
      else
        DumpEnv(E);
    end;
  until Length(SS) = 0;
end.
