{$R-,S-,I-,V-,N-,E-,F-,O-}
{$M 3000,0,0}
{$D+,L+}
program Drives; {check disk sizes and free space}
Uses DOS, TPDos;
const CompileDate='90.11.21';


function GetDiskTypeName(Drive:char):string;
const
  DiskNames : array[DiskClass] of string =
    ('5" floppy', '3" floppy', '5" floppy', '3" floppy', 'Strange floppy', 'Bernoulli',
    'Hard disk', 'RAM disk', 'Substituted', 'Unknown', 'Network?');
var
 Temp:string;
 Subst:char; {if substituted, which one}
begin
  Temp:=DiskNames[GetDiskClass(Drive, Subst)];

  If Subst <> Drive then
    GetDiskTypeName:=Temp + '(' +Subst+ ')'
  Else
    GetDiskTypeName:=Temp;
end;


procedure ReportOnDisks;
const
 OneK = 1024;
 OneMb = 1048576;
 K = ' kb';
 M = ' Mb';
var
  DriveLtr:char;
  TotDriveNum, Count, DrivesCounted:byte;
  Size, Free (*, TotSizes, TotFree *):longint;
  SizeK, FreeK: longint;
  Freepc:real;
  DType:string;
  ShortD:string[3];
  FreePCStr : string[8];

begin
 (* TotSizes:=0; TotFree:=0; *)
  DrivesCounted:=0;
  TotDriveNum:=TPDos.NumberOfDrives;
  Writeln;
  Writeln('DRIVES  '+CompileDate+'  USDA ERS');
  Writeln('--------------------------');
  Writeln('Drive       Type            Total Size       Free Space');

  For Count := 3 to TotDriveNum do  {start at 3 to skip floppies}
  begin
    Size:=DiskSize(Count);
    If Size <> -1 then
    begin
      SizeK:=Size div OneK;
      Free:=DiskFree(Count);

      If Free <> -1 then
      begin
        Inc(DrivesCounted);
        DriveLtr:=Chr(Count+64);
        DType:=GetDiskTypeName(DriveLtr); (* ShortD:=DType; *)
        (*
        If ShortD <> 'Sub' then
        begin
          Inc(TotSizes, Size);
          Inc(TotFree, Free);
        end;
        *)
        FreeK:=Free div OneK;
        FreePC := Free / Size * 100;

        Str(FreePC:3:1,FreePCStr);
        FreePCStr:= '(' + FreePCStr + '%)';
        Writeln(DriveLtr:3, DType:16, SizeK:16,K,FreeK:13,K, FreePCStr:9);
      end;
    end;
  end;
  Writeln;
  If DrivesCounted = 0 then Writeln('You do not have a drive C: or higher.');
  (*
  FreePC:=TotFree / TotSizes * 100;

  If TotSizes > OneK then TotSzStr:=Real2Str(TotSizes / OneK,10,0)+K;
  If TotFree > OneK then TotFrStr:=Real2Str(TotFree / OneK,10,0)+K;

  If TotSizes > OneMb then TotSzStr:=Real2Str(TotSizes / OneMb,10,0)+M;
  If TotFree > OneMb then TotFrStr:=Real2Str(TotFree / OneMb,10,0)+M;

  Writeln('Totals = ', TotSzStr:29, TotFrStr:16, '(':4,FreePC:3:1, '%)');
  Writeln;
  *)

end;

begin
  ReportOnDisks;
end.