{$A+,B-,D+,E-,F-,I-,L-,N-,O-,R-,S-,V-}
{$M 16384,0,655360}

program PackFile;
                           (***********************************)
                           (*               TPDB              *)
                           (***********************************)
                           (*         Object -Oriented        *)
                           (*    Borland/Turbo Pascal Units   *)
                           (*    for Accessing dBASE III      *)
                           (*             files.              *)
                           (*      Copyright 1988 - 1993      *)
                           (*          Brian Corll            *)
                           (*       All Rights Reserved       *)
                           (***********************************)
                           (*            FREEWARE             *)
                           (***********************************)
                           (*     dBASE is a registered       *)
                           (* trademark of Borland Int. Inc.  *)
                           (*   Version 3.35  November, 1993  *)
                           (***********************************)
                           (*   Portions Copyright 1984,1991  *)
                           (*    Borland International Corp.  *)
                           (***********************************)

uses
    Crt, TPDB, TPDBScrn, TPDBStr;

var
    Message: string [80];
    RecCount: string;
    Packer: DataObject;

begin
    CursorOff;
    if ParamCount = 0 then begin
        Beep;
        ClrScr;
        Flash(1, 1, LightGreen + BlackBG, 'PACK filename.dbf');
        CursorOn;
        Halt(1);
    end;
    New(Packer, Init(ParamStr(1)));
    if Packer^.TotalRecs = 0 then begin
        ClrScr;
        Beep;
        Message := 'Record count in file ' + Upper(ParamStr(1)) + ' is ZERO.';
        Flash(1, 1, LightGreen + BlackBG, Message);
        CursorOn;
        Halt(1);
    end;
    ClrScr;
    Message := 'PACKing file ' + Upper(ParamStr(1));
    FlashC(11, Yellow + BlackBG, Message);
    Packer^.Pack;
    Str(Packer^.TotalRecs: 10, RecCount);
    FlashC(12, LightGreen + BlackBG, 'File has been packed.');
    Message := 'Current record count in file ' + Upper(ParamStr(1)) + ' is ' + LTrim(RecCount);
    FlashC(13, LightCyan + BlackBG, Message);
    FlashC(14, White + BlackBG, 'Copyright 1988 - 1993 Brian Corll');
    Dispose(Packer, Done);
    CursorOn;
end.
