program IndxDemo;

                           (***********************************)
                           (*               TPDB              *)
                           (***********************************)
                           (*         Object -Oriented        *)
                           (*    Borland/Turbo Pascal Units   *)
                           (*    for Accessing dBASE III      *)
                           (*             files.              *)
                           (*      Copyright 1988 - 1993      *)
                           (*          Brian Corll            *)
                           (*       All Rights Reserved       *)
                           (***********************************)
                           (*            FREEWARE             *)
                           (***********************************)
                           (*     dBASE is a registered       *)
                           (* trademark of Borland Int. Inc.  *)
                           (*   Version 3.35  November, 1993  *)
                           (***********************************)
                           (*   Portions Copyright 1984,1991  *)
                           (*    Borland International Corp.  *)
                           (***********************************)
Uses TPDB,TPDBIndx,Printer;
var
   IndexTestDBF : DataObject;
   N : LongInt;
begin
   New(IndexTestDBF,Init('names.dbf'));
   with IndexTestDBF^ do
   begin
      (* Create index, with duplicates, on field 1 *)
      Writeln('Creating index number 1...............');
      IndexOn(1,'names1.tpx',1,Duplicates);
      (* Create index, no duplicates, on field 1 *)
      Writeln('Creating index number 2...............');
      IndexOn(2,'names2.tpx',1,NoDuplicates);
      Writeln('Displaying index number 2..............');
      SetIndexTo(2);
      GoTop;
      while not DBEOF do
      begin
         Writeln(Field(1));
         Skip(1);
      end;
      Writeln('Displaying index number 1...............');
      SetIndexTo(1);
      GoTop;
      while not DBEOF do
      begin
         Writeln(Field(1));
         Skip(2);
      end;
      DBReset;
      Writeln('Creating index number 3..............');
      (* Create index,no duplicates, on field 1 + field 2 *)
      MakeDBIndex(3,'namephon.tpx',33,NoDuplicates);
      OpenDBIndex(3,'namephon.tpx',33,NoDuplicates);
      For N := 1 to TotalRecs do
      begin
         GetDBRec(N);
         AddDBKey(3,Field(1)+Field(2));
      end;
      Writeln('Displaying index number 3.................');
      SetIndexTo(3);
      GoBottom;
      while not BOF do
      begin
         Writeln(Field(1)+'   '+Field(2));
         Skip(-2);
      end;
   end;
   Dispose(IndexTestDBF,Done);
end.
