{
 MM> I'm having a problem with a program that uses lots of SVGA images.
 MM> Each image is made of an array [0..140,0..140]. Because of this only
 MM> four images can be used. The compilator refuses to use more than this
 MM> since the total size of the variables must be less than 64 KB. What
 MM> should I do to avoid this problem?

Use pointers. Allocate/release dynamic memory.

Example:
}

type
  BigArrayPtr = ^BigArray;
  BigArray = array[0..65500] of Char;

var
  BigArr : BigArrayPtr;
  I : word;

Begin
  GetMem(BigArr, SizeOf(BigArray));  { or New(BigArr) }

  { to access the array, use it's name with the '^' character in front: }
  for I := 0 to 65500 do
    BigArray^[I] := 'A'; { filling the dynamic array with 'A' }

  FreeMem(BigArr, SizeOf(BigArray))  { or Dispose(BigArr) }
End.

{
* Niklaus Wirth is genious

CUL8R,
Mr. Byte

2:5100/33,AndRew's_BBS,Riga,Andrew_Eigus,371-2-559777,2400,V42B,XX
--- 
 * Origin: The More Windows You Open, The Cooler It Gets! (2:5100/33)
}

