{
 MB> Does anyone here know how to use wildcards in a program?

Yeah, Michael! Here is some code for it:
}

{ SEARCH.PAS }

Program SearchForFiles;

uses Dos;

const
  MaxFilesPerDir = 1024;  { Wow! great number, ain't it? }

type
  PDirList = ^TDirList;
  TDirList = array[0..MaxFilesPerDir - 1] of String[12];

var
  FileNum, NumFiles : word;
  Path : PathStr;
  Dir : PDirList;

Procedure SearchFiles(const Path : PathStr);
var F : SearchRec;
Begin
  NumFiles := 0;
  FindFirst(Path, Archive, F);
  while DosError = 0 do
  begin
    Dir^[NumFiles] := F.Name;
    Inc(NumFiles);
    FindNext(F)
  end
End; { SearchFiles }

Begin
  WriteLn('Search Files   by Andrew Eigus  Fidonet: 2:5100/33');
  if ParamCount = 0 then
  begin
    WriteLn('Usage: SEARCH [mask]');
    WriteLn('Sample: SEARCH C:\DOS\*.exe');
    Halt(1)
  end;

  if MaxAvail < SizeOf(TDirList) then
  begin
    WriteLn('Not enough memory');
    Halt(8)
  end;

  New(Dir);
  Path := ParamStr(1);
  SearchFiles(Path);
  if NumFiles = 0 then
  begin
    WriteLn('No files were found');
    Halt(2)
  end;

  WriteLn(#10'Path: ', Path, #10);
  for FileNum := 0 to NumFiles - 1 do
    WriteLn(Dir^[FileNum]);

  Dispose(Dir)
End.

{
Hope this will help.

C'Ya,
Mr. Byte

2:5100/33,AndRew's_BBS,Riga,Andrew_Eigus,371-2-559777,2400,V42B,XX

--- * Origin: The More Windows You Open, The Cooler It Gets! (2:5100/33)
}

