{
Hello, anyone!

Here's a program I programmed today.
My first try to deal with graphic files (except raw files).

Here is my program which will show a windows' BMP file.
The file must have 256 colors. The width and the height are not checked but the
video mode is 320x200x256 and therefore file with heiger resolution won't be
shown right. This (the video mode) can be changed easily, though.
I've used a SETPAL procedure by Baas van Gaalen (10x).

Any comment is very appreciated.
}

program BMPShow;

var
  FileName:string;
  F:File;
  sig:array[0..1] of char;
  li,i:longint;
  Height,Width:longint;
  bpp:integer;  {bits per pixel}
  pal:array[0..256*4] of byte;
  image,p:^byte;
  y:integer;
  screen:array[0..199,0..319] of byte absolute $A000:0000;

function FileExists(FileName: String): Boolean;
var
 F: file;
begin
 {$I-}
 Assign(F, FileName);
 FileMode := 0;
 Reset(F);
 Close(F);
 {$I+}
 FileExists := (IOResult = 0) and (FileName <> '');
end;  { FileExists }

procedure setpal(c,r,g,b:byte); assembler; asm
  mov dx,3c8h; mov al,[c]; out dx,al; inc dx; mov al,[r]
  out dx,al; mov al,[g]; out dx,al; mov al,[b]; out dx,al; end;

begin
  If paramCount<>1 then
  begin
    Writeln('Usage: BMPSHOW <filename>');
    Halt(1);
  end;
  FileName:=ParamStr(1);
  if not FileExists(FileName) then
  begin
    Writeln('File ',FileName,' was not found');
    Halt(2);
  end;
  Assign(F,FileName);
  Reset(F,1);
  BlockRead(F,sig,2);
  if sig[0]+sig[1]<>'BM' then
  begin
    writeln('The file isn''t a BMP file');
    halt(3);
  end;
  seek(F,14);
  BlockRead(F,li,4);
  if li<>40 then
  begin
    writeln('The File is not a windows BMP(probably OS/2)');
    halt(4);
  end;
  seek(F,28);
  blockread(F,bpp,2);
  if bpp<>8 then
  begin
    writeln('The file must have 256 colors');
    halt(5);
  end;
  seek(F,18);
  BlockRead(F,width,4);
  BlockRead(F,height,4);
  seek(F,54);
  BlockRead(F,pal,1024);
  seek(f,2);
  blockread(F,li,4);
  getmem(Image,li-1078);
  seek(F,1078);
  BlockRead(F,image^,li-1078);
  asm
    mov ax,13h
    int 10h
  end;
  for y:=0 to 255 do
    setpal(y,pal[y*4+2] shr 2,pal[4*y+1] shr 2,pal[y*4] shr 2);
  p:=image;
  y:=height-1; I:=0;
  if width mod 4 <> 0 then width:=((width shr 2) shl 2)+4;
  while i<=li-1078 do {li-1078 = width*height}
  begin
    move(p^,screen[y,0],width);
    inc(i,width);
    inc(p,width);
    dec(y);
  end;
  readln;
end.

{
     Ŀ Ŀ Ŀ Ŀ
     Ĵ        
            2:403/152.2

--- 
 * Origin:  Jacob's Point : VGA - Very Good Adapter  (2:403/152.2)
}
