{
 > Ack..  I'd like to upgrade my fossil unit to support
 > 28.8 baudrates, but have absolutely no idea how to do
 > it...  

I haven't seen any of those units but somewhere he must set the baudrate
divisor, it should only be set once when the comport is initialized. Here's
how to do it:
}

var
   base: word; { port base address, must be set before this
                         snippet }
   bdiv: word
{
baudrate divisor
The baudrate divisor is calculated from the clockfrequency of 1.443200 Mhz
divided by 16, thus the

baudrate divisor = 1843200/(baudrate*16)

for 28.8 bps the bdiv should be 4

}

asm
   mov dx,base
   add dx,3
   in al,dx
   mov ah,al
   or al,10000000b
   out dx,al      {enable setting of bdiv, bit 7 of LCR}
   sub dx,3
   mov cx,bdiv
   mov al,cl
   out dx,al {LSB of bdiv}
   inc dx
   mov al,ch
   out dx,al {MSB of bdiv}
   add dx,2
   mov al,ah
   out dx,al {restore LCR}
end;

{
Finally, I have one question. Why use 28.8? no modems use that speed between
the modem and the computer. a 28.8k modem most probably can manage 57.6k which
is supported by most fossils.

//GEM

--- 
 * Origin: (2:203/117.5)
}
