Unit vgapcx;
{ This is a modified version of ZSoft's SHOW_PCX                        }
{ If you use it in any of your own programs, ZSoft requests that you    }
{ unclude the following notice:                                         }
{                                                                       }
{     Includes portions of SHOW_PCX.                                    }
{     Used by permission of ZSoft Corporation.                          }
Interface
uses
  Dos;
const
  MaxWidth = 4000;    { arbitrary - maximum width (in bytes) of a PCX image }
  CompressNum = $C0;  { this is the upper two bits that indicate a count }
  MaxBlock = 4096;
  Red = 0;
  Green = 1;
  Blue = 2;
  MCGA = $13;
type
  FileBuffer = array [0..127] of byte;
  BlockArray = array [0..MaxBlock] of byte;
  PalArray = array [0..255, Red..Blue] of byte;
  Pal16Array = array[0..15, Red..Blue] of byte;
  EGAArray = array [0..16] of byte;
  LineArray = array [0..MaxWidth] of byte;
  PCXHeader = record
                Manufacturer: byte;     { Always 10 for PCX file }
                Version: byte;          { 2 - old PCX - no palette (not used anymore),
                                          3 - no palette,
                                          4 - Microsoft Windows - no palette (only in
                                              old files, new Windows version uses 3),
                                          5 - with palette }
                Encoding: byte;         { 1 is PCX, it is possible that we may add
                                          additional encoding methods in the future }
                BitsPerPixel: byte;     { Number of bits to represent a pixel
                                          (per plane) - 1, 2, 4, or 8 }
                XMin: integer;          { Image window dimensions (inclusive) }
                YMin: integer;          { Xmin, Ymin are usually zero (not always) }
                XMax: integer;
                YMax: integer;
                HDPI: integer;          { Resolution of image (dots per inch) }
                VDPI: integer;          { Set to scanner resolution - 300 is default }
                ColorMap: Pal16Array;
                                        { RGB palette data (16 colors or less)
                                          256 color palette is appended to end of file }
                Reserved: byte;         { (used to contain video mode)
                                          now it is ignoRed - just set to zero }
                NPlanes: byte;          { Number of planes }
                BytesPerLinePerPlane: integer;   { Number of bytes to allocate
                                                   for a scanline plane.
                                                   MUST be an an EVEN number!
                                                   Do NOT calculate from Xmax-Xmin! }
                PaletteInfo: integer;   { 1 = black & white or color image,
                                          2 = grayscale image - ignoRed in PB4, PB4+
                                          palette must also be set to shades of gray! }
                HscreenSize: integer;   { added for PC Paintbrush IV Plus ver 1.0,  }
                VscreenSize: integer;   { PC Paintbrush IV ver 1.02 (and later)     }
                                        { I know it is tempting to use these fields
                                          to determine what video mode should be used
                                          to display the image - but it is NOT
                                          recommended since the fields will probably
                                          just contain garbage. It is better to have
                                          the user install for the graphics mode he
                                          wants to use... }
                Filler: array [74..127] of byte;     { Just set to zeros }
              end;
procedure ReadPCX(iname: PathStr);
procedure displaypcx(iname: PathStr);
procedure WritePCX(iname: PathStr; pal: pointer; VGAPal: boolean);
Implementation
Uses
  crt;
var
  Name:                                 PathStr;
  BlockFile:                            file;
  BlockData:                            BlockArray;
  Header:                               PCXHeader;
  Palette256:                           PalArray;
  PaletteEGA:                           EGAArray;
  PCXline:                              LineArray;
  YMax:                                 integer;
  NextByte: integer;                  { index into file buffer in ReadByte }
  Index: integer;                     { PCXline index - where to put Data }
  Data: byte;                         { PCX compressed data byte }
  PictureMode: integer;               { Graphics mode number }
  Reg:                                  Registers;
  fs, fp:                               longint;
procedure Error(s: string);
Begin
  WriteLn(s);
  halt;
end;
procedure ReadError(msg: integer);
{ called to check for an error reading the file }
begin
  if IOresult <> 0 then
    case msg of
      1:  Error ('Can''t open file - ' + Name);
      2:  Error ('Error closing file - ' + Name + ' - disk may be full');
      3:  Error ('Error reading file - ' + Name);
    else
      Error ('Error doing file I/O - ' + Name);
    end;   { case }
end;   { ReadError }
procedure VideoMode(n: integer);
{ the simplest possible video mode setting procedure }
begin
  Reg.ah := $00;
  Reg.al := n;                         { mode number }
  intr ($10, Reg);                     { call interrupt }
end;  { VideoMode }
procedure EntireVGApalette;
{ takes a PCX format palette (all colors 0..255) and transforms it to a }
{ VGA palette (all colors 0..63) }
var
   i:                                   integer;
begin
  for i:=0 to 255 do
  begin                                          { R, G, and B must be 0..63 }
    Palette256[i, Red]:=Palette256[i, Red] shr 2;
    Palette256[i, Green]:=Palette256[i, Green] shr 2;
    Palette256[i, Blue]:=Palette256[i, Blue] shr 2;
  end;
  Reg.ah:=$10;                       { Set DAC Call }
  Reg.al:=$12;                       { set a block of DAC registers }
  Reg.bx:=0;                         { first DAC register number }
  Reg.cx:=255;                       { number of registers to update }
  Reg.dx:=ofs (Palette256);          { offset of block }
  Reg.es:=seg (Palette256);          { segment of block }
  intr($10, Reg);                     { call interrupt }
end;  { EntireVGApalette }
procedure ShowMCGA (Y: integer);
{ Shows one line of an MCGA image }
var
  l:                                    integer;
  MCGAscreen:                           array [0..64000] of byte absolute $A000:$0000;
begin
  l:=Header.XMax-Header.Xmin;            { compute number of bytes to display }
  if l>320 then l:=320;                               { don't overrun screen width }
  Move(PCXline[0], MCGAScreen[Y*320], l);
end;   { ShowMCGA }
procedure Read256palette;
{ Reads a 256-color palette (if present) off the end of the PCX file }
var
  i:                                    integer;
  b:                                    byte;
begin
  seek(BlockFile, FileSize(BlockFile)-769);
  BlockRead(BlockFile, b, 1);           { read indicator byte }
  ReadError(3);
  if b <> 12 then exit;                  { no palette here... }
  BlockRead(BlockFile, Palette256, 3*256);
  ReadError(3);
  seek(BlockFile, 128);                 { go back to start of PCX data }
end;  { Read256palette }
procedure ReadHeader;

Procedure WrongFormat;
begin
  close (BlockFile);
  Error ('PCX file is in wrong format - It must be an MCGA image');
end;

begin
{$I-}
  BlockRead(BlockFile, Header, 128);         { read 128 byte PCX header }
  ReadError(3);
  if (Header.Manufacturer <> 10) or (Header.Encoding <> 1) then
  begin
    close(BlockFile);
    Error('This is not a valid PCX image file.');
  end;
  if (Header.Nplanes = 1) then
  begin
    Ymax := 199;
    if (Header.BitsPerPixel = 8) then
    begin
      PictureMode := MCGA;
      if Header.Version = 5 then Read256palette;
    end else WrongFormat;
  end else WrongFormat;
  Index := 0;
  NextByte := MaxBlock;          { indicates no data read in yet... }
end;  { ReadHeader }
Function ReadByte: byte;
begin
  if NextByte=MaxBlock then
    if FileSize(BlockFile)-FilePos(BlockFile)>=MaxBlock then
    begin
      BlockRead(BlockFile, BlockData, MaxBlock);
      NextByte:=0;
    end else
    begin
      BlockRead(BlockFile, BlockData, FileSize(BlockFile)-FilePos(BlockFile));
      NextByte:=0;
    end;
  ReadByte:=BlockData[NextByte];
  inc(NextByte);                         { NextByte++; }
end;  { ReadByte }
procedure ReadPCXLine;
var
  count, BytesPerLine:                  integer;
begin
{$I-}
  BytesPerLine:=Header.BytesPerLinePerPlane * Header.Nplanes;
  if Index <> 0 then FillChar(PCXline[0], Index, data);    { fills a contiguous block of data }
  while (Index < BytesPerLine) do          { read 1 line of data (all planes) }
  begin
    data:=ReadByte;
    if (data and $C0) = CompressNum then
    begin
      count:=data and $3F;
      data:=ReadByte;
      FillChar(PCXline [Index], count, data);  { fills a contiguous block }
      inc(Index, count);                       { Index += count; }
    end   else
    begin
      PCXline [Index] := data;
      inc(Index);                              { Index++; }
    end;
  end;
  ReadError(3);
  Index:=Index-BytesPerLine;
{$I+}
end;  { ReadPCXLine }
procedure ReadPCX(iname: PathStr);
var
  k, kmax:                              integer;
begin
{$I-}
  name:=iname;
  assign(BlockFile, name);
  reset(BlockFile, 1);                  { use 1 byte blocks }
  ReadError(1);
  ReadHeader;                            { read the PCX header }
  VideoMode(PictureMode);                { switch to graphics mode }
  if Header.Version = 5 then EntireVGAPalette; { set the screen palette, if available }
  kmax := Header.Ymin + Ymax;
  if Header.Ymax < kmax then kmax := Header.ymax;
  if PictureMode=MCGA then
    for k:=Header.Ymin to kmax do
    begin
      ReadPCXLine;
      ShowMCGA(k);
    end;
  close(BlockFile);
  ReadError(2);
{$I+}
end;  { ReadPCX }
procedure displaypcx(iname: PathStr);
{ read and pause }
var
  c:                                    char;
begin
  ReadPCX(iname);              { read and display the file }
  c:=ReadKey;
  while keypressed do
    c:=ReadKey;
end;   { displaypcx }
procedure WriteHeader(pal: pointer; VGAPal: boolean);
{ used by WritePCX }
Begin
  with header do
  begin
    Manufacturer:=10;
    if VGAPal then Version:=5 else
    begin
      Version:=3;
      ColorMap:=Pal16Array(pal^);
    end;
    Encoding:=1;
    BitsPerPixel:=8;
    XMin:=0;
    YMin:=0;
    XMax:=319;
    YMax:=199;
    HDPI:=XMax-XMin+1;
    VDPI:=YMax-YMin+1;
    Reserved:=0;
    BytesPerLinePerPlane:=HDPI;
    PaletteInfo:=1;
    HScreenSize:=HDPI;
    VScreenSize:=VDPI;
    FillChar(Filler[74], 54, 0);
  end;
  BlockWrite(BlockFile, Header, SizeOf(Header));
End;
procedure WritePCXLine;
var
  count:                                integer;

procedure WByte(a: byte);
begin
  BlockData[count]:=a;
  inc(count);
end;

var
  BytesPerLine, rle:                    integer;
{ RLE stands for Run Length Encoding, the compression method for PCX files }
{ RLE is especially effective for MCGA graphics with large blocks of one   }
{ color.  Just for explanation: RLE replaces a string of the same byte     }
{ with two bytes.  For example: "AAAAAAAAAAAAAAAAAAAA" might become #212A  }
{ #212 is a signal byte and the number (20) of like characters.  The 20    }
{ are then replaced by 1.  I get sometimes better than 10 to 1 compression }
{ on graphics files this way }
begin
  BytesPerLine:=Header.BytesPerLinePerPlane * Header.Nplanes;
  Index:=0;
  count:=0;
  while (Index < BytesPerLine) do
  begin
    rle:=1;
    while (PCXLine[index]=PCXLine[index+rle]) and (index+rle < BytesPerLine) and (rle<=62) do
      inc(rle);
    if rle>1 then WByte(rle or CompressNum) else
      if PCXLine[index] and CompressNum = CompressNum then WByte($C1);
    WByte(PCXLine[Index]);
    inc(Index, rle);
  end;
  Index:=Index-BytesPerLine;
  BlockWrite(BlockFile, BlockData, Count);
end;
procedure FindMCGA(Y: integer);
{ screen reader, MCGA }
var
  l:                                    integer;
  MCGAscreen:                           array [0..64000] of byte absolute $A000:$0000;
begin
  l:=Header.XMax-Header.Xmin;            { compute number of bytes to display }
  if l>320 then l:=320;                               { don't overrun screen width }
  Move(MCGAScreen[Y*320], PCXline[0], l);
  FillChar(MCGAScreen[y*320], l, 0);
end;   { ShowMCGA }
Procedure Write256Palette(pal: PalArray);
var
  i:                                    integer;
  b:                                    byte;
begin
  b:=12;
  BlockWrite(BlockFile, b, 1);
  BlockWrite(BlockFile, pal, 3*256);
end;
Procedure WritePCX(iname: PathStr; pal: pointer; VGAPal: boolean);
{ iname:   the path and name (up to 80 long) for the PCX file               }
{ pal:     a pointer to a 256-color PalArray.  If you don't want to include }
{          a palette, set this to nil and the default palette will be used  }
{ VGAPal:  whether or not to try to include a palette.  NOTE: if this is    }
{          set to TRUE, it will write no matter what pal is set to!         }
var
  y:                                    word;
Begin
  name:=iname;
  Assign(BlockFile, name);
  ReWrite(BlockFile, 1);
  WriteHeader(pal, VGAPal);
  for y:=0 to 199 do
  begin
    FindMCGA(y);
    WritePCXLine;
  end;
  if VGAPal then Write256Palette(PalArray(pal^));
  Close(BlockFile);
End;
end.

{---
  Cam-Mail v1.40: The Computer Connection....C'vlle, Va. 804-974-9306 (14.4)
 * The DC Information Exchange (703)836-0748
}